/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsGalleryWidgetConfiguration;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsDialog;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public abstract class A_CmsAdeGalleryWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    protected static final String PATH_GALLERY_JSP = "/system/modules/org.opencms.ade.galleries/gallery.jsp";
    private static final Log LOG = CmsLog.getLog(A_CmsAdeGalleryWidget.class);
    private CmsGalleryWidgetConfiguration m_widgetConfiguration;

    public A_CmsAdeGalleryWidget() {
        this("");
    }

    protected A_CmsAdeGalleryWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        return this.getJSONConfig(cms, schemaType, messages, resource, contentLocale).toString();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        long idHash = id.hashCode();
        if (idHash < 0L) {
            idHash = -idHash;
            idHash += 0x100000000L;
        }
        StringBuffer result = new StringBuffer(512);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td class=\"xmlTd\">");
        result.append("<input class=\"xmlInput textInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        String value = param.getStringValue(cms);
        result.append(value);
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" onkeyup=\"checkPreview('");
        result.append(id);
        result.append("');\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenGalleryCall(cms, widgetDialog, param, idHash), null, this.getGalleryName() + "gallery", Messages.getButtonName(this.getGalleryName()), widgetDialog.getButtonStyle()));
        String previewClass = "hide";
        if (CmsStringUtil.isNotEmpty(value) && value.startsWith("/")) {
            previewClass = "show";
        }
        result.append("<td class=\"");
        result.append(previewClass);
        result.append("\" id=\"preview");
        result.append(id);
        result.append("\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenPreviewCall(widgetDialog, param.getId()), null, "preview.png", "GUI_BUTTON_PREVIEW_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        result.append("</tr></table>");
        result.append("</td>");
        JSONObject additional = null;
        try {
            additional = this.getAdditionalGalleryInfo(cms, widgetDialog instanceof CmsDialog ? ((CmsDialog)((Object)widgetDialog)).getParamResource() : null, widgetDialog.getMessages(), param);
        }
        catch (JSONException e) {
            LOG.error((Object)"Error parsing widget configuration", (Throwable)e);
        }
        if (additional != null) {
            result.append("\n<script type=\"text/javascript\">\n");
            result.append("var cms_additional_").append(idHash).append("=");
            result.append(additional.toString()).append(";\n");
            result.append("</script>");
        }
        return result.toString();
    }

    public abstract String getGalleryName();

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return A_CmsAdeGalleryWidget.class.getName();
    }

    @Override
    public boolean isCompactViewEnabled() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    protected abstract JSONObject getAdditionalGalleryInfo(CmsObject var1, String var2, CmsMessages var3, I_CmsWidgetParameter var4) throws JSONException;

    protected Map<String, String> getGalleryOpenParams(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param, String resource, long hashId) {
        CmsGalleryWidgetConfiguration configuration;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("gallerymode", "widget");
        result.put("galleryprefix", this.getGalleryStoragePrefix());
        result.put("resourcetypes", this.getGalleryTypes());
        if (param.getId() != null) {
            result.put("fieldId", param.getId());
            result.put("currentelement", "'+document.getElementById('" + param.getId() + "').getAttribute('value')+'");
        }
        result.put("hashId", "" + hashId);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resource)) {
            result.put("resource", resource);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((configuration = this.getWidgetConfiguration(cms, messages, param)).getStartup())) {
            result.put("gallerypath", configuration.getStartup());
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration.getGalleryTypes())) {
            result.put("gallerytypes", configuration.getGalleryTypes());
        }
        result.put("galleryname", this.getGalleryName());
        return result;
    }

    protected String getGalleryStoragePrefix() {
        return "";
    }

    protected abstract String getGalleryTypes();

    protected JSONObject getJSONConfig(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, String> paramEntry : this.getGalleryOpenParams(cms, messages, schemaType, cms.getSitePath(resource), 0L).entrySet()) {
                result.put(paramEntry.getKey(), paramEntry.getValue());
            }
            JSONObject additional = this.getAdditionalGalleryInfo(cms, cms.getSitePath(resource), messages, null);
            if (additional != null) {
                result.merge(additional, true, true);
            }
            result.put("locale", contentLocale.toString());
            result.remove("currentelement");
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getOpenGalleryCall(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, long hashId) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("javascript:cmsOpenDialog('");
        sb.append(widgetDialog.getMessages().key(Messages.getButtonName(this.getGalleryName()))).append("', '");
        sb.append(OpenCms.getSystemInfo().getOpenCmsContext()).append(PATH_GALLERY_JSP);
        Locale contentLocale = widgetDialog.getLocale();
        try {
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)((Object)param);
            contentLocale = value.getLocale();
        }
        catch (Exception e) {
            // empty catch block
        }
        sb.append("?__locale=").append(contentLocale.toString());
        for (Map.Entry<String, String> paramEntry : this.getGalleryOpenParams(cms, widgetDialog.getMessages(), param, widgetDialog instanceof CmsDialog ? ((CmsDialog)((Object)widgetDialog)).getParamResource() : null, hashId).entrySet()) {
            sb.append("&").append(paramEntry.getKey()).append("=").append(paramEntry.getValue());
        }
        sb.append("', '").append(param.getId()).append("', 488, 650); return false;");
        return sb.toString();
    }

    protected String getOpenPreviewCall(I_CmsWidgetDialog widgetDialog, String id) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("javascript:cmsOpenPreview('").append(widgetDialog.getMessages().key("GUI_BUTTON_PREVIEW_0"));
        sb.append("', '").append(OpenCms.getSystemInfo().getOpenCmsContext());
        sb.append("', '").append(id);
        sb.append("'); return false;");
        return sb.toString();
    }

    protected CmsGalleryWidgetConfiguration getWidgetConfiguration(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param) {
        if (this.m_widgetConfiguration == null) {
            this.m_widgetConfiguration = new CmsGalleryWidgetConfiguration(cms, messages, param, this.getConfiguration());
        }
        return this.m_widgetConfiguration;
    }
}

