/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsFormatterWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentRootLocation;

public class CmsAddFormatterWidget
extends A_CmsFormatterWidget {
    public CmsAddFormatterWidget() {
    }

    public CmsAddFormatterWidget(String config) {
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsAddFormatterWidget();
    }

    @Override
    protected List<CmsSelectWidgetOption> getFormatterOptions(CmsObject cms, CmsADEConfigData config) {
        Map<CmsUUID, I_CmsFormatterBean> inactiveFormatters = config.getInactiveFormatters();
        ArrayList result = Lists.newArrayList();
        ArrayList formatters = Lists.newArrayList(inactiveFormatters.values());
        Collections.sort(formatters, new A_CmsFormatterWidget.FormatterSelectComparator());
        for (I_CmsFormatterBean formatterBean : formatters) {
            CmsSelectWidgetOption option = CmsAddFormatterWidget.getWidgetOptionForFormatter(cms, formatterBean);
            result.add(option);
        }
        return result;
    }

    @Override
    protected Set<String> getSelectedInFile(CmsConfigurationReader reader, CmsXmlContent content) {
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, Locale.ENGLISH);
        Set<String> addFormatters = reader.parseAddFormatters(root);
        return addFormatters;
    }

    @Override
    protected List<CmsSelectWidgetOption> getTypeOptions(CmsObject cms, CmsADEConfigData adeConfig) {
        ArrayList result = Lists.newArrayList();
        Set<String> types = adeConfig.getTypesWithModifiableFormatters();
        Set<String> activeTypes = adeConfig.getTypesWithActiveSchemaFormatters();
        HashSet<String> inactiveTypes = new HashSet<String>(types);
        inactiveTypes.removeAll(activeTypes);
        for (String inactiveType : inactiveTypes) {
            CmsSelectWidgetOption option = CmsAddFormatterWidget.getWidgetOptionForType(cms, inactiveType);
            result.add(option);
        }
        return result;
    }
}

