/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsSpellcheckHandler;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsAdeGalleryWidget;
import org.opencms.widgets.A_CmsHtmlWidget;
import org.opencms.widgets.CmsAdeDownloadGalleryWidget;
import org.opencms.widgets.CmsAdeImageGalleryWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.editors.CmsEditorDisplayOptions;
import org.opencms.workplace.editors.CmsWorkplaceEditorConfiguration;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsHtmlWidget
extends A_CmsHtmlWidget
implements I_CmsADEWidget {
    private static final Log LOG = CmsLog.getLog(CmsHtmlWidget.class);
    private I_CmsWidget m_editorWidget;
    public static final Map<String, String> TINYMCE_DEFAULT_BLOCK_FORMAT_LABELS = Collections.unmodifiableMap(CmsStringUtil.splitAsMap("p:Paragraph|address:Address|pre:Pre|h1:Header 1|h2:Header 2|h3:Header 3|h4:Header 4|h5:Header 5|h6:Header 6", "|", ":"));

    public CmsHtmlWidget() {
        this("");
    }

    public CmsHtmlWidget(CmsHtmlWidgetOption configuration) {
        super(configuration);
    }

    public CmsHtmlWidget(String configuration) {
        super(configuration);
    }

    public static String getTinyMceBlockFormats(String formatSelectOptions) {
        String[] options = formatSelectOptions.split(";");
        ArrayList resultParts = Lists.newArrayList();
        for (String option : options) {
            String label = TINYMCE_DEFAULT_BLOCK_FORMAT_LABELS.get(option);
            if (label == null) {
                label = option;
            }
            resultParts.add(label + "=" + option);
        }
        String result = CmsStringUtil.listAsString(resultParts, ";");
        return result;
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        JSONObject result = this.getJSONConfiguration(cms, resource, contentLocale);
        try {
            this.addEmbeddedGalleryOptions(result, cms, schemaType, messages, resource, contentLocale);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result.toString();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogIncludes(cms, widgetDialog);
    }

    @Override
    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitCall(cms, widgetDialog);
    }

    @Override
    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitMethod(cms, widgetDialog);
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return this.getEditorWidget(cms, widgetDialog).getDialogWidget(cms, widgetDialog, param);
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsHtmlWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsHtmlWidget(this.getConfiguration());
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String val = CmsEncoder.decode(values[0], "UTF-8");
            param.setStringValue(cms, val);
        }
    }

    protected void addEmbeddedGalleryOptions(JSONObject result, CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) throws JSONException {
        A_CmsAdeGalleryWidget widget;
        String embeddedImageGalleryOptions = this.getHtmlWidgetOption().getEmbeddedConfigurations().get("imagegallery");
        String embeddedDownloadGalleryOptions = this.getHtmlWidgetOption().getEmbeddedConfigurations().get("downloadgallery");
        if (embeddedDownloadGalleryOptions != null) {
            widget = new CmsAdeDownloadGalleryWidget();
            widget.setConfiguration(embeddedDownloadGalleryOptions);
            String downloadJsonString = widget.getConfiguration(cms, schemaType, messages, resource, contentLocale);
            JSONObject downloadJsonObj = new JSONObject(downloadJsonString);
            this.filterEmbeddedGalleryOptions(downloadJsonObj);
            result.put("downloadGalleryConfig", downloadJsonObj);
        }
        if (embeddedImageGalleryOptions != null) {
            widget = new CmsAdeImageGalleryWidget();
            widget.setConfiguration(embeddedImageGalleryOptions);
            String imageJsonString = widget.getConfiguration(cms, schemaType, messages, resource, contentLocale);
            JSONObject imageJsonObj = new JSONObject(imageJsonString);
            this.filterEmbeddedGalleryOptions(imageJsonObj);
            result.put("imageGalleryConfig", imageJsonObj);
        }
    }

    protected JSONObject getJSONConfiguration(CmsObject cms, CmsResource resource, Locale contentLocale) {
        JSONObject result = new JSONObject();
        CmsHtmlWidgetOption widgetOptions = this.getHtmlWidgetOption();
        CmsEditorDisplayOptions options = OpenCms.getWorkplaceManager().getEditorDisplayOptions();
        Properties displayOptions = options.getDisplayOptions(cms);
        try {
            String formatSelectOptions;
            if (options.showElement("gallery.enhancedoptions", displayOptions)) {
                result.put("cmsGalleryEnhancedOptions", true);
            }
            if (options.showElement("gallery.usethickbox", displayOptions)) {
                result.put("cmsGalleryUseThickbox", true);
            }
            result.put("fullpage", widgetOptions.isFullPage());
            List<String> toolbarItems = widgetOptions.getButtonBarShownItems();
            result.put("toolbar_items", toolbarItems);
            Locale workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            result.put("language", workplaceLocale.getLanguage());
            String editorHeight = widgetOptions.getEditorHeight();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(editorHeight)) {
                editorHeight = editorHeight.replaceAll("px", "");
                result.put("height", editorHeight);
            }
            boolean cssConfigured = false;
            String cssPath = "";
            if (widgetOptions.useCss()) {
                cssPath = widgetOptions.getCssPath();
                widgetOptions.setCssPath(null);
                cssConfigured = true;
            } else if (OpenCms.getWorkplaceManager().getEditorCssHandlers().size() > 0) {
                Iterator<I_CmsEditorCssHandler> i = OpenCms.getWorkplaceManager().getEditorCssHandlers().iterator();
                try {
                    String editedResourceSitePath;
                    String string = editedResourceSitePath = resource == null ? null : cms.getSitePath(resource);
                    while (i.hasNext()) {
                        I_CmsEditorCssHandler handler = i.next();
                        if (!handler.matches(cms, editedResourceSitePath)) continue;
                        cssPath = handler.getUriStyleSheet(cms, editedResourceSitePath);
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(cssPath)) {
                            cssConfigured = true;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cssConfigured) {
                result.put("content_css", OpenCms.getLinkManager().substituteLink(cms, cssPath));
            }
            if (widgetOptions.showStylesFormat()) {
                try {
                    CmsFile file = cms.readFile(widgetOptions.getStylesFormatPath());
                    String characterEncoding = OpenCms.getSystemInfo().getDefaultEncoding();
                    result.put("style_formats", new String(file.getContents(), characterEncoding));
                }
                catch (CmsException cmsException) {
                    LOG.error((Object)("Can not open file:" + widgetOptions.getStylesFormatPath()), (Throwable)cmsException);
                }
                catch (UnsupportedEncodingException ex) {
                    LOG.error((Object)ex);
                }
            }
            if (!CmsStringUtil.isEmpty(formatSelectOptions = widgetOptions.getFormatSelectOptions()) && !widgetOptions.isButtonHidden("formatselect")) {
                result.put("block_formats", CmsHtmlWidget.getTinyMceBlockFormats(formatSelectOptions));
            }
            CmsWorkplaceEditorConfiguration editorConfig = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getEditorConfiguration("tinymce");
            Boolean pasteText = Boolean.valueOf(editorConfig.getParameters().get("paste_text"));
            JSONObject directOptions = new JSONObject();
            directOptions.put("paste_text_sticky_default", pasteText);
            directOptions.put("paste_text_sticky", pasteText);
            result.put("tinyMceOptions", directOptions);
            if (OpenCmsSpellcheckHandler.isSpellcheckingEnabled()) {
                result.put("spellcheck_url", OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, OpenCmsSpellcheckHandler.getSpellcheckHandlerPath()));
                result.put("spellcheck_language", "+" + contentLocale.getDisplayLanguage(workplaceLocale) + "=" + contentLocale.getLanguage());
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private void filterEmbeddedGalleryOptions(JSONObject json) {
        HashSet validKeys = Sets.newHashSet(Arrays.asList("gallerytypes", "gallerypath", "useformats", "imageformatnames", "imageformats"));
        HashSet toDelete = new HashSet(Sets.difference(json.keySet(), (Set)validKeys));
        for (String toDeleteKey : toDelete) {
            json.remove(toDeleteKey);
        }
    }

    private I_CmsWidget getEditorWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        if (this.m_editorWidget == null) {
            String widgetClassName = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getWidgetEditor(cms.getRequestContext(), widgetDialog.getUserAgent());
            boolean foundWidget = true;
            if (CmsStringUtil.isEmpty(widgetClassName)) {
                widgetClassName = CmsTextareaWidget.class.getName();
                foundWidget = false;
            }
            try {
                if (foundWidget) {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    A_CmsHtmlWidget editorWidget = (A_CmsHtmlWidget)widgetClass.newInstance();
                    editorWidget.setHtmlWidgetOption(this.getHtmlWidgetOption());
                    this.m_editorWidget = editorWidget;
                } else {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    I_CmsWidget editorWidget = (I_CmsWidget)widgetClass.newInstance();
                    editorWidget.setConfiguration("15");
                    this.m_editorWidget = editorWidget;
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().container("LOG_CREATE_HTMLWIDGET_INSTANCE_FAILED_1", widgetClassName).key());
            }
        }
        return this.m_editorWidget;
    }
}

