/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsRegexSubstitution;
import org.opencms.widgets.CmsHtmlWidget;

public class CmsHtmlWidgetOption {
    public static final String BUTTONBAR_BLOCK_END = "]";
    public static final String BUTTONBAR_BLOCK_START = "[";
    public static final String BUTTONBAR_DEFAULT = "[;undo;redo;-;find;replace;-;removeformat;-;pastetext;-;copy;paste;-;bold;italic;underline;strikethrough;-;subscript;superscript;];[;alignleft;aligncenter;alignright;justify;-;orderedlist;unorderedlist;-;outdent;indent;];[;source;-;formatselect;style;editorlink;link;anchor;unlink;];[;imagegallery;downloadgallery;linkgallery;htmlgallery;tablegallery;-;table;-;specialchar;-;print;spellcheck;-;fitwindow;];[;abbr;absolute;acronym;advhr;attribs;backcolor;blockquote;cite;cleanup;del;emotions;fontselect;fontsizeselect;forecolor;hr;ins;insertdate;insertlayer;inserttime;ltr;media;movebackward;moveforward;newdocument;nonbreaking;pagebreak;rtl;styleprops;template;visualaid;visualchars;];";
    public static final List<String> BUTTONBAR_DEFAULT_LIST = CmsStringUtil.splitAsList("[;undo;redo;-;find;replace;-;removeformat;-;pastetext;-;copy;paste;-;bold;italic;underline;strikethrough;-;subscript;superscript;];[;alignleft;aligncenter;alignright;justify;-;orderedlist;unorderedlist;-;outdent;indent;];[;source;-;formatselect;style;editorlink;link;anchor;unlink;];[;imagegallery;downloadgallery;linkgallery;htmlgallery;tablegallery;-;table;-;specialchar;-;print;spellcheck;-;fitwindow;];[;abbr;absolute;acronym;advhr;attribs;backcolor;blockquote;cite;cleanup;del;emotions;fontselect;fontsizeselect;forecolor;hr;ins;insertdate;insertlayer;inserttime;ltr;media;movebackward;moveforward;newdocument;nonbreaking;pagebreak;rtl;styleprops;template;visualaid;visualchars;];", ';');
    public static final String BUTTONBAR_SEPARATOR = "-";
    public static final String DELIMITER_OPTION = ",";
    public static final char DELIMITER_VALUE = ';';
    public static final String EDITOR_DEFAULTHEIGHT = "260px";
    public static final String OPTION_ABBR = "abbr";
    public static final String OPTION_ABSOLUTE = "absolute";
    public static final String OPTION_ACRONYM = "acronym";
    public static final String OPTION_ADVHR = "advhr";
    public static final String OPTION_ANCHOR = "anchor";
    public static final String OPTION_ATTRIBS = "attribs";
    public static final String OPTION_BACKCOLOR = "backcolor";
    public static final String OPTION_BLOCKQUOTE = "blockquote";
    public static final String OPTION_BUTTONBAR = "buttonbar:";
    public static final String OPTION_CITE = "cite";
    public static final String OPTION_CLEANUP = "cleanup";
    public static final String OPTION_CSS = "css:";
    public static final String OPTION_DEL = "del";
    public static final String OPTION_EDITORLINK = "editorlink";
    public static final String OPTION_EMOTIONS = "emotions";
    public static final String OPTION_FIND = "find";
    public static final String OPTION_FONTSELECT = "fontselect";
    public static final String OPTION_FONTSIZESELECT = "fontsizeselect";
    public static final String OPTION_FORECOLOR = "forecolor";
    public static final String OPTION_FORMATSELECT = "formatselect";
    public static final String OPTION_FORMATSELECT_OPTIONS = "formatselect.options:";
    public static final String OPTION_FULLPAGE = "fullpage";
    public static final String OPTION_HEIGHT = "height:";
    public static final String OPTION_HIDEBUTTONS = "hidebuttons:";
    public static final String OPTION_HR = "hr";
    public static final String OPTION_IMAGE = "image";
    public static final String OPTION_INS = "ins";
    public static final String OPTION_INSERTDATE = "insertdate";
    public static final String OPTION_INSERTLAYER = "insertlayer";
    public static final String OPTION_INSERTTIME = "inserttime";
    public static final String OPTION_LINK = "link";
    public static final String OPTION_LTR = "ltr";
    public static final String OPTION_MEDIA = "media";
    public static final String OPTION_MOVEBACKWARD = "movebackward";
    public static final String OPTION_MOVEFORWARD = "moveforward";
    public static final String OPTION_NEWDOCUMENT = "newdocument";
    public static final String OPTION_NONBREAKING = "nonbreaking";
    public static final String OPTION_PAGEBREAK = "pagebreak";
    public static final String OPTION_PASTEWORD = "pasteword";
    public static final String OPTION_REPLACE = "replace";
    public static final String OPTION_RTL = "rtl";
    public static final String OPTION_SOURCE = "source";
    public static final String OPTION_SPELLCHECK = "spellcheck";
    public static final String OPTION_STYLE = "style";
    public static final String OPTION_STYLEPROPS = "styleprops";
    public static final String OPTION_STYLES = "stylesxml:";
    public static final String OPTION_STYLES_FORMAT = "stylesformat:";
    public static final String OPTION_TABLE = "table";
    public static final String OPTION_TEMPLATE = "template";
    public static final String OPTION_UNLINK = "unlink";
    public static final String OPTION_VISUALAID = "visualaid";
    public static final String OPTION_VISUALCHARS = "visualchars";
    public static final String[] OPTIONAL_BUTTONS = new String[]{"anchor", "editorlink", "find", "formatselect", "image", "link", "replace", "source", "spellcheck", "style", "table", "unlink", "abbr", "absolute", "acronym", "advhr", "attribs", "backcolor", "cite", "cleanup", "del", "emotions", "fontselect", "fontsizeselect", "forecolor", "ins", "insertdate", "insertlayer", "inserttime", "ltr", "media", "movebackward", "moveforward", "newdocument", "nonbreaking", "pagebreak", "pasteword", "rtl", "styleprops", "template", "visualaid", "visualchars", "imagegallery", "downloadgallery", "htmlgallery", "linkgallery", "tablegallery"};
    public static final List<String> OPTIONAL_BUTTONS_LIST = Arrays.asList(OPTIONAL_BUTTONS);
    public static final Pattern PATTERN_EMBEDDED_GALLERY_CONFIG = Pattern.compile("(?<![a-zA-Z0-9_])(imagegallery|downloadgallery)(\\{.*?\\})");
    private static List<String> m_globalButtonBarOption;
    private List<String> m_additionalButtons;
    private List<String> m_buttonBar;
    private List<String> m_buttonBarOption;
    private String m_buttonBarOptionString;
    private String m_configuration;
    private String m_cssPath;
    private String m_editorHeight;
    private Map<String, String> m_embeddedConfigurations = Maps.newHashMap();
    private String m_formatSelectOptions;
    private boolean m_fullPage;
    private List<String> m_hiddenButtons;
    private String m_stylesFormatPath;
    private String m_stylesXmlPath;

    public CmsHtmlWidgetOption() {
        this.init(null);
    }

    public CmsHtmlWidgetOption(String configuration) {
        this.init(configuration);
    }

    public static String createConfigurationString(CmsHtmlWidgetOption option) {
        StringBuffer result = new StringBuffer(512);
        boolean added = false;
        if (!option.getEditorHeight().equals(EDITOR_DEFAULTHEIGHT)) {
            result.append(OPTION_HEIGHT);
            result.append(option.getEditorHeight());
            added = true;
        }
        if (option.useCss()) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(OPTION_CSS);
            result.append(option.getCssPath());
            added = true;
        }
        if (option.showStylesXml()) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(OPTION_STYLES);
            result.append(option.getStylesXmlPath());
            added = true;
        }
        if (!option.getAdditionalButtons().isEmpty()) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(CmsStringUtil.collectionAsString(option.getAdditionalButtons(), String.valueOf(DELIMITER_OPTION)));
            added = true;
        }
        if (!option.getHiddenButtons().isEmpty()) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(OPTION_HIDEBUTTONS);
            result.append(CmsStringUtil.collectionAsString(option.getHiddenButtons(), String.valueOf(';')));
            added = true;
        }
        if (CmsStringUtil.isNotEmpty(option.getButtonBarOptionString())) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(OPTION_BUTTONBAR);
            result.append(option.getButtonBarOptionString());
            added = true;
        }
        if (CmsStringUtil.isNotEmpty(option.getFormatSelectOptions())) {
            if (added) {
                result.append(DELIMITER_OPTION);
            }
            result.append(OPTION_FORMATSELECT_OPTIONS);
            result.append(option.getFormatSelectOptions());
            added = true;
        }
        return result.toString();
    }

    public static CmsPair<String, Map<String, String>> parseEmbeddedGalleryOptions(String configuration) {
        final HashMap galleryOptions = Maps.newHashMap();
        String resultConfig = CmsStringUtil.substitute(PATTERN_EMBEDDED_GALLERY_CONFIG, configuration, new I_CmsRegexSubstitution(){

            @Override
            public String substituteMatch(String string, Matcher matcher) {
                String galleryName = string.substring(matcher.start(1), matcher.end(1));
                String embeddedConfig = string.substring(matcher.start(2), matcher.end(2));
                galleryOptions.put(galleryName, embeddedConfig);
                return galleryName;
            }
        });
        return CmsPair.create(resultConfig, galleryOptions);
    }

    public List<String> getAdditionalButtons() {
        return this.m_additionalButtons;
    }

    public String getButtonBar(Map<String, String> buttonNamesLookUp, String itemSeparator) {
        return this.getButtonBar(buttonNamesLookUp, itemSeparator, true);
    }

    public String getButtonBar(Map<String, String> buttonNamesLookUp, String itemSeparator, boolean addMissingBlock) {
        List<String> buttonBar = this.getButtonBarShownItems();
        if (addMissingBlock && !buttonBar.isEmpty()) {
            if (!buttonBar.get(0).equals(BUTTONBAR_BLOCK_START)) {
                buttonBar.add(0, BUTTONBAR_BLOCK_START);
            }
            if (!buttonBar.get(buttonBar.size() - 1).equals(BUTTONBAR_BLOCK_END)) {
                buttonBar.add(BUTTONBAR_BLOCK_END);
            }
        }
        StringBuffer result = new StringBuffer(512);
        boolean isFirst = true;
        for (String barItem : buttonBar) {
            if (BUTTONBAR_BLOCK_START.equals(barItem)) {
                if (!isFirst) {
                    result.append(itemSeparator);
                }
                result.append(this.getButtonName(barItem, buttonNamesLookUp));
                isFirst = true;
                continue;
            }
            if (BUTTONBAR_BLOCK_END.equals(barItem)) {
                result.append(this.getButtonName(barItem, buttonNamesLookUp));
                isFirst = false;
                continue;
            }
            if (!isFirst) {
                result.append(itemSeparator);
            }
            result.append(this.getButtonName(barItem, buttonNamesLookUp));
            isFirst = false;
        }
        return result.toString();
    }

    public List<String> getButtonBarOption() {
        if (this.m_buttonBarOption == null) {
            this.m_buttonBarOption = CmsStringUtil.isEmpty(this.getButtonBarOptionString()) ? Collections.emptyList() : CmsStringUtil.splitAsList(this.getButtonBarOptionString(), ';', true);
        }
        return this.m_buttonBarOption;
    }

    public String getButtonBarOptionString() {
        return this.m_buttonBarOptionString;
    }

    public List<String> getButtonBarShownItems() {
        if (this.m_buttonBar == null) {
            List<String> buttonBar = this.getButtonBarOption();
            if (buttonBar.isEmpty()) {
                if (m_globalButtonBarOption == null) {
                    String defaultConf = OpenCms.getXmlContentTypeManager().getWidgetDefaultConfiguration(CmsHtmlWidget.class.getName());
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultConf) && defaultConf.contains(OPTION_BUTTONBAR)) {
                        CmsHtmlWidgetOption option = new CmsHtmlWidgetOption(defaultConf);
                        m_globalButtonBarOption = option.getButtonBarOption();
                    } else {
                        m_globalButtonBarOption = Collections.emptyList();
                    }
                }
                buttonBar = m_globalButtonBarOption.isEmpty() ? BUTTONBAR_DEFAULT_LIST : m_globalButtonBarOption;
            }
            ArrayList<String> result = new ArrayList<String>(buttonBar.size());
            int lastSep = -1;
            int lastBlock = -1;
            boolean buttonInBlockAdded = false;
            boolean buttonSinceSepAdded = false;
            for (String barItem : buttonBar) {
                if (BUTTONBAR_BLOCK_START.equals(barItem)) {
                    if (lastSep != -1 && lastSep == result.size() - 1) {
                        result.remove(lastSep);
                    }
                    lastBlock = result.size();
                    lastSep = -1;
                    buttonInBlockAdded = false;
                    buttonSinceSepAdded = false;
                    result.add(BUTTONBAR_BLOCK_START);
                    continue;
                }
                if (BUTTONBAR_BLOCK_END.equals(barItem)) {
                    if (lastBlock == -1) continue;
                    if (lastSep == result.size() - 1) {
                        result.remove(lastSep);
                    }
                    if (buttonInBlockAdded) {
                        result.add(BUTTONBAR_BLOCK_END);
                    } else {
                        result.remove(lastBlock);
                    }
                    lastBlock = -1;
                    lastSep = -1;
                    buttonInBlockAdded = false;
                    buttonSinceSepAdded = false;
                    continue;
                }
                if (BUTTONBAR_SEPARATOR.equals(barItem)) {
                    if (!buttonSinceSepAdded) continue;
                    lastSep = result.size();
                    result.add(BUTTONBAR_SEPARATOR);
                    buttonSinceSepAdded = false;
                    continue;
                }
                if (this.getHiddenButtons().contains(barItem)) continue;
                if (OPTIONAL_BUTTONS_LIST.contains(barItem)) {
                    if ("imagegallery".equals(barItem)) {
                        if (!this.getAdditionalButtons().contains(barItem) && !this.getAdditionalButtons().contains(OPTION_IMAGE)) {
                            continue;
                        }
                    } else if (OPTION_UNLINK.equals(barItem)) {
                        if (!(this.getAdditionalButtons().contains(OPTION_LINK) || this.getAdditionalButtons().contains(OPTION_EDITORLINK) || this.getAdditionalButtons().contains(OPTION_ANCHOR))) {
                            continue;
                        }
                    } else if (OPTION_STYLE.equals(barItem)) {
                        boolean showStyles;
                        boolean bl = showStyles = this.getAdditionalButtons().contains(barItem) || this.getStylesFormatPath() != null || this.getStylesXmlPath() != null;
                        if (!showStyles) {
                            continue;
                        }
                    } else if (!this.getAdditionalButtons().contains(barItem)) continue;
                }
                result.add(barItem);
                buttonSinceSepAdded = true;
                if (lastBlock == -1) continue;
                buttonInBlockAdded = true;
            }
            this.m_buttonBar = result;
        }
        return this.m_buttonBar;
    }

    public String getConfiguration() {
        return this.m_configuration;
    }

    public String getCssPath() {
        return this.m_cssPath;
    }

    public String getEditorHeight() {
        return this.m_editorHeight;
    }

    public Map<String, String> getEmbeddedConfigurations() {
        return this.m_embeddedConfigurations;
    }

    public String getFormatSelectOptions() {
        return this.m_formatSelectOptions;
    }

    public List<String> getHiddenButtons() {
        return this.m_hiddenButtons;
    }

    public String getStylesFormatPath() {
        return this.m_stylesFormatPath;
    }

    public String getStylesXmlPath() {
        return this.m_stylesXmlPath;
    }

    public void init(String configuration) {
        this.m_additionalButtons = new ArrayList<String>(OPTIONAL_BUTTONS_LIST.size());
        this.m_configuration = configuration;
        this.m_editorHeight = EDITOR_DEFAULTHEIGHT;
        this.m_hiddenButtons = new ArrayList<String>();
        this.parseOptions(configuration);
    }

    public boolean isButtonAdditional(String buttonName) {
        return this.getAdditionalButtons().contains(buttonName);
    }

    public boolean isButtonHidden(String buttonName) {
        return this.getHiddenButtons().contains(buttonName);
    }

    public boolean isButtonOptional(String buttonName) {
        return OPTIONAL_BUTTONS_LIST.contains(buttonName);
    }

    public boolean isFullPage() {
        return this.m_fullPage;
    }

    public void setAdditionalButtons(List<String> buttons) {
        this.m_additionalButtons = buttons;
    }

    public void setButtonBarOption(List<String> buttonBar) {
        this.m_buttonBarOption = buttonBar;
    }

    public void setButtonBarOptionString(String buttonBar) {
        this.m_buttonBarOptionString = buttonBar;
    }

    public void setCssPath(String cssPath) {
        this.m_cssPath = cssPath;
    }

    public void setEditorHeight(String editorHeight) {
        this.m_editorHeight = editorHeight;
    }

    public void setFormatSelectOptions(String formatSelectOptions) {
        this.m_formatSelectOptions = formatSelectOptions;
    }

    public void setFullPage(boolean fullPage) {
        this.m_fullPage = fullPage;
    }

    public void setHiddenButtons(List<String> buttons) {
        this.m_hiddenButtons = buttons;
    }

    public void setStylesFormatPath(String stylesFormatPath) {
        this.m_stylesFormatPath = stylesFormatPath;
    }

    public void setStylesXmlPath(String stylesXmlPath) {
        this.m_stylesXmlPath = stylesXmlPath;
    }

    public boolean showAnchorDialog() {
        return this.getAdditionalButtons().contains(OPTION_ANCHOR);
    }

    public boolean showFormatSelect() {
        return this.getAdditionalButtons().contains(OPTION_FORMATSELECT);
    }

    public boolean showGalleryDialog(String galleryType) {
        return this.getAdditionalButtons().contains(galleryType);
    }

    public boolean showImageDialog() {
        return this.getAdditionalButtons().contains(OPTION_IMAGE);
    }

    public boolean showLinkDialog() {
        return this.getAdditionalButtons().contains(OPTION_LINK);
    }

    public boolean showSourceEditor() {
        return this.getAdditionalButtons().contains(OPTION_SOURCE);
    }

    public boolean showStylesFormat() {
        return CmsStringUtil.isNotEmpty(this.getStylesFormatPath());
    }

    public boolean showStylesXml() {
        return CmsStringUtil.isNotEmpty(this.getStylesXmlPath());
    }

    public boolean showTableDialog() {
        return this.getAdditionalButtons().contains(OPTION_TABLE);
    }

    public boolean useCss() {
        return CmsStringUtil.isNotEmpty(this.getCssPath());
    }

    protected void addAdditionalButton(String buttonName) {
        this.m_additionalButtons.add(buttonName);
    }

    protected String getButtonName(String barItem, Map<String, String> buttonNamesLookUp) {
        String translatedName;
        String result = barItem;
        if (buttonNamesLookUp != null && CmsStringUtil.isNotEmpty(translatedName = buttonNamesLookUp.get(barItem))) {
            result = translatedName;
        }
        return result;
    }

    protected void parseOptions(String configuration) {
        if (CmsStringUtil.isNotEmpty(configuration)) {
            CmsPair<String, Map<String, String>> simplifiedStringAndGalleryOptions = CmsHtmlWidgetOption.parseEmbeddedGalleryOptions(configuration);
            configuration = simplifiedStringAndGalleryOptions.getFirst();
            this.m_embeddedConfigurations = simplifiedStringAndGalleryOptions.getSecond();
            List<String> options = CmsStringUtil.splitAsList(configuration, DELIMITER_OPTION, true);
            for (String option : options) {
                if (option.startsWith(OPTION_FORMATSELECT_OPTIONS)) {
                    option = option.substring(OPTION_FORMATSELECT_OPTIONS.length());
                    this.setFormatSelectOptions(option);
                    continue;
                }
                if (option.startsWith(OPTION_HEIGHT)) {
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(option = option.substring(OPTION_HEIGHT.length()))) continue;
                    this.setEditorHeight(option);
                    continue;
                }
                if (option.startsWith(OPTION_HIDEBUTTONS)) {
                    option = option.substring(OPTION_HIDEBUTTONS.length());
                    this.setHiddenButtons(CmsStringUtil.splitAsList(option, ';', true));
                    continue;
                }
                if (option.startsWith(OPTION_CSS)) {
                    option = option.substring(OPTION_CSS.length());
                    this.setCssPath(option);
                    continue;
                }
                if (option.startsWith(OPTION_STYLES)) {
                    option = option.substring(OPTION_STYLES.length());
                    this.setStylesXmlPath(option);
                    continue;
                }
                if (option.startsWith(OPTION_STYLES_FORMAT)) {
                    option = option.substring(OPTION_STYLES_FORMAT.length());
                    this.setStylesFormatPath(option);
                    continue;
                }
                if (option.startsWith(OPTION_BUTTONBAR)) {
                    option = option.substring(OPTION_BUTTONBAR.length());
                    this.setButtonBarOptionString(option);
                    continue;
                }
                if (!OPTIONAL_BUTTONS_LIST.contains(option)) continue;
                this.addAdditionalButton(option);
            }
        }
    }
}

