/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.apache.commons.logging.Log;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsLocationPickerWidgetValue {
    public static final int DEFAULT_HEIGHT = 300;
    public static final float DEFAULT_LAT = 0.0f;
    public static final float DEFAULT_LNG = 0.0f;
    public static final MapMode DEFAULT_MODE = MapMode.dynamicMode;
    public static final MapType DEFAULT_TYPE = MapType.roadmap;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_ZOOM = 10;
    public static final String OPTION_HEIGHT = "height";
    public static final String OPTION_LAT = "lat";
    public static final String OPTION_LNG = "lng";
    public static final String OPTION_MODE = "mode";
    public static final String OPTION_TYPE = "type";
    public static final String OPTION_WIDTH = "width";
    public static final String OPTION_ZOOM = "zoom";
    private static final Log LOG = CmsLog.getLog(CmsLocationPickerWidgetValue.class);
    private int m_height = 300;
    private float m_lat = 0.0f;
    private float m_lng = 0.0f;
    private MapMode m_mode = DEFAULT_MODE;
    private MapType m_type = DEFAULT_TYPE;
    private int m_width = 400;
    private int m_zoom = 10;

    public CmsLocationPickerWidgetValue() {
    }

    public CmsLocationPickerWidgetValue(String value) {
        this();
        this.parseOptions(value);
    }

    public int getHeight() {
        return this.m_height;
    }

    public float getLat() {
        return this.m_lat;
    }

    public float getLng() {
        return this.m_lng;
    }

    public MapMode getMode() {
        return this.m_mode;
    }

    public MapType getType() {
        return this.m_type;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getZoom() {
        return this.m_zoom;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public void setLat(float lat) {
        this.m_lat = lat;
    }

    public void setLng(float lng) {
        this.m_lng = lng;
    }

    public void setMode(MapMode mode) {
        this.m_mode = mode;
    }

    public void setType(MapType type) {
        this.m_type = type;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public void setWrappedValue(String value) {
        this.parseOptions(value);
    }

    public void setZoom(int zoom) {
        this.m_zoom = zoom;
    }

    public String toString() {
        JSONObject json;
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    json = new JSONObject();
                                    try {
                                        json.put(OPTION_LAT, this.getLat());
                                    }
                                    catch (JSONException e) {
                                        if (!LOG.isErrorEnabled()) break block14;
                                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    }
                                }
                                try {
                                    json.put(OPTION_LNG, this.getLng());
                                }
                                catch (JSONException e) {
                                    if (!LOG.isErrorEnabled()) break block15;
                                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                            try {
                                json.put(OPTION_ZOOM, this.getZoom());
                            }
                            catch (JSONException e) {
                                if (!LOG.isErrorEnabled()) break block16;
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        try {
                            json.put(OPTION_WIDTH, this.getWidth());
                        }
                        catch (JSONException e) {
                            if (!LOG.isErrorEnabled()) break block17;
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    try {
                        json.put(OPTION_HEIGHT, this.getHeight());
                    }
                    catch (JSONException e) {
                        if (!LOG.isErrorEnabled()) break block18;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                try {
                    json.put(OPTION_TYPE, this.getType().toString());
                }
                catch (JSONException e) {
                    if (!LOG.isErrorEnabled()) break block19;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            try {
                json.put(OPTION_MODE, this.getMode().getMode());
            }
            catch (JSONException e) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return json.toString();
    }

    protected void parseOptions(String configuration) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(configuration)) {
            return;
        }
        if (!configuration.startsWith("{")) {
            configuration = "{" + configuration + "}";
        }
        try {
            JSONObject json = new JSONObject(configuration);
            if (json.has(OPTION_LAT)) {
                this.setLat((float)json.getDouble(OPTION_LAT));
            }
            if (json.has(OPTION_LNG)) {
                this.setLng((float)json.getDouble(OPTION_LNG));
            }
            if (json.has(OPTION_ZOOM)) {
                this.setZoom(json.getInt(OPTION_ZOOM));
            }
            if (json.has(OPTION_WIDTH)) {
                this.setWidth(json.getInt(OPTION_WIDTH));
            }
            if (json.has(OPTION_HEIGHT)) {
                this.setHeight(json.getInt(OPTION_HEIGHT));
            }
            if (json.has(OPTION_TYPE)) {
                this.setType(MapType.valueOf(json.getString(OPTION_TYPE)));
            }
            if (json.has(OPTION_MODE)) {
                this.setMode(MapMode.parseMode(json.getString(OPTION_MODE)));
            }
        }
        catch (JSONException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
    }

    public static enum MapType {
        hybrid,
        roadmap,
        satellite,
        terrain;


        public boolean isHybrid() {
            return this == hybrid;
        }

        public boolean isMap() {
            return this == roadmap;
        }

        public boolean isSatellite() {
            return this == satellite;
        }

        public boolean isTerrain() {
            return this == terrain;
        }
    }

    public static enum MapMode {
        dynamicMode("dynamic"),
        staticMode("static");

        private String m_modeValue;

        private MapMode(String modeValue) {
            this.m_modeValue = modeValue;
        }

        public static MapMode parseMode(String mode) {
            MapMode result = null;
            if (dynamicMode.getMode().equals(mode)) {
                result = dynamicMode;
            } else if (staticMode.getMode().equals(mode)) {
                result = staticMode;
            }
            return result;
        }

        public String getMode() {
            return this.m_modeValue;
        }

        public boolean isDynamic() {
            return this == dynamicMode;
        }

        public boolean isStatic() {
            return this == staticMode;
        }
    }
}

