/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

public class CmsReport
extends CmsMultiDialog {
    public static final String PARAM_REPORT_CONTINUEKEY = "reportcontinuekey";
    public static final String PARAM_REPORT_TYPE = "reporttype";
    public static final int REPORT_UPDATE_SIZE = 512000;
    public static final int REPORT_UPDATE_TIME = 2000;
    private static final Log LOG = CmsLog.getLog(CmsReport.class);
    private String m_paramRefreshWorkplace;
    private String m_paramReportContinueKey;
    private String m_paramReportType;
    private CmsUUID m_paramThread;
    private String m_paramThreadHasNext;

    public CmsReport(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsReport(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String generateCssStyle(CmsObject cms) {
        StringBuffer result = new StringBuffer(128);
        result.append("<style type='text/css'>\n");
        String contents = "";
        try {
            contents = new String(cms.readFile("/system/workplace/commons/style/report.css").getContents(), OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CmsStringUtil.isEmpty(contents)) {
            result.append("body       { box-sizing: border-box; -moz-box-sizing: border-box; padding: 2px; margin: 0; color: /*begin-color WindowText*/#000000/*end-color*/; background-color: /*begin-color Window*/#ffffff/*end-color*/; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px; }\n");
            result.append("div.main   { box-sizing: border-box; -moz-box-sizing: border-box; color: /*begin-color WindowText*/#000000/*end-color*/; white-space: nowrap; }\n");
            result.append("span.head  { color: #000099; font-weight: bold; }\n");
            result.append("span.note  { color: #666666; }\n");
            result.append("span.ok    { color: #009900; }\n");
            result.append("span.warn  { color: #990000; padding-left: 40px; }\n");
            result.append("span.err   { color: #990000; font-weight: bold; padding-left: 40px; }\n");
            result.append("span.throw { color: #990000; font-weight: bold; }\n");
            result.append("span.link1 { color: #666666; }\n");
            result.append("span.link2 { color: #666666; padding-left: 40px; }\n");
            result.append("span.link2 { color: #990000; }\n");
        } else {
            result.append(contents);
        }
        result.append("</style>\n");
        return result.toString();
    }

    public static String generatePageEndExtended() {
        StringBuffer result = new StringBuffer(128);
        result.append("</div>\n");
        result.append("</body>\n");
        result.append("</html>\n");
        return result.toString();
    }

    public static String generatePageEndSimple() {
        StringBuffer result = new StringBuffer(128);
        result.append("</td></tr>\n");
        result.append("</table></div>\n");
        result.append("</body>\n</html>");
        return result.toString();
    }

    public static String generatePageStartExtended(CmsObject cms, String encoding) {
        StringBuffer result = new StringBuffer(128);
        result.append("<html>\n<head>\n");
        result.append("<meta HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=");
        result.append(encoding);
        result.append("'>\n");
        result.append(CmsReport.generateCssStyle(cms));
        result.append("</head>\n");
        result.append("<body style='overflow: auto;'>\n");
        result.append("<div class='main'>\n");
        return result.toString();
    }

    public static String generatePageStartSimple(CmsWorkplace wp) {
        StringBuffer result = new StringBuffer(128);
        result.append("<html>\n<head>\n");
        result.append("<meta HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=");
        result.append(wp.getEncoding());
        result.append("'>\n");
        result.append("<link rel='stylesheet' type='text/css' href='");
        result.append(wp.getStyleUri("workplace.css"));
        result.append("'>\n");
        result.append(CmsReport.generateCssStyle(wp.getCms()));
        result.append("</head>\n");
        result.append("<body style='background-color:/*begin-color Menu*/#f0f0f0/*end-color*/;'>\n");
        result.append("<div style='vertical-align:middle; height: 100%;'>\n");
        result.append("<table border='0' style='vertical-align:middle; height: 100%;'>\n");
        result.append("<tr><td width='40' align='center' valign='middle'><img name='report_img' src='");
        result.append(CmsWorkplace.getSkinUri());
        result.append("commons/wait.gif' width='32' height='32' alt=''></td>\n");
        result.append("<td valign='middle'>");
        return result.toString();
    }

    public static CmsReport initCmsReport(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        CmsReport wp = (CmsReport)req.getAttribute("__CmsWorkplace.WORKPLACE_CLASS");
        if (wp == null) {
            wp = new CmsReport(new CmsJspActionElement(context, req, res));
        }
        return wp;
    }

    public String dialogButtonsContinue(String okAttrs, String cancelAttrs, String detailsAttrs) {
        detailsAttrs = CmsStringUtil.isEmptyOrWhitespaceOnly(detailsAttrs) ? "" : detailsAttrs + " ";
        return this.dialogButtons(new int[]{0, 1, 5}, new String[]{okAttrs, cancelAttrs, detailsAttrs + "onclick=\"switchOutputFormat();\""});
    }

    public String dialogButtonsOkCancelDetails(String okAttrs, String cancelAttrs, String detailsAttrs) {
        detailsAttrs = CmsStringUtil.isEmptyOrWhitespaceOnly(detailsAttrs) ? "" : detailsAttrs + " ";
        if (Boolean.valueOf(this.getParamThreadHasNext()).booleanValue() && CmsStringUtil.isNotEmpty(this.getParamReportContinueKey())) {
            return this.dialogButtons(new int[]{0, 1, 5}, new String[]{okAttrs, cancelAttrs, detailsAttrs + "onclick=\"switchOutputFormat();\""});
        }
        return this.dialogButtons(new int[]{0, 5}, new String[]{okAttrs, detailsAttrs + "onclick=\"switchOutputFormat();\""});
    }

    public String getParamRefreshWorkplace() {
        return this.m_paramRefreshWorkplace;
    }

    public String getParamReportContinueKey() {
        if (this.m_paramReportContinueKey == null) {
            this.m_paramReportContinueKey = "";
        }
        return this.m_paramReportContinueKey;
    }

    public String getParamReportType() {
        if (this.m_paramReportType == null) {
            this.setParamReportType(this.getSettings().getUserSettings().getWorkplaceReportType());
        }
        return this.m_paramReportType;
    }

    public String getParamThread() {
        if (this.m_paramThread != null && !this.m_paramThread.equals(CmsUUID.getNullUUID())) {
            return this.m_paramThread.toString();
        }
        return null;
    }

    public String getParamThreadHasNext() {
        if (this.m_paramThreadHasNext == null) {
            this.m_paramThreadHasNext = "";
        }
        return this.m_paramThreadHasNext;
    }

    public String getReportUpdate() {
        A_CmsReportThread thread = OpenCms.getThreadStore().retrieveThread(this.m_paramThread);
        if (thread != null) {
            return thread.getReportUpdate();
        }
        return "";
    }

    public boolean hasError() {
        A_CmsReportThread thread = OpenCms.getThreadStore().retrieveThread(this.m_paramThread);
        if (thread != null) {
            return thread.hasError();
        }
        return false;
    }

    @Override
    public String htmlStart() {
        return this.pageHtml(0, true);
    }

    public String htmlStart(boolean loadStyles) {
        return this.pageHtml(0, loadStyles);
    }

    public boolean isAlive() {
        A_CmsReportThread thread = OpenCms.getThreadStore().retrieveThread(this.m_paramThread);
        if (thread != null) {
            return thread.isAlive();
        }
        return false;
    }

    public boolean isSimpleReport() {
        return this.getParamReportType().equalsIgnoreCase("simple");
    }

    public String pageHtml(int segment, boolean loadStyles) {
        if (this.useNewStyle()) {
            return super.pageHtml(segment, null, this.getParamTitle());
        }
        if (segment == 0) {
            StringBuffer result = new StringBuffer(512);
            result.append("<!DOCTYPE html>\n");
            result.append("<html>\n<head>\n");
            result.append("<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=");
            result.append(this.getEncoding());
            result.append("\">\n");
            if (loadStyles) {
                result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                result.append(CmsReport.getStyleUri(this.getJsp(), "workplace.css"));
                result.append("\">\n");
                result.append("<script type=\"text/javascript\">\n");
                result.append(this.dialogScriptSubmit());
                result.append("</script>\n");
            }
            return result.toString();
        }
        return "</html>";
    }

    public String reportConclusionText() {
        return "";
    }

    public String reportIntroductionText() {
        return "";
    }

    public void setParamRefreshWorkplace(String value) {
        this.m_paramRefreshWorkplace = value;
    }

    public void setParamReportContinueKey(String key) {
        this.m_paramReportContinueKey = key;
    }

    public void setParamReportType(String value) {
        this.m_paramReportType = value;
    }

    public void setParamThread(String value) {
        block3: {
            this.m_paramThread = CmsUUID.getNullUUID();
            if (value != null) {
                try {
                    this.m_paramThread = new CmsUUID(value);
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_THREAD_CREATION_FAILED_1", new Integer(value)), (Throwable)e);
                }
            }
        }
    }

    public void setParamThreadHasNext(String value) {
        this.m_paramThreadHasNext = value;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if ("reportupdate".equals(this.getParamAction())) {
            this.setAction(91);
        } else {
            this.setAction(90);
        }
    }

    @Override
    protected boolean performDialogOperation() throws CmsException {
        throw new CmsException(new CmsMessageContainer(null, ""));
    }
}

