/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.List;
import java.util.Map;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.CmsLockedResourcesCollector;
import org.opencms.workplace.commons.CmsPublishBrokenRelationFormatter;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListIndependentJsAction;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListResourceProjStateAction;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsLockedResourcesList
extends A_CmsListExplorerDialog {
    public static final String LIST_DETAIL_OWN_LOCKS = "dol";
    public static final String LIST_DETAIL_OWN_LOCKS_HIDE = "dolh";
    public static final String LIST_DETAIL_OWN_LOCKS_SHOW = "dols";
    public static final String LIST_ID = "llr";
    protected static final String LIST_COLUMN_IS_RELATED = "ecir";
    private I_CmsListResourceCollector m_collector;
    private Map<String, String> m_lockParams;

    public CmsLockedResourcesList(CmsJspActionElement jsp, List<String> lockedResources, String relativeTo, Map<String, String> lockParams) {
        super(jsp, LIST_ID, Messages.get().container("GUI_LOCKED_FILES_LIST_NAME_0"));
        this.m_collector = new CmsLockedResourcesCollector(this, lockedResources);
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setAbbrevLength(50);
        resUtil.setRelativeTo(this.getCms().getRequestContext().addSiteRoot(relativeTo));
        this.m_lockParams = lockParams;
        this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OWN_LOCKS).setVisible(Boolean.valueOf(this.getLockParams().get("showownlocks")));
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        return this.m_collector;
    }

    public Map<String, String> getLockParams() {
        return this.m_lockParams;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        boolean isVisible = colFlag == 1;
        isVisible = isVisible || colFlag == 256;
        isVisible = isVisible || colFlag == "ecti".hashCode();
        isVisible = isVisible || colFlag == "ecli".hashCode();
        isVisible = isVisible || colFlag == "ecpi".hashCode();
        isVisible = isVisible || colFlag == "ecn".hashCode();
        return isVisible;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        for (CmsListColumnDefinition colDefinition : metadata.getColumnDefinitions()) {
            colDefinition.setSorteable(false);
            if (colDefinition.getId().equals("ecn")) {
                colDefinition.removeDefaultAction("edo");
                colDefinition.setWidth("60%");
                continue;
            }
            if (!colDefinition.getId().equals("ecpi")) continue;
            colDefinition.removeDirectAction("eaps");
            CmsListResourceProjStateAction resourceProjStateAction = new CmsListResourceProjStateAction("eaps"){

                @Override
                public String getIconPath() {
                    if (((Boolean)this.getItem().get(CmsLockedResourcesList.LIST_COLUMN_IS_RELATED)).booleanValue()) {
                        return "explorer/related_resource.png";
                    }
                    return super.getIconPath();
                }

                @Override
                public CmsMessageContainer getName() {
                    if (((Boolean)this.getItem().get(CmsLockedResourcesList.LIST_COLUMN_IS_RELATED)).booleanValue()) {
                        return Messages.get().container("GUI_PUBLISH_RELATED_RESOURCE_0");
                    }
                    return super.getName();
                }
            };
            resourceProjStateAction.setEnabled(false);
            colDefinition.addDirectAction(resourceProjStateAction);
        }
        CmsListExplorerColumn relatedCol = new CmsListExplorerColumn(LIST_COLUMN_IS_RELATED);
        relatedCol.setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_NAME_0"));
        relatedCol.setVisible(false);
        relatedCol.setPrintable(false);
        metadata.addColumn(relatedCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        abstract class DetailsJsAction
        extends A_CmsListIndependentJsAction {
            public DetailsJsAction(String id) {
                super(id);
            }

            @Override
            public String buttonHtml(CmsWorkplace wp) {
                StringBuffer html = new StringBuffer(1024);
                html.append("\t<span id='");
                html.append(this.getId());
                html.append("' class=\"link");
                html.append("\"");
                html.append(" onClick=\"");
                html.append(this.resolveOnClic(wp));
                html.append("\"");
                html.append(">");
                html.append("<img src='");
                html.append(CmsWorkplace.getSkinUri());
                html.append(super.getIconPath());
                html.append("'");
                html.append(" alt='");
                html.append(super.getName().key(wp.getLocale()));
                html.append("'");
                html.append(" title='");
                html.append(super.getName().key(wp.getLocale()));
                html.append("'");
                html.append(">");
                html.append("&nbsp;");
                html.append("<a href='#'>");
                html.append(super.getName().key(wp.getLocale()));
                html.append("</a>");
                html.append("</span>");
                return html.toString();
            }

            protected String getRequestLink(CmsWorkplace wp, boolean showOwnLocks) {
                Map<String, String> params = ((CmsLockedResourcesList)wp).getLockParams();
                StringBuffer html = new StringBuffer(128);
                html.append("javascript:{ajaxReportContent = ''; document.getElementById('ajaxreport').innerHTML = ajaxWaitMessage; makeRequest('");
                html.append(wp.getJsp().link("/system/workplace/commons/report-locks.jsp"));
                html.append("', '");
                boolean needsAmpersand = false;
                if (params.get("resourcelist") != null) {
                    html.append("resourcelist");
                    html.append("=");
                    html.append(CmsEncoder.escapeXml(params.get("resourcelist")));
                    needsAmpersand = true;
                }
                if (params.get("resource") != null) {
                    if (needsAmpersand) {
                        html.append("&");
                    }
                    html.append("resource");
                    html.append("=");
                    html.append(CmsEncoder.escapeXml(params.get("resource")));
                    needsAmpersand = true;
                }
                if (params.get("includerelated") != null) {
                    if (needsAmpersand) {
                        html.append("&");
                    }
                    html.append("includerelated");
                    html.append("=");
                    html.append(CmsEncoder.escapeXml(params.get("includerelated")));
                }
                if (needsAmpersand) {
                    html.append("&");
                }
                html.append("showownlocks");
                html.append("=").append(showOwnLocks).append("', 'doReportUpdate');}");
                return html.toString();
            }
        }
        DetailsJsAction hideAction = new DetailsJsAction(LIST_DETAIL_OWN_LOCKS_HIDE){
            {
                super(x0);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return this.getRequestLink(wp, false);
            }
        };
        hideAction.setIconPath("list/details_hide.png");
        hideAction.setName(Messages.get().container("GUI_LOCK_DETAIL_HIDE_OWN_LOCKS_NAME_0"));
        hideAction.setHelpText(Messages.get().container("GUI_LOCK_DETAIL_HIDE_OWN_LOCKS_HELP_0"));
        DetailsJsAction showAction = new DetailsJsAction(LIST_DETAIL_OWN_LOCKS_SHOW){
            {
                super(x0);
            }

            @Override
            public String jsCode(CmsWorkplace wp) {
                return this.getRequestLink(wp, true);
            }
        };
        showAction.setIconPath("list/details_show.png");
        showAction.setName(Messages.get().container("GUI_LOCK_DETAIL_SHOW_OWN_LOCKS_NAME_0"));
        showAction.setHelpText(Messages.get().container("GUI_LOCK_DETAIL_SHOW_OWN_LOCKS_HELP_0"));
        CmsListItemDetails relationsDetails = new CmsListItemDetails(LIST_DETAIL_OWN_LOCKS);
        relationsDetails.setAtColumn("ecn");
        relationsDetails.setVisible(false);
        relationsDetails.setFormatter(new CmsPublishBrokenRelationFormatter());
        relationsDetails.setHideAction(hideAction);
        relationsDetails.setShowAction(showAction);
        metadata.addItemDetails(relationsDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
        metadata.setSearchAction(null);
    }
}

