/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPasswordInfo;
import org.opencms.site.CmsSite;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.workplace.CmsTabDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.CmsWorkplaceView;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.editors.CmsWorkplaceEditorConfiguration;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.galleries.A_CmsAjaxGallery;

public class CmsPreferences
extends CmsTabDialog {
    public static final int ACTION_CHPWD = 202;
    public static final int ACTION_ERROR = 203;
    public static final int ACTION_RELOAD = 201;
    public static final String DIALOG_CHPWD = "chpwd";
    public static final String DIALOG_RELOAD = "reload";
    public static final String DIALOG_TYPE = "preferences";
    public static final String INPUT_DEFAULT = "default";
    public static final String INPUT_NONE = "none";
    public static final String INPUT_PRESELECT = "preselect";
    public static final String PARAM_DIALOGS_COPYFILEMODE = "tabdicopyfilemode";
    public static final String PARAM_DIALOGS_COPYFOLDERMODE = "tabdicopyfoldermode";
    public static final String PARAM_DIALOGS_DELETEFILEMODE = "tabdideletefilemode";
    public static final String PARAM_DIALOGS_PERMISSIONS_EXPANDINHERITED = "tabdipermissionsexpandinherited";
    public static final String PARAM_DIALOGS_PERMISSIONS_EXPANDUSER = "tabdipermissionsexpanduser";
    public static final String PARAM_DIALOGS_PERMISSIONS_INHERITONFOLDER = "tabdipermissionsinheritonfolder";
    public static final String PARAM_DIALOGS_PUBLISHFILEMODE = "tabdipublishfilemode";
    public static final String PARAM_DIALOGS_SHOWLOCK = "tabdishowlock";
    public static final String PARAM_DIRECTEDIT_BUTTONSTYLE = "tabeddirecteditbuttonstyle";
    public static final String PARAM_EDITOR_BUTTONSTYLE = "tabedbuttonstyle";
    public static final String PARAM_EXPLORER_BUTTONSTYLE = "tabexbuttonstyle";
    public static final String PARAM_EXPLORER_FILEDATECREATED = "tabexfiledatecreated";
    public static final String PARAM_EXPLORER_FILEDATEEXPIRED = "tabexfiledateexpired";
    public static final String PARAM_EXPLORER_FILEDATELASTMODIFIED = "tabexfiledatelastmodified";
    public static final String PARAM_EXPLORER_FILEDATERELEASED = "tabexfiledatereleased";
    public static final String PARAM_EXPLORER_FILEENTRIES = "tabexfileentries";
    public static final String PARAM_EXPLORER_FILELOCKEDBY = "tabexfilelockedby";
    public static final String PARAM_EXPLORER_FILENAVTEXT = "tabexfilenavtext";
    public static final String PARAM_EXPLORER_FILEPERMISSIONS = "tabexfilepermissions";
    public static final String PARAM_EXPLORER_FILESIZE = "tabexfilesize";
    public static final String PARAM_EXPLORER_FILESTATE = "tabexfilestate";
    public static final String PARAM_EXPLORER_FILETITLE = "tabexfiletitle";
    public static final String PARAM_EXPLORER_FILETYPE = "tabexfiletype";
    public static final String PARAM_EXPLORER_FILEUSERCREATED = "tabexfileusercreated";
    public static final String PARAM_EXPLORER_FILEUSERLASTMODIFIED = "tabexfileuserlastmodified";
    public static final String PARAM_EXPLORER_SEARCH_RESULT = "tabexworkplacesearchresult";
    public static final String PARAM_NEWPASSWORD = "newpassword";
    public static final String PARAM_OLDPASSWORD = "oldpassword";
    public static final String PARAM_PREFERREDEDITOR_PREFIX = "tabedprefed_";
    public static final String PARAM_STARTGALLERY_PREFIX = "tabgastartgallery_";
    public static final String PARAM_WORKPLACE_BUTTONSTYLE = "tabwpbuttonstyle";
    public static final String PARAM_WORKPLACE_FOLDER = "tabwpfolder";
    public static final String PARAM_WORKPLACE_LANGUAGE = "tabwplanguage";
    public static final String PARAM_WORKPLACE_LISTALLPROJECTS = "tabwplistallprojects";
    public static final String PARAM_WORKPLACE_PROJECT = "tabwpproject";
    public static final String PARAM_WORKPLACE_REPORTTYPE = "tabwpreporttype";
    public static final String PARAM_WORKPLACE_RESTRICTEXPLORERVIEW = "tabwprestrictexplorerview";
    public static final String PARAM_WORKPLACE_SHOWPUBLISHNOTIFICATION = "tabwpshowpublishnotification";
    public static final String PARAM_WORKPLACE_SITE = "tabwpsite";
    public static final String PARAM_WORKPLACE_TIMEWARP = "tabwptimewarp";
    public static final String PARAM_WORKPLACE_UPLOADVARIANT = "tabwpuploadvariant";
    public static final String PARAM_WORKPLACE_VIEW = "tabwpview";
    private static final Log LOG = CmsLog.getLog(CmsPreferences.class);
    private String m_paramNewPassword;
    private String m_paramOldPassword;
    private CmsUserSettings m_userSettings;

    public CmsPreferences(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPreferences(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static SelectOptions getOptionsForLanguageStatic(Locale setLocale, Locale prevLocale) {
        List<Locale> locales = OpenCms.getWorkplaceManager().getLocales();
        ArrayList<String> options = new ArrayList<String>(locales.size());
        ArrayList<String> values = new ArrayList<String>(locales.size());
        int checkedIndex = 0;
        int counter = 0;
        for (Locale currentLocale : locales) {
            String language = currentLocale.getDisplayLanguage(setLocale);
            if (CmsStringUtil.isNotEmpty(currentLocale.getCountry())) {
                language = language + " (" + currentLocale.getDisplayCountry(setLocale) + ")";
            }
            if (CmsStringUtil.isNotEmpty(currentLocale.getVariant())) {
                language = language + " (" + currentLocale.getDisplayVariant(setLocale) + ")";
            }
            options.add(language);
            values.add(currentLocale.toString());
            if (prevLocale.toString().equals(currentLocale.toString())) {
                checkedIndex = counter;
            }
            ++counter;
        }
        SelectOptions selectOptions = new SelectOptions(options, values, checkedIndex);
        return selectOptions;
    }

    public static SelectOptions getProjectSelectOptionsStatic(CmsObject cms, String startProject, Locale locale) {
        List<Object> allProjects;
        try {
            String ouFqn = "";
            CmsUserSettings settings = new CmsUserSettings(cms);
            if (!settings.getListAllProjects()) {
                ouFqn = cms.getRequestContext().getCurrentUser().getOuFqn();
            }
            allProjects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, ouFqn, settings.getListAllProjects());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            allProjects = Collections.emptyList();
        }
        boolean singleOu = true;
        String ouFqn = null;
        for (CmsProject cmsProject : allProjects) {
            if (cmsProject.isOnlineProject()) continue;
            if (ouFqn == null) {
                ouFqn = cmsProject.getOuFqn();
            }
            if (ouFqn.equals(cmsProject.getOuFqn())) continue;
            singleOu = false;
            break;
        }
        ArrayList<String> arrayList = new ArrayList<String>(allProjects.size());
        ArrayList<String> values = new ArrayList<String>(allProjects.size());
        int checkedIndex = 0;
        int n = allProjects.size();
        for (int i = 0; i < n; ++i) {
            CmsProject project = (CmsProject)allProjects.get(i);
            String projectName = project.getSimpleName();
            if (!singleOu && !project.isOnlineProject()) {
                try {
                    projectName = projectName + " - " + OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale);
                }
                catch (CmsException e) {
                    projectName = projectName + " - " + project.getOuFqn();
                }
            }
            arrayList.add(projectName);
            values.add(project.getName());
            if (!startProject.equals(project.getName())) continue;
            checkedIndex = i;
        }
        SelectOptions selectOptions = new SelectOptions(arrayList, values, checkedIndex);
        return selectOptions;
    }

    public static SelectOptions getSiteSelectOptionsStatic(CmsObject cms, String wpSite, Locale locale) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        List<CmsSite> sites = OpenCms.getSiteManager().getAvailableSites(cms, true, false, cms.getRequestContext().getOuFqn());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(wpSite) && !wpSite.endsWith("/")) {
            wpSite = wpSite + "/";
        }
        Iterator<CmsSite> i = sites.iterator();
        int pos = 0;
        while (i.hasNext()) {
            CmsSite site = i.next();
            String siteRoot = site.getSiteRoot();
            if (!siteRoot.endsWith("/")) {
                siteRoot = siteRoot + "/";
            }
            values.add(siteRoot);
            options.add(CmsWorkplace.substituteSiteTitleStatic(site.getTitle(), locale));
            if (siteRoot.equals(wpSite)) {
                selectedIndex = pos;
            }
            ++pos;
        }
        if (sites.size() < 1) {
            String siteRoot = cms.getRequestContext().getSiteRoot();
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            if (!siteRoot.endsWith("/")) {
                siteRoot = siteRoot + "/";
            }
            String title = "";
            if (site != null) {
                title = site.getTitle();
            }
            values.add(siteRoot);
            options.add(title);
        }
        SelectOptions selectOptions = new SelectOptions(options, values, selectedIndex);
        return selectOptions;
    }

    public void actionChangePassword() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        String newPwd = this.getParamNewPassword();
        String oldPwd = this.getParamOldPassword();
        this.setAction(0);
        this.setParamOldPassword(null);
        this.setParamNewPassword(null);
        try {
            CmsPasswordInfo pwdInfo = new CmsPasswordInfo(this.getCms());
            pwdInfo.setCurrentPwd(oldPwd);
            pwdInfo.setNewPwd(newPwd);
            pwdInfo.setConfirmation(newPwd);
            pwdInfo.applyChanges();
        }
        catch (Throwable e) {
            this.setAction(203);
            this.includeErrorpage(this, e);
        }
    }

    public void actionSave() {
        block14: {
            block13: {
                HttpServletRequest request = this.getJsp().getRequest();
                request.setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
                CmsUserSettings userSettings = new CmsUserSettings(this.getSettings().getUser());
                this.m_userSettings.setEditorSettings(userSettings.getEditorSettings());
                this.m_userSettings.setStartGalleriesSetting(userSettings.getStartGalleriesSettings());
                this.m_userSettings.setSynchronizeSettings(userSettings.getSynchronizeSettings());
                Enumeration en = request.getParameterNames();
                while (en.hasMoreElements()) {
                    String paramValue;
                    String paramName = (String)en.nextElement();
                    if (paramName.startsWith(PARAM_PREFERREDEDITOR_PREFIX)) {
                        paramValue = request.getParameter(paramName);
                        if (paramValue != null && !INPUT_DEFAULT.equals(paramValue.trim())) {
                            this.m_userSettings.setPreferredEditor(paramName.substring(PARAM_PREFERREDEDITOR_PREFIX.length()), CmsEncoder.decode(paramValue));
                            continue;
                        }
                        this.m_userSettings.setPreferredEditor(paramName.substring(PARAM_PREFERREDEDITOR_PREFIX.length()), null);
                        continue;
                    }
                    if (!paramName.startsWith(PARAM_STARTGALLERY_PREFIX) || (paramValue = request.getParameter(paramName)) == null) continue;
                    this.m_userSettings.setStartGallery(paramName.substring(PARAM_STARTGALLERY_PREFIX.length()), CmsEncoder.decode(paramValue));
                }
                this.m_userSettings.setUser(this.getSettings().getUser());
                try {
                    this.m_userSettings.save(this.getCms());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block13;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            this.updatePreferences(this.getCms(), this.getJsp().getRequest());
            try {
                String projectName = this.m_userSettings.getStartProject();
                CmsProject project = this.getCms().readProject(projectName);
                this.getCms().getRequestContext().setCurrentProject(project);
                this.getSettings().setProject(project.getUuid());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage());
            }
            try {
                HashMap<String, String[]> params;
                if ("set".equals(this.getParamAction())) {
                    params = new HashMap<String, String[]>();
                    params.put("tab", new String[]{String.valueOf(this.getActiveTab())});
                    params.put("setpressed", new String[]{Boolean.TRUE.toString()});
                    this.sendForward(this.getJsp().getRequestContext().getUri(), params);
                } else {
                    params = new HashMap();
                    params.put("action", new String[]{DIALOG_RELOAD});
                    this.sendForward(this.getJsp().getRequestContext().getUri(), params);
                }
            }
            catch (IOException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            catch (ServletException e) {
                if (!LOG.isInfoEnabled()) break block14;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
    }

    public String buildSelectCopyFileMode(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(2);
        options.add(this.key("GUI_PREF_COPY_AS_SIBLING_0"));
        options.add(this.key("GUI_COPY_AS_NEW_0"));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add(CmsResource.COPY_AS_SIBLING.toString());
        values.add(CmsResource.COPY_AS_NEW.toString());
        int selectedIndex = values.indexOf(this.getParamTabDiCopyFileMode());
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectCopyFolderMode(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(this.key("GUI_PREF_COPY_AS_SIBLINGS_0"));
        options.add(this.key("GUI_PREF_PRESERVE_SIBLINGS_RESOURCES_0"));
        options.add(this.key("GUI_PREF_COPY_AS_NEW_0"));
        ArrayList<String> values = new ArrayList<String>(3);
        values.add(CmsResource.COPY_AS_SIBLING.toString());
        values.add(CmsResource.COPY_PRESERVE_SIBLING.toString());
        values.add(CmsResource.COPY_AS_NEW.toString());
        int selectedIndex = values.indexOf(this.getParamTabDiCopyFolderMode());
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectDeleteFileMode(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(2);
        options.add(this.key("GUI_PREF_PRESERVE_SIBLINGS_0"));
        options.add(this.key("GUI_PREF_DELETE_SIBLINGS_0"));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add(String.valueOf(CmsResource.DELETE_PRESERVE_SIBLINGS));
        values.add(String.valueOf(CmsResource.DELETE_REMOVE_SIBLINGS));
        int selectedIndex = values.indexOf(this.getParamTabDiDeleteFileMode());
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectDirectEditButtonStyle(String htmlAttributes) {
        int selectedIndex = Integer.parseInt(this.getParamTabEdDirectEditButtonStyle());
        return this.buildSelectButtonStyle(htmlAttributes, selectedIndex);
    }

    public String buildSelectEditorButtonStyle(String htmlAttributes) {
        int selectedIndex = Integer.parseInt(this.getParamTabEdButtonStyle());
        return this.buildSelectButtonStyle(htmlAttributes, selectedIndex);
    }

    public String buildSelectExplorerButtonStyle(String htmlAttributes) {
        int selectedIndex = Integer.parseInt(this.getParamTabExButtonStyle());
        return this.buildSelectButtonStyle(htmlAttributes, selectedIndex);
    }

    public String buildSelectExplorerFileEntries(String htmlAttributes) {
        String emptyOption = OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerFileEntryOptions();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(emptyOption)) {
            emptyOption = "50,100,200,300,400,500";
        }
        emptyOption = emptyOption.replaceAll("[^0-9|^,]", "");
        emptyOption = emptyOption.replaceAll(",,", ",");
        List<String> opts = CmsStringUtil.splitAsList(emptyOption, ",", true);
        opts.add(this.key("GUI_LABEL_UNLIMITED_0"));
        opts.remove("0");
        List<String> vals = CmsStringUtil.splitAsList(emptyOption, ",", true);
        vals.add("2147483647");
        vals.remove("0");
        int selectedIndex = 2;
        for (int i = 0; i < vals.size(); ++i) {
            if (!vals.get(i).equals(this.getParamTabExFileEntries())) continue;
            selectedIndex = i;
            break;
        }
        return this.buildSelect(htmlAttributes, opts, vals, selectedIndex);
    }

    public String buildSelectLanguage(String htmlAttributes) {
        SelectOptions selectOptions = this.getOptionsForLanguage();
        return this.buildSelect(htmlAttributes, selectOptions);
    }

    public String buildSelectPreferredEditors(String htmlAttributes) {
        Map<String, SortedMap<Float, CmsWorkplaceEditorConfiguration>> resourceEditors;
        StringBuffer result = new StringBuffer(1024);
        HttpServletRequest request = this.getJsp().getRequest();
        if (htmlAttributes != null) {
            htmlAttributes = htmlAttributes + " name=\"tabedprefed_";
        }
        if ((resourceEditors = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getConfigurableEditors()) != null) {
            Iterator<String> i = resourceEditors.keySet().iterator();
            TreeMap<Float, String> rankResources = new TreeMap<Float, String>();
            while (i.hasNext()) {
                String currentResourceType = i.next();
                CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(currentResourceType);
                rankResources.put(new Float(settings.getNewResourceOrder()), currentResourceType);
            }
            while (rankResources.size() > 0) {
                Float keyVal = (Float)rankResources.firstKey();
                String currentResourceType = (String)rankResources.get(keyVal);
                SortedMap<Float, CmsWorkplaceEditorConfiguration> availableEditors = resourceEditors.get(currentResourceType);
                if (availableEditors != null && availableEditors.size() > 0) {
                    String preSelection = this.computeEditorPreselection(request, currentResourceType);
                    ArrayList<String> options = new ArrayList<String>(availableEditors.size() + 1);
                    ArrayList<String> values = new ArrayList<String>(availableEditors.size() + 1);
                    options.add(this.key("GUI_PREF_EDITOR_BEST_0"));
                    values.add(INPUT_DEFAULT);
                    int selectedIndex = 0;
                    int counter = 1;
                    while (availableEditors.size() > 0) {
                        Float key = availableEditors.lastKey();
                        CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)availableEditors.get(key);
                        options.add(this.keyDefault(conf.getEditorLabel(), conf.getEditorLabel()));
                        values.add(conf.getEditorUri());
                        if (conf.getEditorUri().equals(preSelection)) {
                            selectedIndex = counter;
                        }
                        ++counter;
                        availableEditors.remove(key);
                    }
                    result.append("<tr>\n\t<td style=\"white-space: nowrap;\">");
                    String localizedName = this.keyDefault("label.editor.preferred." + currentResourceType, "");
                    if (CmsStringUtil.isEmpty(localizedName)) {
                        localizedName = CmsWorkplaceMessages.getResourceTypeName(this, currentResourceType);
                    }
                    result.append(localizedName);
                    result.append("</td>\n\t<td>");
                    result.append(this.buildSelect(htmlAttributes + currentResourceType + "\"", options, values, selectedIndex));
                    result.append("</td>\n</tr>\n");
                }
                rankResources.remove(keyVal);
            }
        }
        return result.toString();
    }

    public String buildSelectProject(String htmlAttributes) {
        SelectOptions selectOptions = this.getProjectSelectOptions();
        return this.buildSelect(htmlAttributes, selectOptions);
    }

    public String buildSelectPublishSiblings(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(2);
        options.add(this.key("GUI_PREF_PUBLISH_SIBLINGS_0"));
        options.add(this.key("GUI_PREF_PUBLISH_ONLY_SELECTED_0"));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add(CmsStringUtil.TRUE);
        values.add(CmsStringUtil.FALSE);
        int selectedIndex = values.indexOf(this.getParamTabDiPublishFileMode());
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectReportType(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(2);
        options.add(this.key("GUI_LABEL_SIMPLE_0"));
        options.add(this.key("GUI_LABEL_EXTENDED_0"));
        String[] vals = new String[]{"simple", "extended"};
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(vals));
        int selectedIndex = 0;
        if ("extended".equals(this.getParamTabWpReportType())) {
            selectedIndex = 1;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectSite(String htmlAttributes) {
        SelectOptions selectOptions = this.getSiteSelectOptions();
        return this.buildSelect(htmlAttributes, selectOptions);
    }

    public String buildSelectStartGalleries(String htmlAttributes) {
        Map<String, A_CmsAjaxGallery> galleriesTypes;
        StringBuffer result = new StringBuffer(1024);
        HttpServletRequest request = this.getJsp().getRequest();
        if (htmlAttributes != null) {
            htmlAttributes = htmlAttributes + " name=\"tabgastartgallery_";
        }
        if ((galleriesTypes = OpenCms.getWorkplaceManager().getGalleries()) != null) {
            TreeMap<String, String> localizedGalleries = new TreeMap<String, String>();
            for (String string : galleriesTypes.keySet()) {
                String localizedName = CmsWorkplaceMessages.getResourceTypeName(this, string);
                localizedGalleries.put(localizedName, string);
            }
            for (Map.Entry entry : localizedGalleries.entrySet()) {
                String currentGalleryType = (String)entry.getValue();
                int currentGalleryTypeId = 0;
                try {
                    currentGalleryTypeId = OpenCms.getResourceManager().getResourceType(currentGalleryType).getTypeId();
                }
                catch (CmsLoaderException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                List<CmsResource> availableGalleries = A_CmsAjaxGallery.getGalleries(currentGalleryTypeId, this.getCms());
                ArrayList<String> options = new ArrayList<String>(availableGalleries.size() + 2);
                ArrayList<String> values = new ArrayList<String>(availableGalleries.size() + 2);
                options.add(this.key("GUI_PREF_STARTGALLERY_PRESELECT_0"));
                values.add(INPUT_DEFAULT);
                options.add(this.key("GUI_PREF_STARTGALLERY_NONE_0"));
                values.add(INPUT_NONE);
                String savedValue = this.computeStartGalleryPreselection(request, currentGalleryType);
                int counter = 2;
                int selectedIndex = 0;
                for (CmsResource res : availableGalleries) {
                    String title;
                    String sitePath;
                    String rootPath;
                    block11: {
                        rootPath = res.getRootPath();
                        sitePath = this.getCms().getSitePath(res);
                        if (savedValue != null && savedValue.equals(rootPath)) {
                            selectedIndex = counter;
                        }
                        ++counter;
                        title = "";
                        try {
                            title = this.getCms().readPropertyObject(sitePath, "Title", false).getValue("");
                        }
                        catch (CmsException e) {
                            if (!LOG.isErrorEnabled()) break block11;
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    options.add(title.concat(" (").concat(sitePath).concat(")"));
                    values.add(rootPath);
                }
                if (savedValue != null && savedValue.equals(INPUT_NONE)) {
                    selectedIndex = 1;
                }
                result.append("<tr>\n\t<td style=\"white-space: nowrap;\">");
                result.append((String)entry.getKey());
                result.append("</td>\n\t<td>");
                result.append(this.buildSelect(htmlAttributes + currentGalleryType + "\"", options, values, selectedIndex));
                result.append("</td>\n</tr>\n");
            }
        }
        return result.toString();
    }

    public String buildSelectUpload(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        int pos = 0;
        CmsUserSettings.UploadVariant currentVariant = this.getParamTabWpUploadVariant();
        for (CmsUserSettings.UploadVariant variant : CmsUserSettings.UploadVariant.values()) {
            values.add(variant.toString());
            options.add(this.getUploadVariantMessage(variant));
            if (variant.equals((Object)currentVariant)) {
                selectedIndex = pos;
            }
            ++pos;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectView(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        ArrayList<CmsWorkplaceView> list = new ArrayList<CmsWorkplaceView>(OpenCms.getWorkplaceManager().getViews());
        CmsWorkplaceView directEditView = new CmsWorkplaceView(Messages.get().getBundle(this.getLocale()).key("GUI_LABEL_DIRECT_EDIT_VIEW_0"), "/system/workplace/views/explorer/directEdit.jsp", Float.valueOf(100.0f));
        list.add(directEditView);
        Iterator i = list.iterator();
        int count = -1;
        while (i.hasNext()) {
            ++count;
            CmsWorkplaceView view = (CmsWorkplaceView)i.next();
            boolean visible = true;
            try {
                this.getCms().readResource(view.getUri());
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                visible = false;
            }
            if (!visible) continue;
            String localizedKey = this.resolveMacros(view.getKey());
            options.add(localizedKey);
            values.add(view.getUri());
            if (!view.getUri().equals(this.getParamTabWpView())) continue;
            selectedIndex = count;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String buildSelectWorkplaceButtonStyle(String htmlAttributes) {
        int selectedIndex = Integer.parseInt(this.getParamTabWpButtonStyle());
        return this.buildSelectButtonStyle(htmlAttributes, selectedIndex);
    }

    public String buildSelectWorkplaceSearchResult(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>(3);
        ArrayList<String> values = new ArrayList<String>(3);
        int checkedIndex = 0;
        options.add(this.key(CmsUserSettings.CmsSearchResultStyle.STYLE_EXPLORER.getKey()));
        values.add(CmsUserSettings.CmsSearchResultStyle.STYLE_EXPLORER.getMode());
        if (this.getParamTabExWorkplaceSearchResult().equals(CmsUserSettings.CmsSearchResultStyle.STYLE_EXPLORER.toString())) {
            checkedIndex = 0;
        }
        options.add(this.key(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITH_EXCERPTS.getKey()));
        values.add(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITH_EXCERPTS.getMode());
        if (this.getParamTabExWorkplaceSearchResult().equals(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITH_EXCERPTS.toString())) {
            checkedIndex = 1;
        }
        options.add(this.key(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITHOUT_EXCERPTS.getKey()));
        values.add(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITHOUT_EXCERPTS.getMode());
        if (this.getParamTabExWorkplaceSearchResult().equals(CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITHOUT_EXCERPTS.toString())) {
            checkedIndex = 2;
        }
        return this.buildSelect(htmlAttributes, options, values, checkedIndex);
    }

    public String buildUserInformation() {
        StringBuffer result = new StringBuffer(512);
        CmsUser user = this.getSettings().getUser();
        result.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
        result.append("<tr>\n");
        result.append("\t<td style=\"width: 25%;\">");
        result.append(this.key("GUI_LABEL_USER_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\" style=\"width: 25%;\">");
        result.append(user.getName());
        result.append("</td>\n");
        result.append("\t<td style=\"width: 25%;\">");
        result.append(this.key("GUI_LABEL_EMAIL_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\" style=\"width: 25%;\">");
        result.append(user.getEmail());
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("\t<td>");
        result.append(this.key("GUI_LABEL_LASTNAME_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\">");
        result.append(user.getLastname());
        result.append("</td>\n");
        result.append("\t<td rowspan=\"3\" style=\"vertical-align: top;\">");
        result.append(this.key("GUI_INPUT_ADRESS_0"));
        result.append("</td>\n");
        String address = user.getAddress();
        result.append("\t<td rowspan=\"3\" class=\"textbold\" style=\"vertical-align: top;\">");
        result.append(address);
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("\t<td>");
        result.append(this.key("GUI_LABEL_FIRSTNAME_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\">");
        result.append(user.getFirstname());
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("\t<td>");
        result.append(this.key("GUI_LABEL_DESCRIPTION_0"));
        result.append("</td>\n");
        result.append("\t<td class=\"textbold\">");
        result.append(user.getDescription(this.getLocale()));
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    @Deprecated
    public String calendarIncludes() {
        return CmsCalendarWidget.calendarIncludes(this.getLocale());
    }

    @Deprecated
    public String calendarInit(String inputFieldId, String triggerButtonId, String align, boolean singleClick, boolean weekNumbers, boolean mondayFirst, String dateStatusFunc, boolean showTime) {
        return CmsCalendarWidget.calendarInit(this.getMessages(), inputFieldId, triggerButtonId, align, singleClick, weekNumbers, mondayFirst, dateStatusFunc, showTime);
    }

    public SelectOptions getOptionsForLanguage() {
        return CmsPreferences.getOptionsForLanguageStatic(this.getSettings().getUserSettings().getLocale(), this.m_userSettings.getLocale());
    }

    public String getParamNewPassword() {
        return this.m_paramNewPassword;
    }

    public String getParamOldPassword() {
        return this.m_paramOldPassword;
    }

    public String getParamTabDiCopyFileMode() {
        return "" + this.m_userSettings.getDialogCopyFileMode();
    }

    public String getParamTabDiCopyFolderMode() {
        return "" + this.m_userSettings.getDialogCopyFolderMode();
    }

    public String getParamTabDiDeleteFileMode() {
        return "" + this.m_userSettings.getDialogDeleteFileMode();
    }

    public String getParamTabDiPermissionsExpandInherited() {
        return this.isParamEnabled(this.m_userSettings.getDialogExpandInheritedPermissions());
    }

    public String getParamTabDiPermissionsExpandUser() {
        return this.isParamEnabled(this.m_userSettings.getDialogExpandUserPermissions());
    }

    public String getParamTabDiPermissionsInheritOnFolder() {
        return this.isParamEnabled(this.m_userSettings.getDialogPermissionsInheritOnFolder());
    }

    public String getParamTabDiPublishFileMode() {
        return "" + this.m_userSettings.getDialogPublishSiblings();
    }

    public String getParamTabDiShowLock() {
        return this.isParamEnabled(this.m_userSettings.getDialogShowLock());
    }

    public String getParamTabEdButtonStyle() {
        return "" + this.m_userSettings.getEditorButtonStyle();
    }

    public String getParamTabEdDirectEditButtonStyle() {
        return "" + this.m_userSettings.getDirectEditButtonStyle();
    }

    public String getParamTabExButtonStyle() {
        return "" + this.m_userSettings.getExplorerButtonStyle();
    }

    public String getParamTabExFileDateCreated() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileDateCreated());
    }

    public String getParamTabExFileDateExpired() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileDateExpired());
    }

    public String getParamTabExFileDateLastModified() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileDateLastModified());
    }

    public String getParamTabExFileDateReleased() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileDateReleased());
    }

    public String getParamTabExFileEntries() {
        return "" + this.m_userSettings.getExplorerFileEntries();
    }

    public String getParamTabExFileLockedBy() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileLockedBy());
    }

    public String getParamTabExFileNavText() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileNavText());
    }

    public String getParamTabExFilePermissions() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFilePermissions());
    }

    public String getParamTabExFileSize() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileSize());
    }

    public String getParamTabExFileState() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileState());
    }

    public String getParamTabExFileTitle() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileTitle());
    }

    public String getParamTabExFileType() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileType());
    }

    public String getParamTabExFileUserCreated() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileUserCreated());
    }

    public String getParamTabExFileUserLastModified() {
        return this.isParamEnabled(this.m_userSettings.showExplorerFileUserLastModified());
    }

    public String getParamTabExWorkplaceSearchResult() {
        return this.m_userSettings.getWorkplaceSearchViewStyle().toString();
    }

    public String getParamTabWpButtonStyle() {
        return "" + this.m_userSettings.getWorkplaceButtonStyle();
    }

    public String getParamTabWpFolder() {
        return this.m_userSettings.getStartFolder();
    }

    public String getParamTabWpLanguage() {
        return this.m_userSettings.getLocale().toString();
    }

    public String getParamTabWpListAllProjects() {
        return this.isParamEnabled(this.m_userSettings.getListAllProjects());
    }

    public String getParamTabWpProject() {
        return this.m_userSettings.getStartProject();
    }

    public String getParamTabWpReportType() {
        return this.m_userSettings.getWorkplaceReportType();
    }

    public String getParamTabWpRestrictExplorerView() {
        return "" + this.m_userSettings.getRestrictExplorerView();
    }

    public String getParamTabWpShowPublishNotification() {
        return this.isParamEnabled(this.m_userSettings.getShowPublishNotification());
    }

    public String getParamTabWpSite() {
        return this.m_userSettings.getStartSite();
    }

    public String getParamTabWpTimeWarp() {
        String result = this.m_userSettings.getTimeWarp() == -1L ? "-" : CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), this.m_userSettings.getTimeWarp());
        return result;
    }

    public CmsUserSettings.UploadVariant getParamTabWpUploadVariant() {
        return this.m_userSettings.getUploadVariant();
    }

    public String getParamTabWpView() {
        return this.m_userSettings.getStartView();
    }

    public SelectOptions getProjectSelectOptions() {
        return CmsPreferences.getProjectSelectOptionsStatic(this.getCms(), this.m_userSettings.getStartProject(), this.getLocale());
    }

    public SelectOptions getSiteSelectOptions() {
        return CmsPreferences.getSiteSelectOptionsStatic(this.getCms(), this.m_userSettings.getStartSite(), this.getSettings().getUserSettings().getLocale());
    }

    @Override
    public List<String> getTabParameterOrder() {
        ArrayList<String> orderList = new ArrayList<String>(5);
        orderList.add("tabwp");
        orderList.add("tabex");
        orderList.add("tabdi");
        orderList.add("tabed");
        orderList.add("tabga");
        orderList.add("tabup");
        return orderList;
    }

    @Override
    public List<String> getTabs() {
        ArrayList<String> tabList = new ArrayList<String>(6);
        tabList.add(this.key("GUI_PREF_PANEL_WORKPLACE_0"));
        tabList.add(this.key("GUI_PREF_PANEL_EXPLORER_0"));
        tabList.add(this.key("GUI_PREF_PANEL_DIALOGS_0"));
        tabList.add(this.key("GUI_PREF_PANEL_EDITORS_0"));
        tabList.add(this.key("GUI_PREF_PANEL_GALLERIES_0"));
        tabList.add(this.key("GUI_PREF_PANEL_USER_0"));
        return tabList;
    }

    public String getTimeWarpInt() {
        return "" + this.m_userSettings.getTimeWarp();
    }

    public CmsUserSettings getUserSettings() {
        return this.m_userSettings;
    }

    public String isChecked(String paramValue) {
        if (Boolean.valueOf(paramValue).booleanValue()) {
            return " checked=\"checked\"";
        }
        return "";
    }

    public void setParamNewPassword(String newPwd) {
        this.m_paramNewPassword = newPwd;
    }

    public void setParamOldPassword(String oldPwd) {
        this.m_paramOldPassword = oldPwd;
    }

    public void setParamTabDiCopyFileMode(String value) {
        try {
            this.m_userSettings.setDialogCopyFileMode(CmsResource.CmsResourceCopyMode.valueOf(Integer.parseInt(value)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabDiCopyFolderMode(String value) {
        try {
            this.m_userSettings.setDialogCopyFolderMode(CmsResource.CmsResourceCopyMode.valueOf(Integer.parseInt(value)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabDiDeleteFileMode(String value) {
        try {
            this.m_userSettings.setDialogDeleteFileMode(CmsResource.CmsResourceDeleteMode.valueOf(Integer.parseInt(value)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabDiPermissionsExpandInherited(String value) {
        this.m_userSettings.setDialogExpandInheritedPermissions(Boolean.valueOf(value));
    }

    public void setParamTabDiPermissionsExpandUser(String value) {
        this.m_userSettings.setDialogExpandUserPermissions(Boolean.valueOf(value));
    }

    public void setParamTabDiPermissionsInheritOnFolder(String value) {
        this.m_userSettings.setDialogPermissionsInheritOnFolder(Boolean.valueOf(value));
    }

    public void setParamTabDiPublishFileMode(String value) {
        this.m_userSettings.setDialogPublishSiblings(Boolean.valueOf(value));
    }

    public void setParamTabDiShowLock(String value) {
        this.m_userSettings.setDialogShowLock(Boolean.valueOf(value));
    }

    public void setParamTabEdButtonStyle(String value) {
        try {
            this.m_userSettings.setEditorButtonStyle(Integer.parseInt(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabEdDirectEditButtonStyle(String value) {
        try {
            this.m_userSettings.setDirectEditButtonStyle(Integer.parseInt(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabExButtonStyle(String value) {
        try {
            this.m_userSettings.setExplorerButtonStyle(Integer.parseInt(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabExFileDateCreated(String value) {
        this.m_userSettings.setShowExplorerFileDateCreated(Boolean.valueOf(value));
    }

    public void setParamTabExFileDateExpired(String value) {
        this.m_userSettings.setShowExplorerFileDateExpired(Boolean.valueOf(value));
    }

    public void setParamTabExFileDateLastModified(String value) {
        this.m_userSettings.setShowExplorerFileDateLastModified(Boolean.valueOf(value));
    }

    public void setParamTabExFileDateReleased(String value) {
        this.m_userSettings.setShowExplorerFileDateReleased(Boolean.valueOf(value));
    }

    public void setParamTabExFileEntries(String value) {
        try {
            this.m_userSettings.setExplorerFileEntries(Integer.parseInt(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabExFileLockedBy(String value) {
        this.m_userSettings.setShowExplorerFileLockedBy(Boolean.valueOf(value));
    }

    public void setParamTabExFileNavText(String value) {
        this.m_userSettings.setShowExplorerFileNavText(Boolean.valueOf(value));
    }

    public void setParamTabExFilePermissions(String value) {
        this.m_userSettings.setShowExplorerFilePermissions(Boolean.valueOf(value));
    }

    public void setParamTabExFileSize(String value) {
        this.m_userSettings.setShowExplorerFileSize(Boolean.valueOf(value));
    }

    public void setParamTabExFileState(String value) {
        this.m_userSettings.setShowExplorerFileState(Boolean.valueOf(value));
    }

    public void setParamTabExFileTitle(String value) {
        this.m_userSettings.setShowExplorerFileTitle(Boolean.valueOf(value));
    }

    public void setParamTabExFileType(String value) {
        this.m_userSettings.setShowExplorerFileType(Boolean.valueOf(value));
    }

    public void setParamTabExFileUserCreated(String value) {
        this.m_userSettings.setShowExplorerFileUserCreated(Boolean.valueOf(value));
    }

    public void setParamTabExFileUserLastModified(String value) {
        this.m_userSettings.setShowExplorerFileUserLastModified(Boolean.valueOf(value));
    }

    public void setParamTabExWorkplaceSearchResult(String style) {
        if (style == null) {
            style = OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceSearchViewStyle().getMode();
        }
        this.m_userSettings.setWorkplaceSearchViewStyle(CmsUserSettings.CmsSearchResultStyle.valueOf(style));
    }

    public void setParamTabWpButtonStyle(String value) {
        try {
            this.m_userSettings.setWorkplaceButtonStyle(Integer.parseInt(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParamTabWpFolder(String value) {
        if (!this.getCms().existsResource(value, CmsResourceFilter.IGNORE_EXPIRATION)) {
            value = "/";
        }
        this.m_userSettings.setStartFolder(value);
    }

    public void setParamTabWpLanguage(String value) {
        this.m_userSettings.setLocale(CmsLocaleManager.getLocale(value));
    }

    public void setParamTabWpListAllProjects(String value) {
        this.m_userSettings.setListAllProjects(Boolean.valueOf(value));
    }

    public void setParamTabWpProject(String value) {
        this.m_userSettings.setStartProject(value);
    }

    public void setParamTabWpReportType(String value) {
        if ("simple".equals(value) || "extended".equals(value)) {
            this.m_userSettings.setWorkplaceReportType(value);
        }
    }

    public void setParamTabWpRestrictExplorerView(String value) {
        this.m_userSettings.setRestrictExplorerView(Boolean.valueOf(value));
    }

    public void setParamTabWpShowPublishNotification(String value) {
        this.m_userSettings.setShowPublishNotification(Boolean.valueOf(value));
    }

    public void setParamTabWpSite(String value) {
        this.m_userSettings.setStartSite(value);
    }

    public void setParamTabWpTimeWarp(String value) {
        long datetimestamp = -1L;
        if (CmsStringUtil.isNotEmpty(value) && !"-".equals(value)) {
            try {
                datetimestamp = CmsCalendarWidget.getCalendarDate(this.getMessages(), value, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.m_userSettings.setTimeWarp(datetimestamp);
    }

    public void setParamTabWpUploadVariant(String value) {
        this.m_userSettings.setUploadVariant(value);
    }

    public void setParamTabWpView(String value) {
        this.m_userSettings.setStartView(value);
    }

    public void setTimewarpInt(String timewarp) {
        try {
            this.m_userSettings.setTimeWarp(Long.valueOf(timewarp));
        }
        catch (Exception e) {
            this.m_userSettings.setTimeWarp(-1L);
        }
    }

    public void setUserSettings(CmsDefaultUserSettings userSettings) {
        this.m_userSettings = userSettings;
    }

    public void updatePreferences(CmsObject cms, HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        CmsWorkplaceSettings settings = (CmsWorkplaceSettings)session.getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
        if (settings == null) {
            return;
        }
        CmsSynchronizeSettings synchronizeSettings = settings.getUserSettings().getSynchronizeSettings();
        settings = CmsWorkplace.initWorkplaceSettings(cms, settings, true);
        settings.getUserSettings().setSynchronizeSettings(synchronizeSettings);
    }

    @Override
    protected void checkRole() {
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.m_userSettings = new CmsUserSettings();
        this.fillParamValues(request);
        this.getActiveTab();
        this.setParamDialogtype(DIALOG_TYPE);
        if ("set".equals(this.getParamAction())) {
            this.setAction(5);
        } else if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if (DIALOG_RELOAD.equals(this.getParamAction())) {
            this.setAction(201);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if (DIALOG_CHPWD.equals(this.getParamAction())) {
            this.setAction(202);
        } else {
            if (!"switchtab".equals(this.getParamAction())) {
                this.fillUserSettings();
            }
            this.setAction(0);
            this.setParamTitle(this.key("GUI_PREF_0"));
        }
    }

    @Override
    protected Map<String, Object> paramValues() {
        Map<String, Object> map = super.paramValues();
        HttpServletRequest request = this.getJsp().getRequest();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramValue;
            String paramName = (String)en.nextElement();
            if (!paramName.startsWith(PARAM_PREFERREDEDITOR_PREFIX) && !paramName.startsWith(PARAM_STARTGALLERY_PREFIX) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramValue = request.getParameter(paramName))) continue;
            map.put(paramName, CmsEncoder.decode(paramValue));
        }
        return map;
    }

    String buildSelect(String htmlAttributes, SelectOptions options) {
        return this.buildSelect(htmlAttributes, options.getOptions(), options.getValues(), options.getSelectedIndex());
    }

    private String buildSelectButtonStyle(String htmlAttributes, int selectedIndex) {
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(this.key("GUI_PREF_BUTTONSTYLE_IMG_0"));
        options.add(this.key("GUI_PREF_BUTTONSTYLE_IMGTXT_0"));
        options.add(this.key("GUI_PREF_BUTTONSTYLE_TXT_0"));
        String[] vals = new String[]{"0", "1", "2"};
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(vals));
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    private String computeEditorPreselection(HttpServletRequest request, String resourceType) {
        String preSelection = request.getParameter(PARAM_PREFERREDEDITOR_PREFIX + resourceType);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(preSelection)) {
            return CmsEncoder.decode(preSelection);
        }
        CmsUserSettings userSettings = new CmsUserSettings(this.getSettings().getUser());
        return userSettings.getPreferredEditor(resourceType);
    }

    private String computeStartGalleryPreselection(HttpServletRequest request, String galleryType) {
        String preSelection = request.getParameter(PARAM_STARTGALLERY_PREFIX + galleryType);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(preSelection)) {
            return CmsEncoder.decode(preSelection);
        }
        CmsUserSettings userSettings = new CmsUserSettings(this.getSettings().getUser());
        return userSettings.getStartGallery(galleryType);
    }

    private void fillUserSettings() {
        this.m_userSettings = new CmsUserSettings(this.getSettings().getUser());
    }

    private String getUploadVariantMessage(CmsUserSettings.UploadVariant variant) {
        String message = null;
        switch (variant) {
            case basic: {
                message = this.key("GUI_PREF_USE_UPLOAD_BASIC_0");
                break;
            }
            case gwt: {
                message = this.key("GUI_PREF_USE_UPLOAD_GWT_0");
                break;
            }
            default: {
                message = this.key("ERR_PREF_UPLOAD_VARIANT_NOT_FOUND_0");
            }
        }
        return message;
    }

    private String isParamEnabled(boolean isEnabled) {
        if (isEnabled) {
            return CmsStringUtil.TRUE;
        }
        return "";
    }

    public static class SelectOptions {
        private List<String> m_options;
        private int m_selectedIndex;
        private List<String> m_values;

        public SelectOptions(List<String> options, List<String> values, int selectedIndex) {
            this.m_options = options;
            this.m_values = values;
            this.m_selectedIndex = selectedIndex;
        }

        public List<String> getOptions() {
            return this.m_options;
        }

        public int getSelectedIndex() {
            return this.m_selectedIndex;
        }

        public List<String> getValues() {
            return this.m_values;
        }

        public String toClientSelectWidgetConfiguration() {
            StringBuffer resultBuffer = new StringBuffer();
            for (int i = 0; i < this.m_values.size(); ++i) {
                String option;
                String value = this.m_values.get(i);
                String string = option = i < this.m_options.size() ? this.m_options.get(i) : value;
                if (i != 0) {
                    resultBuffer.append("|");
                }
                resultBuffer.append(value);
                resultBuffer.append(":");
                resultBuffer.append(option);
            }
            return resultBuffer.toString();
        }
    }
}

