/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsTabDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.I_CmsPostUploadDialogHandler;
import org.opencms.workplace.commons.CmsDefaultUploadHandler;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsPropertyAdvanced
extends CmsTabDialog
implements I_CmsDialogHandler,
I_CmsPostUploadDialogHandler {
    public static final int ACTION_SAVE_DEFINE = 400;
    public static final int ACTION_SAVE_EDIT = 300;
    public static final int ACTION_SHOW_DEFINE = 200;
    public static final int ACTION_SHOW_EDIT = 100;
    public static final int BUTTON_DEFINE = 201;
    public static final int BUTTON_FINISH = 202;
    public static final String DIALOG_SAVE_DEFINE = "savedefine";
    public static final String DIALOG_SAVE_EDIT = "saveedit";
    public static final String DIALOG_SHOW_DEFAULT = "default";
    public static final String DIALOG_SHOW_DEFINE = "define";
    public static final String DIALOG_SHOW_EDIT = "edit";
    public static final String DIALOG_TYPE = "property";
    public static final String MODE_WIZARD = "wizard";
    public static final String MODE_WIZARD_CREATEINDEX = "wizardcreateindex";
    public static final String MODE_WIZARD_INDEXCREATED = "wizardindexcreated";
    public static final String PANEL_RESOURCE = "panel.properties.resource";
    public static final String PANEL_STRUCTURE = "panel.properties.structure";
    public static final String PARAM_DIALOGMODE = "dialogmode";
    public static final String PARAM_HIDEADVANCED = "hideadvanced";
    public static final String PARAM_NEWPROPERTY = "newproperty";
    public static final String PARAM_POSTUPLOADHANDLER = "upload-handler";
    public static final String PARAM_SHOWGROUP = "showgroup";
    public static final String PREFIX_HIDDEN = "valhidden";
    public static final String PREFIX_RESOURCE = "valresource";
    public static final String PREFIX_STRUCTURE = "valstructure";
    public static final String PREFIX_USEPROPERTY = "useprop";
    public static final String PREFIX_VALUE = "valprop";
    public static final String TAB_RESOURCE = "tabres";
    public static final String TAB_STRUCTURE = "tabstr";
    public static final String URI_PROPERTY_CUSTOM_DIALOG = "/system/workplace/commons/property_custom.jsp";
    public static final String URI_PROPERTY_DIALOG = "/system/workplace/commons/property_advanced.jsp";
    public static final String URI_PROPERTY_DIALOG_HANDLER = "/system/workplace/commons/property.jsp";
    private static final Log LOG = CmsLog.getLog(CmsPropertyAdvanced.class);
    private Map<String, CmsProperty> m_activeProperties;
    private CmsParameterConfiguration m_handlerParams = new CmsParameterConfiguration();
    private Boolean m_isEditable;
    private boolean m_isFolder;
    private String m_paramDialogMode;
    private String m_paramIndexPageType;
    private String m_paramNewproperty;
    private String m_paramUseTempfileProject;
    private List<String[]> m_propertyValues;
    private boolean m_tabSwitched;
    private I_CmsPostUploadDialogHandler m_uploadHandler = new CmsDefaultUploadHandler();

    public CmsPropertyAdvanced() {
        super(null);
    }

    public CmsPropertyAdvanced(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPropertyAdvanced(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static Map<String, CmsProperty> getPropertyMap(List<CmsProperty> list) {
        HashMap<String, CmsProperty> result = null;
        String key = null;
        CmsProperty property2 = null;
        if (list == null || list.size() == 0) {
            return Collections.emptyMap();
        }
        result = new HashMap<String, CmsProperty>();
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                property2 = list.get(i);
                key = property2.getName();
                result.put(key, property2);
            }
        } else {
            for (CmsProperty property2 : list) {
                key = property2.getName();
                result.put(key, property2);
            }
        }
        return result;
    }

    @Override
    public void actionCloseDialog() throws JspException {
        block12: {
            if (this.getAction() == 300 && MODE_WIZARD_CREATEINDEX.equals(this.getParamDialogmode())) {
                String newFolder = this.getParamResource();
                if (!newFolder.endsWith("/")) {
                    newFolder = newFolder + "/";
                }
                this.getSettings().setExplorerResource(newFolder, this.getCms());
                String newUri = "/system/workplace/commons/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.getParamIndexPageType()).getNewResourceUri();
                try {
                    CmsUriSplitter splitter = new CmsUriSplitter(newUri);
                    Map<String, String[]> params = CmsRequestUtil.createParameterMap(splitter.getQuery());
                    params.put(PARAM_DIALOGMODE, new String[]{MODE_WIZARD_CREATEINDEX});
                    params.put("action", new String[]{"newform"});
                    this.sendForward(splitter.getPrefix(), params);
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_REDIRECT_INDEXPAGE_DIALOG_1", "/system/workplace/commons/" + newUri));
                }
                catch (ServletException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_REDIRECT_INDEXPAGE_DIALOG_1", "/system/workplace/commons/" + newUri));
                }
            } else {
                if (this.getAction() == 300 && MODE_WIZARD.equals(this.getParamDialogmode())) {
                    try {
                        CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                        if (res.isFolder()) {
                            ArrayList<String> folderList = new ArrayList<String>(1);
                            folderList.add(CmsResource.getParentFolder(this.getParamResource()));
                            this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                        }
                        break block12;
                    }
                    catch (CmsException e) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)e.getLocalizedMessage());
                        }
                        break block12;
                    }
                }
                if (MODE_WIZARD_INDEXCREATED.equals(this.getParamDialogmode())) {
                    this.getSettings().setExplorerResource(CmsResource.getParentFolder(CmsResource.getParentFolder(this.getParamResource())), this.getCms());
                    ArrayList<String> folderList = new ArrayList<String>(1);
                    folderList.add(CmsResource.getParentFolder(CmsResource.getParentFolder(this.getParamResource())));
                    this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                }
            }
        }
        super.actionCloseDialog();
    }

    public void actionDefine() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.performDefineOperation();
            this.setParamAction(DIALOG_SHOW_DEFAULT);
            this.setParamNewproperty(null);
            this.sendForward(URI_PROPERTY_DIALOG, this.paramsAsParameterMap());
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public void actionDeleteResource() throws JspException {
        if (this.getParamDialogmode() != null && this.getParamDialogmode().startsWith(MODE_WIZARD)) {
            try {
                this.getCms().deleteResource(this.getParamResource(), CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            catch (Throwable e) {
                this.includeErrorpage(this, e);
            }
        }
    }

    public void actionEdit(HttpServletRequest request) throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.isEditable()) {
                this.performDialogOperation(request);
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        if (this.m_handlerParams == null) {
            this.m_handlerParams = new CmsParameterConfiguration();
        }
        if (PARAM_HIDEADVANCED.equalsIgnoreCase(paramName)) {
            this.m_handlerParams.add(PARAM_HIDEADVANCED, paramValue.trim());
        }
        if (PARAM_SHOWGROUP.equalsIgnoreCase(paramName)) {
            this.m_handlerParams.add(PARAM_SHOWGROUP, paramValue.trim());
        }
        if (PARAM_POSTUPLOADHANDLER.equalsIgnoreCase(paramName)) {
            this.m_handlerParams.add(PARAM_POSTUPLOADHANDLER, paramValue.trim());
        }
    }

    public String buildActivePropertiesList() {
        List<Object> propertyDef;
        StringBuffer retValue;
        block4: {
            retValue = new StringBuffer(256);
            propertyDef = new ArrayList();
            try {
                propertyDef = this.getCms().readAllPropertyDefinitions();
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        Iterator<Object> j = propertyDef.iterator();
        int i = 0;
        while (j.hasNext()) {
            CmsPropertyDefinition curProperty = (CmsPropertyDefinition)j.next();
            retValue.append(CmsEncoder.escapeXml(curProperty.getName()));
            if (i + 1 < propertyDef.size()) {
                retValue.append("<br>");
            }
            ++i;
        }
        return retValue.toString();
    }

    public String buildEditForm() {
        List<String[]> properties;
        StringBuffer result = new StringBuffer(4096);
        String activeTab = this.getActiveTabName();
        String disabled = "";
        if (!this.isEditable()) {
            disabled = " disabled=\"disabled\"";
        }
        if ((properties = this.getPropertyValues()).size() > 0) {
            result.append("<table border=\"0\" style=\"width:100%\">\n");
            result.append("<tr>\n");
            result.append("\t<td class=\"textbold\" nowrap>");
            result.append(this.key("GUI_PROPERTY_0"));
            result.append("</td>\n");
            result.append("\t<td class=\"textbold\">");
            result.append(this.key("GUI_PROPERTY_VALUE_0"));
            result.append("</td>\n");
            result.append("\t<td class=\"textbold\" style=\"white-space: nowrap;\">");
            result.append("&nbsp;");
            result.append("</td>\n");
            result.append("</tr>\n");
            result.append("<tr><td colspan=\"3\"><span style=\"height: 6px;\"></span></td></tr>\n");
            for (String[] curProp : properties) {
                result.append(this.buildPropertyRow(curProp[0], curProp[1], curProp[2], curProp[3], disabled, activeTab));
            }
            result.append("</table>");
        } else {
            result.append(this.key("GUI_PROPERTY_ADVANCED_NO_PROPDEFS_0"));
        }
        return result.toString();
    }

    public String buildSetFormValues() {
        StringBuffer result = new StringBuffer(1024);
        String activeTab = this.getActiveTabName();
        String structurePanelName = this.key("GUI_PROPERTIES_INDIVIDUAL_0");
        for (String[] curProp : this.getPropertyValues()) {
            String shownValue = curProp[1];
            if (structurePanelName.equals(activeTab) && "".equals(curProp[2]) && !"".equals(curProp[3])) {
                shownValue = curProp[3];
            }
            if ("".equals(shownValue)) continue;
            result.append("\tdocument.getElementById(\"");
            result.append(PREFIX_VALUE);
            result.append(curProp[0]);
            result.append("\").value = \"");
            result.append(CmsStringUtil.escapeJavaScript(shownValue));
            result.append("\";\n");
        }
        return result.toString();
    }

    public String dialogButtonsOkCancelDefine() {
        if (this.isEditable()) {
            int okButton = 0;
            if (this.getParamDialogmode() != null && this.getParamDialogmode().startsWith(MODE_WIZARD)) {
                okButton = 202;
            }
            return this.dialogButtons(new int[]{okButton, 1, 201}, new String[]{null, null, "onclick=\"definePropertyForm();\""});
        }
        return this.dialogButtons(new int[]{2}, new String[]{null});
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        if (this.m_handlerParams == null) {
            this.m_handlerParams = new CmsParameterConfiguration();
        }
        return this.m_handlerParams;
    }

    @Override
    public String getDialogHandler() {
        return "class_dialog_property";
    }

    @Override
    public String getDialogUri(String resource, CmsJspActionElement jsp) {
        block4: {
            try {
                CmsResource res = jsp.getCmsObject().readResource(resource, CmsResourceFilter.ALL);
                if (CmsResourceTypeXmlPage.isXmlPage(res)) {
                    return "/system/workplace/editors/dialogs/property.jsp";
                }
                String resTypeName = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
                CmsExplorerTypeSettings settings = this.getSettingsForType(resTypeName);
                if (settings.isPropertiesEnabled()) {
                    return URI_PROPERTY_CUSTOM_DIALOG;
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return URI_PROPERTY_DIALOG;
    }

    public String getParamDialogmode() {
        return this.m_paramDialogMode;
    }

    public String getParamIndexPageType() {
        return this.m_paramIndexPageType;
    }

    public String getParamNewproperty() {
        return this.m_paramNewproperty;
    }

    public String getParamUsetempfileproject() {
        return this.m_paramUseTempfileProject;
    }

    @Override
    public List<String> getTabParameterOrder() {
        ArrayList<String> orderList = new ArrayList<String>(2);
        orderList.add(TAB_STRUCTURE);
        orderList.add(TAB_RESOURCE);
        return orderList;
    }

    @Override
    public List<String> getTabs() {
        ArrayList<String> tabList = new ArrayList<String>(2);
        if (OpenCms.getWorkplaceManager().isEnableAdvancedPropertyTabs()) {
            if (this.m_isFolder) {
                tabList.add(this.key("GUI_PROPERTIES_INDIVIDUAL_0"));
            } else {
                tabList.add(this.key("GUI_PROPERTIES_INDIVIDUAL_0"));
                tabList.add(this.key("GUI_PROPERTIES_SHARED_0"));
            }
        } else if (this.m_isFolder || OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
            tabList.add(this.key("GUI_PROPERTIES_INDIVIDUAL_0"));
        } else {
            tabList.add(this.key("GUI_PROPERTIES_SHARED_0"));
        }
        return tabList;
    }

    @Override
    public String getUploadHook(CmsObject cms, String uploadFolderSitePath) {
        return this.m_uploadHandler.getUploadHook(cms, uploadFolderSitePath);
    }

    @Override
    public void initConfiguration() {
        String uploadHandlerName = this.m_handlerParams.get(PARAM_POSTUPLOADHANDLER);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(uploadHandlerName)) {
            try {
                Class<?> uploadHandlerClass = Class.forName(uploadHandlerName);
                if (I_CmsPostUploadDialogHandler.class.isAssignableFrom(uploadHandlerClass)) {
                    this.m_uploadHandler = (I_CmsPostUploadDialogHandler)uploadHandlerClass.newInstance();
                } else {
                    LOG.error((Object)("Invalid upload handler class: " + uploadHandlerName));
                }
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Could not instantiate upload handler: " + uploadHandlerName), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Upload handler class not found: " + uploadHandlerName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void setParamDialogmode(String value) {
        this.m_paramDialogMode = value;
    }

    public void setParamIndexPageType(String paramIndexPageType) {
        this.m_paramIndexPageType = paramIndexPageType;
    }

    public void setParamNewproperty(String value) {
        this.m_paramNewproperty = value;
    }

    public void setParamUsetempfileproject(String value) {
        this.m_paramUseTempfileProject = value;
    }

    @Override
    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        attribute = this.appendDelimiter(attribute);
        switch (button) {
            case 201: {
                result.append("<input name=\"define\" type=\"button\" value=\"");
                result.append(this.key("GUI_PROPERTY_DEFINE_0"));
                result.append("\" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 202: {
                result.append("<input name=\"finish\" type=\"submit\" value=\"");
                result.append(this.key("GUI_PROPERTY_FINISH_0"));
                result.append("\" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                super.dialogButtonsHtml(result, button, attribute);
            }
        }
    }

    protected Map<String, CmsProperty> getActiveProperties() {
        if (this.m_activeProperties == null) {
            try {
                this.m_activeProperties = CmsPropertyAdvanced.getPropertyMap(this.getCms().readPropertyObjects(this.getParamResource(), false));
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                this.m_activeProperties = new HashMap<String, CmsProperty>();
            }
        }
        return this.m_activeProperties;
    }

    protected CmsExplorerTypeSettings getSettingsForType(String resTypeName) {
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName);
        if (!settings.hasEditOptions() && CmsStringUtil.isNotEmpty(settings.getReference())) {
            settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(settings.getReference());
        }
        return settings;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.getActiveTab();
        this.m_isFolder = false;
        try {
            CmsResource resource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            if (resource.isFolder()) {
                this.m_isFolder = true;
                if (!this.getParamResource().endsWith("/")) {
                    this.setParamResource(this.getParamResource() + "/");
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        this.setParamDialogtype(DIALOG_TYPE);
        boolean isPopup = Boolean.valueOf(this.getParamIsPopup());
        if (DIALOG_SHOW_DEFINE.equals(this.getParamAction())) {
            this.setAction(200);
            this.setParamTitle(this.key("GUI_PROPERTY_NEW_DEF_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        } else if (DIALOG_SAVE_EDIT.equals(this.getParamAction())) {
            if (isPopup) {
                this.setAction(7);
            } else {
                this.setAction(300);
            }
        } else if (DIALOG_SAVE_DEFINE.equals(this.getParamAction())) {
            this.setAction(400);
        } else if ("cancel".equals(this.getParamAction())) {
            if (isPopup) {
                this.setAction(6);
            } else {
                this.setAction(4);
            }
        } else {
            this.setAction(0);
            if (!this.isEditable()) {
                this.setParamTitle(this.key("GUI_PROPERTIES_OF_1", new Object[]{CmsResource.getName(this.getParamResource())}));
            } else {
                this.setParamTitle(this.key("GUI_PROPERTIES_EDIT_1", new Object[]{CmsResource.getName(this.getParamResource())}));
            }
            this.m_tabSwitched = false;
            if ("switchtab".equals(this.getParamAction())) {
                this.m_tabSwitched = true;
            }
        }
    }

    protected boolean isEditable() {
        if (this.m_isEditable == null) {
            if (this.getCms().getRequestContext().getCurrentProject().isOnlineProject() || !this.getCms().isInsideCurrentProject(this.getParamResource())) {
                this.m_isEditable = Boolean.FALSE;
            } else {
                CmsLock lock;
                CmsResource file;
                String resourceName;
                block18: {
                    block17: {
                        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
                            this.getSettings().setErrorMessage(null);
                            this.m_isEditable = Boolean.FALSE;
                            return this.m_isEditable;
                        }
                        resourceName = this.getParamResource();
                        file = null;
                        lock = null;
                        try {
                            file = this.getCms().readResource(resourceName, CmsResourceFilter.ALL);
                            if (file.isFolder() && !resourceName.endsWith("/")) {
                                resourceName = resourceName + "/";
                            }
                        }
                        catch (CmsException e) {
                            if (!LOG.isInfoEnabled()) break block17;
                            LOG.info((Object)e.getLocalizedMessage());
                        }
                    }
                    try {
                        lock = this.getCms().getLock(file);
                    }
                    catch (CmsException e) {
                        lock = CmsLock.getNullLock();
                        if (!LOG.isErrorEnabled()) break block18;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (!lock.isNullLock()) {
                    if (lock.isDirectlyOwnedBy(this.getCms().getRequestContext().getCurrentUser()) && (lock.isInProject(this.getCms().getRequestContext().getCurrentProject()) || Boolean.valueOf(this.getParamUsetempfileproject()).booleanValue())) {
                        this.m_isEditable = Boolean.TRUE;
                        return this.m_isEditable;
                    }
                } else if (OpenCms.getWorkplaceManager().autoLockResources()) {
                    block19: {
                        if (file == null || file.isFolder()) {
                            try {
                                List<String> lockedResources = this.getCms().getLockedResources(resourceName, CmsLockFilter.FILTER_ALL.filterNotOwnedByUserId(this.getCms().getRequestContext().getCurrentUser().getId()));
                                if (!lockedResources.isEmpty()) {
                                    this.m_isEditable = Boolean.FALSE;
                                    return this.m_isEditable;
                                }
                            }
                            catch (CmsException e1) {
                                if (!LOG.isErrorEnabled()) break block19;
                                LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                            }
                        }
                    }
                    this.m_isEditable = Boolean.TRUE;
                    return this.m_isEditable;
                }
                this.m_isEditable = Boolean.FALSE;
            }
        }
        return this.m_isEditable;
    }

    private StringBuffer buildPropertyRow(String propName, String propValue, String valueStructure, String valueResource, String disabled, String activeTab) {
        StringBuffer result = new StringBuffer(256);
        String structurePanelName = this.key("GUI_PROPERTIES_INDIVIDUAL_0");
        String inputAttrs = "class=\"maxwidth\"";
        if (structurePanelName.equals(activeTab) && "".equals(valueStructure) && !"".equals(valueResource)) {
            inputAttrs = "class=\"dialogmarkedfield\"";
        }
        result.append("<tr>\n");
        result.append("\t<td style=\"white-space: nowrap;\">" + propName);
        result.append("</td>\n");
        result.append("\t<td class=\"maxwidth\">");
        result.append("<input type=\"text\" ");
        result.append(inputAttrs);
        result.append(" name=\"");
        result.append(PREFIX_VALUE);
        result.append(propName);
        result.append("\" id=\"");
        result.append(PREFIX_VALUE);
        result.append(propName);
        result.append("\"");
        result.append(" onFocus=\"deleteResEntry('");
        result.append(propName);
        result.append("', '");
        result.append(activeTab);
        result.append("');\"");
        result.append(" onBlur=\"checkResEntry('");
        result.append(propName);
        result.append("', '");
        result.append(activeTab);
        result.append("');\" onKeyup=\"checkValue('");
        result.append(propName);
        result.append("', '");
        result.append(activeTab);
        result.append("');\"");
        result.append(disabled);
        result.append(">");
        result.append("<input type=\"hidden\" name=\"");
        result.append(PREFIX_STRUCTURE);
        result.append(propName);
        result.append("\" id=\"");
        result.append(PREFIX_STRUCTURE);
        result.append(propName);
        result.append("\" value=\"");
        result.append(CmsEncoder.escapeXml(valueStructure));
        result.append("\">");
        result.append("<input type=\"hidden\" name=\"");
        result.append(PREFIX_RESOURCE);
        result.append(propName);
        result.append("\" id=\"");
        result.append(PREFIX_RESOURCE);
        result.append(propName);
        result.append("\" value=\"");
        result.append(CmsEncoder.escapeXml(valueResource));
        result.append("\"></td>\n");
        result.append("\t<td class=\"propertydialog-checkboxcell\">");
        String prefix = PREFIX_RESOURCE;
        if (structurePanelName.equals(activeTab)) {
            prefix = PREFIX_STRUCTURE;
        }
        result.append("<input type=\"checkbox\" name=\"");
        result.append(PREFIX_USEPROPERTY);
        result.append(propName);
        result.append("\" id=\"");
        result.append(PREFIX_USEPROPERTY);
        result.append(propName);
        result.append("\" value=\"true\"");
        result.append(disabled);
        if (CmsStringUtil.isNotEmpty(propValue)) {
            result.append(" checked=\"checked\" ");
        }
        result.append("onClick=\"toggleDelete('");
        result.append(propName);
        result.append("', '");
        result.append(prefix);
        result.append("', '");
        result.append(activeTab);
        result.append("');\">");
        result.append("</td>\n");
        result.append("</tr>\n");
        return result;
    }

    private List<String[]> getPropertyValues() {
        if (this.m_propertyValues == null) {
            List<Object> propertyDef;
            String structurePanelName;
            String activeTab;
            block13: {
                activeTab = this.getActiveTabName();
                structurePanelName = this.key("GUI_PROPERTIES_INDIVIDUAL_0");
                propertyDef = new ArrayList();
                try {
                    propertyDef = this.getCms().readAllPropertyDefinitions();
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block13;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            this.m_propertyValues = new ArrayList<String[]>(propertyDef.size());
            Map<String, CmsProperty> activeProperties = this.getActiveProperties();
            for (CmsPropertyDefinition cmsPropertyDefinition : propertyDef) {
                String propName = CmsEncoder.escapeXml(cmsPropertyDefinition.getName());
                String propValue = "";
                String valueStructure = "";
                String valueResource = "";
                if (this.m_tabSwitched) {
                    if (structurePanelName.equals(activeTab)) {
                        propValue = this.getJsp().getRequest().getParameter(PREFIX_STRUCTURE + propName);
                        valueStructure = this.getJsp().getRequest().getParameter(PREFIX_STRUCTURE + propName);
                        valueResource = !this.isEditable() ? this.getJsp().getRequest().getParameter(PREFIX_RESOURCE + propName) : this.getJsp().getRequest().getParameter(PREFIX_VALUE + propName);
                    } else {
                        propValue = this.getJsp().getRequest().getParameter(PREFIX_RESOURCE + propName);
                        valueStructure = !this.isEditable() ? this.getJsp().getRequest().getParameter(PREFIX_STRUCTURE + propName) : this.getJsp().getRequest().getParameter(PREFIX_VALUE + propName);
                        valueResource = this.getJsp().getRequest().getParameter(PREFIX_RESOURCE + propName);
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(valueStructure) && valueStructure.equals(valueResource)) {
                            valueStructure = "";
                        }
                    }
                } else {
                    CmsProperty currentProperty = activeProperties.get(propName);
                    if (currentProperty == null) {
                        currentProperty = new CmsProperty();
                    }
                    propValue = structurePanelName.equals(activeTab) ? currentProperty.getStructureValue() : currentProperty.getResourceValue();
                    valueStructure = currentProperty.getStructureValue();
                    valueResource = currentProperty.getResourceValue();
                }
                if (propValue == null) {
                    propValue = "";
                }
                if (valueStructure == null) {
                    valueStructure = "";
                }
                if (valueResource == null) {
                    valueResource = "";
                }
                propValue = propValue.trim();
                valueStructure = valueStructure.trim();
                valueResource = valueResource.trim();
                String[] property = new String[]{propName, propValue, valueStructure, valueResource};
                this.m_propertyValues.add(property);
            }
        }
        return this.m_propertyValues;
    }

    private boolean performDefineOperation() throws CmsException {
        boolean useTempfileProject = Boolean.valueOf(this.getParamUsetempfileproject());
        try {
            String newProperty;
            if (useTempfileProject) {
                this.switchToTempProject();
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newProperty = this.getParamNewproperty())) {
                this.getCms().createPropertyDefinition(newProperty);
                boolean bl = true;
                return bl;
            }
            throw new CmsException(Messages.get().container("ERR_INVALID_PROP_0"));
        }
        finally {
            if (useTempfileProject) {
                this.switchToCurrentProject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performDialogOperation(HttpServletRequest request) throws CmsException {
        List<CmsPropertyDefinition> propertyDef = this.getCms().readAllPropertyDefinitions();
        boolean useTempfileProject = Boolean.valueOf(this.getParamUsetempfileproject());
        try {
            if (useTempfileProject) {
                this.switchToTempProject();
            }
            Map<String, CmsProperty> activeProperties = this.getActiveProperties();
            String activeTab = this.getActiveTabName();
            ArrayList<CmsProperty> propertiesToWrite = new ArrayList<CmsProperty>();
            for (CmsPropertyDefinition curPropDef : propertyDef) {
                String propName = CmsEncoder.escapeXml(curPropDef.getName());
                String valueStructure = null;
                String valueResource = null;
                if (this.key("GUI_PROPERTIES_INDIVIDUAL_0").equals(activeTab)) {
                    valueStructure = request.getParameter(PREFIX_VALUE + propName);
                    valueResource = request.getParameter(PREFIX_RESOURCE + propName);
                    if (valueStructure != null && !"".equals(valueStructure.trim()) && valueStructure.equals(valueResource)) {
                        valueStructure = "";
                    }
                } else {
                    valueStructure = request.getParameter(PREFIX_STRUCTURE + propName);
                    valueResource = request.getParameter(PREFIX_VALUE + propName);
                }
                if (valueStructure != null) {
                    valueStructure = valueStructure.trim();
                }
                if (valueResource != null) {
                    valueResource = valueResource.trim();
                }
                CmsProperty newProperty = new CmsProperty();
                newProperty.setName(curPropDef.getName());
                newProperty.setStructureValue(valueStructure);
                newProperty.setResourceValue(valueResource);
                CmsProperty oldProperty = activeProperties.get(curPropDef.getName());
                if (oldProperty == null) {
                    oldProperty = new CmsProperty();
                    oldProperty.setName(curPropDef.getName());
                }
                boolean writeStructureValue = false;
                boolean writeResourceValue = false;
                String oldValue = oldProperty.getStructureValue();
                String newValue = newProperty.getStructureValue();
                writeStructureValue = oldValue != null && newProperty.isDeleteStructureValue();
                if (!(writeStructureValue |= !newValue.equals(oldValue) && !"".equalsIgnoreCase(newValue) && !"".equalsIgnoreCase(newValue))) {
                    newProperty.setStructureValue(null);
                }
                oldValue = oldProperty.getResourceValue();
                newValue = newProperty.getResourceValue();
                writeResourceValue = oldValue != null && newProperty.isDeleteResourceValue();
                if (!(writeResourceValue |= !newValue.equals(oldValue) && !"".equalsIgnoreCase(newValue) && !"".equalsIgnoreCase(newValue))) {
                    newProperty.setResourceValue(null);
                }
                if (!writeStructureValue && !writeResourceValue) continue;
                propertiesToWrite.add(newProperty);
            }
            if (propertiesToWrite.size() > 0) {
                this.checkLock(this.getParamResource());
                this.getCms().writePropertyObjects(this.getParamResource(), propertiesToWrite);
            }
        }
        finally {
            if (useTempfileProject) {
                this.switchToCurrentProject();
            }
        }
        return true;
    }
}

