/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsCategory;
import org.opencms.workplace.commons.A_CmsResourceCategoriesList;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;

public class CmsResourceCategoriesList
extends A_CmsResourceCategoriesList {
    public static final String LIST_ACTION_REMOVE1 = "ar1";
    public static final String LIST_ACTION_REMOVE2 = "ar2";
    public static final String LIST_ID = "lrc";
    public static final String LIST_MACTION_REMOVE = "mr";

    public CmsResourceCategoriesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsResourceCategoriesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsResourceCategoriesList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_RESOURCECATEGORIES_LIST_NAME_0"), true);
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_ACTION_REMOVE1) || this.getParamListAction().equals(LIST_ACTION_REMOVE2)) {
            try {
                this.checkLock(this.getParamResource());
                CmsListItem listItem = this.getSelectedItem();
                String categoryPath = listItem.getId();
                this.getCategoryService().removeResourceFromCategory(this.getCms(), this.getParamResource(), categoryPath);
                this.getCategoryService().repairRelations(this.getCms(), this.getParamResource());
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    @Override
    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    @Override
    protected List<CmsCategory> getCategories() throws CmsException {
        return this.getResourceCategories();
    }

    @Override
    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction1 = new CmsListDirectAction(LIST_ACTION_REMOVE1){

            @Override
            public boolean isVisible() {
                return this.getItem() != null && (Boolean)this.getItem().get("cl") == false;
            }
        };
        stateAction1.setName(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction1.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction1.setIconPath("list/minus.png");
        stateAction1.setConfirmationMessage(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_CONF_MORE_0"));
        stateCol.addDirectAction(stateAction1);
        CmsListDirectAction stateAction2 = new CmsListDirectAction(LIST_ACTION_REMOVE2){

            @Override
            public boolean isVisible() {
                return this.getItem() == null || (Boolean)this.getItem().get("cl") != false;
            }
        };
        stateAction2.setName(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction2.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction2.setIconPath("list/minus.png");
        stateCol.addDirectAction(stateAction2);
        metadata.addColumn(stateCol);
    }
}

