/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsMirPrSameLockedActiveChangedAl
extends A_CmsMenuItemRule {
    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        if (resourceUtil[0].getResource().getState().isDeleted()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        if (resourceUtil[0].getResource().getState().isNew() || resourceUtil[0].getResource().isFile() && resourceUtil[0].getResource().getState().isUnchanged()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_NEW_UNCHANGED_0");
        }
        try {
            if (!resourceUtil[0].isEditable() || !cms.hasPermissions(resourceUtil[0].getResource(), CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PERM_WRITE_0");
            }
        }
        catch (CmsException e) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }

    @Override
    public boolean matches(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        if (resourceUtil[0].isInsideProject()) {
            CmsLock lock = resourceUtil[0].getLock();
            boolean lockedForPublish = resourceUtil[0].getProjectState().isLockedForPublishing();
            return !lockedForPublish && !lock.isShared() && lock.isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject()) || !lockedForPublish && lock.isNullLock() && OpenCms.getWorkplaceManager().autoLockResources();
        }
        return false;
    }
}

