/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.workplace.list.Messages;

public final class CmsListColumnAlignEnum {
    public static final CmsListColumnAlignEnum ALIGN_CENTER = new CmsListColumnAlignEnum("center");
    public static final CmsListColumnAlignEnum ALIGN_LEFT = new CmsListColumnAlignEnum("left");
    public static final CmsListColumnAlignEnum ALIGN_RIGHT = new CmsListColumnAlignEnum("right");
    private static final CmsListColumnAlignEnum[] VALUE_ARRAY = new CmsListColumnAlignEnum[]{ALIGN_LEFT, ALIGN_CENTER, ALIGN_RIGHT};
    public static final List<CmsListColumnAlignEnum> VALUES = Collections.unmodifiableList(Arrays.asList(VALUE_ARRAY));
    private final String m_align;

    private CmsListColumnAlignEnum(String align) {
        this.m_align = align;
    }

    public static CmsListColumnAlignEnum valueOf(String value) throws CmsIllegalArgumentException {
        for (CmsListColumnAlignEnum target : VALUES) {
            if (!value.equals(target.getAlign())) continue;
            return target;
        }
        throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_ENUM_PARSE_2", new Integer(value), CmsListColumnAlignEnum.class.getName()));
    }

    public String getAlign() {
        return this.m_align;
    }

    public String toString() {
        return this.m_align;
    }
}

