/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDefaultComparator;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public class CmsListColumnDefinition {
    public static final String ICON_DOWN = "list/arrow_down.png";
    public static final String ICON_UP = "list/arrow_up.png";
    private CmsListColumnAlignEnum m_align = CmsListColumnAlignEnum.ALIGN_LEFT;
    private I_CmsListItemComparator m_comparator = new CmsListItemDefaultComparator();
    private List<CmsListDefaultAction> m_defaultActions = new ArrayList<CmsListDefaultAction>();
    private List<I_CmsListDirectAction> m_directActions = new ArrayList<I_CmsListDirectAction>();
    private I_CmsListFormatter m_formatter;
    private CmsMessageContainer m_helpText;
    private final String m_id;
    private String m_listId;
    private CmsMessageContainer m_name;
    private boolean m_printable = true;
    private boolean m_textWrapping;
    private boolean m_visible = true;
    private String m_width;
    private transient A_CmsListDialog m_wp;

    public CmsListColumnDefinition(String id) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(id)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_NULL_ARG_1", "id"));
        }
        this.m_id = id;
    }

    public void addDefaultAction(CmsListDefaultAction defaultAction) {
        if (this.m_listId != null) {
            defaultAction.setListId(this.m_listId);
        }
        defaultAction.setColumnForLink(this);
        this.m_defaultActions.add(defaultAction);
    }

    public void addDirectAction(I_CmsListDirectAction listAction) {
        if (this.m_listId != null) {
            listAction.setListId(this.m_listId);
        }
        this.m_directActions.add(listAction);
    }

    public String csvCell(CmsListItem item) {
        if (!this.isVisible()) {
            return "";
        }
        StringBuffer csv = new StringBuffer(512);
        if (this.m_formatter == null) {
            if (item.get(this.m_id) != null) {
                csv.append(item.get(this.m_id).toString());
            } else {
                for (I_CmsListDirectAction action : this.m_directActions) {
                    if (!action.isVisible()) continue;
                    action.setItem(item);
                    csv.append(action.getName().key(this.getWp().getLocale()));
                }
            }
        } else {
            csv.append(this.m_formatter.format(item.get(this.m_id), this.getWp().getLocale()));
        }
        return csv.toString();
    }

    public String csvHeader() {
        if (!this.isVisible()) {
            return "";
        }
        return this.getName().key(this.getWp().getLocale());
    }

    public CmsListColumnAlignEnum getAlign() {
        return this.m_align;
    }

    public CmsListDefaultAction getDefaultAction(String actionId) {
        for (CmsListDefaultAction action : this.m_defaultActions) {
            if (!action.getId().equals(actionId)) continue;
            return action;
        }
        return null;
    }

    public List<String> getDefaultActionIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (I_CmsListDirectAction i_CmsListDirectAction : this.m_defaultActions) {
            ids.add(i_CmsListDirectAction.getId());
        }
        return Collections.unmodifiableList(ids);
    }

    public List<CmsListDefaultAction> getDefaultActions() {
        return Collections.unmodifiableList(this.m_defaultActions);
    }

    public I_CmsListDirectAction getDirectAction(String actionId) {
        for (I_CmsListDirectAction action : this.m_directActions) {
            if (!action.getId().equals(actionId)) continue;
            return action;
        }
        return null;
    }

    public List<String> getDirectActionIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (I_CmsListDirectAction action : this.m_directActions) {
            ids.add(action.getId());
        }
        return Collections.unmodifiableList(ids);
    }

    public List<I_CmsListDirectAction> getDirectActions() {
        return Collections.unmodifiableList(this.m_directActions);
    }

    public I_CmsListFormatter getFormatter() {
        return this.m_formatter;
    }

    public CmsMessageContainer getHelpText() {
        return this.m_helpText;
    }

    public String getId() {
        return this.m_id;
    }

    public I_CmsListItemComparator getListItemComparator() {
        return this.m_comparator;
    }

    public CmsMessageContainer getName() {
        return this.m_name;
    }

    public String getWidth() {
        return this.m_width;
    }

    public A_CmsListDialog getWp() {
        return this.m_wp;
    }

    public String htmlCell(CmsListItem item, boolean isPrintable) {
        StringBuffer html = new StringBuffer(512);
        for (I_CmsListDirectAction action : this.m_directActions) {
            action.setItem(item);
            boolean enabled = action.isEnabled();
            if (isPrintable) {
                action.setEnabled(false);
            }
            html.append(action.buttonHtml());
            if (!isPrintable) continue;
            action.setEnabled(enabled);
        }
        if (!this.m_defaultActions.isEmpty()) {
            for (CmsListDefaultAction defAction : this.m_defaultActions) {
                defAction.setItem(item);
                boolean enabled = defAction.isEnabled();
                if (isPrintable) {
                    defAction.setEnabled(false);
                }
                html.append(defAction.buttonHtml());
                if (!isPrintable) continue;
                defAction.setEnabled(enabled);
            }
        } else if (this.m_formatter == null) {
            if (item.get(this.m_id) != null) {
                html.append(item.get(this.m_id).toString());
            }
        } else {
            html.append(this.m_formatter.format(item.get(this.m_id), this.getWp().getLocale()));
        }
        html.append("\n");
        return html.toString();
    }

    public String htmlHeader(CmsHtmlList list) {
        String listId = list.getId();
        String sortedCol = list.getSortedColumn();
        CmsListOrderEnum order = list.getCurrentSortOrder();
        StringBuffer html = new StringBuffer(512);
        Locale locale = this.getWp().getLocale();
        CmsMessages messages = Messages.get().getBundle(locale);
        html.append("<th");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getWidth())) {
            html.append(" width='");
            html.append(this.getWidth());
            html.append("'");
        }
        if (!this.isTextWrapping()) {
            html.append(" style='white-space: nowrap;'");
        }
        html.append(">\n");
        boolean isSorted = this.getId().equals(sortedCol);
        CmsListOrderEnum nextOrder = CmsListOrderEnum.ORDER_ASCENDING;
        if (isSorted && order == CmsListOrderEnum.ORDER_ASCENDING) {
            nextOrder = CmsListOrderEnum.ORDER_DESCENDING;
        }
        String id = listId + this.getId() + "Sort";
        String onClic = "listSort('" + listId + "', '" + this.getId() + "');";
        String helpText = null;
        helpText = this.m_helpText != null ? new MessageFormat(this.m_helpText.key(locale), locale).format(new Object[]{this.getName().key(locale)}) : (this.isSorteable() ? (nextOrder.equals(CmsListOrderEnum.ORDER_ASCENDING) ? messages.key("GUI_LIST_COLUMN_ASC_SORT_1", new Object[]{this.getName().key(locale)}) : messages.key("GUI_LIST_COLUMN_DESC_SORT_1", new Object[]{this.getName().key(locale)})) : messages.key("GUI_LIST_COLUMN_NO_SORT_1", new Object[]{this.getName().key(locale)}));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getWidth()) && this.getWidth().indexOf(37) < 0) {
            html.append("\t<div style='display:block; width: ");
            html.append(this.getWidth());
            html.append("px;'>\n");
        }
        String sortArrow = "";
        if (isSorted) {
            sortArrow = nextOrder == CmsListOrderEnum.ORDER_ASCENDING ? "<img src='" + CmsWorkplace.getSkinUri() + ICON_DOWN + "' alt=''>&nbsp;" : "<img src='" + CmsWorkplace.getSkinUri() + ICON_UP + "' alt=''>&nbsp;";
        }
        html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, id, id, this.getName().key(locale), helpText, list.isPrintable() ? false : this.isSorteable(), null, null, onClic, false, sortArrow));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getWidth()) && this.getWidth().indexOf(37) < 0) {
            html.append("\t</div>\n");
        }
        html.append("</th>\n");
        return html.toString();
    }

    public boolean isPrintable() {
        return this.m_printable;
    }

    public boolean isSorteable() {
        return this.getListItemComparator() != null;
    }

    public boolean isTextWrapping() {
        return this.m_textWrapping;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public CmsListDefaultAction removeDefaultAction(String actionId) {
        Iterator<CmsListDefaultAction> it = this.m_defaultActions.iterator();
        while (it.hasNext()) {
            CmsListDefaultAction action = it.next();
            if (!action.getId().equals(actionId)) continue;
            it.remove();
            return action;
        }
        return null;
    }

    public I_CmsListDirectAction removeDirectAction(String actionId) {
        Iterator<I_CmsListDirectAction> it = this.m_directActions.iterator();
        while (it.hasNext()) {
            I_CmsListDirectAction action = it.next();
            if (!action.getId().equals(actionId)) continue;
            it.remove();
            return action;
        }
        return null;
    }

    public void setAlign(CmsListColumnAlignEnum align) {
        this.m_align = align;
    }

    public void setFormatter(I_CmsListFormatter formatter) {
        this.m_formatter = formatter;
        for (CmsListDefaultAction action : this.m_defaultActions) {
            action.setColumnForLink(this);
        }
    }

    public void setHelpText(CmsMessageContainer helpText) {
        this.m_helpText = helpText;
    }

    public void setListItemComparator(I_CmsListItemComparator comparator) {
        this.m_comparator = comparator;
    }

    public void setName(CmsMessageContainer name) {
        this.m_name = name;
    }

    public void setPrintable(boolean printable) {
        this.m_printable = printable;
    }

    public void setSorteable(boolean sorteable) {
        if (sorteable) {
            this.setListItemComparator(new CmsListItemDefaultComparator());
        } else {
            this.setListItemComparator(null);
        }
    }

    public void setTextWrapping(boolean textWrapping) {
        this.m_textWrapping = textWrapping;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
        if (!this.m_visible) {
            this.setPrintable(false);
        }
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    public void setWp(A_CmsListDialog wp) {
        this.m_wp = wp;
        for (I_CmsListDirectAction action : this.getDirectActions()) {
            action.setWp(wp);
        }
        for (CmsListDefaultAction action : this.getDefaultActions()) {
            action.setWp(wp);
        }
    }

    void setListId(String listId) {
        this.m_listId = listId;
    }
}

