/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.opencms.workplace.list.A_CmsListDialog;

public class CmsMultiListDialog {
    private A_CmsListDialog m_activeWp;
    private List<A_CmsListDialog> m_wps;

    public CmsMultiListDialog(List<A_CmsListDialog> wps) {
        this.m_wps = wps;
        for (A_CmsListDialog wp : this.m_wps) {
            if (!wp.isActive()) continue;
            this.m_activeWp = wp;
        }
        if (this.m_activeWp == null) {
            this.m_activeWp = this.m_wps.get(0);
        }
    }

    public void displayDialog() throws JspException, IOException, ServletException {
        this.displayDialog(false);
    }

    public void displayDialog(boolean writeLater) throws JspException, IOException, ServletException {
        this.m_activeWp.actionDialog();
        if (this.m_activeWp.isForwarded()) {
            return;
        }
        for (A_CmsListDialog wp : this.m_wps) {
            wp.refreshList();
        }
        if (writeLater) {
            return;
        }
        this.writeDialog();
    }

    public A_CmsListDialog getActiveWp() {
        return this.m_activeWp;
    }

    public boolean isForwarded() {
        for (A_CmsListDialog wp : this.m_wps) {
            if (!wp.isForwarded()) continue;
            return true;
        }
        return false;
    }

    public void writeDialog() throws IOException {
        JspWriter out = this.m_activeWp.getJsp().getJspContext().getOut();
        out.print(this.defaultActionHtml());
    }

    protected String defaultActionHtml() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.defaultActionHtmlStart());
        result.append(this.defaultActionHtmlContent());
        result.append(this.defaultActionHtmlEnd());
        return result.toString();
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<table id='twolists' cellpadding='0' cellspacing='0' align='center' width='100%'>\n");
        for (A_CmsListDialog wp : this.m_wps) {
            result.append("\t<tr>\n");
            result.append("\t\t<td valign='top'>\n");
            result.append("\t\t\t").append(wp.defaultActionHtmlContent()).append("\n");
            result.append("\t\t</td>\n");
            result.append("\t</tr>\n");
            result.append("\t<tr><td height='20'/></tr>\n");
        }
        result.append("</table>\n");
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return this.m_activeWp.defaultActionHtmlEnd() + this.m_activeWp.dialogContentEnd();
    }

    protected String defaultActionHtmlStart() {
        return this.m_activeWp.getList().listJs() + this.m_activeWp.dialogContentStart(this.getActiveWp().getParamTitle());
    }
}

