/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsFormatterBean
implements I_CmsFormatterBean {
    public static final int DEFAULT_CONFIGURATION_RANK = 1000;
    public static final int DEFAULT_SCHEMA_RANK = 10000;
    public static final String PREVIEW_TYPE = "_PREVIEW_";
    public static final int PREVIEW_WIDTH = 640;
    public static final String WILDCARD_TYPE = "*";
    private Set<String> m_containerTypes;
    private Set<String> m_cssHeadIncludes = new LinkedHashSet<String>();
    private String m_id;
    private String m_inlineCss;
    private String m_inlineJavascript;
    private boolean m_isAutoEnabled;
    private boolean m_isDetail;
    private boolean m_isFromFormatterConfigFile;
    private boolean m_isPreviewFormatter;
    private List<String> m_javascriptHeadIncludes = new ArrayList<String>();
    private String m_jspRootPath;
    private CmsUUID m_jspStructureId;
    private String m_location;
    private boolean m_matchAll;
    private int m_maxWidth;
    private int m_minWidth;
    private boolean m_nestedContainers;
    private String m_niceName;
    private int m_rank;
    private String m_resourceTypeName;
    private boolean m_search;
    private Map<String, CmsXmlContentProperty> m_settings = new LinkedHashMap<String, CmsXmlContentProperty>();

    public CmsFormatterBean(Set<String> containerTypes, String jspRootPath, CmsUUID jspStructureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location, List<String> cssHeadIncludes, String inlineCss, List<String> javascriptHeadIncludes, String inlineJavascript, String niceName, String resourceTypeName, int rank, String id, Map<String, CmsXmlContentProperty> settings, boolean isFromConfigFile, boolean isAutoEnabled, boolean isDetail, boolean nestedContainers) {
        this.m_jspRootPath = jspRootPath;
        this.m_jspStructureId = jspStructureId;
        this.m_containerTypes = containerTypes;
        this.m_minWidth = minWidth;
        this.m_maxWidth = maxWidth;
        this.m_isPreviewFormatter = preview;
        this.m_search = searchContent;
        this.m_location = location;
        this.m_id = id;
        this.m_niceName = niceName;
        this.m_resourceTypeName = resourceTypeName;
        this.m_rank = rank;
        this.m_inlineCss = inlineCss;
        this.m_inlineJavascript = inlineJavascript;
        this.m_javascriptHeadIncludes.addAll(javascriptHeadIncludes);
        this.m_cssHeadIncludes.addAll(cssHeadIncludes);
        this.m_settings.putAll(settings);
        this.m_isFromFormatterConfigFile = isFromConfigFile;
        this.m_isAutoEnabled = isAutoEnabled;
        this.m_isDetail = isDetail;
        this.m_nestedContainers = nestedContainers;
    }

    public CmsFormatterBean(String containerType, String rootPath, CmsUUID structureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location) {
        this(CmsFormatterBean.isWildcardType(containerType) ? Collections.emptySet() : Collections.singleton(containerType), rootPath, structureId, minWidth, maxWidth, preview, searchContent, location, Collections.emptyList(), "", Collections.emptyList(), "", rootPath, "", 1000, null, Collections.emptyMap(), false, false, true, false);
    }

    public CmsFormatterBean(String containerType, String jspRootPath, String minWidthStr, String maxWidthStr, String preview, String searchContent, String location) {
        this.m_jspRootPath = jspRootPath;
        this.m_containerTypes = Collections.singleton(containerType);
        if (CmsFormatterBean.isWildcardType(containerType)) {
            this.m_containerTypes = Collections.emptySet();
        }
        this.m_minWidth = -1;
        this.m_maxWidth = Integer.MAX_VALUE;
        if (this.m_containerTypes.isEmpty()) {
            try {
                this.m_minWidth = Integer.parseInt(minWidthStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.m_isPreviewFormatter = Boolean.valueOf(preview);
        this.m_search = CmsStringUtil.isEmptyOrWhitespaceOnly(searchContent) ? true : Boolean.valueOf(searchContent);
        this.m_location = location;
        this.m_rank = 10000;
    }

    CmsFormatterBean(String jspRootPath, CmsUUID jspStructureId, String location, boolean preview) {
        this(Collections.emptySet(), jspRootPath, jspStructureId, -1, Integer.MAX_VALUE, preview, false, location, Collections.emptyList(), "", Collections.emptyList(), "", jspRootPath, "", 10000, null, Collections.emptyMap(), false, false, true, false);
        this.m_matchAll = true;
    }

    public static boolean isPreviewType(String containerType) {
        return PREVIEW_TYPE.equals(containerType);
    }

    private static boolean isWildcardType(String containerType) {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(containerType) || WILDCARD_TYPE.equals(containerType);
    }

    @Override
    public Set<String> getContainerTypes() {
        return this.m_containerTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.m_containerTypes);
    }

    @Override
    public Set<String> getCssHeadIncludes() {
        return Collections.unmodifiableSet(this.m_cssHeadIncludes);
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getInlineCss() {
        return this.m_inlineCss;
    }

    @Override
    public String getInlineJavascript() {
        return this.m_inlineJavascript;
    }

    @Override
    public List<String> getJavascriptHeadIncludes() {
        return Collections.unmodifiableList(this.m_javascriptHeadIncludes);
    }

    @Override
    public String getJspRootPath() {
        return this.m_jspRootPath;
    }

    @Override
    public CmsUUID getJspStructureId() {
        return this.m_jspStructureId;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    @Override
    public int getMinWidth() {
        return this.m_minWidth;
    }

    @Override
    public String getNiceName() {
        return this.m_niceName;
    }

    @Override
    public int getRank() {
        return this.m_rank;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceTypeName;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings() {
        return Collections.unmodifiableMap(this.m_settings);
    }

    public int hashCode() {
        return ((Object)this.getContainerTypes()).hashCode() ^ (this.m_minWidth * 33 ^ this.m_maxWidth);
    }

    @Override
    public boolean hasNestedContainers() {
        return this.m_nestedContainers;
    }

    @Override
    public boolean isAutoEnabled() {
        return this.m_isAutoEnabled;
    }

    @Override
    public boolean isDetailFormatter() {
        return this.m_isDetail;
    }

    @Override
    public boolean isFromFormatterConfigFile() {
        return this.m_isFromFormatterConfigFile;
    }

    @Override
    public boolean isMatchAll() {
        return this.m_matchAll;
    }

    @Override
    public boolean isPreviewFormatter() {
        return this.m_isPreviewFormatter;
    }

    @Override
    public boolean isSearchContent() {
        return this.m_search;
    }

    @Override
    public boolean isTypeFormatter() {
        return !this.getContainerTypes().isEmpty();
    }

    @Override
    public void setJspStructureId(CmsUUID jspStructureId) {
        this.m_jspStructureId = jspStructureId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

