/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentMacroVisitor;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public class CmsXmlGroupContainer
extends CmsXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsXmlGroupContainer.class);
    private Map<Locale, CmsGroupContainerBean> m_groupContainers;

    protected CmsXmlGroupContainer() {
    }

    protected CmsXmlGroupContainer(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        this.m_document = document;
        this.m_contentDefinition = this.getContentDefinition(resolver);
        this.initDocument(cms, this.m_document, encoding, this.m_contentDefinition);
    }

    protected CmsXmlGroupContainer(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsFile modelFile = cms.readFile(modelUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsXmlGroupContainer model = CmsXmlGroupContainerFactory.unmarshal(cms, modelFile);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        this.m_contentDefinition = model.getContentDefinition();
        Document document = (Document)model.m_document.clone();
        this.initDocument(cms, document, model.getEncoding(), this.m_contentDefinition);
        this.visitAllValuesWith(new CmsXmlContentMacroVisitor(cms, macroResolver));
        if (!this.hasLocale(locale)) {
            try {
                this.addLocale(cms, locale);
            }
            catch (CmsXmlException e) {
                // empty catch block
            }
        }
    }

    protected CmsXmlGroupContainer(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
        Document document = this.m_contentDefinition.createDocument(cms, this, locale);
        this.initDocument(cms, document, encoding, this.m_contentDefinition);
    }

    public void clearLocales() throws CmsXmlException {
        for (Locale locale : this.getLocales()) {
            this.removeLocale(locale);
        }
    }

    public CmsGroupContainerBean getGroupContainer(CmsObject cms) {
        if (this.m_groupContainers.containsKey(CmsLocaleManager.MASTER_LOCALE)) {
            return this.m_groupContainers.get(CmsLocaleManager.MASTER_LOCALE);
        }
        if (!this.m_groupContainers.isEmpty()) {
            return this.m_groupContainers.get(this.m_groupContainers.keySet().iterator().next());
        }
        return null;
    }

    @Override
    public boolean isAutoCorrectionEnabled() {
        return true;
    }

    public void save(CmsObject cms, CmsGroupContainerBean groupContainer, Locale locale) throws CmsException {
        CmsFile file = this.getFile();
        cms.lockResourceTemporary(cms.getSitePath(file));
        if (this.hasLocale(locale)) {
            this.removeLocale(locale);
        }
        this.addLocale(cms, locale);
        Element parent = this.getLocaleNode(locale);
        this.saveGroupContainer(cms, parent, groupContainer);
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
        file.setContents(this.marshal());
        cms.writeFile(file);
    }

    protected void fillResource(CmsObject cms, Element element, CmsResource res) {
        String xpath = element.getPath();
        int pos = xpath.lastIndexOf("/" + XmlNode.GroupContainers.name() + "/");
        if (pos > 0) {
            xpath = xpath.substring(pos + 1);
        }
        CmsRelationType type = this.getHandler().getRelationType(xpath);
        CmsXmlVfsFileValue.fillEntry(element, res.getStructureId(), res.getRootPath(), type);
    }

    @Override
    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_document = document;
        this.m_contentDefinition = definition;
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        this.m_groupContainers = new HashMap<Locale, CmsGroupContainerBean>();
        this.clearBookmarks();
        Iterator<Element> itGroupContainers = CmsXmlGenericWrapper.elementIterator(this.m_document.getRootElement());
        while (itGroupContainers.hasNext()) {
            Element cntPage = itGroupContainers.next();
            try {
                Locale locale = CmsLocaleManager.getLocale(cntPage.attribute("language").getValue());
                this.addLocale(locale);
                Element groupContainer = cntPage.element(XmlNode.GroupContainers.name());
                int cntIndex = CmsXmlUtils.getXpathIndexInt(groupContainer.getUniquePath(cntPage));
                String cntPath = CmsXmlUtils.createXpathElement(groupContainer.getName(), cntIndex);
                I_CmsXmlSchemaType cntSchemaType = definition.getSchemaType(groupContainer.getName());
                I_CmsXmlContentValue cntValue = cntSchemaType.createValue(this, groupContainer, locale);
                this.addBookmark(cntPath, locale, true, cntValue);
                CmsXmlContentDefinition cntDef = ((CmsXmlNestedContentDefinition)cntSchemaType).getNestedContentDefinition();
                Element title = groupContainer.element(XmlNode.Title.name());
                this.addBookmarkForElement(title, locale, groupContainer, cntPath, cntDef);
                Element description = groupContainer.element(XmlNode.Description.name());
                this.addBookmarkForElement(description, locale, groupContainer, cntPath, cntDef);
                HashSet<String> types = new HashSet<String>();
                Iterator<Element> itTypes = CmsXmlGenericWrapper.elementIterator(groupContainer, XmlNode.Type.name());
                while (itTypes.hasNext()) {
                    Element type = itTypes.next();
                    this.addBookmarkForElement(type, locale, groupContainer, cntPath, cntDef);
                    String typeName = type.getTextTrim();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(typeName)) continue;
                    types.add(typeName);
                }
                ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
                for (Element element : CmsXmlGenericWrapper.elementIterable(groupContainer, XmlNode.Element.name())) {
                    int elemIndex = CmsXmlUtils.getXpathIndexInt(element.getUniquePath(groupContainer));
                    String elemPath = CmsXmlUtils.concatXpath(cntPath, CmsXmlUtils.createXpathElement(element.getName(), elemIndex));
                    I_CmsXmlSchemaType elemSchemaType = cntDef.getSchemaType(element.getName());
                    I_CmsXmlContentValue elemValue = elemSchemaType.createValue(this, element, locale);
                    this.addBookmark(elemPath, locale, true, elemValue);
                    CmsXmlContentDefinition elemDef = ((CmsXmlNestedContentDefinition)elemSchemaType).getNestedContentDefinition();
                    Element uri = element.element(XmlNode.Uri.name());
                    this.addBookmarkForElement(uri, locale, element, elemPath, elemDef);
                    Element uriLink = uri.element("link");
                    CmsUUID elementId = null;
                    if (uriLink != null) {
                        elementId = new CmsLink(uriLink).getStructureId();
                    }
                    Map<String, String> propertiesMap = CmsXmlContentPropertyHelper.readProperties(this, locale, element, elemPath, elemDef);
                    if (elementId == null) continue;
                    elements.add(new CmsContainerElementBean(elementId, null, propertiesMap, false));
                }
                this.m_groupContainers.put(locale, new CmsGroupContainerBean(title.getText(), description.getText(), elements, types));
            }
            catch (NullPointerException e) {
                LOG.error((Object)org.opencms.xml.content.Messages.get().getBundle().key("LOG_XMLCONTENT_INIT_BOOKMARKS_0"), (Throwable)e);
            }
        }
    }

    protected void saveGroupContainer(CmsObject cms, Element parent, CmsGroupContainerBean groupContainer) throws CmsException {
        parent.clearContent();
        Element groupContainerElem = parent.addElement(XmlNode.GroupContainers.name());
        groupContainerElem.addElement(XmlNode.Title.name()).addCDATA(groupContainer.getTitle());
        groupContainerElem.addElement(XmlNode.Description.name()).addCDATA(groupContainer.getDescription());
        for (String type : groupContainer.getTypes()) {
            groupContainerElem.addElement(XmlNode.Type.name()).addCDATA(type);
        }
        for (CmsContainerElementBean element : groupContainer.getElements()) {
            CmsResource res = cms.readResource(element.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName().equals("groupcontainer")) {
                LOG.warn((Object)Messages.get().container("LOG_WARN_ELEMENT_GROUP_INSIDE_ELEMENT_GROUP_0"));
                continue;
            }
            Element elemElement = groupContainerElem.addElement(XmlNode.Element.name());
            Element uriElem = elemElement.addElement(XmlNode.Uri.name());
            this.fillResource(cms, uriElem, res);
            Map<String, String> properties = element.getIndividualSettings();
            Map<String, CmsXmlContentProperty> propertiesConf = OpenCms.getADEManager().getElementSettings(cms, res);
            CmsXmlContentPropertyHelper.saveProperties(cms, elemElement, properties, propertiesConf);
        }
    }

    @Override
    protected void setFile(CmsFile file) {
        super.setFile(file);
    }

    public static enum XmlNode {
        Description,
        Element,
        GroupContainers,
        Title,
        Type,
        Uri;

    }
}

