/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkUpdateUtil;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlCategoryValue
extends A_CmsXmlContentValue {
    public static final String NO_LINK = "none";
    public static final String TYPE_NAME = "OpenCmsCategory";
    public static final String TYPE_VFS_LINK = "vfsLink";
    private static String m_schemaDefinition;
    private String m_stringValue;

    public CmsXmlCategoryValue() {
    }

    public CmsXmlCategoryValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlCategoryValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    public static void fillEntry(Element element, CmsUUID id, String rootPath, CmsRelationType type) {
        CmsLink link = new CmsLink(TYPE_VFS_LINK, type, id, rootPath, true);
        Element linkElement = element.element("link");
        if (linkElement == null) {
            linkElement = element.addElement("link");
        }
        CmsLinkUpdateUtil.updateXmlForVfsFile(link, linkElement);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlCategoryValue(document, element, locale, this);
    }

    @Override
    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        String defaultValue = document.getHandler().getDefault(cms, this, locale);
        if (defaultValue != null) {
            I_CmsXmlContentValue value = this.createValue(document, element, locale);
            value.setStringValue(cms, defaultValue);
        }
        return element;
    }

    public List<CmsLink> getLinks(CmsObject cms) {
        ArrayList<CmsLink> result = new ArrayList<CmsLink>();
        List linkElements = this.m_element.elements("link");
        for (Element linkElement : linkElements) {
            String uri;
            if (linkElement == null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(uri = this.m_element.getText())) {
                this.setStringValue(cms, uri);
            }
            CmsLinkUpdateUtil.updateType(linkElement, this.getRelationType(this.getPath()));
            CmsLink link = new CmsLink(linkElement);
            link.checkConsistency(cms);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(link.getTarget())) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public String getPlainText(CmsObject cms) {
        return this.getStringValue(cms);
    }

    @Override
    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlCategoryValue.xsd");
        }
        return m_schemaDefinition;
    }

    @Override
    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        if (this.m_stringValue == null) {
            this.m_stringValue = this.createStringValue(cms);
        }
        return this.m_stringValue;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlCategoryValue(name, minOccurs, maxOccurs);
    }

    public void setIdValue(CmsObject cms, CmsUUID id) {
        CmsRelationType type = CmsRelationType.CATEGORY;
        CmsLink link = new CmsLink(TYPE_VFS_LINK, type, id, "@", true);
        link.checkConsistency(cms);
        CmsLinkUpdateUtil.updateXmlForVfsFile(link, this.m_element.addElement("link"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        String[] pathes;
        this.m_element.clearContent();
        this.m_stringValue = null;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return;
        }
        for (String path : pathes = value.split(",")) {
            if (cms != null) {
                String siteRoot = OpenCms.getSiteManager().getSiteRoot(path);
                String oldSite = cms.getRequestContext().getSiteRoot();
                try {
                    if (siteRoot != null) {
                        cms.getRequestContext().setSiteRoot(siteRoot);
                        path = cms.getRequestContext().removeSiteRoot(path);
                    }
                    String query = "";
                    int pos = path.indexOf("?");
                    int anchorPos = path.indexOf(35);
                    if (pos == -1 || anchorPos > -1 && pos > anchorPos) {
                        pos = anchorPos;
                    }
                    if (pos > -1) {
                        query = path.substring(pos);
                        path = path.substring(0, pos);
                    }
                    if ((path = OpenCms.getLinkManager().getRootPath(cms, path)) != null) {
                        path = path + query;
                    }
                }
                finally {
                    if (siteRoot != null) {
                        cms.getRequestContext().setSiteRoot(oldSite);
                    }
                }
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) continue;
            CmsRelationType type = this.getRelationType(this.getPath());
            CmsLink link = new CmsLink(TYPE_VFS_LINK, type, path, true);
            link.checkConsistency(cms);
            CmsLinkUpdateUtil.updateXmlForVfsFile(link, this.m_element.addElement("link"));
        }
    }

    private String createStringValue(CmsObject cms) {
        Attribute enabled = this.m_element.attribute("enabled");
        String content = "";
        if (enabled == null || Boolean.valueOf(enabled.getText()).booleanValue()) {
            List<CmsLink> links = this.getLinks(cms);
            int i = 0;
            for (CmsLink link : links) {
                if (link == null) continue;
                String uri = "";
                uri = uri + link.getUri();
                if (cms != null) {
                    uri = cms.getRequestContext().removeSiteRoot(link.getUri());
                }
                if (i > 0) {
                    content = content + ",";
                }
                content = content + uri;
                ++i;
            }
        }
        return content;
    }
}

