/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.document1.jmi1.Media;
import org.opencrx.kernel.layer.persistence.Media_2;
import org.opencrx.kernel.tools.FastResultSet;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.loading.Classes;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class DbSchemaUtils {
    protected static final int FETCH_SIZE = 200;
    protected static final Set<String> HIDDEN_FILES = new TreeSet<String>(Arrays.asList(".git", ".cvs", ".svn"));
    public static final String CREATE_TABLE_PREFIX = "CREATE MEMORY TABLE PUBLIC.";
    public static final String CREATE_VIEW_PREFIX = "CREATE VIEW PUBLIC.";
    public static final String CREATE_SEQUENCE_PREFIX = "CREATE SEQUENCE PUBLIC.";
    public static final String CREATE_INDEX_PREFIX = "CREATE INDEX";
    public static final String ALTER_TABLE_PREFIX = "ALTER TABLE";
    public static final Set<String> OPTIONAL_DBOBJECTS = new HashSet<String>(Arrays.asList("OOCKE1_TOBJ_ACCTMEMBERSHIP_ALT", "OOCKE1_TOBJ_ACCTMEMBERSHIP_FR", "OOCKE1_TOBJ_ACCTMEMBERSHIP_TO"));
    protected static boolean schemaPrepared = false;
    protected static Database_2[] databasePlugIns;

    public static String getJdbcDriverName(String connectionUrl) {
        if (connectionUrl.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (connectionUrl.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (connectionUrl.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }
        if (connectionUrl.startsWith("jdbc:db2:")) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (connectionUrl.startsWith("jdbc:as400:")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        if (connectionUrl.startsWith("jdbc:oracle:")) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        if (connectionUrl.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(Connection conn, List<String> commands, boolean logExceptions) throws ServiceException {
        try {
            for (String command : commands) {
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement(command);
                    ps.executeUpdate();
                    ps.close();
                }
                catch (Exception e) {
                    if (!logExceptions) continue;
                    new ServiceException(e).log();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static Connection getSchemaConnection() throws ServiceException {
        try {
            Connection connSchema = DriverManager.getConnection("jdbc:hsqldb:mem:dbschema", "sa", "");
            if (!schemaPrepared) {
                try {
                    Properties properties = new Properties();
                    properties.put("database", "org/opencrx/kernel/tools/resource/crx");
                    properties.put("user", "SA");
                    properties.put("password", "manager99");
                    Connection conn = DriverManager.getConnection("jdbc:hsqldb:res:", properties);
                    PreparedStatement ps = conn.prepareStatement("script");
                    ResultSet rs = ps.executeQuery();
                    ArrayList<String> commands = new ArrayList<String>();
                    while (rs.next()) {
                        commands.add(rs.getString("Command"));
                    }
                    rs.close();
                    ps.close();
                    DbSchemaUtils.executeUpdate(connSchema, commands, false);
                    conn.close();
                }
                catch (Exception e) {
                    throw new ServiceException(e);
                }
                Enumeration schemaResources = Classes.getResources((String)"META-INF/dbschema-add.sql");
                while (schemaResources.hasMoreElements()) {
                    InputStream is = ((URL)schemaResources.nextElement()).openStream();
                    ArrayList<String> commands = new ArrayList<String>();
                    BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String command = null;
                    while ((command = in.readLine()) != null) {
                        commands.add(command);
                    }
                    in.close();
                    DbSchemaUtils.executeUpdate(connSchema, commands, true);
                }
                schemaPrepared = true;
            }
            return connSchema;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<String> getSchema(Connection conn) throws ServiceException {
        ArrayList<String> schema = new ArrayList<String>();
        try {
            PreparedStatement ps = conn.prepareStatement("script");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                schema.add(rs.getString("Command"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return schema;
    }

    /*
     * WARNING - void declaration
     */
    public static String getObjectDefinition(String type, String object, List<String> schema, String targetDatabaseName, boolean replaceObject) {
        for (String string : schema) {
            void var6_31;
            if (string.indexOf(type) < 0 || string.indexOf(object + "(") <= 0 && string.indexOf(object + " ") <= 0) continue;
            String string5 = string.replace(CREATE_TABLE_PREFIX, "CREATE TABLE ");
            string5 = string5.replace(CREATE_VIEW_PREFIX, "CREATE VIEW ");
            string5 = string5.replace(" PUBLIC.", " ");
            string5 = string5.replace(",PUBLIC.", ", ");
            if (targetDatabaseName.indexOf("PostgreSQL") >= 0) {
                if (type.equals(CREATE_SEQUENCE_PREFIX)) {
                    String string6 = string5.replace("AS INTEGER", "");
                } else {
                    void var6_13;
                    if (replaceObject) {
                        String string7 = string5.replace("CREATE VIEW ", "CREATE OR REPLACE VIEW ");
                    }
                    String string8 = DbSchemaUtils.mapColumnDefinition(targetDatabaseName, (String)var6_13);
                }
            } else if (targetDatabaseName.indexOf("HSQL") >= 0) {
                String string9;
                int pos1;
                if (replaceObject && (pos1 = (string9 = string5.replace("CREATE VIEW ", "ALTER VIEW ")).indexOf("(")) > 0) {
                    int pos2 = string9.indexOf(")", pos1);
                    String string10 = string9.substring(0, pos1) + string9.substring(pos2 + 1);
                }
            } else if (targetDatabaseName.indexOf("MySQL") >= 0) {
                void var6_19;
                if (replaceObject) {
                    String string11 = string5.replace("CREATE VIEW ", "CREATE OR REPLACE VIEW ");
                }
                String string12 = DbSchemaUtils.mapColumnDefinition(targetDatabaseName, (String)var6_19);
            } else if (targetDatabaseName.indexOf("DB2") >= 0) {
                void var6_22;
                if (replaceObject && targetDatabaseName.indexOf("UDB") < 0) {
                    String string13 = string5.replace("CREATE VIEW ", "CREATE OR REPLACE VIEW ");
                }
                String string14 = DbSchemaUtils.mapColumnDefinition(targetDatabaseName, (String)var6_22);
            } else if (targetDatabaseName.indexOf("Oracle") >= 0) {
                if (type.equals(CREATE_SEQUENCE_PREFIX)) {
                    String string15 = string5.replace("AS INTEGER", "");
                } else {
                    void var6_26;
                    if (replaceObject) {
                        String string16 = string5.replace("CREATE VIEW ", "CREATE OR REPLACE VIEW ");
                    }
                    String string17 = DbSchemaUtils.mapColumnDefinition(targetDatabaseName, (String)var6_26);
                }
            } else if (targetDatabaseName.indexOf("Microsoft") >= 0) {
                void var6_29;
                if (replaceObject) {
                    String string18 = string5.replace("CREATE VIEW ", "ALTER VIEW ");
                }
                String string19 = DbSchemaUtils.mapColumnDefinition(targetDatabaseName, (String)var6_29);
            }
            return var6_31;
        }
        return null;
    }

    public static String mapColumnDefinition(String targetDatabaseName, String command) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (targetDatabaseName.indexOf("HSQL") < 0) {
                                command = ((String)command).replace("CLOB(10000000)", "CLOB");
                                command = ((String)command).replace("VARBINARY(10000000)", "VARBINARY");
                                command = ((String)command).replace("\"P$$PARENT\"", "P$$PARENT");
                                command = ((String)command).replace("\"NAME\"", "NAME");
                                command = ((String)command).replace("\"TYPE\"", "TYPE");
                                command = ((String)command).replace("\"SCOPE\"", "SCOPE");
                                command = ((String)command).replace("\"LANGUAGE\"", "LANGUAGE");
                                command = ((String)command).replace("\"POSITION\"", "POSITION");
                                command = ((String)command).replace("\"STATE\"", "STATE");
                                command = ((String)command).replace("\"EXCEPTION\"", "EXCEPTION");
                                command = ((String)command).replace("\"DOMAIN\"", "DOMAIN");
                                command = ((String)command).replace("\"NUMBER\"", "NUMBER");
                                command = ((String)command).replace("\"ACTION\"", "ACTION");
                                command = ((String)command).replace("\"TEXT\"", "TEXT");
                            }
                            if (targetDatabaseName.indexOf("PostgreSQL") < 0) break block4;
                            command = ((String)command).replace(" TIMESTAMP", " TIMESTAMP WITH TIME ZONE");
                            command = ((String)command).replace(" CLOB,", " TEXT,");
                            command = ((String)command).replace(" VARBINARY,", " BYTEA,");
                            command = ((String)command).replace(" CLOB)", " TEXT)");
                            command = ((String)command).replace(" VARBINARY)", " BYTEA)");
                            command = ((String)command).replace("'\\'", "E'\\\\'");
                            command = ((String)command).replace("'AS DTYPE", "'::text AS DTYPE");
                            command = ((String)command).replace(" CHAR(", " CHR(");
                            while (((String)command).indexOf("ROW_NUMBER()OVER()") > 0) {
                                int pos = ((String)command).indexOf("ROW_NUMBER()OVER()");
                                int posOrderBy1 = ((String)command).indexOf("ORDER BY", pos);
                                int posOrderBy2 = ((String)command).indexOf(")", posOrderBy1);
                                String orderBy = ((String)command).substring(posOrderBy1, posOrderBy2);
                                command = ((String)command).substring(0, pos) + "ROW_NUMBER()OVER(" + orderBy + ")" + ((String)command).substring(pos + 18, posOrderBy1) + ((String)command).substring(posOrderBy2);
                            }
                            break block5;
                        }
                        if (targetDatabaseName.indexOf("HSQL") >= 0) break block5;
                        if (targetDatabaseName.indexOf("MySQL") < 0) break block6;
                        if (((String)command).indexOf(" TIMESTAMP") > 0) {
                            command = ((String)command).replace(" TIMESTAMP", " DATETIME");
                            command = ((String)command).replace("MODIFIED_AT DATETIME", "MODIFIED_AT TIMESTAMP(6)");
                            command = ((String)command).replace("CREATED_AT DATETIME", "CREATED_AT TIMESTAMP(6)");
                        }
                        command = ((String)command).replace(" BOOLEAN,", " BIT,");
                        command = ((String)command).replace(" CLOB,", " LONGTEXT,");
                        command = ((String)command).replace(" VARBINARY,", " BLOB,");
                        command = ((String)command).replace(" BOOLEAN)", " BIT)");
                        command = ((String)command).replace(" CLOB)", " LONGTEXT)");
                        command = ((String)command).replace(" VARBINARY)", " BLOB)");
                        command = ((String)command).replace(",CONDITION ", ",`CONDITION` ");
                        command = ((String)command).replace("\"POSITION\"", "`POSITION`");
                        command = ((String)command).replace("\"position\"", "`POSITION`");
                        command = ((String)command).replace("'\\'", "'\\\\'");
                        break block5;
                    }
                    if (targetDatabaseName.indexOf("DB2") < 0) break block7;
                    command = ((String)command).replace(" BOOLEAN,", " SMALLINT,");
                    command = ((String)command).replace(" VARBINARY,", " BLOB,");
                    command = ((String)command).replace(" BOOLEAN)", " SMALLINT)");
                    command = ((String)command).replace(" VARBINARY)", " BLOB)");
                    command = ((String)command).replace("SUBSTRING(", "SUBSTR(");
                    command = ((String)command).replace(" CHAR(", "CHR(");
                    command = ((String)command).replace(" WITH RECURSIVE", " WITH");
                    break block5;
                }
                if (targetDatabaseName.indexOf("Oracle") < 0) break block8;
                command = ((String)command).replace(" VARCHAR(", " VARCHAR2(");
                command = ((String)command).replace(" SMALLINT,", " NUMBER,");
                command = ((String)command).replace(" BOOLEAN,", " NUMBER,");
                command = ((String)command).replace(" VARBINARY,", " BLOB,");
                command = ((String)command).replace(" BIGINT,", " INTEGER,");
                command = ((String)command).replace(" SMALLINT)", " NUMBER)");
                command = ((String)command).replace(" BOOLEAN)", " NUMBER)");
                command = ((String)command).replace(" VARBINARY)", " BLOB)");
                command = ((String)command).replace(" BIGINT)", " INTEGER)");
                command = ((String)command).replace(",COMMENT ", ",\"comment\" ");
                command = ((String)command).replace(",NUMBER ", ",\"number\" ");
                command = ((String)command).replace("RESOURCE,", "\"resource\",");
                command = ((String)command).replace("RESOURCE)", "\"resource\")");
                command = ((String)command).replace(" RESOURCE ", " \"resource\" ");
                command = ((String)command).replace("SUBSTRING(", "SUBSTR(");
                command = ((String)command).replace(" CHAR(", "CHR(");
                command = ((String)command).replace(" WITH RECURSIVE", " WITH");
                break block5;
            }
            if (targetDatabaseName.indexOf("Microsoft") < 0) break block5;
            command = ((String)command).replace("||", "+");
            command = ((String)command).replace(" VARCHAR(", " NVARCHAR(");
            command = ((String)command).replace(" DATE,", " DATETIME2,");
            command = ((String)command).replace(" TIMESTAMP", " DATETIME2");
            command = ((String)command).replace(" BOOLEAN,", " BIT,");
            command = ((String)command).replace(" CLOB,", " NTEXT,");
            command = ((String)command).replace(" VARBINARY,", " IMAGE,");
            command = ((String)command).replace(" DATE)", " DATETIME2)");
            command = ((String)command).replace(" BOOLEAN)", " BIT)");
            command = ((String)command).replace(" CLOB)", " NTEXT)");
            command = ((String)command).replace(" VARBINARY)", " IMAGE)");
            command = ((String)command).replace(" WITH RECURSIVE", " WITH");
            command = ((String)command).replace("(ASS0.OBJECT_ID)+'*+1'", " CAST(ASS0.OBJECT_ID+'*+1' AS VARCHAR)");
            command = ((String)command).replace("(ASS1.OBJECT_ID)+'*+'+(TEMP.DISTANCE+1)", " CAST(ASS1.OBJECT_ID+'*+'+(TEMP.DISTANCE+1) AS VARCHAR)");
            while (((String)command).indexOf("ROW_NUMBER()OVER()") > 0) {
                int pos = ((String)command).indexOf("ROW_NUMBER()OVER()");
                int posOrderBy1 = ((String)command).indexOf("ORDER BY", pos);
                int posOrderBy2 = ((String)command).indexOf(")", posOrderBy1);
                String orderBy = ((String)command).substring(posOrderBy1, posOrderBy2);
                command = ((String)command).substring(0, pos) + "ROW_NUMBER()OVER(" + orderBy + ")" + ((String)command).substring(pos + 18, posOrderBy1) + ((String)command).substring(posOrderBy2);
            }
        }
        return command;
    }

    public static List<String> getTableNames() throws ServiceException {
        Connection connS = DbSchemaUtils.getSchemaConnection();
        try {
            List<String> list = DbSchemaUtils.getTableNames(connS);
            return list;
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<String> getTableNames(Connection connS) throws ServiceException {
        TreeSet<String> tableNames = new TreeSet<String>();
        List<String> schema = DbSchemaUtils.getSchema(connS);
        for (String command : schema) {
            if (!command.startsWith(CREATE_TABLE_PREFIX)) continue;
            tableNames.add(command.substring(CREATE_TABLE_PREFIX.length(), command.indexOf("(", CREATE_TABLE_PREFIX.length())).trim());
        }
        return new ArrayList<String>(tableNames);
    }

    public static List<String> getViewNames(Connection connS) throws ServiceException {
        TreeSet<String> viewNames = new TreeSet<String>();
        List<String> schema = DbSchemaUtils.getSchema(connS);
        for (String command : schema) {
            if (!command.startsWith(CREATE_VIEW_PREFIX)) continue;
            viewNames.add(command.substring(CREATE_VIEW_PREFIX.length(), command.indexOf("(", CREATE_VIEW_PREFIX.length())).trim());
        }
        return new ArrayList<String>(viewNames);
    }

    public static List<String> getViewNames() throws ServiceException {
        Connection connS = DbSchemaUtils.getSchemaConnection();
        try {
            List<String> list = DbSchemaUtils.getViewNames(connS);
            return list;
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<String> getColumnNames(String dbObject, List<Integer> includeColumnTypes, List<Integer> excludeColumnTypes) throws ServiceException {
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = DbSchemaUtils.getSchemaConnection();
            String statement = "SELECT * FROM " + dbObject + " WHERE 1=0";
            PreparedStatement ps = conn.prepareStatement(statement);
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    boolean excludeColumn;
                    boolean includeColumn = includeColumnTypes == null || includeColumnTypes.isEmpty() || includeColumnTypes.contains(rsmd.getColumnType(i + 1));
                    boolean bl = excludeColumn = excludeColumnTypes != null && !excludeColumnTypes.isEmpty() && excludeColumnTypes.contains(rsmd.getColumnType(i + 1));
                    if (!includeColumn || excludeColumn) continue;
                    columnNames.add(rsmd.getColumnName(i + 1).toLowerCase());
                }
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            throw new ServiceException((Exception)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return columnNames;
    }

    public static List<String> getIndexNames(Connection connS) throws ServiceException {
        TreeSet<String> indexNames = new TreeSet<String>();
        List<String> schema = DbSchemaUtils.getSchema(connS);
        for (String command : schema) {
            if (!command.startsWith(CREATE_INDEX_PREFIX)) continue;
            indexNames.add(command.substring(CREATE_INDEX_PREFIX.length(), command.indexOf(" ", CREATE_INDEX_PREFIX.length() + 1)).trim());
        }
        return new ArrayList<String>(indexNames);
    }

    public static List<String> getIndexNames() throws ServiceException {
        Connection connS = DbSchemaUtils.getSchemaConnection();
        try {
            List<String> list = DbSchemaUtils.getIndexNames(connS);
            return list;
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<String> getSequenceNames(Connection connS) throws ServiceException {
        TreeSet<String> sequenceNames = new TreeSet<String>();
        List<String> schema = DbSchemaUtils.getSchema(connS);
        for (String command : schema) {
            if (!command.startsWith(CREATE_SEQUENCE_PREFIX)) continue;
            sequenceNames.add(command.substring(CREATE_SEQUENCE_PREFIX.length(), command.indexOf(" ", CREATE_SEQUENCE_PREFIX.length() + 1)).trim());
        }
        return new ArrayList<String>(sequenceNames);
    }

    public static List<String> getSequenceNames() throws ServiceException {
        Connection connS = DbSchemaUtils.getSchemaConnection();
        try {
            List<String> list = DbSchemaUtils.getSequenceNames(connS);
            return list;
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> validateTables(Connection connT, boolean fix) throws ServiceException {
        Connection connS = null;
        ArrayList<String> report = new ArrayList<String>();
        try {
            connS = DbSchemaUtils.getSchemaConnection();
            List<String> schema = DbSchemaUtils.getSchema(connS);
            List<String> tableNames = DbSchemaUtils.getTableNames(connS);
            for (String tableName : tableNames) {
                Object statement = "SELECT * FROM " + tableName + " WHERE 1=0";
                PreparedStatement psT = null;
                FastResultSet rsT = null;
                boolean exists = false;
                try {
                    psT = connT.prepareStatement((String)statement);
                    rsT = new FastResultSet(psT.executeQuery());
                    exists = true;
                }
                catch (Exception e) {
                    if (!fix) {
                        report.add("ERROR: Missing table=" + tableName + " (message=" + e + ")");
                    }
                }
                finally {
                    try {
                        rsT.close();
                    }
                    catch (Exception e) {}
                    try {
                        psT.close();
                    }
                    catch (Exception e) {}
                }
                if (exists) continue;
                statement = DbSchemaUtils.getObjectDefinition(CREATE_TABLE_PREFIX, tableName, schema, connT.getMetaData().getDatabaseProductName(), false);
                if (fix) {
                    Statement psFix = null;
                    try {
                        report.add("SQL: " + (String)statement);
                        psFix = connT.prepareStatement((String)statement);
                        psFix.executeUpdate();
                        continue;
                    }
                    catch (Exception e0) {
                        report.add("ERROR: Creation of table " + tableName + " failed (message=" + e0 + ")");
                        continue;
                    }
                    finally {
                        try {
                            psFix.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                report.add("FIX: " + (String)statement);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> validateTableColumns(Connection connT, boolean fix) throws ServiceException {
        Connection connS = null;
        ArrayList<String> report = new ArrayList<String>();
        try {
            connS = DbSchemaUtils.getSchemaConnection();
            List<String> schema = DbSchemaUtils.getSchema(connS);
            List<String> tableNames = DbSchemaUtils.getTableNames(connS);
            for (String tableName : tableNames) {
                Object statement = "SELECT * FROM " + tableName + " WHERE 1=0";
                PreparedStatement psT = null;
                FastResultSet rsT = null;
                try {
                    psT = connT.prepareStatement((String)statement);
                    rsT = new FastResultSet(psT.executeQuery());
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        rsT.close();
                    }
                    catch (Exception exception) {}
                    try {
                        psT.close();
                    }
                    catch (Exception exception) {}
                }
                PreparedStatement psS = connS.prepareStatement((String)statement);
                FastResultSet rsS = null;
                try {
                    rsS = new FastResultSet(psS.executeQuery());
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        rsS.close();
                    }
                    catch (Exception exception) {}
                    try {
                        psS.close();
                    }
                    catch (Exception exception) {}
                }
                if (rsT == null || rsS == null) continue;
                if (!rsT.getColumnNames().containsAll(rsS.getColumnNames())) {
                    ArrayList missingColumns = new ArrayList(rsS.getColumnNames());
                    missingColumns.removeAll(rsT.getColumnNames());
                    statement = DbSchemaUtils.getObjectDefinition(CREATE_TABLE_PREFIX, tableName, schema, connT.getMetaData().getDatabaseProductName(), false);
                    for (String columnName : missingColumns) {
                        int pos1;
                        if (!fix) {
                            report.add("ERROR: missing column in table=" + tableName + ", column=" + columnName);
                        }
                        if ((pos1 = ((String)statement).indexOf("(" + columnName.toUpperCase() + " ")) < 0) {
                            pos1 = ((String)statement).indexOf("," + columnName.toUpperCase() + " ");
                        }
                        if (pos1 < 0) {
                            pos1 = ((String)statement).indexOf("(\"" + columnName.toUpperCase() + "\" ");
                        }
                        if (pos1 < 0) {
                            pos1 = ((String)statement).indexOf(",\"" + columnName.toUpperCase() + "\" ");
                        }
                        if (pos1 <= 0) continue;
                        int pos2 = ((String)statement).indexOf(",", pos1 + 1);
                        if (pos2 < 0) {
                            pos2 = ((String)statement).length() - 1;
                        } else if (Character.isDigit(((String)statement).charAt(pos2 + 1)) && (pos2 = ((String)statement).indexOf(",", pos2 + 1)) < 0) {
                            pos2 = ((String)statement).length();
                        }
                        if (pos2 <= 0) continue;
                        Statement psFix = null;
                        String addColumnStatement = "ALTER TABLE " + tableName + " ADD " + ((String)statement).substring(pos1 + 1, pos2);
                        if (fix) {
                            try {
                                report.add("SQL: " + addColumnStatement);
                                psFix = connT.prepareStatement(addColumnStatement);
                                psFix.executeUpdate();
                                continue;
                            }
                            catch (Exception e0) {
                                report.add("ERROR: Adding column failed (message=" + e0 + ")");
                                continue;
                            }
                            finally {
                                if (psFix == null) continue;
                                try {
                                    psFix.close();
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                        }
                        report.add("FIX: " + addColumnStatement);
                    }
                } else {
                    report.add("OK: Table=" + tableName);
                }
                if (rsS.getColumnNames().containsAll(rsT.getColumnNames())) continue;
                ArrayList extraColumns = new ArrayList(rsT.getColumnNames());
                extraColumns.removeAll(rsS.getColumnNames());
                report.add("WARN: Extra or custom columns in table=" + tableName + ", columns=" + extraColumns);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> validateViews(Connection connT, boolean fix) throws ServiceException {
        Connection connS = null;
        ArrayList<String> report = new ArrayList<String>();
        try {
            connS = DbSchemaUtils.getSchemaConnection();
            List<String> schema = DbSchemaUtils.getSchema(connS);
            List<String> viewNames = DbSchemaUtils.getViewNames(connS);
            for (String viewName : viewNames) {
                Object statement = "SELECT * FROM " + viewName + " WHERE 1=0";
                PreparedStatement psT = null;
                FastResultSet rsT = null;
                boolean exists = false;
                try {
                    psT = connT.prepareStatement((String)statement);
                    rsT = new FastResultSet(psT.executeQuery());
                    exists = true;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        rsT.close();
                    }
                    catch (Exception exception) {}
                    try {
                        psT.close();
                    }
                    catch (Exception exception) {}
                }
                statement = DbSchemaUtils.getObjectDefinition(CREATE_VIEW_PREFIX, viewName, schema, connT.getMetaData().getDatabaseProductName(), exists);
                if (fix) {
                    Statement psFix = null;
                    try {
                        report.add("SQL: " + (String)statement);
                        psFix = connT.prepareStatement((String)statement);
                        psFix.executeUpdate();
                        continue;
                    }
                    catch (Exception e) {
                        if (OPTIONAL_DBOBJECTS.contains(viewName)) continue;
                        report.add("ERROR: Create/Replace of view " + viewName + " failed (message=" + e + ")");
                        continue;
                    }
                    finally {
                        try {
                            psFix.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                if (exists) {
                    report.add("OK: View " + viewName);
                    continue;
                }
                if (OPTIONAL_DBOBJECTS.contains(viewName)) continue;
                report.add("FIX: " + (String)statement);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
        return report;
    }

    protected static List<Path> getIdentityPatterns(ModelElement_1_0 classDef, Path segmentIdentity, String referenceName) throws ServiceException {
        Model_1_0 model = classDef.getModel();
        ArrayList<Path> xriPatterns = new ArrayList<Path>();
        if (model.getFeatureDef(classDef, referenceName, false) != null) {
            Path identityPattern = model.getIdentityPattern(classDef);
            if (identityPattern == null) {
                ModelElement_1_0 compositeReference = model.getCompositeReference(classDef);
                ArrayList<String> suffix = new ArrayList<String>();
                while (compositeReference != null) {
                    suffix.add(compositeReference.getName());
                    suffix.add(":*");
                    classDef = model.getElement((Object)model.getElement((Object)compositeReference.getExposedEnd()).getType());
                    compositeReference = model.getCompositeReference(classDef);
                }
                for (Object subtype : classDef.objGetList("subtype")) {
                    ModelElement_1_0 subClassDef = model.getElement(subtype);
                    identityPattern = model.getIdentityPattern(subClassDef);
                    if (identityPattern == null) continue;
                    for (String component : suffix) {
                        identityPattern = identityPattern.getChild(component);
                    }
                    if (!segmentIdentity.isLike(identityPattern.getPrefix(5)) || identityPattern.size() >= 15) continue;
                    xriPatterns.add(segmentIdentity.getDescendant(identityPattern.getSuffix(5)).getDescendant(new String[]{referenceName, ":*"}));
                }
            } else if (identityPattern != null && segmentIdentity.isLike(identityPattern.getPrefix(5))) {
                xriPatterns.add(segmentIdentity.getDescendant(identityPattern.getSuffix(5)).getDescendant(new String[]{referenceName, ":*"}));
            }
        }
        return xriPatterns;
    }

    protected static Set<File> listFilesRecursively(File dir) {
        TreeSet<File> files = new TreeSet<File>();
        if (dir.isDirectory() && !HIDDEN_FILES.contains(dir.getName())) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    files.addAll(DbSchemaUtils.listFilesRecursively(f));
                    continue;
                }
                files.add(f);
            }
        }
        return files;
    }

    public static List<String> migrateMediaToFS(String providerName, PersistenceManager pm, Connection connT, boolean validateOnly) throws ServiceException {
        ArrayList<String> report = new ArrayList<String>();
        if (System.getProperty("org.opencrx.mediadir." + providerName) != null) {
            File mediadir = new File(System.getProperty("org.opencrx.mediadir." + providerName));
            Set<File> existingMediaFiles = DbSchemaUtils.listFilesRecursively(mediadir);
            Database_2 db = DbSchemaUtils.getDatabasePlugIns()[0];
            try {
                PreparedStatement psT = connT.prepareStatement("SELECT object_id FROM OOCKE1_MEDIA ORDER BY object_id");
                ResultSet rsT = psT.executeQuery();
                int count = 0;
                int countEmptyMedia = 0;
                while (rsT.next()) {
                    String objectId = rsT.getString(1);
                    Path mediaIdentity = db.getReference(connT, (Object)objectId).getChild(objectId.substring(objectId.lastIndexOf("/") + 1));
                    boolean unsupportedMediaIdentity = false;
                    for (int i = 1; i < mediaIdentity.size(); ++i) {
                        if (mediaIdentity.get(i).indexOf(":") < 0) continue;
                        unsupportedMediaIdentity = true;
                        break;
                    }
                    if (unsupportedMediaIdentity) {
                        report.add("ERROR: Unsupported media identity " + mediaIdentity.toXRI() + ". Qualifiers must not contain [:]");
                        SysLog.error((String)("ERROR: Unsupported media identity " + mediaIdentity.toXRI() + ". Qualifiers must not contain [:]"));
                    } else {
                        Media media;
                        File contentDir = Media_2.toContentDir((File)mediadir, (Path)mediaIdentity);
                        File contentFile = new File(contentDir, mediaIdentity.getLastSegment().toString());
                        if (validateOnly) {
                            if (!existingMediaFiles.contains(contentFile)) {
                                media = (Media)pm.getObjectById((Object)mediaIdentity);
                                BinaryLargeObject mediaContent = media.getContent();
                                long length = 0L;
                                try {
                                    length = mediaContent == null ? 0L : mediaContent.getLength();
                                }
                                catch (Exception e) {
                                    throw new ServiceException(e);
                                }
                                if (length > 0L) {
                                    report.add("ERROR: Missing media file for " + media.refGetPath().toXRI() + ". Expected location " + contentFile);
                                    SysLog.error((String)("ERROR: Missing media file for " + media.refGetPath().toXRI() + ". Expected location " + contentFile));
                                } else {
                                    ++countEmptyMedia;
                                }
                            }
                        } else if (!contentFile.exists()) {
                            media = (Media)pm.getObjectById((Object)mediaIdentity);
                            media.getContent();
                        }
                    }
                    if (++count % 100 != 0) continue;
                    pm.evictAll();
                    if (validateOnly) {
                        System.out.println(new Date() + ": Validated " + count + " media objects");
                        continue;
                    }
                    System.out.println(new Date() + ": Migrated " + count + " media objects");
                }
                rsT.close();
                psT.close();
                connT.close();
                if (validateOnly) {
                    report.add("OK: Validated " + count + " media objects where " + countEmptyMedia + " are empty");
                    System.out.println(new Date() + ": Validated " + count + " media objects where " + countEmptyMedia + " are empty");
                } else {
                    report.add("OK: Migrated " + count + " media objects");
                    System.out.println(new Date() + ": Migrated " + count + " media objects");
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                report.add("ERROR: Exception. Message is " + e.getMessage());
            }
        }
        return report;
    }

    public static List<String> migrateMediaToDB(String providerName, PersistenceManager pm) throws ServiceException {
        ArrayList<String> report = new ArrayList<String>();
        if (System.getProperty("org.opencrx.mediadir." + providerName) != null) {
            File mediadir = new File(System.getProperty("org.opencrx.mediadir." + providerName));
            Set<File> mediaFiles = DbSchemaUtils.listFilesRecursively(mediadir);
            int count = 0;
            for (File mediaFile : mediaFiles) {
                ArrayList<String> components = new ArrayList<String>();
                File contentFile = mediaFile;
                while (!contentFile.equals(mediadir)) {
                    components.add(0, contentFile.getName());
                    contentFile = contentFile.getParentFile();
                }
                if (components.size() > 0) {
                    components.set(0, ((String)components.get(0)).replace("_", ":"));
                }
                Path mediaIdentity = new Path(components.toArray(new String[components.size()]));
                Media media = null;
                try {
                    media = (Media)pm.getObjectById((Object)mediaIdentity);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
                if (media == null) {
                    report.add("ERROR: Missing media " + mediaIdentity.toXRI() + " for file " + mediaFile);
                    continue;
                }
                try {
                    if (media.getContent() == null || mediaFile.lastModified() > media.getModifiedAt().getTime()) {
                        pm.currentTransaction().begin();
                        media.setContent(BinaryLargeObjects.valueOf((File)mediaFile));
                        pm.currentTransaction().commit();
                        report.add("OK: Migrated " + mediaIdentity.toXRI());
                    } else {
                        System.out.println(new Date() + ": Media up-to-date for file " + mediaFile + ".");
                    }
                    if (++count % 100 != 0) continue;
                    System.out.println(new Date() + ": Migrated " + count + " media files to database");
                    pm.evictAll();
                }
                catch (Exception e) {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    new ServiceException(e).log();
                    report.add("ERROR: Error migrating media. Message is " + e.getMessage());
                }
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> validateIndexes(Connection connT, boolean fix) throws ServiceException {
        Connection connS = null;
        ArrayList<String> report = new ArrayList<String>();
        try {
            connS = DbSchemaUtils.getSchemaConnection();
            List<String> schema = DbSchemaUtils.getSchema(connS);
            List<String> indexNames = DbSchemaUtils.getIndexNames(connS);
            String databaseProductName = connT.getMetaData().getDatabaseProductName();
            for (String indexName : indexNames) {
                String statement = DbSchemaUtils.getObjectDefinition(CREATE_INDEX_PREFIX, indexName, schema, connT.getMetaData().getDatabaseProductName(), false);
                Statement psT = null;
                try {
                    if (databaseProductName.indexOf("Oracle") >= 0 && indexName.length() > 30) {
                        statement = statement.replace(indexName, indexName.substring(0, 30));
                    }
                    psT = connT.prepareStatement(statement);
                    psT.executeUpdate();
                    if (fix) {
                        report.add("SQL: " + statement);
                        continue;
                    }
                    report.add("OK: Index " + indexName);
                }
                catch (SQLException e0) {
                    boolean alreadyExists;
                    String message = e0.getMessage();
                    int errorCode = e0.getErrorCode();
                    boolean bl = alreadyExists = message.indexOf("already exists") >= 0 || message.indexOf("Duplicate key name") >= 0 || message.indexOf("ORA-01408") >= 0 || message.indexOf("ORA-00955") >= 0 || errorCode == 0 || errorCode == 1913;
                    if (alreadyExists) {
                        if (fix) continue;
                        report.add("OK: Index " + indexName);
                        continue;
                    }
                    report.add("ERROR: " + statement + " (message=" + e0.getMessage() + "; errorCode=" + errorCode + ")");
                }
                finally {
                    try {
                        psT.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> validateSequences(Connection connT, boolean fix) throws ServiceException {
        Connection connS = null;
        ArrayList<String> report = new ArrayList<String>();
        try {
            connS = DbSchemaUtils.getSchemaConnection();
            List<String> schema = DbSchemaUtils.getSchema(connS);
            List<String> sequenceNames = DbSchemaUtils.getSequenceNames(connS);
            String databaseProductName = connT.getMetaData().getDatabaseProductName();
            for (String sequenceName : sequenceNames) {
                Object statement = DbSchemaUtils.getObjectDefinition(CREATE_SEQUENCE_PREFIX, sequenceName, schema, databaseProductName, false);
                Statement psT = null;
                if (databaseProductName.indexOf("MySQL") >= 0) {
                    statement = "SELECT * FROM " + sequenceName + " WHERE 1=0";
                    try {
                        psT = connT.prepareStatement((String)statement);
                        psT.executeQuery();
                        psT.close();
                        report.add("OK: Sequence " + sequenceName);
                        continue;
                    }
                    catch (Exception e) {
                        psT.close();
                        statement = "CREATE TABLE " + sequenceName + "(nextval int)";
                        report.add("SQL: " + (String)statement);
                        psT = connT.prepareStatement((String)statement);
                        psT.executeUpdate();
                        psT.close();
                        statement = "INSERT INTO " + sequenceName + " (nextval) VALUES (1000000)";
                        report.add("SQL: " + (String)statement);
                        psT = connT.prepareStatement((String)statement);
                        psT.executeUpdate();
                        psT.close();
                        continue;
                    }
                    finally {
                        try {
                            psT.close();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                }
                try {
                    if (databaseProductName.indexOf("Oracle") >= 0) {
                        statement = (String)statement + " NOCYCLE CACHE 100 NOORDER";
                    }
                    psT = connT.prepareStatement((String)statement);
                    psT.executeUpdate();
                    if (fix) {
                        report.add("SQL: " + (String)statement);
                        continue;
                    }
                    report.add("OK: Sequence " + sequenceName);
                }
                catch (SQLException e0) {
                    boolean alreadyExists;
                    String message = e0.getMessage();
                    int errorCode = e0.getErrorCode();
                    boolean bl = alreadyExists = message.indexOf("already exists") >= 0 || message.indexOf("Duplicate key name") >= 0 || message.indexOf("ORA-01408") >= 0 || message.indexOf("ORA-00955") >= 0 || message.indexOf("SQLSTATE=42710") >= 0 || message.indexOf("errorCode=2714") >= 0 || errorCode == 99999 || errorCode == 2714;
                    if (alreadyExists) {
                        if (fix) continue;
                        report.add("OK: Sequence " + sequenceName);
                        continue;
                    }
                    report.add("ERROR: " + (String)statement + " (message=" + e0.getMessage() + "; errorCode=" + errorCode + ")");
                }
                finally {
                    try {
                        psT.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                connS.close();
            }
            catch (Exception exception) {}
        }
        return report;
    }

    protected static Database_2[] getDatabasePlugIns() throws ServiceException {
        if (databasePlugIns == null) {
            databasePlugIns = Utils.getDatabasePlugIns();
        }
        return databasePlugIns;
    }

    static class MigrationDefinition {
        private final String name;
        private final String testForVersionStatement;
        private final List<String> migrationStatements;

        public MigrationDefinition(String name, String testForReleaseStatement, List<String> migrateStatements) {
            this.name = name;
            this.testForVersionStatement = testForReleaseStatement;
            this.migrationStatements = migrateStatements;
        }

        public String getName() {
            return this.name;
        }

        public String getTestForVersionStatement() {
            return this.testForVersionStatement;
        }

        public List<String> getMigrationStatements() {
            return this.migrationStatements;
        }
    }
}

