/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.opencrx.application.uses.com.auxilii.msgparser.Message;
import org.opencrx.application.uses.com.auxilii.msgparser.MsgParser;
import org.opencrx.application.uses.com.auxilii.msgparser.RecipientEntry;
import org.opencrx.application.uses.com.auxilii.msgparser.attachment.Attachment;
import org.opencrx.application.uses.com.auxilii.msgparser.attachment.FileAttachment;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.cci2.EMailAddressQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.text.RTFToText;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.io.StringInputStream;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.text.conversion.Base64;
import org.w3c.cci2.AnyTypePredicate;

public abstract class MimeUtils {
    public static final String[] STANDARD_HEADER_FIELDS = new String[]{"Return-Path", "From", "To", "Cc", "Bcc", "Subject", "Date", "Message-ID", "MIME-Version", "Content-Type", "In-Reply-To"};

    public static String getHeadersAsRFC822(Part part, String[] fields) throws MessagingException {
        if (fields == null) {
            ArrayList<String> headerNames = new ArrayList<String>();
            Enumeration allHeaders = part.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                headerNames.add(((Header)allHeaders.nextElement()).getName());
            }
            return MimeUtils.getHeadersAsRFC822(part, headerNames.toArray(new String[headerNames.size()]));
        }
        StringBuilder header = new StringBuilder();
        for (String field : fields) {
            String[] values = part.getHeader(field);
            if (values == null) continue;
            for (String value : values) {
                header.append(field).append(": ").append(value).append("\r\n");
            }
        }
        return header.toString();
    }

    public static boolean isAllAscii(String s) {
        int nonAscii = 0;
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            boolean isNonAscii;
            char c = s.charAt(i);
            boolean bl = isNonAscii = c >= '\u007f' || c < ' ' && c != '\r' && c != '\n' && c != '\t';
            if (!isNonAscii) continue;
            ++nonAscii;
        }
        return nonAscii == 0;
    }

    private static String mapX500ToSMTPAddress(String x500Address, Segment accountSegment, Map<String, String> addressMap) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        if (accountSegment != null) {
            AccountAddress[] addresses;
            AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
            EMailAddressQuery emailAddressQuery = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            emailAddressQuery.emailType().equalTo((Object)Addresses.EMailType.X500.getValue());
            emailAddressQuery.thereExistsEmailAddress().like((Object)("(?i)" + x500Address));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)emailAddressQuery));
            List accounts = accountSegment.getAccount(accountQuery);
            if (accounts.size() == 1 && (addresses = Accounts.getInstance().getMainAddresses((Account)accounts.iterator().next()))[0] != null && ((EMailAddress)addresses[0]).getEmailType() == Addresses.EMailType.SMTP.getValue()) {
                return ((EMailAddress)addresses[0]).getEmailAddress();
            }
        }
        return addressMap.containsKey(x500Address) ? addressMap.get(x500Address) : null;
    }

    private static boolean smtpAddressIsValid(Segment accountSegment, String smtpAddress, boolean validate) throws ServiceException {
        if (smtpAddress == null) {
            return false;
        }
        if (validate) {
            if (accountSegment == null) {
                return false;
            }
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
            List emailAddresses = Accounts.getInstance().lookupEmailAddress(pm, accountSegment.refGetPath().get(2), accountSegment.refGetPath().get(4), smtpAddress);
            return !emailAddresses.isEmpty();
        }
        return true;
    }

    public static MimeMessage mapMsgToMime(InputStream msgStream, Segment accountSegment, Map<String, String> addressMap, boolean validateAddresses, List<String> errors) {
        MimeMessageImpl mimeMessage = new MimeMessageImpl();
        MimeMultipart mimeMultipart = new MimeMultipart();
        try {
            Message msg = new MsgParser().parseMsg(msgStream, true);
            if (msg.getDate() != null) {
                mimeMessage.setSentDate(msg.getDate());
            }
            try {
                String emailAddress = msg.getFromEmail();
                Object smtpAddress = null;
                smtpAddress = emailAddress.startsWith("/") ? MimeUtils.mapX500ToSMTPAddress(emailAddress, accountSegment, addressMap) : emailAddress;
                if (MimeUtils.smtpAddressIsValid(accountSegment, (String)smtpAddress, validateAddresses)) {
                    mimeMessage.setFrom((Address)new InternetAddress((String)smtpAddress, msg.getFromName()));
                } else {
                    errors.add(emailAddress);
                }
            }
            catch (Exception emailAddress) {
                // empty catch block
            }
            mimeMessage.setSubject(msg.getSubject(), "UTF-8");
            for (RecipientEntry recipient : msg.getRecipients()) {
                String emailAddress = recipient.getToEmail();
                String smtpAddress = null;
                smtpAddress = emailAddress.startsWith("/") ? MimeUtils.mapX500ToSMTPAddress(emailAddress, accountSegment, addressMap) : emailAddress;
                if (MimeUtils.smtpAddressIsValid(accountSegment, smtpAddress, validateAddresses)) {
                    mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(smtpAddress, recipient.getToName()));
                    continue;
                }
                errors.add(emailAddress);
            }
            if (msg.getMessageId() != null) {
                mimeMessage.addHeader("Message-ID", msg.getMessageId());
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (msg.getBodyText() != null) {
                messageBodyPart.setText(msg.getBodyText());
            } else if (msg.getBodyRTF() != null) {
                messageBodyPart.setText(RTFToText.toTextAsString((InputStream)new StringInputStream(msg.getBodyRTF())));
            } else {
                messageBodyPart.setText("");
            }
            mimeMultipart.addBodyPart((BodyPart)messageBodyPart);
            for (Attachment attachment : msg.getAttachments()) {
                if (!(attachment instanceof FileAttachment)) continue;
                FileAttachment fileAttachment = (FileAttachment)attachment;
                InternetHeaders headers = new InternetHeaders();
                headers.addHeader("Content-Type", (fileAttachment.getMimeTag() == null ? "application/octet-stream" : fileAttachment.getMimeTag()) + "; name=\"" + MimeUtility.encodeText((String)fileAttachment.getFilename()) + "\"");
                headers.addHeader("Content-Disposition", "attachment");
                headers.addHeader("Content-Transfer-Encoding", "base64");
                MimeBodyPart messageBodyPart2 = new MimeBodyPart(headers, Base64.encode((byte[])fileAttachment.getData(), (int)0, (int)((int)fileAttachment.getSize())).getBytes("US-ASCII"));
                mimeMultipart.addBodyPart((BodyPart)messageBodyPart2);
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            e0.log();
            errors.add(e0.getMessage());
        }
        return errors.isEmpty() ? mimeMessage : null;
    }

    public static String[] parseContentType(String contentType) {
        String[] result = new String[2];
        contentType = contentType.replace("\t", " ");
        contentType = contentType.replace("\r\n", "");
        Pattern pattern = Pattern.compile("([0-9a-zA-Z/\\+\\-\\.]+)(?:;(?:[ \\r\\n\\t]*)name(?:[^\\=]*)=[\\\"]?([.[^\\\"]]*)[\\\"]?)?");
        Matcher matcher = pattern.matcher(contentType);
        if (matcher.find()) {
            result[0] = matcher.group(1);
            try {
                String name = matcher.group(2);
                result[1] = name == null ? null : MimeUtility.decodeText((String)name);
            }
            catch (Exception e) {
                result[1] = matcher.group(2);
            }
        } else {
            result[0] = contentType;
            result[1] = null;
        }
        return result;
    }

    public static class MimeMessageImpl
    extends MimeMessage {
        protected long uid;
        protected int messageNumber;

        public MimeMessageImpl() {
            super((Session)null);
        }

        public MimeMessageImpl(InputStream is) throws MessagingException {
            super(null, is);
        }

        public MimeMessageImpl(MimeMessage message) throws MessagingException {
            super(message);
        }

        public long getUid() {
            return this.uid;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public int getMessageNumber() {
            return this.messageNumber;
        }

        public void setMessageNumber(int messageNumber) {
            this.messageNumber = messageNumber;
        }

        public String getHeader(String name, String delimiter) throws MessagingException {
            String h = this.headers.getHeader(name, delimiter);
            if (h != null) {
                return h.replace('\r', ' ');
            }
            return h;
        }
    }
}

