/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;

public class ScriptUtils {
    private static final List<String> INVALID_WORDS = Arrays.asList("commit(", "commit ", "begin(", "begin ", "getPersistenceManagerFactory", "System.", "System ", "Runtime.", "Runtime ", "InitialContext");
    protected static final ThreadLocal<Map<String, Class<?>>> compiledScripts = new ThreadLocal<Map<String, Class<?>>>(){

        @Override
        protected synchronized Map<String, Class<?>> initialValue() {
            return new IdentityHashMap();
        }
    };

    public static Class<?> getClass(String script) throws ServiceException {
        try {
            if (!((String)script).endsWith("\n")) {
                script = (String)script + "\n";
            }
            for (String invalidWord : INVALID_WORDS) {
                int pos = ((String)script).indexOf(invalidWord);
                while (pos >= 0) {
                    if (pos > 0 && !Character.isLetter(((String)script).charAt(pos - 1))) {
                        throw new ServiceException("DefaultDomain", -2, "Script contains invalid words", new BasicException.Parameter[]{new BasicException.Parameter("script", script), new BasicException.Parameter("word", (Object)invalidWord), new BasicException.Parameter("invalid words", INVALID_WORDS)});
                    }
                    pos = ((String)script).indexOf(invalidWord, pos + 1);
                }
            }
            Map<String, Class<?>> classes = compiledScripts.get();
            Class clazz = classes.get(script);
            if (clazz == null) {
                clazz = new ClassBodyEvaluator((String)script).getClazz();
                classes.put((String)script, clazz);
            }
            return clazz;
        }
        catch (CompileException e) {
            throw new ServiceException((Exception)((Object)e), "DefaultDomain", -37, "Script compile error: " + e.getMessage(), new BasicException.Parameter[]{new BasicException.Parameter("script", script)});
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

