/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils.rtf;

import java.awt.Font;
import org.opencrx.kernel.utils.rtf.RtfUtil;
import org.opencrx.kernel.utils.rtf.Text;

public class TextPart
implements Text {
    public static final int FORMAT_NORMAL = 0;
    public static final int FORMAT_BOLD = 1;
    public static final int FORMAT_ITALIC = 2;
    public static final int FORMAT_UNDERLINE = 4;
    public static final int FORMAT_CAPITALS = 8;
    public static final int FORMAT_OUTLINE = 16;
    public static final int FORMAT_SHADOW = 32;
    public static final int ANIMTEXT_NO = 0;
    public static final int ANIMTEXT_LASVEGAS_LIGHTS = 1;
    public static final int ANIMTEXT_BLINKING_BACKGROUND = 2;
    public static final int ANIMTEXT_SPARKLE_TEXT = 3;
    public static final int ANIMTEXT_MARCHING_BLACK_ANTS = 4;
    public static final int ANIMTEXT_MARCHING_RED_ANTS = 5;
    public static final int ANIMTEXT_SHIMMER = 6;
    public static final char SIGN_TAB = '\t';
    public static final TextPart TABULATOR = new TextPart("\\tab", true);
    public static final TextPart NEWLINE = new TextPart("\\line", true);
    public static final TextPart SIGN_HARDSPACE = new TextPart("\\~", true);
    public static final TextPart SIGN_NON_REQUIRED_HYPHEN = new TextPart("\\-", true);
    public static final TextPart SIGN_NO_BREAKING_HYPHEN = new TextPart("\\_", true);
    private boolean rawrtf = false;
    private String content;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean capitals = false;
    private boolean outline = false;
    private boolean shadow = false;
    private int animtext = 0;
    private int fontsize = 0;

    public TextPart(String text) {
        this.content = text;
    }

    protected TextPart(String rawtext, boolean raw) {
        if (raw) {
            this.content = rawtext;
            this.rawrtf = true;
        } else {
            this.content = rawtext;
        }
    }

    public TextPart(int format, String text) {
        this(text);
        if ((format & 1) == 1) {
            this.setBold(true);
        }
        if ((format & 2) == 2) {
            this.setItalic(true);
        }
        if ((format & 4) == 4) {
            this.setUnderline(true);
        }
        if ((format & 8) == 8) {
            this.setCapitals(true);
        }
        if ((format & 0x10) == 16) {
            this.setOutline(true);
        }
        if ((format & 0x20) == 32) {
            this.setShadow(true);
        }
    }

    public TextPart(int format, int fontsize, Font font, String text) {
        this(format, text);
        this.fontsize = fontsize;
    }

    public void setItalic(boolean value) {
        this.italic = value;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setBold(boolean value) {
        this.bold = value;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setUnderline(boolean value) {
        this.underline = value;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setCapitals(boolean value) {
        this.capitals = value;
    }

    public boolean isCapitals() {
        return this.capitals;
    }

    public void setOutline(boolean value) {
        this.outline = value;
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setShadow(boolean value) {
        this.shadow = value;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setAnimtext(int animtext) {
        this.animtext = animtext;
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public void setFontsize(int size) {
        this.fontsize = size;
    }

    public int getAnimtext() {
        return this.animtext;
    }

    public void setContent(String value) {
        this.content = value;
    }

    @Override
    public String getRtfContent() {
        String format = (this.bold ? "\\b" : "") + (this.italic ? "\\i" : "") + (this.underline ? "\\ul" : "") + (this.capitals ? "\\caps" : "") + (this.outline ? "\\outl" : "") + (this.shadow ? "\\shad" : "") + (String)(this.animtext <= 0 ? "" : "\\animtext" + this.animtext) + (String)(this.fontsize <= 0 ? "" : "\\fs" + this.fontsize * 2);
        return "{" + (String)(format.length() <= 0 ? "" : format + " ") + (this.rawrtf ? this.content : RtfUtil.getRTFString(this.content)) + "}";
    }
}

