/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.adapter.AbstractServer;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public abstract class AbstractServlet
extends HttpServlet {
    private static final long serialVersionUID = -781335769801341481L;
    private static final String DEFAULT_PROVIDER_NAME = "CRX";
    private static final String COMMAND_PAUSE = "/pause";
    private static final String COMMAND_RESUME = "/resume";
    protected String providerName = null;
    protected AbstractServer server;
    protected boolean isStopped = true;

    public abstract AbstractServer newServer(PersistenceManagerFactory var1, String var2, String var3, int var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, Boolean var12, boolean var13, int var14);

    public abstract String getConfigurationId();

    public abstract int getPortNumber(String var1);

    public void init(ServletConfig config) throws ServletException {
        super.init();
        try {
            Utils.getModel();
            PersistenceManagerFactory pmf = Utils.getPersistenceManagerFactory();
            this.providerName = config.getInitParameter("provider");
            this.providerName = this.providerName == null ? DEFAULT_PROVIDER_NAME : (this.providerName.indexOf("/") > 0 ? this.providerName.substring(this.providerName.indexOf("/") + 1) : this.providerName);
            String bindAddress = config.getInitParameter("bindAddress");
            String portNumber = config.getInitParameter("port");
            String sslKeystoreFile = config.getInitParameter("sslKeystoreFile");
            String sslKeystoreType = config.getInitParameter("sslKeystoreType");
            String sslKeystorePass = config.getInitParameter("sslKeystorePass");
            String sslKeyPass = config.getInitParameter("sslKeyPass");
            String sslTruststoreFile = config.getInitParameter("sslTruststoreFile");
            String sslTruststorePass = config.getInitParameter("sslTruststorePass");
            String sslTruststoreType = config.getInitParameter("sslTruststoreType");
            Boolean sslNeedClientAuth = Boolean.valueOf(config.getInitParameter("sslNeedClientAuth"));
            String isDebug = config.getInitParameter("debug");
            String delayOnStartup = config.getInitParameter("delayOnStartup");
            PersistenceManager pm = pmf.getPersistenceManager("admin-Root", null);
            pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.admin1").getDescendant(new String[]{"provider", this.providerName, "segment", "Root"}));
            String autostartConnectors = System.getProperty("org.openmdx.catalina.core.ExtendedService.autostartConnectors");
            this.isStopped = autostartConnectors != null && Boolean.valueOf(autostartConnectors) == false;
            AbstractServer server = this.newServer(pmf, this.providerName, bindAddress, this.getPortNumber(portNumber), sslKeystoreFile, sslKeystoreType, sslKeystorePass, sslKeyPass, sslTruststoreFile, sslTruststorePass, sslTruststoreType, sslNeedClientAuth, isDebug == null ? false : Boolean.valueOf(isDebug), delayOnStartup == null ? 0 : Integer.valueOf(delayOnStartup));
            Thread serverThread = new Thread(server);
            serverThread.start();
            if (!this.isStopped) {
                server.resume();
            }
            this.server = server;
            try {
                pm.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            new ServiceException(e).log();
            throw new ServletException("Can not initialize server", (Throwable)e);
        }
    }

    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (COMMAND_PAUSE.equals(req.getPathInfo())) {
            this.server.pause();
            this.isStopped = true;
            System.out.println(new Date().toString() + ": " + this.getConfigurationId() + ": paused " + this.providerName);
        } else if (COMMAND_RESUME.equals(req.getPathInfo())) {
            this.server.resume();
            this.isStopped = false;
            System.out.println(new Date().toString() + ": " + this.getConfigurationId() + ": resumed " + this.providerName);
        }
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head>");
        out.println("<body>");
        out.println("<h2>openCRX IMAP Server " + this.providerName + "</h2>");
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><a href=\"" + req.getContextPath() + req.getServletPath() + (this.isStopped ? COMMAND_RESUME : COMMAND_PAUSE) + "\">" + (this.isStopped ? "Resume" : "Pause") + "</a></td><td />");
        out.println("</tr>");
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }
}

