/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.Arrays;
import org.opencrx.application.airsync.datatypes.ContactTXmlFormat;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.EmailTXmlFormat;
import org.opencrx.application.airsync.datatypes.EventTXmlFormat;
import org.opencrx.application.airsync.datatypes.IDataFormat;
import org.opencrx.application.airsync.datatypes.TaskTXmlFormat;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;

public class DataFormatFactory {
    public static IDataFormat getXmlFormat(DataType dataType) throws ServiceException {
        switch (dataType) {
            case Calendar: {
                return new EventTXmlFormat();
            }
            case Contacts: {
                return new ContactTXmlFormat();
            }
            case Tasks: {
                return new TaskTXmlFormat();
            }
            case Email: {
                return new EmailTXmlFormat();
            }
        }
        throw new ServiceException("DefaultDomain", -2, "Missing data decoder", new BasicException.Parameter[]{new BasicException.Parameter("actual", (Object)dataType), new BasicException.Parameter("supported", Arrays.asList(DataType.values()))});
    }
}

