/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opencrx.application.airsync.datatypes.AbstractXmlFormat;
import org.opencrx.application.airsync.datatypes.AttendeeStatus;
import org.opencrx.application.airsync.datatypes.AttendeeT;
import org.opencrx.application.airsync.datatypes.AttendeeType;
import org.opencrx.application.airsync.datatypes.BusyStatus;
import org.opencrx.application.airsync.datatypes.EventT;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.MeetingStatus;
import org.opencrx.application.airsync.datatypes.RecurrenceDayOfWeek;
import org.opencrx.application.airsync.datatypes.RecurrenceT;
import org.opencrx.application.airsync.datatypes.RecurrenceType;
import org.opencrx.application.airsync.datatypes.Sensitivity;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.kernel.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.format.DateTimeFormat;

public class EventTXmlFormat
extends AbstractXmlFormat {
    @Override
    public void format(Element eData, IData data, double protocolVersion) {
        DateTimeFormat utcf = this.getUtcFormat(false);
        EventT eventT = (EventT)data;
        this.createElement(eData, "Calendar:", "Timezone", eventT.getTimezone());
        if (eventT.getAllDayEvent() != null) {
            this.createElement(eData, "Calendar:", "AllDayEvent", eventT.getAllDayEvent() != false ? "1" : "0");
        } else {
            this.createElement(eData, "Calendar:", "AllDayEvent", "0");
        }
        String body = eventT.getBody();
        if (body != null) {
            this.createElement(eData, "Calendar:", "Body", Utils.normalizeNewLines(body).replace("\n", "\r\n"));
        }
        this.createElement(eData, "Calendar:", "BusyStatus", Integer.toString(eventT.getBusyStatus().getValue()));
        this.createElement(eData, "Calendar:", "Organizer_Name", eventT.getOrganizerName());
        this.createElement(eData, "Calendar:", "Organizer_Email", eventT.getOrganizerEmail());
        this.createElement(eData, "Calendar:", "DtStamp", utcf.format(eventT.getDtStamp() != null ? eventT.getDtStamp() : new Date()));
        if (eventT.getEndTime() != null) {
            this.createElement(eData, "Calendar:", "EndTime", utcf.format(eventT.getEndTime()));
        }
        this.createElement(eData, "Calendar:", "Location", eventT.getLocation());
        if (eventT.getReminder() != null) {
            this.createElement(eData, "Calendar:", "Reminder_MinsBefore", Integer.toString(eventT.getReminder()));
        }
        this.createElement(eData, "Calendar:", "Sensitivity", "0");
        this.createElement(eData, "Calendar:", "Subject", eventT.getSubject());
        if (eventT.getStartTime() != null) {
            this.createElement(eData, "Calendar:", "StartTime", utcf.format(eventT.getStartTime()));
        }
        this.createElement(eData, "Calendar:", "UID", eventT.getUID());
        if (eventT.getMeetingStatus() != null) {
            this.createElement(eData, "Calendar:", "MeetingStatus", Integer.toString(eventT.getMeetingStatus().getValue()));
        }
        if (eventT.getAttendees() != null && !eventT.getAttendees().isEmpty()) {
            Element eAttendees = DOMUtils.createElement(eData, "Calendar:", "Attendees");
            for (AttendeeT attendeeT : eventT.getAttendees()) {
                Element eAttendee = DOMUtils.createElement(eAttendees, "Calendar:", "Attendee");
                this.createElement(eAttendee, "Calendar:", "Attendee_Email", attendeeT.getEmail());
                this.createElement(eAttendee, "Calendar:", "Attendee_Name", attendeeT.getName());
                if (attendeeT.getAttendeeStatus() != null) {
                    this.createElement(eAttendee, "Calendar:", "Attendee_Status", Integer.toString(attendeeT.getAttendeeStatus().getValue()));
                }
                if (attendeeT.getAttendeeType() == null) continue;
                this.createElement(eAttendee, "Calendar:", "Attendee_Type", Integer.toString(attendeeT.getAttendeeType().getValue()));
            }
        }
        if (eventT.getCategories() != null && !eventT.getCategories().isEmpty()) {
            Element eCategories = DOMUtils.createElement(eData, "Calendar:", "Categories");
            for (String category : eventT.getCategories()) {
                this.createElement(eCategories, "Calendar:", "Category", category);
            }
        }
        if (eventT.getRecurrence() != null) {
            this.formatRecurrence(eData, eventT, protocolVersion);
        }
        if (eventT.getExceptions() != null && !eventT.getExceptions().isEmpty()) {
            this.formatExceptions(eData, eventT.getExceptions(), protocolVersion);
        }
    }

    private void formatExceptions(Element eData, List<EventT> exceptionsT, double protocolVersion) {
        DateTimeFormat utcf = this.getUtcFormat(false);
        Element es = DOMUtils.createElement(eData, "Calendar:", "Exceptions");
        for (EventT exceptionT : exceptionsT) {
            Element eException = DOMUtils.createElement(es, "Calendar:", "Exception");
            if (exceptionT.isDeletedException()) {
                DOMUtils.createElementAndText(eException, "Calendar:", "Deleted", "1");
                DOMUtils.createElementAndText(eException, "Calendar:", "MeetingStatus", Integer.toString(MeetingStatus.MEETING_IS_CANCELED.getValue()));
            } else {
                if (exceptionT.getExceptionStartTime() != null) {
                    DOMUtils.createElementAndText(eException, "Calendar:", "Exception_StartTime", utcf.format(exceptionT.getExceptionStartTime()));
                }
                this.createElement(eException, "Calendar:", "Subject", exceptionT.getSubject());
                if (exceptionT.getStartTime() != null) {
                    DOMUtils.createElementAndText(eException, "Calendar:", "StartTime", utcf.format(exceptionT.getStartTime()));
                }
                if (exceptionT.getEndTime() != null) {
                    DOMUtils.createElementAndText(eException, "Calendar:", "EndTime", utcf.format(exceptionT.getEndTime()));
                }
                this.createElement(eException, "Calendar:", "Body", exceptionT.getBody());
                this.createElement(eException, "Calendar:", "Location", exceptionT.getLocation());
                if (exceptionT.getCategories() != null && !exceptionT.getCategories().isEmpty()) {
                    Element eCategories = DOMUtils.createElement(eException, "Calendar:", "Categories");
                    for (String category : exceptionT.getCategories()) {
                        this.createElement(eCategories, "Calendar:", "Category", category);
                    }
                }
                if (exceptionT.getSensitivity() != null) {
                    this.createElement(eException, "Calendar:", "Sensitivity", Integer.toString(exceptionT.getSensitivity().getValue()));
                }
                if (exceptionT.getBusyStatus() != null) {
                    this.createElement(eException, "Calendar:", "BusyStatus", Integer.toString(exceptionT.getBusyStatus().getValue()));
                }
                this.createElement(eException, "Calendar:", "AllDayEvent", Boolean.TRUE.equals(exceptionT.getAllDayEvent()) ? "1" : "0");
                if (exceptionT.getReminder() != null) {
                    this.createElement(eException, "Calendar:", "Reminder", Integer.toString(exceptionT.getReminder()));
                }
                if (exceptionT.getMeetingStatus() != null) {
                    this.createElement(eException, "Calendar:", "MeetingStatus", Integer.toString(exceptionT.getMeetingStatus().getValue()));
                }
            }
            if (exceptionT.getDtStamp() == null) continue;
            DOMUtils.createElementAndText(eException, "Calendar:", "DtStamp", utcf.format(exceptionT.getDtStamp()));
        }
    }

    private void formatRecurrence(Element eData, EventT ev, double protocolVersion) {
        DateTimeFormat utcf = this.getUtcFormat(false);
        RecurrenceT recurrenceT = ev.getRecurrence();
        if (recurrenceT == null || recurrenceT.getType() == null) {
            return;
        }
        Element eRecurrence = DOMUtils.createElement(eData, "Calendar:", "Recurrence");
        DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_Type", Integer.toString(recurrenceT.getType().getValue()));
        if (recurrenceT.getOccurrences() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_Occurrences", Integer.toString(recurrenceT.getOccurrences()));
        }
        if (recurrenceT.getInterval() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_Interval", recurrenceT.getInterval().toString());
        }
        if (recurrenceT.getWeekOfMonth() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_WeekOfMonth", Integer.toString(recurrenceT.getWeekOfMonth()));
        }
        if (recurrenceT.getDayOfWeek() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_DayOfWeek", Integer.toString(RecurrenceDayOfWeek.asInt(recurrenceT.getDayOfWeek())));
        }
        if (recurrenceT.getMonthOfYear() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_MonthOfYear", Integer.toString(recurrenceT.getMonthOfYear()));
        }
        if (recurrenceT.getUntil() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Calendar:", "Recurrence_Until", utcf.format(recurrenceT.getUntil()));
        }
    }

    @Override
    public IData parse(Element eData) {
        Element eRecurrence;
        Element eExceptions;
        EventT eventT = new EventT();
        eventT.setTimezone(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Calendar:", "Timezone")));
        eventT.setOrganizerName(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Calendar:", "Organizer_Name")));
        eventT.setOrganizerEmail(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Calendar:", "Organizer_Email")));
        eventT.setUID(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Calendar:", "UID")));
        this.parseEvent(eventT, eData);
        Element eAttendees = DOMUtils.getUniqueElement(eData, "Calendar:", "Attendees");
        if (eAttendees != null) {
            ArrayList<AttendeeT> attendeesT = new ArrayList<AttendeeT>();
            int n = eAttendees.getChildNodes().getLength();
            for (int i = 0; i < n; ++i) {
                Node node = eAttendees.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                Element eAttendee = (Element)node;
                AttendeeT attendeeT = new AttendeeT();
                attendeeT.setEmail(this.parseDOMString(DOMUtils.getUniqueElement(eAttendee, "Calendar:", "Attendee_Email")));
                attendeeT.setName(this.parseDOMString(DOMUtils.getUniqueElement(eAttendee, "Calendar:", "Attendee_Name")));
                Element attendeeStatus = DOMUtils.getUniqueElement(eData, "Calendar:", "Attendee_Status");
                attendeeT.setAttendeeStatus(attendeeStatus == null ? null : AttendeeStatus.toAttendeeStatus(this.parseDOMNoNullInt(attendeeStatus)));
                attendeeT.setAttendeeType(AttendeeType.toAttendeeType(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eData, "Calendar:", "Attendee_Type"))));
                attendeesT.add(attendeeT);
            }
            eventT.setAttendees(attendeesT);
        }
        if ((eExceptions = DOMUtils.getUniqueElement(eData, "Calendar:", "Exceptions")) != null) {
            ArrayList<EventT> exceptions = new ArrayList<EventT>();
            int n = eExceptions.getChildNodes().getLength();
            for (int i = 0; i < n; ++i) {
                Node node = eExceptions.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                Element eException = (Element)node;
                EventT exceptionT = new EventT();
                this.parseEvent(exceptionT, eException);
                exceptionT.setDeleted(this.parseDOMInt2Boolean(DOMUtils.getUniqueElement(eException, "Calendar:", "Deleted")));
                exceptionT.setExceptionStartTime(this.parseDOMDate(DOMUtils.getUniqueElement(eException, "Calendar:", "Exception_StartTime")));
                exceptionT.setMeetingStatus(MeetingStatus.toMeetingStatus(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eException, "Calendar:", "MeetingStatus"))));
                exceptionT.setSensitivity(Sensitivity.toSensitivity(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eException, "Calendar:", "Sensitivity"))));
                exceptionT.setBusyStatus(BusyStatus.toBusyStatus(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eException, "Calendar:", "BusyStatus"))));
                exceptions.add(exceptionT);
            }
            eventT.setExceptions(exceptions);
        }
        if ((eRecurrence = DOMUtils.getUniqueElement(eData, "Calendar:", "Recurrence")) != null) {
            RecurrenceT recurrenceT = new RecurrenceT();
            recurrenceT.setUntil(this.parseDOMDate(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_Until")));
            recurrenceT.setWeekOfMonth(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_WeekOfMonth")));
            recurrenceT.setMonthOfYear(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_MonthOfYear")));
            recurrenceT.setOccurrences(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_Occurrences")));
            recurrenceT.setInterval(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_Interval")));
            Integer dayOfWeek = this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_DayOfWeek"));
            if (dayOfWeek != null) {
                recurrenceT.setDayOfWeek(RecurrenceDayOfWeek.fromInt(dayOfWeek));
            }
            recurrenceT.setType(RecurrenceType.toRecurrenceType(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eRecurrence, "Calendar:", "Recurrence_Type"))));
            eventT.setRecurrence(recurrenceT);
        }
        return eventT;
    }

    void parseEvent(EventT eventT, Element eEvent) {
        eventT.setBody(this.parseDOMString(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Body")));
        eventT.setAllDayEvent(this.parseDOMInt2Boolean(DOMUtils.getUniqueElement(eEvent, "Calendar:", "AllDayEvent")));
        eventT.setBusyStatus(BusyStatus.toBusyStatus(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eEvent, "Calendar:", "BusyStatus"))));
        eventT.setDtStamp(this.parseDOMDate(DOMUtils.getUniqueElement(eEvent, "Calendar:", "DtStamp")));
        eventT.setEndTime(this.parseDOMDate(DOMUtils.getUniqueElement(eEvent, "Calendar:", "EndTime")));
        eventT.setLocation(this.parseDOMString(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Location")));
        eventT.setReminder(this.parseDOMInt(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Reminder_MinsBefore")));
        eventT.setSensitivity(Sensitivity.toSensitivity(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Sensitivity"))));
        eventT.setSubject(this.parseDOMString(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Subject")));
        eventT.setStartTime(this.parseDOMDate(DOMUtils.getUniqueElement(eEvent, "Calendar:", "StartTime")));
        eventT.setMeetingStatus(MeetingStatus.toMeetingStatus(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eEvent, "Calendar:", "MeetingStatus"))));
        eventT.setCategories(this.parseDOMStringCollection(DOMUtils.getUniqueElement(eEvent, "Calendar:", "Categories"), "Calendar:", "Category"));
    }
}

