/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.Date;
import org.opencrx.application.airsync.datatypes.AbstractXmlFormat;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.NoteT;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.kernel.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.format.DateTimeFormat;

public class NoteTXmlFormat
extends AbstractXmlFormat {
    @Override
    public void format(Element eData, IData data, double protocolVersion) {
        DateTimeFormat eutcf = DateTimeFormat.EXTENDED_UTC_FORMAT;
        NoteT noteT = (NoteT)data;
        this.createElement(eData, "Note:", "Subject", noteT.getSubject());
        String body = noteT.getBody();
        if (body != null) {
            this.createElement(eData, "Note:", "Body", Utils.normalizeNewLines(body).replace("\n", "\r\n"));
        }
        this.createElement(eData, "Note:", "LastModifiedDate", eutcf.format(noteT.getLastModifiedDate() != null ? noteT.getLastModifiedDate() : new Date()));
        if (noteT.getCategories() != null && !noteT.getCategories().isEmpty()) {
            Element eCategories = DOMUtils.createElement(eData, "Note:", "Categories");
            for (String category : noteT.getCategories()) {
                this.createElement(eCategories, "Note:", "Category", category);
            }
        }
    }

    @Override
    public IData parse(Element eData) {
        NoteT noteT = new NoteT();
        noteT.setSubject(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Note:", "Subject")));
        noteT.setBody(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Note:", "Body")));
        noteT.setLastModifiedDate(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Note:", "LastModifiedDate")));
        noteT.setCategories(this.parseDOMStringCollection(DOMUtils.getUniqueElement(eData, "Note:", "Categories"), "Note:", "Category"));
        return noteT;
    }
}

