/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import org.opencrx.application.airsync.datatypes.AbstractXmlFormat;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.Importance;
import org.opencrx.application.airsync.datatypes.RecurrenceDayOfWeek;
import org.opencrx.application.airsync.datatypes.RecurrenceT;
import org.opencrx.application.airsync.datatypes.RecurrenceType;
import org.opencrx.application.airsync.datatypes.Sensitivity;
import org.opencrx.application.airsync.datatypes.TaskT;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.kernel.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.format.DateTimeFormat;

public class TaskTXmlFormat
extends AbstractXmlFormat {
    @Override
    public void format(Element eData, IData data, double protocolVersion) {
        DateTimeFormat eutcf = this.getUtcFormat(true);
        TaskT taskT = (TaskT)data;
        String body = taskT.getBody();
        if (body != null) {
            this.createElement(eData, "Tasks:", "Body", Utils.normalizeNewLines(body).replace("\n", "\r\n"));
        }
        this.createElement(eData, "Tasks:", "Subject", taskT.getSubject());
        this.createElement(eData, "Tasks:", "Importance", Integer.toString(taskT.getImportance().getValue()));
        if (taskT.getUtcstartdate() != null) {
            this.createElement(eData, "Tasks:", "UTCStartDate", eutcf.format(taskT.getUtcstartdate()));
        }
        if (taskT.getStartdate() != null) {
            this.createElement(eData, "Tasks:", "StartDate", eutcf.format(taskT.getStartdate()));
        }
        if (taskT.getUtcduedate() != null) {
            this.createElement(eData, "Tasks:", "UTCDueDate", eutcf.format(taskT.getUtcduedate()));
        }
        if (taskT.getDuedate() != null) {
            this.createElement(eData, "Tasks:", "DueDate", eutcf.format(taskT.getDuedate()));
        }
        if (taskT.getCategories() != null && !taskT.getCategories().isEmpty()) {
            Element eCategories = DOMUtils.createElement(eData, "Tasks:", "Categories");
            for (String category : taskT.getCategories()) {
                this.createElement(eCategories, "Tasks:", "Category", category);
            }
        }
        if (taskT.getRecurrence() != null) {
            this.formatRecurrence(eData, taskT, protocolVersion);
        }
        this.createElement(eData, "Tasks:", "Complete", Boolean.TRUE.equals(taskT.getComplete()) ? "1" : "0");
        if (taskT.getDatecompleted() != null) {
            this.createElement(eData, "Tasks:", "DateCompleted", eutcf.format(taskT.getDatecompleted()));
        }
        if (taskT.getSensitivity() != null) {
            this.createElement(eData, "Tasks:", "Sensitivity", Integer.toString(taskT.getSensitivity().getValue()));
        }
    }

    private void formatRecurrence(Element eData, TaskT ev, double protocolVersion) {
        DateTimeFormat eutcf = this.getUtcFormat(true);
        RecurrenceT recurrenceT = ev.getRecurrence();
        if (recurrenceT == null || recurrenceT.getType() == null) {
            return;
        }
        Element eRecurrence = DOMUtils.createElement(eData, "Tasks:", "Recurrence");
        DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_Type", Integer.toString(recurrenceT.getType().getValue()));
        if (recurrenceT.getOccurrences() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_Occurrences", Integer.toString(recurrenceT.getOccurrences()));
        }
        if (recurrenceT.getInterval() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_Interval", recurrenceT.getInterval().toString());
        }
        if (recurrenceT.getWeekOfMonth() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_WeekOfMonth", Integer.toString(recurrenceT.getWeekOfMonth()));
        }
        if (recurrenceT.getDayOfWeek() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_DayOfWeek", Integer.toString(RecurrenceDayOfWeek.asInt(recurrenceT.getDayOfWeek())));
        }
        if (recurrenceT.getMonthOfYear() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_MonthOfYear", Integer.toString(recurrenceT.getMonthOfYear()));
        }
        if (recurrenceT.getUntil() != null) {
            DOMUtils.createElementAndText(eRecurrence, "Tasks:", "Recurrence_Until", eutcf.format(recurrenceT.getUntil()));
        }
    }

    private void parseBody(Element eData, TaskT taskT) {
        Element eBody = DOMUtils.getUniqueElement(eData, "AirSyncBase:", "Body");
        if (eBody != null) {
            taskT.setBody(this.parseDOMString(DOMUtils.getUniqueElement(eBody, "AirSyncBase:", "Data")));
        }
    }

    @Override
    public IData parse(Element eData) {
        TaskT taskT = new TaskT();
        this.parseBody(eData, taskT);
        taskT.setSubject(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Tasks:", "Subject")));
        taskT.setImportance(Importance.toImportance(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eData, "Tasks:", "Importance"))));
        taskT.setUtcstartdate(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Tasks:", "UTCStartDate")));
        taskT.setStartdate(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Tasks:", "StartDate")));
        taskT.setUtcduedate(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Tasks:", "UTCDueDate")));
        taskT.setDuedate(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Tasks:", "DueDate")));
        taskT.setCategories(this.parseDOMStringCollection(DOMUtils.getUniqueElement(eData, "Tasks:", "Categories"), "Tasks:", "Category"));
        Element eRecurrence = DOMUtils.getUniqueElement(eData, "Tasks:", "Recurrence");
        if (eRecurrence != null) {
            RecurrenceT recurrenceT = new RecurrenceT();
            recurrenceT.setUntil(this.parseDOMDate(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_Until")));
            recurrenceT.setWeekOfMonth(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_WeekOfMonth")));
            recurrenceT.setMonthOfYear(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_MonthOfYear")));
            recurrenceT.setOccurrences(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_Occurrences")));
            recurrenceT.setInterval(this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_Interval")));
            Integer dayOfWeek = this.parseDOMInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_DayOfWeek"));
            if (dayOfWeek != null) {
                recurrenceT.setDayOfWeek(RecurrenceDayOfWeek.fromInt(dayOfWeek));
            }
            recurrenceT.setType(RecurrenceType.toRecurrenceType(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eRecurrence, "Tasks:", "Recurrence_Type"))));
            taskT.setRecurrence(recurrenceT);
        }
        taskT.setComplete("1".equals(this.parseDOMString(DOMUtils.getUniqueElement(eData, "Tasks:", "Complete"))));
        taskT.setDatecompleted(this.parseDOMDate(DOMUtils.getUniqueElement(eData, "Tasks:", "DateCompleted")));
        taskT.setSensitivity(Sensitivity.toSensitivity(this.parseDOMNoNullInt(DOMUtils.getUniqueElement(eData, "Tasks:", "Sensitivity"))));
        return taskT;
    }
}

