/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.util.HashMap;
import java.util.List;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.SyncFolder;
import org.opencrx.application.airsync.datatypes.SyncStatus;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FolderSyncHandler
extends AbstractServerHandler {
    public FolderSyncHandler(SyncBackend backend, String profilePrefix) {
        super(backend, profilePrefix);
    }

    @Override
    public Document handle(SyncRequest request, Document docRequest) {
        SyncStatus status = SyncStatus.OK;
        List<SyncFolder> changedFolders = null;
        List<SyncFolder> deletedFolders = null;
        String newSyncKey = null;
        Element eChanges = null;
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        try {
            String syncKey = docRequest == null ? null : DOMUtils.getElementText(docRequest.getDocumentElement(), null, "FolderHierarchy:SyncKey");
            syncKey = syncKey == null ? "0" : syncKey;
            Element element = eChanges = docRequest == null ? null : DOMUtils.getUniqueElement(docRequest.getDocumentElement(), null, "FolderHierarchy:Changes");
            if (eChanges != null) {
                HashMap<String, String> idMap = new HashMap<String, String>();
                NodeList nlChanges = eChanges.getChildNodes();
                for (int i = 0; i < nlChanges.getLength(); ++i) {
                    Element eChange = (Element)nlChanges.item(i);
                    String command = eChange.getNodeName();
                    String serverId = null;
                    SyncFolder folder = SyncFolder.decode(eChange, null);
                    if (command.equals("Add") || command.equals("Modify")) {
                        serverId = this.backend.createOrUpdateFolder(requestContext, folder);
                    } else if (command.equals("Remove")) {
                        serverId = this.backend.deleteFolder(requestContext, folder.getServerId());
                    }
                    if (serverId == null) continue;
                    idMap.put(serverId, folder.getClientId());
                }
            }
            changedFolders = this.backend.getChangedFolders(requestContext, this.getProfileName(request), syncKey);
            deletedFolders = this.backend.getDeletedFolders(requestContext, this.getProfilePrefix() + request.getDeviceId(), syncKey);
            newSyncKey = this.backend.getNextSyncKey(requestContext, syncKey);
            if ("0".equals(syncKey)) {
                newSyncKey = this.backend.getNextSyncKey(requestContext, newSyncKey);
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            status = SyncStatus.SERVER_ERROR;
        }
        Document docResponse = DOMUtils.createDoc("FolderHierarchy:", "FolderSync", new String[0][]);
        Element eRoot = docResponse.getDocumentElement();
        DOMUtils.createElementAndText(eRoot, null, "Status", Integer.toString(status.getValue()));
        if (status == SyncStatus.OK) {
            DOMUtils.createElementAndText(eRoot, null, "SyncKey", newSyncKey);
            if (changedFolders != null || deletedFolders != null) {
                Element e;
                eChanges = DOMUtils.createElement(eRoot, null, "Changes");
                int count = (changedFolders == null ? 0 : changedFolders.size()) + (deletedFolders == null ? 0 : deletedFolders.size());
                DOMUtils.createElementAndText(eChanges, null, "Count", Integer.toString(count));
                if (changedFolders != null) {
                    for (SyncFolder folder : changedFolders) {
                        e = DOMUtils.createElement(eChanges, null, "Add");
                        folder.encode(e);
                    }
                }
                if (deletedFolders != null) {
                    for (SyncFolder folder : deletedFolders) {
                        e = DOMUtils.createElement(eChanges, null, "Delete");
                        folder.encode(e);
                    }
                }
            }
        }
        return docResponse;
    }
}

