/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opencrx.application.airsync.backend.cci.GetChangedDataItemsResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.SyncCollection;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.datatypes.SyncStatus;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetItemEstimateHandler
extends AbstractServerHandler {
    private static final int MAX_ESTIMATE_COUNT = 256;

    public GetItemEstimateHandler(SyncBackend backend, String profilePrefix) {
        super(backend, profilePrefix);
    }

    @Override
    public Document handle(SyncRequest request, Document docRequest) {
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        String profileName = this.getProfileName(request);
        ArrayList<SyncCollection> collections = new ArrayList<SyncCollection>();
        Element eRoot = docRequest.getDocumentElement();
        NodeList lCollection = eRoot.getElementsByTagNameNS("ItemEstimate:", "Collection");
        for (int i = 0; i < lCollection.getLength(); ++i) {
            Element eCollection = (Element)lCollection.item(i);
            SyncCollection collection = SyncCollection.decode("ItemEstimate:", eCollection);
            collections.add(collection);
        }
        Document docResponse = DOMUtils.createDoc("ItemEstimate:", "GetItemEstimate", new String[0][]);
        eRoot = docResponse.getDocumentElement();
        for (SyncCollection collection : collections) {
            Element eResponse = DOMUtils.createElement(eRoot, null, "Response");
            SyncStatus syncStatus = SyncStatus.OK;
            int count = 0;
            try {
                if (this.backend.folderIsValid(requestContext, profileName, collection)) {
                    HashSet<String> excludes = new HashSet<String>();
                    GetChangedDataItemsResult getNewDataItemsResult = this.backend.getChangedDataItems(requestContext, profileName, collection, true, 256, SyncDataItem.State.NEW, excludes);
                    count = getNewDataItemsResult.getDataItems().size();
                    for (List<SyncDataItem> dataItems : getNewDataItemsResult.getDataItems().values()) {
                        for (SyncDataItem dataItem : dataItems) {
                            excludes.add(dataItem.getServerId());
                        }
                    }
                    if (count < 256) {
                        collection.setSyncKey(getNewDataItemsResult.getSyncKey());
                        GetChangedDataItemsResult getChangedDataItemsResult = this.backend.getChangedDataItems(requestContext, profileName, collection, true, 256, SyncDataItem.State.MODIFIED, excludes);
                        count += getChangedDataItemsResult.getDataItems().size();
                    }
                } else {
                    syncStatus = SyncStatus.OBJECT_NOT_FOUND;
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                syncStatus = SyncStatus.SERVER_ERROR;
            }
            DOMUtils.createElementAndText(eResponse, null, "Status", Integer.toString(syncStatus.getValue()));
            Element eCollection = DOMUtils.createElement(eResponse, null, "Collection");
            if (collection.getDataType() != null) {
                DOMUtils.createElementAndText(eCollection, null, "Class", collection.getDataType().toString());
            }
            DOMUtils.createElementAndText(eCollection, null, "CollectionId", collection.getCollectionId());
            if (syncStatus != SyncStatus.OK) continue;
            Element eEstimate = DOMUtils.createElement(eCollection, null, "Estimate");
            eEstimate.setTextContent(Integer.toString(count));
        }
        return docResponse;
    }
}

