/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencrx.application.airsync.backend.cci.GetChangedDataItemsResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.PingStatus;
import org.opencrx.application.airsync.datatypes.SyncCollection;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PingHandler
extends AbstractServerHandler {
    protected static final long PING_DELAY = 10000L;
    protected static final Logger logger = Logger.getLogger(PingHandler.class.getPackage().getName());

    public PingHandler(SyncBackend backend, String profilePrefix) {
        super(backend, profilePrefix);
    }

    private File getTempFile(SyncRequest request, String fileName) throws ServiceException {
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        File tempDir = this.backend.getContextTempDir(requestContext, request.getTempDir());
        try {
            tempDir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(tempDir.getPath() + File.separator + PingHandler.class.getName() + "-" + fileName + ".ser");
    }

    @Override
    public Document handle(SyncRequest request, Document docRequest) {
        File cachedPingRequestFile;
        PingRequest pingRequest;
        ArrayList<String> changedFolders;
        block23: {
            SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
            String profileName = this.getProfileName(request);
            changedFolders = new ArrayList<String>();
            pingRequest = new PingRequest();
            cachedPingRequestFile = null;
            try {
                Element eHeartbeatInterval;
                Element eRoot = docRequest == null ? null : docRequest.getDocumentElement();
                cachedPingRequestFile = this.getTempFile(request, request.getUserId() + "@" + request.getDeviceId());
                if (cachedPingRequestFile.exists()) {
                    try {
                        ObjectInputStream in = new ObjectInputStream(new FileInputStream(cachedPingRequestFile));
                        pingRequest = (PingRequest)in.readObject();
                        in.close();
                    }
                    catch (Exception in) {
                        // empty catch block
                    }
                }
                Element element = eHeartbeatInterval = eRoot == null ? null : DOMUtils.getUniqueElement(eRoot, "Ping:", "HeartbeatInterval");
                if (eHeartbeatInterval != null) {
                    pingRequest.intervalSeconds = Long.valueOf(eHeartbeatInterval.getTextContent());
                    NodeList lFolder = eRoot.getElementsByTagNameNS("Ping:", "Folder");
                    for (int i = 0; i < lFolder.getLength(); ++i) {
                        Node node = lFolder.item(i);
                        if (!(node instanceof Element)) continue;
                        Element eFolder = (Element)node;
                        SyncCollection collection = new SyncCollection();
                        collection.setCollectionId(DOMUtils.getElementText(eFolder, "Ping:", "Id"));
                        collection.setDataType(DataType.valueOf(DOMUtils.getElementText(eFolder, "Ping:", "Class")));
                        if (!this.backend.folderIsValid(requestContext, profileName, collection)) continue;
                        collection.setSyncKey(this.backend.getNextSyncKey(requestContext, this.backend.getNextSyncKey(requestContext, this.backend.getNextSyncKey(requestContext, "0"))));
                        pingRequest.collections.put(collection.getCollectionId(), collection);
                    }
                }
                if (pingRequest.collections.isEmpty()) break block23;
                long waitUntil = System.currentTimeMillis() + (pingRequest.intervalSeconds - 60L) * 1000L;
                while (System.currentTimeMillis() < waitUntil) {
                    for (SyncCollection collection : pingRequest.collections.values()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("PingHandler  Checking changes for collection " + collection.getCollectionId());
                        }
                        HashSet<String> excludes = new HashSet<String>();
                        GetChangedDataItemsResult getChangedDataItemsResult = this.backend.getChangedDataItems(requestContext, profileName, collection, true, 1, SyncDataItem.State.MODIFIED, excludes);
                        String newSyncKey = getChangedDataItemsResult.getSyncKey();
                        if (!getChangedDataItemsResult.getDataItems().isEmpty()) {
                            changedFolders.add(collection.getCollectionId());
                        } else {
                            List<String> deletedItemIds = this.backend.getDeletedDataItems(requestContext, profileName, collection, newSyncKey);
                            if (!deletedItemIds.isEmpty()) {
                                changedFolders.add(collection.getCollectionId());
                            }
                        }
                        collection.setSyncKey(newSyncKey);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (changedFolders == null || changedFolders.isEmpty()) continue;
                    break;
                }
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e);
                SysLog.warning((String)"Exception occurred while processing ping request. For more info see detail log", (Object)e0.getMessage());
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
            }
        }
        Document docResponse = DOMUtils.createDoc("Ping:", "Ping", new String[0][]);
        Element eRoot = docResponse.getDocumentElement();
        if (changedFolders == null) {
            DOMUtils.createElementAndText(eRoot, "Ping:", "Status", Integer.toString(PingStatus.FOLDER_SYNC_REQUIRED.getValue()));
        } else if (changedFolders.isEmpty()) {
            DOMUtils.createElementAndText(eRoot, "Ping:", "Status", Integer.toString(PingStatus.NO_CHANGES.getValue()));
        } else {
            DOMUtils.createElementAndText(eRoot, "Ping:", "Status", Integer.toString(PingStatus.CHANGES_OCCURED.getValue()));
            Element eFolders = DOMUtils.createElement(eRoot, "Ping:", "Folders");
            for (String folderId : changedFolders) {
                DOMUtils.createElementAndText(eFolders, "Ping:", "Folder", folderId);
            }
        }
        if (cachedPingRequestFile != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cachedPingRequestFile));
                out.writeObject(pingRequest);
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return docResponse;
    }

    public static class PingRequest
    implements Serializable {
        private static final long serialVersionUID = -2905533554043970286L;
        public Map<String, SyncCollection> collections = new HashMap<String, SyncCollection>();
        public long intervalSeconds = 0L;
        public String lastSyncKey = "0";
    }
}

