/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.client.ClientHandler;
import org.opencrx.application.airsync.datatypes.AttachmentDataT;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.FolderSyncHandler;
import org.opencrx.application.airsync.server.SyncHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.WbXMLTransformer;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.dom.Document;

public class AirSyncUtils {
    static final Logger logger = Logger.getLogger(AirSyncUtils.class.getPackage().getName());

    public static ClientHandler.SyncTarget newRemoteSyncTarget(final String serverUrl, final String username, String domain, final String password, final String deviceId) {
        return new ClientHandler.SyncTarget(){

            @Override
            public Object perform(String cmd, String policyKey, String userAgent, Document requestDoc) throws ServiceException {
                try {
                    URL url = new URL(serverUrl + "?Cmd=" + cmd + "&User=" + username + "&DeviceId=" + deviceId + "&DeviceType=OpenCrx");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    String userpassword = username + ":" + password;
                    connection.setRequestProperty("Authorization", "Basic " + Base64.encode((byte[])userpassword.getBytes()));
                    connection.setRequestProperty("Content-Type", "application/vnd.ms-sync.wbxml");
                    connection.setRequestProperty("MS-ASProtocolVersion", "2.5");
                    if (policyKey != null) {
                        connection.setRequestProperty("X-Ms-Policykey", policyKey);
                    }
                    if (userAgent != null) {
                        connection.setRequestProperty("User-Agent", userAgent);
                    }
                    connection.setRequestProperty("Accept", "*/*");
                    connection.setRequestMethod("POST");
                    logger.log(Level.FINE, "+-+-+-+-+- Request +-+-+-+-+-");
                    if (requestDoc == null) {
                        connection.getOutputStream().close();
                    } else {
                        WbXMLTransformer.transformToWBXML(requestDoc, connection.getOutputStream());
                        if (logger.isLoggable(Level.FINE)) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            System.out.println(url);
                            WbXMLTransformer.transform(requestDoc, new StreamResult(out), false);
                            out.close();
                            logger.log(Level.FINE, out.toString());
                        }
                    }
                    logger.log(Level.FINE, "POST Request", url);
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        throw new ServiceException("DefaultDomain", -7, "Unable to perform POST", new BasicException.Parameter[]{new BasicException.Parameter("url", (Object)url), new BasicException.Parameter("status", responseCode)});
                    }
                    if (cmd.startsWith("GetAttachment")) {
                        AttachmentDataT attachmentDataT = new AttachmentDataT();
                        ByteArrayOutputStream content = new ByteArrayOutputStream();
                        BinaryLargeObjects.streamCopy((InputStream)connection.getInputStream(), (long)0L, (OutputStream)content);
                        content.close();
                        attachmentDataT.setContent(new ByteArrayInputStream(content.toByteArray()));
                        attachmentDataT.setContentType(connection.getContentType());
                        connection.disconnect();
                        return attachmentDataT;
                    }
                    Document responseBody = WbXMLTransformer.transformFromWBXML(connection.getInputStream());
                    connection.disconnect();
                    return responseBody;
                }
                catch (Exception e) {
                    throw new ServiceException(e);
                }
            }
        };
    }

    public static ClientHandler.SyncTarget newLocalSyncTarget(final SyncBackend backend, final String profilePrefix, final String username, final String domain, final String deviceId) {
        return new ClientHandler.SyncTarget(){

            @Override
            public Object perform(String cmd, String policyKey, String userAgent, Document requestDoc) throws ServiceException {
                AbstractServerHandler syncHandler;
                SyncRequest request = new SyncRequest(cmd, domain + "\\" + username, deviceId);
                QuotaByteArrayOutputStream bos = new QuotaByteArrayOutputStream(AirSyncUtils.class.getName());
                try {
                    WbXMLTransformer.transformToWBXML(requestDoc, bos);
                    bos.close();
                }
                catch (IOException e) {
                    throw new ServiceException((Exception)e);
                }
                requestDoc = WbXMLTransformer.transformFromWBXML(new ByteArrayInputStream(bos.toByteArray()));
                Document responseDoc = null;
                if ("Sync".equals(cmd)) {
                    syncHandler = new SyncHandler(backend, profilePrefix);
                    responseDoc = ((SyncHandler)syncHandler).handle(request, requestDoc);
                } else if ("FolderSync".equals(cmd)) {
                    syncHandler = new FolderSyncHandler(backend, profilePrefix);
                    responseDoc = ((FolderSyncHandler)syncHandler).handle(request, requestDoc);
                } else {
                    throw new ServiceException("DefaultDomain", -36, "Unsupported command", new BasicException.Parameter[]{new BasicException.Parameter("command", (Object)cmd)});
                }
                bos.reset();
                try {
                    WbXMLTransformer.transformToWBXML(responseDoc, bos);
                    bos.close();
                }
                catch (IOException e) {
                    throw new ServiceException((Exception)e);
                }
                responseDoc = WbXMLTransformer.transformFromWBXML(new ByteArrayInputStream(bos.toByteArray()));
                return responseDoc;
            }
        };
    }
}

