/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openmdx.application.airsync.WBXMLPlugIn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static WBXMLPlugIn wbxmlPlugin;

    public static String getNamespaceURI(String prefix) {
        return wbxmlPlugin.getNamespaceContext().getNamespaceURI(prefix.endsWith(":") ? prefix.substring(0, prefix.indexOf(":")) : prefix);
    }

    public static String getElementText(Element root, String prefix, String elementName) {
        NodeList list = null;
        list = prefix == null ? root.getElementsByTagName(elementName) : root.getElementsByTagNameNS(DOMUtils.getNamespaceURI(prefix), elementName);
        if (list.getLength() == 0) {
            return null;
        }
        return DOMUtils.getElementText((Element)list.item(0));
    }

    public static String getElementText(Element node) {
        Text txtElem = (Text)node.getFirstChild();
        if (txtElem == null) {
            return null;
        }
        return txtElem.getData();
    }

    public static List<String> getTexts(Element root, String prefix, String elementName) {
        NodeList list = null;
        list = prefix == null ? root.getElementsByTagName(elementName) : root.getElementsByTagNameNS(DOMUtils.getNamespaceURI(prefix), elementName);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Text txt = (Text)list.item(i).getFirstChild();
            if (txt != null) {
                ret.add(txt.getData());
                continue;
            }
            ret.add("");
        }
        return ret;
    }

    public static Element getUniqueElement(Element parent, String prefix, String elementName) {
        NodeList list = null;
        list = prefix == null ? parent.getElementsByTagName(elementName) : parent.getElementsByTagNameNS(DOMUtils.getNamespaceURI(prefix), elementName);
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !node.getParentNode().equals(parent)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element createElementAndText(Element parent, String prefix, String elementName, String text) {
        if (text == null) {
            return null;
        }
        Element el = null;
        el = prefix == null ? parent.getOwnerDocument().createElement(elementName) : parent.getOwnerDocument().createElementNS(DOMUtils.getNamespaceURI(prefix), prefix + elementName);
        parent.appendChild(el);
        Text txt = el.getOwnerDocument().createTextNode(text);
        el.appendChild(txt);
        return el;
    }

    public static Element createElement(Element parent, String prefix, String elementName) {
        Element el = null;
        el = prefix == null ? parent.getOwnerDocument().createElement(elementName) : parent.getOwnerDocument().createElementNS(DOMUtils.getNamespaceURI(prefix), prefix + elementName);
        parent.appendChild(el);
        return el;
    }

    public static Document parse(InputStream is) throws SAXException, IOException {
        Document ret = documentBuilder.parse(is);
        return ret;
    }

    public static Document createDoc(String namespaceURI, String rootElement, String[] ... namespaces) {
        Document doc = documentBuilder.getDOMImplementation().createDocument(namespaceURI, rootElement, null);
        for (String[] namespace : namespaces) {
            doc.getDocumentElement().setAttribute(namespace[0], namespace[1]);
        }
        return doc;
    }

    static {
        wbxmlPlugin = new WBXMLPlugIn();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

