/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import org.openmdx.application.airsync.WBXMLPlugIn;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.wbxml.PlugIn;
import org.openmdx.base.wbxml.WBXMLReader;
import org.openmdx.base.xml.stream.XMLOutputFactories;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class WbXMLTransformer {
    private static XMLOutputFactory xmlOutputFactory;
    private static TransformerFactory transformerFactory;

    public static Document transformFromWBXML(InputStream in) throws ServiceException {
        try {
            WBXMLReader wbxmlReader = new WBXMLReader((PlugIn)new WBXMLPlugIn());
            Transformer transformer = transformerFactory.newTransformer();
            SAXSource xmlSource = new SAXSource((XMLReader)wbxmlReader, new InputSource(in));
            DOMResult outputTarget = new DOMResult();
            transformer.transform(xmlSource, outputTarget);
            return (Document)outputTarget.getNode();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static void transformToWBXML(Document doc, OutputStream out) throws IOException {
        try {
            XMLStreamWriter wbxmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(out);
            StAXResult outputTarget = new StAXResult(wbxmlStreamWriter);
            WbXMLTransformer.transform(doc, outputTarget, false);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void transform(Document doc, Result outputTarget, boolean indent) throws IOException {
        try {
            DOMSource xmlSource = new DOMSource(doc.getDocumentElement());
            Transformer transformer = transformerFactory.newTransformer();
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.transform(xmlSource, outputTarget);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static {
        transformerFactory = TransformerFactory.newInstance();
        try {
            xmlOutputFactory = XMLOutputFactories.newInstance((String)"application/vnd.ms-sync.wbxml");
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }
}

