/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.adapter.CreateActivityAction;
import org.opencrx.application.bpi.adapter.DoFollowUpAction;
import org.opencrx.application.bpi.adapter.GetAccountFilterAction;
import org.opencrx.application.bpi.adapter.GetActivityAction;
import org.opencrx.application.bpi.adapter.GetActivityCreatorAction;
import org.opencrx.application.bpi.adapter.GetAddressGroupAction;
import org.opencrx.application.bpi.adapter.GetAddressGroupMembersAction;
import org.opencrx.application.bpi.adapter.GetAddressGroupsAction;
import org.opencrx.application.bpi.adapter.GetAssignedActivitiesAction;
import org.opencrx.application.bpi.adapter.GetCodeTableAction;
import org.opencrx.application.bpi.adapter.GetContactAction;
import org.opencrx.application.bpi.adapter.GetContactMembershipsAction;
import org.opencrx.application.bpi.adapter.GetContactsAction;
import org.opencrx.application.bpi.adapter.GetOrganizationAction;
import org.opencrx.application.bpi.adapter.GetOrganizationMembersAction;
import org.opencrx.application.bpi.adapter.GetOrganizationsAction;
import org.opencrx.application.bpi.adapter.RunExportAction;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class BpiAdapterServlet
extends HttpServlet {
    private static final long serialVersionUID = -98101472441835933L;
    protected final Map<Path, BpiAction> actionRegistry = new HashMap<Path, BpiAction>();
    protected boolean logRequests = false;
    protected BpiPlugIn plugIn = null;
    protected PersistenceManagerFactory pmf = null;

    protected void registerAction(Path pathPattern, BpiAction action) {
        this.actionRegistry.put(pathPattern, action);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init();
        if (this.pmf == null) {
            try {
                Utils.getModel();
                this.pmf = Utils.getPersistenceManagerFactory();
            }
            catch (ServiceException e) {
                throw new ServletException("Can not get persistence manager", (Throwable)e);
            }
        }
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "codeTable", ":*"}), new GetCodeTableAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "contact", ":*"}), new GetContactAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "contact"}), new GetContactsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "contact", ":*", "membership"}), new GetContactMembershipsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "organization"}), new GetOrganizationsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "organization", ":*"}), new GetOrganizationAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "organization", ":*", "member"}), new GetOrganizationMembersAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "activityCreator", ":*"}), new GetActivityCreatorAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "activityCreator", ":*", "createActivity"}), new CreateActivityAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "activity", ":*"}), new GetActivityAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "activity", ":*", "doFollowUp"}), new DoFollowUpAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "contact", ":*", "assignedActivity"}), new GetAssignedActivitiesAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "addressGroup"}), new GetAddressGroupsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "addressGroup", ":*"}), new GetAddressGroupAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "addressGroup", ":*", "member"}), new GetAddressGroupMembersAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "accountFilter", ":*"}), new GetAccountFilterAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "accountFilter", ":*", "contact"}), new GetContactsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "accountFilter", ":*", "organization"}), new GetOrganizationsAction());
        this.registerAction(new Path("xri://@openmdx*org.opencrx.application.bpi1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "exporter", ":*", "file", ":*"}), new RunExportAction());
        this.plugIn = this.newPlugIn();
    }

    protected PersistenceManager getPersistenceManager(HttpServletRequest req) {
        return req.getUserPrincipal() == null ? null : this.pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    protected BpiPlugIn newPlugIn() {
        return new BpiPlugIn();
    }

    protected Path getPath(HttpServletRequest req) throws ServiceException {
        String requestURI = req.getRequestURI();
        return new Path("xri://@openmdx*" + requestURI.substring(req.getContextPath().length() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = null;
        long startedAt = System.currentTimeMillis();
        try {
            if (this.logRequests) {
                System.out.println(new Date() + "  " + ((Object)((Object)this)).getClass().getSimpleName() + " Processing " + req.getRequestURL() + "?" + req.getQueryString());
            }
            Path path = this.getPath(req);
            pm = this.getPersistenceManager(req);
            boolean done = false;
            for (Map.Entry<Path, BpiAction> action : this.actionRegistry.entrySet()) {
                if (!path.isLike(action.getKey())) continue;
                action.getValue().perform(path, pm, this.plugIn, req, resp);
                done = true;
                break;
            }
            if (!done) {
                super.doGet(req, resp);
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            resp.setStatus(500);
        }
        finally {
            if (pm != null) {
                try {
                    pm.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.logRequests) {
            System.out.println(new Date() + "  " + ((Object)((Object)this)).getClass().getSimpleName() + " Execution time " + (System.currentTimeMillis() - startedAt) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = null;
        try {
            Path path = this.getPath(req);
            pm = this.getPersistenceManager(req);
            boolean done = false;
            for (Map.Entry<Path, BpiAction> action : this.actionRegistry.entrySet()) {
                if (!path.isLike(action.getKey())) continue;
                action.getValue().perform(path, pm, this.plugIn, req, resp);
                done = true;
                break;
            }
            if (!done) {
                super.doPost(req, resp);
            }
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            resp.setStatus(500);
        }
        finally {
            if (pm != null) {
                try {
                    pm.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

