/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.bpi.datatype.BpiAccount;
import org.opencrx.application.bpi.datatype.BpiAccountFilter;
import org.opencrx.application.bpi.datatype.BpiAccountMember;
import org.opencrx.application.bpi.datatype.BpiActivity;
import org.opencrx.application.bpi.datatype.BpiActivityCreator;
import org.opencrx.application.bpi.datatype.BpiActivityFollowUp;
import org.opencrx.application.bpi.datatype.BpiAddress;
import org.opencrx.application.bpi.datatype.BpiAddressGroup;
import org.opencrx.application.bpi.datatype.BpiCodeTable;
import org.opencrx.application.bpi.datatype.BpiCodeTableEntry;
import org.opencrx.application.bpi.datatype.BpiContact;
import org.opencrx.application.bpi.datatype.BpiEMailAddress;
import org.opencrx.application.bpi.datatype.BpiLocalizedField;
import org.opencrx.application.bpi.datatype.BpiObject;
import org.opencrx.application.bpi.datatype.BpiOrganization;
import org.opencrx.application.bpi.datatype.BpiParticipant;
import org.opencrx.application.bpi.datatype.BpiPhoneNumber;
import org.opencrx.application.bpi.datatype.BpiPostalAddress;
import org.opencrx.application.bpi.datatype.BpiWebAddress;
import org.opencrx.kernel.account1.cci2.AccountFilterGlobalQuery;
import org.opencrx.kernel.account1.cci2.ContactQuery;
import org.opencrx.kernel.account1.cci2.LegalEntityQuery;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.AccountMembership;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.LegalEntity;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.activity1.cci2.ActivityCreatorQuery;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.ActivityTrackerQuery;
import org.opencrx.kernel.activity1.cci2.AddressGroupQuery;
import org.opencrx.kernel.activity1.jmi1.AbstractActivityParty;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.AddressGroup;
import org.opencrx.kernel.activity1.jmi1.IncidentParty;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.activity1.jmi1.TaskParty;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.code1.cci2.CodeValueContainerQuery;
import org.opencrx.kernel.code1.cci2.CodeValueEntryQuery;
import org.opencrx.kernel.code1.jmi1.CodeValueContainer;
import org.opencrx.kernel.code1.jmi1.CodeValueEntry;
import org.opencrx.kernel.generic.jmi1.LocalizedField;
import org.opencrx.kernel.workflow1.cci2.ExporterTaskQuery;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.Segment;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.naming.Path;

public class BpiPlugIn {
    protected GsonBuilder newGsonBuilder() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public void printObject(PrintWriter pw, Object value) {
        Gson gson = this.newGsonBuilder().create();
        pw.println(gson.toJson(value));
    }

    public String printObject(Object value) {
        return this.printObject(value, false);
    }

    public String printObject(Object value, boolean prettyPrinting) {
        GsonBuilder gsonBuilder = this.newGsonBuilder();
        if (prettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        return gson.toJson(value);
    }

    public <T> T parseObject(Reader r, Class<T> clazz) {
        Gson gson = new Gson();
        return (T)gson.fromJson(r, clazz);
    }

    public List<CodeValueContainer> findCodeValueContainers(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.code1.jmi1.Segment codeSegment = (org.opencrx.kernel.code1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()}));
        CodeValueContainerQuery codeValueContainerQuery = (CodeValueContainerQuery)pm.newQuery(CodeValueContainer.class);
        codeValueContainerQuery.thereExistsName().equalTo((Object)path.getLastSegment().toString());
        codeValueContainerQuery.orderByCreatedAt().ascending();
        return codeSegment.getValueContainer(codeValueContainerQuery);
    }

    public BpiCodeTable newBpiCodeTable() {
        return new BpiCodeTable();
    }

    public BpiCodeTableEntry newBpiCodeTableEntry() {
        return new BpiCodeTableEntry();
    }

    public BpiActivityCreator newBpiActivityCreator() {
        return new BpiActivityCreator();
    }

    public BpiActivity newBpiActivity() {
        return new BpiActivity();
    }

    public BpiActivityFollowUp newBpiActivityFollowUp() {
        return new BpiActivityFollowUp();
    }

    public BpiEMailAddress newBpiEMailAddress() {
        return new BpiEMailAddress();
    }

    public BpiPhoneNumber newBpiPhoneNumber() {
        return new BpiPhoneNumber();
    }

    public BpiWebAddress newBpiWebAddress() {
        return new BpiWebAddress();
    }

    public BpiAccountMember newBpiAccountMember() {
        return new BpiAccountMember();
    }

    public BpiPostalAddress newBpiPostalAddress() {
        return new BpiPostalAddress();
    }

    public BpiParticipant newBpiParticipant() {
        return new BpiParticipant();
    }

    public BpiContact newBpiContact() {
        return new BpiContact();
    }

    public BpiOrganization newBpiOrganization() {
        return new BpiOrganization();
    }

    public BpiLocalizedField newBpiLocalizedField() {
        return new BpiLocalizedField();
    }

    public BpiAddressGroup newBpiAddressGroup() {
        return new BpiAddressGroup();
    }

    public BpiAccountFilter newBpiAccountFilter() {
        return new BpiAccountFilter();
    }

    public BpiCodeTable toBpiCodeTable(CodeValueContainer codeValueContainer, BpiCodeTable bpiCodeTable, List<Short> locales, String fetchGroup) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)codeValueContainer);
        this.toBpiObject(codeValueContainer, bpiCodeTable, fetchGroup);
        bpiCodeTable.setName(codeValueContainer.getName());
        ArrayList<BpiCodeTableEntry> bpiEntries = new ArrayList<BpiCodeTableEntry>();
        CodeValueEntryQuery codeValueEntryQuery = (CodeValueEntryQuery)pm.newQuery(CodeValueEntry.class);
        codeValueEntryQuery.orderByCreatedAt().ascending();
        for (CodeValueEntry entry : codeValueContainer.getEntry(codeValueEntryQuery)) {
            BpiCodeTableEntry bpiEntry = this.newBpiCodeTableEntry();
            this.toBpiObject(entry, bpiEntry, fetchGroup);
            bpiEntry.setValidFrom(entry.getValidFrom());
            bpiEntry.setValidTo(entry.getValidTo());
            if (locales == null || locales.isEmpty()) {
                bpiEntry.setShortText(entry.getShortText());
                bpiEntry.setLongText(entry.getLongText());
            } else {
                ArrayList<String> shortTexts = new ArrayList<String>();
                ArrayList<String> longTexts = new ArrayList<String>();
                for (Short locale : locales) {
                    if (locale < entry.getShortText().size()) {
                        shortTexts.add(entry.getShortText().get(locale.shortValue()));
                    }
                    if (locale >= entry.getLongText().size()) continue;
                    longTexts.add(entry.getLongText().get(locale.shortValue()));
                }
                bpiEntry.setShortText(shortTexts);
                bpiEntry.setLongText(longTexts);
            }
            bpiEntries.add(bpiEntry);
        }
        bpiCodeTable.setEntry(bpiEntries);
        return bpiCodeTable;
    }

    public BpiActivityCreator toBpiActivityCreator(ActivityCreator activityCreator, BpiActivityCreator bpiActivityCreator, String fetchGroup) throws ServiceException {
        this.toBpiObject(activityCreator, bpiActivityCreator, fetchGroup);
        bpiActivityCreator.setName(activityCreator.getName());
        bpiActivityCreator.setDescription(activityCreator.getDescription());
        return bpiActivityCreator;
    }

    public BpiAddress toBpiAddress(AccountAddress address, BpiAddress bpiAddress, String fetchGroup) throws ServiceException {
        this.toBpiObject(address, bpiAddress, fetchGroup);
        bpiAddress.setMain(address.isMain());
        bpiAddress.setUsage(address.getUsage());
        return bpiAddress;
    }

    public BpiEMailAddress toBpiEMailAddress(EMailAddress emailAddress, String fetchGroup) throws ServiceException {
        BpiEMailAddress bpiEMailAddress = this.newBpiEMailAddress();
        this.toBpiAddress(emailAddress, bpiEMailAddress, fetchGroup);
        bpiEMailAddress.setEmailAddress(emailAddress.getEmailAddress());
        return bpiEMailAddress;
    }

    public BpiPhoneNumber toBpiPhoneNumber(PhoneNumber phoneNumber, String fetchGroup) throws ServiceException {
        BpiPhoneNumber bpiPhoneNumber = this.newBpiPhoneNumber();
        this.toBpiAddress(phoneNumber, bpiPhoneNumber, fetchGroup);
        bpiPhoneNumber.setPhoneNumberFull(phoneNumber.getPhoneNumberFull());
        return bpiPhoneNumber;
    }

    public BpiWebAddress toBpiWebAddress(WebAddress webAddress, String fetchGroup) throws ServiceException {
        BpiWebAddress bpiWebAddress = this.newBpiWebAddress();
        this.toBpiAddress(webAddress, bpiWebAddress, fetchGroup);
        bpiWebAddress.setWebAddress(webAddress.getWebUrl());
        return bpiWebAddress;
    }

    public BpiPostalAddress toBpiPostalAddress(PostalAddress postalAddress, String fetchGroup) throws ServiceException {
        BpiPostalAddress bpiPostalAddress = this.newBpiPostalAddress();
        this.toBpiAddress(postalAddress, bpiPostalAddress, fetchGroup);
        bpiPostalAddress.setPostalAddressLine(postalAddress.getPostalAddressLine());
        bpiPostalAddress.setPostalStreet(postalAddress.getPostalStreet());
        bpiPostalAddress.setPostalCode(postalAddress.getPostalCode());
        bpiPostalAddress.setPostalCountry(postalAddress.getPostalCountry());
        bpiPostalAddress.setPostalCity(postalAddress.getPostalCity());
        return bpiPostalAddress;
    }

    public BpiObject toBpiObject(BasicObject object, BpiObject bpiObject, String fetchGroup) throws ServiceException {
        if (bpiObject.getId() == null) {
            bpiObject.setId(object.refGetPath().getLastSegment().toString());
        }
        if (!"basic".equals(fetchGroup)) {
            bpiObject.setXri(object.refGetPath().toXRI());
            bpiObject.setCreatedAt(object.getCreatedAt());
            bpiObject.setCreatedBy(object.getCreatedBy());
            bpiObject.setModifiedAt(object.getModifiedAt());
            bpiObject.setModifiedBy(object.getModifiedBy());
        }
        return bpiObject;
    }

    public BpiAccount toBpiAccount(Account account, BpiAccount bpiAccount, String fetchGroup) throws ServiceException {
        this.toBpiObject(account, bpiAccount, fetchGroup);
        bpiAccount.setExtString0(account.getExtString0());
        AccountAddress[] mainAddresses = null;
        List<AccountAddress> businessAddresses = Accounts.getInstance().getAccountAddresses(account, Addresses.USAGE_BUSINESS);
        if ("basic".equals(fetchGroup)) {
            mainAddresses = new AccountAddress[13];
            for (AccountAddress address : businessAddresses) {
                if (!Boolean.TRUE.equals(address.isMain())) continue;
                if (address instanceof PostalAddress) {
                    mainAddresses[6] = address;
                    continue;
                }
                if (address instanceof PhoneNumber) {
                    mainAddresses[2] = address;
                    continue;
                }
                if (!(address instanceof EMailAddress)) continue;
                mainAddresses[0] = address;
            }
        } else {
            mainAddresses = Accounts.getInstance().getMainAddresses(account);
        }
        PhoneNumber phoneBusiness2 = null;
        EMailAddress mailBusiness2 = null;
        PhoneNumber faxBusiness2 = null;
        PostalAddress postalBusiness2 = null;
        for (AccountAddress address : businessAddresses) {
            if (address instanceof PhoneNumber && mainAddresses[2] != null && !address.equals(mainAddresses[2])) {
                phoneBusiness2 = (PhoneNumber)address;
                continue;
            }
            if (address instanceof EMailAddress && mainAddresses[0] != null && !address.equals(mainAddresses[0])) {
                mailBusiness2 = (EMailAddress)address;
                continue;
            }
            if (address instanceof PhoneNumber && mainAddresses[4] != null && !address.equals(mainAddresses[4])) {
                faxBusiness2 = (PhoneNumber)address;
                continue;
            }
            if (!(address instanceof PostalAddress) || mainAddresses[6] == null || address.equals(mainAddresses[6])) continue;
            postalBusiness2 = (PostalAddress)address;
        }
        if (mainAddresses[0] instanceof EMailAddress) {
            bpiAccount.setMailBusiness(this.toBpiEMailAddress((EMailAddress)mainAddresses[0], fetchGroup));
        }
        if (mailBusiness2 != null) {
            bpiAccount.setMailBusiness2(this.toBpiEMailAddress(mailBusiness2, fetchGroup));
        }
        if (mainAddresses[1] instanceof EMailAddress) {
            bpiAccount.setMailHome(this.toBpiEMailAddress((EMailAddress)mainAddresses[1], fetchGroup));
        }
        if (mainAddresses[12] instanceof EMailAddress) {
            bpiAccount.setMailOther(this.toBpiEMailAddress((EMailAddress)mainAddresses[12], fetchGroup));
        }
        if (mainAddresses[2] instanceof PhoneNumber) {
            bpiAccount.setPhoneBusiness(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[2], fetchGroup));
        }
        if (phoneBusiness2 != null) {
            bpiAccount.setPhoneBusiness2(this.toBpiPhoneNumber(phoneBusiness2, fetchGroup));
        }
        if (mainAddresses[3] instanceof PhoneNumber) {
            bpiAccount.setPhoneHome(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[3], fetchGroup));
        }
        if (mainAddresses[11] instanceof PhoneNumber) {
            bpiAccount.setPhoneOther(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[11], fetchGroup));
        }
        if (mainAddresses[4] instanceof PhoneNumber) {
            bpiAccount.setFaxBusiness(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[4], fetchGroup));
        }
        if (faxBusiness2 != null) {
            bpiAccount.setFaxBusiness2(this.toBpiPhoneNumber(faxBusiness2, fetchGroup));
        }
        if (mainAddresses[5] instanceof PhoneNumber) {
            bpiAccount.setFaxHome(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[5], fetchGroup));
        }
        if (mainAddresses[6] instanceof PostalAddress) {
            bpiAccount.setPostalBusiness(this.toBpiPostalAddress((PostalAddress)mainAddresses[6], fetchGroup));
        }
        if (postalBusiness2 != null) {
            bpiAccount.setPostalBusiness2(this.toBpiPostalAddress(postalBusiness2, fetchGroup));
        }
        if (mainAddresses[8] instanceof PostalAddress) {
            bpiAccount.setPostalHome(this.toBpiPostalAddress((PostalAddress)mainAddresses[8], fetchGroup));
        }
        if (mainAddresses[10] instanceof PhoneNumber) {
            bpiAccount.setMobile(this.toBpiPhoneNumber((PhoneNumber)mainAddresses[10], fetchGroup));
        }
        if (mainAddresses[7] instanceof WebAddress) {
            bpiAccount.setWebBusiness(this.toBpiWebAddress((WebAddress)mainAddresses[7], fetchGroup));
        }
        if (mainAddresses[9] instanceof WebAddress) {
            bpiAccount.setWebBusiness(this.toBpiWebAddress((WebAddress)mainAddresses[9], fetchGroup));
        }
        if (!"basic".equals(fetchGroup)) {
            ArrayList<BpiLocalizedField> bpiLocalizedFields = new ArrayList<BpiLocalizedField>();
            Iterator iterator = account.getLocalizedField().iterator();
            while (iterator.hasNext()) {
                LocalizedField localizedField = (LocalizedField)iterator.next();
                bpiLocalizedFields.add(this.toBpiLocalizedField(localizedField, this.newBpiLocalizedField(), "default"));
            }
            bpiAccount.setLocalizedField(bpiLocalizedFields);
        }
        return bpiAccount;
    }

    public BpiContact toBpiContact(Contact contact, BpiContact bpiContact, String fetchGroup) throws ServiceException {
        this.toBpiAccount(contact, bpiContact, fetchGroup);
        bpiContact.setAliasName(contact.getAliasName());
        bpiContact.setFullName(contact.getFullName());
        if (!"basic".equals(fetchGroup)) {
            bpiContact.setVcard(contact.getVcard());
        }
        bpiContact.setFirstName(contact.getFirstName());
        bpiContact.setLastName(contact.getLastName());
        bpiContact.setSalutationCode(contact.getSalutationCode());
        bpiContact.setSalutation(contact.getSalutation());
        bpiContact.setJobTitle(contact.getJobTitle());
        return bpiContact;
    }

    public BpiAddressGroup toBpiAddressGroup(AddressGroup addressGroup, BpiAddressGroup bpiAddressGroup, String fetchGroup) throws ServiceException {
        this.toBpiObject(addressGroup, bpiAddressGroup, fetchGroup);
        bpiAddressGroup.setName(addressGroup.getName());
        bpiAddressGroup.setDescription(addressGroup.getDescription());
        return bpiAddressGroup;
    }

    public BpiAccountFilter toBpiAccountFilter(AccountFilterGlobal accountFilter, BpiAccountFilter bpiAccountFilter, String fetchGroup) throws ServiceException {
        this.toBpiObject(accountFilter, bpiAccountFilter, fetchGroup);
        bpiAccountFilter.setName(accountFilter.getName());
        bpiAccountFilter.setDescription(accountFilter.getDescription());
        return bpiAccountFilter;
    }

    public BpiOrganization toBpiOrganization(LegalEntity organization, BpiOrganization bpiOrganization, String fetchGroup) throws ServiceException {
        this.toBpiAccount(organization, bpiOrganization, fetchGroup);
        bpiOrganization.setName(organization.getName());
        bpiOrganization.setAliasName(organization.getAliasName());
        bpiOrganization.setFullName(organization.getFullName());
        if (!"basic".equals(fetchGroup)) {
            bpiOrganization.setVcard(organization.getVcard());
        }
        return bpiOrganization;
    }

    public BpiActivity toBpiActivity(Activity activity, BpiActivity bpiActivity, String fetchGroup) throws ServiceException {
        this.toBpiObject(activity, bpiActivity, fetchGroup);
        bpiActivity.setActivityNumber(activity.getActivityNumber());
        bpiActivity.setName(activity.getName());
        bpiActivity.setDescription(activity.getDescription());
        bpiActivity.setAdditionalInformation(activity.getDetailedDescription());
        bpiActivity.setScheduledStart(activity.getScheduledStart());
        bpiActivity.setScheduledEnd(activity.getScheduledEnd());
        bpiActivity.setActivityState(activity.getActivityState());
        bpiActivity.setProcessState(activity.getProcessState() == null ? null : activity.getProcessState().getName());
        bpiActivity.setLocation(activity.getLocation());
        bpiActivity.setCategory(activity.getCategory());
        if (!"basic".equals(fetchGroup)) {
            if (activity.getReportingContact() instanceof Contact) {
                bpiActivity.setReportingContact(this.toBpiContact(activity.getReportingContact(), this.newBpiContact(), "default"));
            }
            if (activity.getAssignedTo() instanceof Contact) {
                bpiActivity.setAssignedTo(this.toBpiContact(activity.getAssignedTo(), this.newBpiContact(), "default"));
            }
            if (activity.getReportingAccount() instanceof Contact) {
                bpiActivity.setReportingContact2(this.toBpiContact((Contact)activity.getReportingAccount(), this.newBpiContact(), "default"));
            }
        }
        if ("all".equals(fetchGroup)) {
            ArrayList<BpiParticipant> bpiParticipants = new ArrayList<BpiParticipant>();
            for (AbstractActivityParty party : Activities.getInstance().getActivityParties(activity)) {
                Account partyAccount = null;
                if (party instanceof TaskParty) {
                    partyAccount = ((TaskParty)party).getParty();
                } else if (party instanceof MeetingParty) {
                    partyAccount = ((MeetingParty)party).getParty();
                } else if (party instanceof IncidentParty) {
                    partyAccount = ((IncidentParty)party).getParty();
                }
                if (partyAccount == null) continue;
                BpiParticipant bpiParticipant = this.newBpiParticipant();
                this.toBpiObject(party, bpiParticipant, "default");
                bpiParticipant.setPartyStatus(party.getPartyStatus());
                bpiParticipant.setPartyType(party.getPartyType());
                if (partyAccount instanceof Contact) {
                    bpiParticipant.setAccount(this.toBpiContact((Contact)partyAccount, this.newBpiContact(), "default"));
                } else if (partyAccount instanceof LegalEntity) {
                    bpiParticipant.setAccount(this.toBpiOrganization((LegalEntity)partyAccount, this.newBpiOrganization(), "default"));
                }
                bpiParticipants.add(bpiParticipant);
            }
            bpiActivity.setParticipant(bpiParticipants);
        }
        if (!"basic".equals(fetchGroup)) {
            ArrayList<BpiLocalizedField> bpiLocalizedFields = new ArrayList<BpiLocalizedField>();
            Iterator iterator = activity.getLocalizedField().iterator();
            while (iterator.hasNext()) {
                LocalizedField localizedField = (LocalizedField)iterator.next();
                bpiLocalizedFields.add(this.toBpiLocalizedField(localizedField, this.newBpiLocalizedField(), "default"));
            }
            bpiActivity.setLocalizedField(bpiLocalizedFields);
        }
        return bpiActivity;
    }

    public BpiActivityFollowUp toBpiActivityFollowUp(ActivityFollowUp activityFollowUp, BpiActivityFollowUp bpiActivityFollowUp, String fetchGroup) throws ServiceException {
        this.toBpiObject(activityFollowUp, bpiActivityFollowUp, fetchGroup);
        bpiActivityFollowUp.setTitle(activityFollowUp.getTitle());
        bpiActivityFollowUp.setText(activityFollowUp.getText());
        bpiActivityFollowUp.setTransition(activityFollowUp.getTransition().getName());
        return bpiActivityFollowUp;
    }

    public BpiAccountMember toBpiAccountMember(Member member, BpiAccountMember bpiAccountMember, String fetchGroup) throws ServiceException {
        bpiAccountMember.setId(member.refGetPath().getLastSegment().toString());
        bpiAccountMember.setXri(member.refGetPath().toXRI());
        bpiAccountMember.setName(member.getAccount().getFullName());
        bpiAccountMember.setMemberRole(member.getMemberRole());
        if (member.getAccount() instanceof Contact) {
            bpiAccountMember.setAccount(this.toBpiContact((Contact)member.getAccount(), this.newBpiContact(), "basic"));
        } else if (member.getAccount() instanceof LegalEntity) {
            bpiAccountMember.setAccount(this.toBpiOrganization((LegalEntity)member.getAccount(), this.newBpiOrganization(), "basic"));
        }
        return bpiAccountMember;
    }

    public BpiAccountMember toBpiAccountMember(AccountMembership membership, BpiAccountMember bpiAccountMember, String fetchGroup) throws ServiceException {
        bpiAccountMember.setId(membership.refGetPath().getLastSegment().toString());
        bpiAccountMember.setXri(membership.refGetPath().toXRI());
        bpiAccountMember.setName(membership.getAccountTo().getFullName());
        bpiAccountMember.setMemberRole(membership.getMemberRole());
        if (membership.getAccountFrom() instanceof Contact) {
            bpiAccountMember.setAccount(this.toBpiContact((Contact)membership.getAccountFrom(), this.newBpiContact(), "basic"));
        } else if (membership.getAccountFrom() instanceof LegalEntity) {
            bpiAccountMember.setAccount(this.toBpiOrganization((LegalEntity)membership.getAccountFrom(), this.newBpiOrganization(), "basic"));
        }
        return bpiAccountMember;
    }

    public BpiLocalizedField toBpiLocalizedField(LocalizedField localizedField, BpiLocalizedField bpiLocalizedField, String fetchGroup) throws ServiceException {
        this.toBpiObject(localizedField, bpiLocalizedField, fetchGroup);
        bpiLocalizedField.setName(localizedField.getName());
        bpiLocalizedField.setDescription(localizedField.getDescription());
        bpiLocalizedField.setLocale(localizedField.getLocale());
        bpiLocalizedField.setLocalizedValue(localizedField.getLocalizedValue());
        return bpiLocalizedField;
    }

    public List<Contact> findContacts(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        ContactQuery contactQuery = (ContactQuery)pm.newQuery(Contact.class);
        contactQuery.thereExistsAliasName().equalTo((Object)path.getLastSegment().toString());
        contactQuery.orderByCreatedAt().ascending();
        contactQuery.forAllDisabled().isFalse();
        return accountSegment.getAccount(contactQuery);
    }

    public List<ExporterTask> findExporterTasks(Path path, PersistenceManager pm) throws ServiceException {
        String id = path.getSegment(6).toString();
        Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        ExporterTask exporterTask = (ExporterTask)workflowSegment.getWfProcess(id);
        if (exporterTask != null) {
            return Collections.singletonList(exporterTask);
        }
        ExporterTaskQuery exporterTaskQuery = (ExporterTaskQuery)pm.newQuery(ExporterTask.class);
        exporterTaskQuery.name().equalTo((Object)path.getSegment(6).toString());
        return workflowSegment.getWfProcess(exporterTaskQuery);
    }

    public List<AddressGroup> findAddressGroups(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        AddressGroupQuery addressGroupQuery = (AddressGroupQuery)pm.newQuery(AddressGroup.class);
        try {
            addressGroupQuery.name().equalTo((Object)URLDecoder.decode(path.getSegment(6).toString(), "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        addressGroupQuery.orderByCreatedAt().ascending();
        addressGroupQuery.forAllDisabled().isFalse();
        return activitySegment.getAddressGroup(addressGroupQuery);
    }

    public List<AccountFilterGlobal> findAccountFilters(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        AccountFilterGlobalQuery accountFilterQuery = (AccountFilterGlobalQuery)pm.newQuery(AccountFilterGlobal.class);
        try {
            accountFilterQuery.name().equalTo((Object)URLDecoder.decode(path.getSegment(6).toString(), "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        accountFilterQuery.orderByCreatedAt().ascending();
        accountFilterQuery.forAllDisabled().isFalse();
        return accountSegment.getAccountFilter(accountFilterQuery);
    }

    public List<Member> findAccountMembers(Account account) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
        memberQuery.forAllDisabled().isFalse();
        memberQuery.thereExistsAccount().forAllDisabled().isFalse();
        return account.getMember(memberQuery);
    }

    public List<LegalEntity> findLegalEntities(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        LegalEntityQuery legalEntityQuery = (LegalEntityQuery)pm.newQuery(LegalEntity.class);
        legalEntityQuery.name().equalTo((Object)path.getLastSegment().toString());
        legalEntityQuery.orderByCreatedAt().ascending();
        legalEntityQuery.forAllDisabled().isFalse();
        return accountSegment.getAccount(legalEntityQuery);
    }

    public List<ActivityCreator> findActivityCreators(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        ActivityCreatorQuery activityCreatorQuery = (ActivityCreatorQuery)pm.newQuery(ActivityCreator.class);
        activityCreatorQuery.name().equalTo((Object)path.getLastSegment().toString());
        activityCreatorQuery.orderByCreatedAt().ascending();
        activityCreatorQuery.forAllDisabled().isFalse();
        return activitySegment.getActivityCreator(activityCreatorQuery);
    }

    public List<ActivityTracker> findActivityTrackers(Path path, PersistenceManager pm) throws ServiceException {
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        ActivityTrackerQuery activityTrackerQuery = (ActivityTrackerQuery)pm.newQuery(ActivityTracker.class);
        try {
            activityTrackerQuery.name().equalTo((Object)URLDecoder.decode(path.getLastSegment().toString(), "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        activityTrackerQuery.orderByCreatedAt().ascending();
        activityTrackerQuery.forAllDisabled().isFalse();
        return activitySegment.getActivityTracker(activityTrackerQuery);
    }

    public List<Activity> findActivities(Path path, PersistenceManager pm) throws ServiceException {
        String id = path.getLastSegment().toString();
        org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, path.getSegment(2).toString(), path.getSegment(4).toString());
        ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
        activityQuery.thereExistsActivityNumber().equalTo((Object)id);
        activityQuery.orderByCreatedAt().ascending();
        activityQuery.forAllDisabled().isFalse();
        List<Activity> activities = activitySegment.getActivity(activityQuery);
        if (!activities.isEmpty()) {
            return activities;
        }
        activities = new ArrayList<Activity>();
        try {
            Activity activity = activitySegment.getActivity(id);
            if (activity != null) {
                activities.add(activity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activities;
    }

    public String mergeActivityDetailedDescription(String oldText, String newText) {
        return newText + "\n\n~ ~ ~\n" + oldText;
    }
}

