/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class GetActivityCreatorAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<ActivityCreator> activityCreators = plugIn.findActivityCreators(path, pm);
        if (activityCreators == null || activityCreators.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                ActivityCreator activityCreator = activityCreators.iterator().next();
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                PrintWriter pw = resp.getWriter();
                plugIn.printObject(pw, plugIn.toBpiActivityCreator(activityCreator, plugIn.newBpiActivityCreator(), "all"));
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

