/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiAccountMember;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.LegalEntity;
import org.opencrx.kernel.account1.jmi1.Member;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class GetOrganizationMembersAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<LegalEntity> organizations = plugIn.findLegalEntities(path.getPrefix(7), pm);
        if (organizations == null || organizations.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                LegalEntity organization = organizations.iterator().next();
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                PrintWriter pw = resp.getWriter();
                ArrayList<BpiAccountMember> bpiAccountMembers = new ArrayList<BpiAccountMember>();
                for (Member member : plugIn.findAccountMembers(organization)) {
                    if (!(member.getAccount() instanceof Contact)) continue;
                    bpiAccountMembers.add(plugIn.toBpiAccountMember(member, plugIn.newBpiAccountMember(), this.getFetchGroup(req)));
                }
                plugIn.printObject(pw, bpiAccountMembers);
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

