/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.opencrx.application.caldav.ActivityResource;
import org.opencrx.application.caldav.CalDavResource;
import org.opencrx.application.caldav.CalDavStore;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.generic.ChainingCollection;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.openmdx.base.collection.MarshallingCollection;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.marshalling.Marshaller;

abstract class ActivityCollectionResource
extends CalDavResource {
    private static final int FETCH_SIZE = 200;
    private final Type type;
    private final boolean allowChange;
    private final boolean allowAddDelete;
    private final String backColor;
    private final String runAs;
    private final ActivityQueryHelper queryHelper;

    public ActivityCollectionResource(RequestContext requestContext, BasicObject object, ActivityQueryHelper queryHelper, Type type, boolean allowChange, boolean allowAddDelete, String backColor, String runAs) {
        super(requestContext, (ContextCapable)object);
        this.type = type;
        this.allowChange = allowChange;
        this.allowAddDelete = allowAddDelete;
        this.backColor = backColor;
        if (runAs != null) {
            PersistenceManager pm = this.getRequestContext().newPersistenceManager(runAs);
            queryHelper = CalDavStore.getActivityQueryHelper(pm, queryHelper.getQueryId(), "false");
        }
        this.queryHelper = queryHelper;
        this.runAs = runAs;
    }

    @Override
    public ContextCapable getObject() {
        return super.getObject();
    }

    @Override
    public String getDisplayName() {
        Set features = this.getObject().refDefaultFetchGroup();
        String name = this.getName();
        if (features.contains("name")) {
            name = (String)this.getObject().refGetValue("name");
        }
        if (this.type != Type.VEVENT) {
            name = name + " - Todos";
        }
        return name;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getName() {
        return super.getName() + (this.type == Type.VTODO ? ":VTODO" : "");
    }

    public Type getType() {
        return this.type;
    }

    public boolean allowChange() {
        return this.allowChange;
    }

    public boolean allowAddDelete() {
        return this.allowAddDelete;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public String getMimeType() {
        return "text/calendar";
    }

    public ActivityQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    protected ActivityQuery getChildrenBaseQuery(PersistenceManager pm) {
        ActivityQuery query = (ActivityQuery)pm.newQuery(Activity.class);
        if (this.queryHelper.isDisabledFilter()) {
            query.thereExistsDisabled().isTrue();
        } else {
            query.forAllDisabled().isFalse();
        }
        if (this.type == Type.VEVENT) {
            query.icalType().elementOf(new Object[]{(short)1});
        } else if (this.type == Type.VTODO) {
            query.icalType().equalTo((Object)2);
        }
        query.ical().isNonNull();
        query.forAllExternalLink().startsNotWith((Object)"ICAL-RECURRENCE-ID:");
        query.orderByCreatedAt().ascending();
        ((Query)query).getFetchPlan().setFetchSize(200);
        return query;
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        PersistenceManager pm = this.queryHelper.getPersistenceManager();
        ArrayList childrenCollections = new ArrayList();
        ActivityQuery queryActivitiesInRange = this.getChildrenBaseQuery(pm);
        if (timeRangeStart != null) {
            queryActivitiesInRange.thereExistsScheduledEnd().greaterThanOrEqualTo((Comparable)timeRangeStart);
        }
        if (timeRangeEnd != null) {
            queryActivitiesInRange.thereExistsScheduledStart().lessThanOrEqualTo((Comparable)timeRangeEnd);
        }
        childrenCollections.add(this.queryHelper.getFilteredActivities(queryActivitiesInRange));
        if (timeRangeStart != null) {
            ActivityQuery queryRecurringActivities = this.getChildrenBaseQuery(pm);
            queryRecurringActivities.thereExistsIcal().like((Object)".*RRULE:.*");
            if (timeRangeEnd != null) {
                queryRecurringActivities.thereExistsScheduledStart().lessThanOrEqualTo((Comparable)timeRangeEnd);
            }
            childrenCollections.add(this.queryHelper.getFilteredActivities(queryRecurringActivities));
        }
        return new ActivityResourceCollection(this.getRequestContext(), new ChainingCollection<Activity>(childrenCollections), this);
    }

    static class ActivityResourceCollection<T>
    extends MarshallingCollection<T> {
        private static final long serialVersionUID = 6257982279508324945L;

        public ActivityResourceCollection(final RequestContext requestContext, Collection<Activity> activities, final ActivityCollectionResource activityCollectionResource) {
            super(new Marshaller(){

                public Object marshal(Object source) throws ServiceException {
                    if (source instanceof Activity) {
                        return new ActivityResource(requestContext, (Activity)source, activityCollectionResource);
                    }
                    return source;
                }

                public Object unmarshal(Object source) throws ServiceException {
                    if (source instanceof CalDavResource) {
                        return ((CalDavResource)source).getObject();
                    }
                    return source;
                }
            }, activities);
        }
    }

    public static enum Type {
        VEVENT,
        VTODO;

    }
}

