/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.carddav;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.opencrx.application.carddav.AccountCollectionResource;
import org.opencrx.application.carddav.CardDavResource;
import org.opencrx.application.uses.ezvcard.Ezvcard;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.parameter.ImageType;
import org.opencrx.application.uses.ezvcard.property.Photo;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.document1.jmi1.Media;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

public class AccountResource
extends CardDavResource {
    private final AccountCollectionResource parent;

    public AccountResource(RequestContext requestContext, Account account, AccountCollectionResource parent) {
        super(requestContext, account);
        this.parent = parent;
    }

    @Override
    public Account getObject() {
        return (Account)super.getObject();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public String getMimeType() {
        return "text/x-vcard";
    }

    @Override
    public String getName() {
        return super.getName() + ".vcf";
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getFullName();
    }

    public AccountCollectionResource getAccountCollectionResource() {
        return this.parent;
    }

    public static Photo getPhoto(Account account) {
        String mimeType;
        Media picture = null;
        try {
            picture = account.getPicture();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (picture != null && (mimeType = picture.getContentMimeType()) != null && mimeType.indexOf("/") > 0) {
            try {
                return new Photo(picture.getContent().getContent(), ImageType.get(null, mimeType, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public WebDavStore.ResourceContent getContent() {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter p = null;
        try {
            p = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        catch (Exception e) {
            p = new PrintWriter(out);
        }
        Account account = this.getObject();
        HttpServletRequest req = this.getRequestContext().getHttpServletRequest();
        String vcard = account.getVcard();
        if (vcard != null && vcard.indexOf("BEGIN:VCARD") >= 0) {
            Photo photo;
            VCard vCard = Ezvcard.parse(vcard).first();
            if (vCard.getUrls().isEmpty()) {
                String url = null;
                try {
                    url = Base.getInstance().getAccessUrl(req, "-carddav-", account);
                    vCard.addUrl(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (vCard.getPhotos().isEmpty() && (photo = AccountResource.getPhoto(account)) != null) {
                vCard.addPhoto(photo);
            }
            try {
                Ezvcard.write(vCard).version(VCardVersion.V3_0).go(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.close();
        return new WebDavStore.ResourceContent(){

            @Override
            public Long getLength() {
                return out.size();
            }

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])out.toByteArray());
            }
        };
    }
}

