/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.ical;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.ical.FreeBusyServlet;
import org.opencrx.kernel.account1.cci2.ContactQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.utils.AccountQueryHelper;
import org.opencrx.kernel.utils.ActivityQueryHelper;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Action;

public class ICalServlet
extends FreeBusyServlet {
    private static final long serialVersionUID = 4746783518992145105L;
    protected static final String RESOURCE_ACTIVITIES_ICS = "activities.ics";

    protected boolean acceptDate(Contact contact, CalendarType calendarType, int year) {
        GregorianCalendar dateOfBirth = null;
        GregorianCalendar anniversary = null;
        GregorianCalendar dateOfDeath = null;
        GregorianCalendar dateOfBirthInYear = null;
        GregorianCalendar anniversaryInYear = null;
        if (contact.getBirthdate() != null) {
            dateOfBirth = new GregorianCalendar();
            dateOfBirth.setTime(contact.getBirthdate());
        }
        if (contact.getAnniversary() != null) {
            anniversary = new GregorianCalendar();
            anniversary.setTime(contact.getAnniversary());
        }
        if (contact.getDateOfDeath() != null) {
            dateOfDeath = new GregorianCalendar();
            dateOfDeath.setTime(contact.getDateOfDeath());
            if (dateOfBirth != null) {
                dateOfBirthInYear = (GregorianCalendar)dateOfBirth.clone();
                dateOfBirthInYear.set(1, year);
            }
            if (anniversary != null) {
                anniversaryInYear = (GregorianCalendar)anniversary.clone();
                anniversaryInYear.set(1, year);
            }
        }
        switch (calendarType) {
            case BDAYS: {
                return dateOfBirth != null && dateOfBirth.get(1) <= year;
            }
            case ANNIVERSARIES: {
                return anniversary != null && anniversary.get(1) <= year;
            }
            case DATESOFDEATH: {
                return dateOfDeath != null && dateOfDeath.get(1) <= year;
            }
        }
        return false;
    }

    protected PersistenceManager getPersistenceManager(HttpServletRequest req) {
        return req.getUserPrincipal() == null ? null : this.pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    protected AccountQueryHelper getAccountsHelper(PersistenceManager pm, String filterId, String isDisabledFilter) {
        AccountQueryHelper accountsHelper = new AccountQueryHelper(pm);
        if (filterId != null) {
            try {
                accountsHelper.parseQueryId((filterId.startsWith("/") ? "" : "/") + filterId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return accountsHelper;
    }

    protected String getActivityUrl(HttpServletRequest req, Activity activity) {
        Action selectActivityAction = new Action(6, new Action.Parameter[]{new Action.Parameter("xri", activity.refMofId())}, "", true);
        return req.getContextPath().replace("-ical-", "-core-") + "/" + "ObjectInspectorServlet" + "?event=" + 6 + "&amp;parameter=" + selectActivityAction.getParameterEncoded();
    }

    protected void printCalendar(CalendarType calendarType, AccountQueryHelper accountsHelper, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String summaryPrefix;
        PersistenceManager pm = accountsHelper.getPersistenceManager();
        boolean YEARS_BEFORE_SELECTED_YEAR = true;
        boolean YEARS_AFTER_SELECTED_YEAR = true;
        GregorianCalendar now = new GregorianCalendar();
        int year = now.get(1);
        if (req.getParameter("year") != null) {
            try {
                year = Integer.parseInt(req.getParameter("year"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean createAlarm = req.getParameter("alarm") != null ? Boolean.valueOf(req.getParameter("alarm")) : (req.getParameter("ALARM") != null ? Boolean.valueOf(req.getParameter("ALARM")) : false);
        int icalType = 1;
        if (req.getParameter("icalType") != null && req.getParameter("icalType").compareTo("VTODO") == 0) {
            icalType = 2;
        }
        int max = req.getParameter("max") != null ? Integer.valueOf(req.getParameter("max")) : 500;
        String categories = req.getParameter("categories") != null ? req.getParameter("categories") : calendarType.name();
        String string = summaryPrefix = req.getParameter("summaryPrefix") != null ? req.getParameter("summaryPrefix") : "";
        if (accountsHelper.getAccountSegment() != null) {
            SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
            dateTimeFormatter.setLenient(false);
            GregorianCalendar calendarEndAt = new GregorianCalendar();
            calendarEndAt.add(1, 2);
            calendarEndAt.set(2, 0);
            calendarEndAt.set(5, 1);
            calendarEndAt.set(11, 0);
            calendarEndAt.set(12, 0);
            calendarEndAt.set(13, 0);
            calendarEndAt.set(14, 0);
            ContactQuery contactQuery = (ContactQuery)pm.newQuery(Contact.class);
            contactQuery.forAllDisabled().isFalse();
            switch (calendarType) {
                case BDAYS: {
                    contactQuery.thereExistsBirthdate().lessThanOrEqualTo((Comparable)calendarEndAt.getTime());
                    break;
                }
                case ANNIVERSARIES: {
                    contactQuery.thereExistsAnniversary().lessThanOrEqualTo((Comparable)calendarEndAt.getTime());
                    break;
                }
                case DATESOFDEATH: {
                    contactQuery.thereExistsDateOfDeath().lessThanOrEqualTo((Comparable)calendarEndAt.getTime());
                }
            }
            Collection<Account> contacts = accountsHelper.getFilteredAccounts(contactQuery);
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            resp.setContentType("text/calendar");
            PrintWriter p = resp.getWriter();
            p.write("BEGIN:VCALENDAR\n");
            p.write("VERSION:2.0\n");
            p.write("PRODID://OPENCRX//V2//EN\n");
            p.write("CALSCALE:GREGORIAN\n");
            p.write("METHOD:PUBLISH\n");
            int n = 0;
            for (Account account : contacts) {
                if (!(account instanceof Contact)) continue;
                Contact contact = (Contact)account;
                for (int i = -1; i <= 1; ++i) {
                    int currentYear = year + i;
                    if (!this.acceptDate(contact, calendarType, currentYear)) continue;
                    UUID uid = null;
                    try {
                        uid = UUIDConversion.fromString((String)contact.refGetPath().getLastSegment().toString());
                    }
                    catch (Exception e) {
                        uid = UUIDs.newUUID();
                    }
                    String lastModified = dateTimeFormatter.format(new Date());
                    String dtStart = null;
                    String dtEnd = null;
                    String dtDue = null;
                    String valarm = null;
                    String name = "";
                    try {
                        name = contact.getFullName();
                        String age = "";
                        String description = "";
                        GregorianCalendar date = new GregorianCalendar();
                        switch (calendarType) {
                            case BDAYS: {
                                date = new GregorianCalendar();
                                date.setTime(contact.getBirthdate());
                                if (contact.getDateOfDeath() == null) {
                                    age = Integer.toString(currentYear - date.get(1));
                                    description = name + " *" + date.get(1) + " (" + age + ")";
                                    break;
                                }
                                GregorianCalendar dateOfDeath = new GregorianCalendar();
                                dateOfDeath.setTime(contact.getDateOfDeath());
                                description = name + " " + date.get(1) + "-" + dateOfDeath.get(1) + " (+)";
                                break;
                            }
                            case ANNIVERSARIES: {
                                date = new GregorianCalendar();
                                date.setTime(contact.getAnniversary());
                                age = Integer.toString(currentYear - date.get(1));
                                description = name + " #" + date.get(1) + " (" + age + ")";
                                break;
                            }
                            case DATESOFDEATH: {
                                date = new GregorianCalendar();
                                date.setTime(contact.getDateOfDeath());
                                age = Integer.toString(currentYear - date.get(1));
                                description = name + " +" + date.get(1) + " (" + age + ")";
                            }
                        }
                        date.set(1, currentYear);
                        dtStart = "DTSTART;VALUE=DATE:" + dateTimeFormatter.format(date.getTime()).substring(0, 8);
                        if (createAlarm) {
                            GregorianCalendar yesterday = new GregorianCalendar();
                            yesterday.add(5, -1);
                            if (yesterday.compareTo(date) <= 0) {
                                valarm = "BEGIN:VALARM\nACTION:DISPLAY\nDESCRIPTION:" + description + "\nTRIGGER;VALUE=DURATION:-P1D\nEND:VALARM\n";
                            }
                        }
                        date.add(5, 1);
                        dtEnd = "DTEND;VALUE=DATE:" + dateTimeFormatter.format(date.getTime()).substring(0, 8);
                        dtDue = "DUE;VALUE=DATE:" + dateTimeFormatter.format(date.getTime()).substring(0, 8);
                        String emailAddress = Accounts.getInstance().getPrimaryBusinessEMail(account, null);
                        String attendee = null;
                        if (emailAddress != null) {
                            String fullName = contact.getFullName();
                            attendee = fullName == null ? "ATTENDEE;CN=" + emailAddress + ";ROLE=REQ-PARTICIPANT;RSVP=TRUE:MAILTO:" + emailAddress + "\n" : "ATTENDEE;CN=\"" + fullName + " (" + emailAddress + ")\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:MAILTO:" + emailAddress + "\n";
                        }
                        p.write(icalType == 2 ? "BEGIN:VTODO\n" : "BEGIN:VEVENT\n");
                        p.write("UID:" + uid.toString() + "-" + age + "\n");
                        p.write("LAST-MODIFIED:" + lastModified.substring(0, 15) + "Z\n");
                        p.write(dtStart + "\n");
                        p.write(dtEnd + "\n");
                        p.write(dtDue + "\n");
                        p.write(valarm != null ? valarm : "");
                        p.write("CATEGORIES:" + categories + "\n");
                        p.write("DTSTAMP:" + dateTimeFormatter.format(contact.getModifiedAt()).substring(0, 15) + "Z\n");
                        p.write("SUMMARY:" + (summaryPrefix == null || summaryPrefix.isEmpty() ? "" : summaryPrefix + " - ") + description + "\n");
                        p.write("DESCRIPTION:" + description + "\n");
                        p.write(attendee != null ? attendee : "");
                        p.write("PRIORITY:6\n");
                        p.write("STATUS:CONFIRMED\n");
                        p.write("CLASS:PUBLIC\n");
                        String url = Base.getInstance().getAccessUrl(req, "-ical-", contact);
                        p.write("URL:" + url + "\n");
                        p.write(icalType == 2 ? "END:VTODO\n" : "END:VEVENT\n");
                        continue;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                }
                if (++n <= max) continue;
                break;
            }
            p.write("END:VCALENDAR\n");
            p.flush();
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = this.getPersistenceManager(req);
        PersistenceManager rootPm = this.getRootPersistenceManager();
        if (pm == null) {
            resp.setStatus(401);
            return;
        }
        String filterId = req.getParameter("id");
        String isDisabledFilter = req.getParameter("disabled");
        if (req.getRequestURI().endsWith("/ical") || req.getRequestURI().endsWith("/activities")) {
            ActivityQueryHelper activitiesQueryHelper = this.getActivitiesQueryHelper(pm, filterId, isDisabledFilter);
            if (activitiesQueryHelper.getActivitySegment() != null) {
                int maxActivities;
                ComponentConfiguration componentConfiguration = this.getComponentConfiguration(activitiesQueryHelper.getActivitySegment().refGetPath().get(2), rootPm);
                String maxActivitiesValue = componentConfiguration == null ? null : ComponentConfigHelper.getComponentConfigProperty("maxActivities", componentConfiguration).getStringValue();
                int n = maxActivities = maxActivitiesValue == null ? 500 : Integer.valueOf(maxActivitiesValue);
                if ("ics".equals(req.getParameter("type")) || RESOURCE_ACTIVITIES_ICS.equals(req.getParameter("resource"))) {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setStatus(200);
                    resp.setContentType("text/calendar");
                    ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
                    if (activitiesQueryHelper.isDisabledFilter()) {
                        activityQuery.thereExistsDisabled().isTrue();
                    } else {
                        activityQuery.forAllDisabled().isFalse();
                    }
                    activityQuery.ical().isNonNull();
                    activityQuery.forAllExternalLink().startsNotWith((Object)"ICAL-RECURRENCE-ID:");
                    PrintWriter p = resp.getWriter();
                    p.write("BEGIN:VCALENDAR\n");
                    p.write("VERSION:2.0\n");
                    p.write("PRODID://OPENCRX//V2//EN\n");
                    p.write("CALSCALE:GREGORIAN\n");
                    p.write("METHOD:PUBLISH\n");
                    p.write("BEGIN:VEVENT\n");
                    BasicObject source = activitiesQueryHelper.getSource();
                    p.write("UID:" + (source == null ? "-" : source.refGetPath().getLastSegment().toString()) + "\n");
                    p.write("CLASS:PUBLIC\n");
                    p.write("DTSTART:19000101T000000Z\n");
                    p.write("DTEND:19000101T000000Z\n");
                    p.write("LAST-MODIFIED:19000101T000000Z\n");
                    p.write("DTSTAMP:19000101T000000Z\n");
                    p.write("SUMMARY:" + filterId + "\n");
                    p.write("END:VEVENT\n");
                    int n2 = 0;
                    for (Activity activity : activitiesQueryHelper.getFilteredActivities(activityQuery)) {
                        try {
                            SysLog.detail((String)"VEVENT #", (Object)n2);
                            ICalendar.getInstance().printCalendar(p, activity, activitiesQueryHelper, null, true, req, "-ical-");
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                        }
                        if (++n2 <= maxActivities) continue;
                        break;
                    }
                    p.write("END:VCALENDAR\n");
                    p.flush();
                }
            } else {
                super.doGet(req, resp);
            }
        } else if (req.getRequestURI().endsWith(CalendarType.BDAYS.getPath())) {
            this.printCalendar(CalendarType.BDAYS, this.getAccountsHelper(pm, filterId, isDisabledFilter), req, resp);
        } else if (req.getRequestURI().endsWith(CalendarType.ANNIVERSARIES.getPath())) {
            this.printCalendar(CalendarType.ANNIVERSARIES, this.getAccountsHelper(pm, filterId, isDisabledFilter), req, resp);
        } else if (req.getRequestURI().endsWith(CalendarType.DATESOFDEATH.getPath())) {
            this.printCalendar(CalendarType.DATESOFDEATH, this.getAccountsHelper(pm, filterId, isDisabledFilter), req, resp);
        } else {
            super.doGet(req, resp);
        }
        try {
            if (pm != null) {
                pm.close();
            }
            if (rootPm != null) {
                rootPm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum CalendarType {
        BDAYS("/bdays"),
        ANNIVERSARIES("/anniversaries"),
        DATESOFDEATH("/datesofdeath");

        private final String path;

        private CalendarType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

