/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.imap;

import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.mail.MessagingException;
import org.opencrx.application.adapter.AbstractServer;
import org.opencrx.application.adapter.AbstractSession;
import org.opencrx.application.imap.IMAPSession;
import org.opencrx.kernel.activity1.cci2.SegmentContainsActivityCategory;
import org.opencrx.kernel.activity1.cci2.SegmentContainsActivityMilestone;
import org.opencrx.kernel.activity1.cci2.SegmentContainsActivityTracker;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.Segment;
import org.opencrx.kernel.generic.SecurityKeys;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.Base64;

public class IMAPServer
extends AbstractServer {
    private static final long FOLDER_REFRESH_PERIOD_MILLIS = 300000L;
    protected Map<String, Map<String, String>> availableFolders = new ConcurrentHashMap<String, Map<String, String>>();
    protected long refreshFoldersAt = System.currentTimeMillis();

    protected IMAPServer(PersistenceManagerFactory pmf, String providerName, String bindAddress, int portNumber, String sslKeystoreFile, String sslKeystoreType, String sslKeystorePass, String sslKeyPass, String sslTruststoreFile, String sslTruststorePass, String sslTruststoreType, Boolean sslNeedClientAuth, boolean isDebug, int delayOnStartup) {
        super("IMAPServer", pmf, providerName, bindAddress, portNumber, sslKeystoreFile, sslKeystoreType, sslKeystorePass, sslKeyPass, sslTruststoreFile, sslTruststorePass, sslTruststoreType, sslNeedClientAuth, isDebug, delayOnStartup);
    }

    @Override
    public AbstractSession newSession(Socket socket, AbstractServer server) {
        return new IMAPSession(socket, server);
    }

    protected String encodeFolderName(String name) {
        name = name.replace("/", ".");
        StringBuilder encodedName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c <= '\u007f' && c != '&') {
                encodedName.append(c);
                continue;
            }
            if (c == '&') {
                encodedName.append("&-");
                continue;
            }
            String base64EncodedChar = Base64.encode((byte[])new byte[]{(byte)(c / 256), (byte)(c % 256)});
            encodedName.append("&" + base64EncodedChar.substring(0, base64EncodedChar.length() - 1) + "-");
        }
        return encodedName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAvailableFolders(String segmentName) throws MessagingException {
        if (System.currentTimeMillis() > this.refreshFoldersAt || this.availableFolders.get(segmentName) == null) {
            try (PersistenceManager pm = AbstractSession.newPersistenceManager(this.getPersistenceManagerFactory(), "admin" + SecurityKeys.ID_SEPARATOR + segmentName + "@" + segmentName);){
                Object group;
                HashMap<String, String> folders = new HashMap<String, String>();
                String providerName = this.getProviderName();
                Segment activitySegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
                SegmentContainsActivityTracker.ActivityTracker trackers = activitySegment.getActivityTracker();
                Iterator iterator = trackers.iterator();
                while (iterator.hasNext()) {
                    group = (ActivityGroup)iterator.next();
                    String groupUri = "/" + providerName + "/" + segmentName + "/tracker/";
                    folders.put("INBOX" + groupUri + this.encodeFolderName(group.getName()), groupUri + group.getName());
                }
                SegmentContainsActivityMilestone.ActivityMilestone milestones = activitySegment.getActivityMilestone();
                group = milestones.iterator();
                while (group.hasNext()) {
                    ActivityGroup group2 = (ActivityGroup)group.next();
                    String groupUri = "/" + providerName + "/" + segmentName + "/milestone/";
                    folders.put("INBOX" + groupUri + this.encodeFolderName(group2.getName()), groupUri + group2.getName());
                }
                SegmentContainsActivityCategory.ActivityCategory categories = activitySegment.getActivityCategory();
                Iterator iterator2 = categories.iterator();
                while (iterator2.hasNext()) {
                    ActivityGroup group3 = (ActivityGroup)iterator2.next();
                    String groupUri = "/" + providerName + "/" + segmentName + "/category/";
                    folders.put("INBOX" + groupUri + this.encodeFolderName(group3.getName()), groupUri + group3.getName());
                }
                this.availableFolders.put(segmentName, folders);
                this.refreshFoldersAt = System.currentTimeMillis() + 300000L;
            }
        }
        return this.availableFolders.get(segmentName);
    }
}

