/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.imap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.SubjectTerm;
import org.opencrx.application.adapter.AbstractServer;
import org.opencrx.application.adapter.AbstractSession;
import org.opencrx.application.imap.IMAPFolderImpl;
import org.opencrx.application.imap.IMAPServer;
import org.opencrx.kernel.utils.MimeUtils;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.kernel.text.format.HexadecimalFormatter;
import org.w3c.format.DateTimeFormat;

public class IMAPSession
extends AbstractSession {
    private static final int MAX_LINE_LENGTH = 2048;
    public static final long MAX_ACTIVITY_NUMBER = 9999999999L;
    protected OutputStream out = null;
    protected InputStream in = null;
    protected SessionState state = SessionState.NOT_AUTHENTICATED;
    protected IMAPFolderImpl selectedFolder = null;
    private static ThreadLocal<QuotaByteArrayOutputStream> byteOutputStreams = new ThreadLocal<QuotaByteArrayOutputStream>(){

        @Override
        protected synchronized QuotaByteArrayOutputStream initialValue() {
            return new QuotaByteArrayOutputStream(IMAPSession.class.getName());
        }
    };

    public IMAPSession(Socket client, AbstractServer server) {
        super(client, server);
    }

    private IMAPServer getServer() {
        return (IMAPServer)this.server;
    }

    private String readLine() throws IOException {
        StringBuilder line;
        block3: {
            line = new StringBuilder();
            do {
                char c;
                if ((c = (char)this.in.read()) == '\r') {
                    c = (char)this.in.read();
                }
                if (c == '\n') break block3;
                if (c <= '\u0000' || c > '\u00ff') {
                    return null;
                }
                line.append(c);
            } while (line.length() <= 2048);
            SysLog.info((String)"Error: line too long. Details:", Arrays.asList(this.username, line.length(), line.substring(0, 80) + "..."));
        }
        return line.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.socket == null || !this.socket.isConnected()) {
            System.out.println("Unable to start conversation, invalid connection passed to client handler");
        } else {
            SysLog.info((String)"Session started for client", (Object)this.socket.getInetAddress().getHostAddress());
            try {
                this.out = new PrintStream(this.socket.getOutputStream());
                this.in = this.socket.getInputStream();
                this.println("* OK [CAPABILTY IMAP4rev1 IDLE] OPENCRX");
                String line = this.readLine();
                Pattern pattern = Pattern.compile("([a-zA-Z0-9]+) ([a-zA-Z0-9]+)(.*)");
                while (line != null) {
                    String params;
                    String command;
                    String tag;
                    Matcher matcher;
                    if (line.indexOf("LOGIN") > 0 && line.indexOf(" ") > 0) {
                        System.out.println(">>> IMAPServer[" + this.socket.getInetAddress() + "]\n" + line.substring(0, line.lastIndexOf(" ")));
                    } else if (line.indexOf("LOGOUT") > 0) {
                        System.out.println(">>> IMAPServer[" + this.socket.getInetAddress() + "]\n" + line + " " + this.username);
                    }
                    if (this.getServer().isDebug()) {
                        System.out.println(">>> IMAPServer[" + this.socket.getInetAddress() + "]\n" + line);
                    }
                    if ((matcher = pattern.matcher(line)).find() && !this.handleCommand(tag = matcher.group(1), command = matcher.group(2), params = matcher.group(3))) {
                        this.socket.close();
                        return;
                    }
                    line = this.readLine();
                }
                SysLog.info((String)"connection closed", (Object)this.socket.getInetAddress().getHostAddress());
            }
            catch (Exception e) {
                if (!(e instanceof SocketTimeoutException)) {
                    ServiceException e0 = new ServiceException(e);
                    SysLog.warning((String)e0.getMessage(), (Throwable)e0.getCause());
                }
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleCommand(String tag, String command, String params) throws MessagingException {
        block103: {
            if ("CAPABILITY".equals(command = command.toUpperCase())) {
                this.println("* CAPABILITY IMAP4rev1 IDLE");
                this.println(tag + " OK CAPABILITY complete");
            } else if ("NOOP".equals(command)) {
                this.println(tag + " OK NOOP completed");
            } else {
                if ("LOGOUT".equals(command)) {
                    this.println("* BYE IMAP4rev1 Server logging out");
                    this.println(tag + " OK LOGOUT complete");
                    this.logout();
                    try {
                        return false;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        break block103;
                    }
                }
                switch (this.state) {
                    case NOT_AUTHENTICATED: {
                        if ("LOGIN".equals(command)) {
                            String string;
                            String username = "";
                            String string2 = "";
                            try {
                                String[] bits = params.split(" ");
                                username = bits[1].replace("\"", "");
                                string = bits[2].replace("\"", "");
                            }
                            catch (Exception e) {
                                this.println(tag + " BAD parameters");
                                return true;
                            }
                            if (this.login(username, string)) {
                                this.state = SessionState.AUTHENTICATED;
                                this.println(tag + " OK User logged in");
                                this.selectedFolder = this.getFolder("INBOX");
                                break;
                            }
                            this.println(tag + " NO LOGIN failed.");
                            break;
                        }
                        this.unrecognizedCommand(tag, command);
                        break;
                    }
                    case AUTHENTICATED: {
                        if ("SELECT".equals(command)) {
                            params = params.replace("\"", "");
                            params = params.trim().toUpperCase();
                            this.selectedFolder = null;
                            IMAPFolderImpl folder = this.getFolder(params);
                            if (folder != null) {
                                this.selectedFolder = folder;
                                this.println("* " + folder.getMessageCount() + " EXISTS");
                                this.println("* 0 RECENT");
                                this.println("* OK [UIDVALIDITY " + folder.getUIDValidity() + "] UID validity status");
                                this.println(tag + " OK [" + (folder.getMode() == 1 ? "READ-ONLY" : "READ-WRITE") + "] complete");
                            }
                            if (this.selectedFolder != null) break;
                            this.println(tag + " NO SELECT failed, no mailbox with that name");
                            break;
                        }
                        if ("STATUS".equals(command)) {
                            if (params.indexOf(" (") > 0) {
                                params = params.substring(0, params.indexOf(" ("));
                            }
                            params = params.replace("\"", "");
                            IMAPFolderImpl folder = this.getFolder(params = params.trim().toUpperCase());
                            if (folder != null) {
                                this.selectedFolder = folder;
                                this.println("* " + folder.getMessageCount() + " EXISTS");
                                this.println("* 0 RECENT");
                                this.println("* OK [UIDVALIDITY " + folder.getUIDValidity() + "] UID validity status");
                                this.println(tag + " OK [" + (folder.getMode() == 1 ? "READ-ONLY" : "READ-WRITE") + "] complete");
                                break;
                            }
                            this.println(tag + " NO STATUS failed, no mailbox with that name");
                            break;
                        }
                        if ("EXAMINE".equals(command)) {
                            params = params.replace("\"", "");
                            IMAPFolderImpl folder = this.getFolder(params = params.trim().toUpperCase());
                            if (folder != null) {
                                this.selectedFolder = folder;
                                this.println("* " + folder.getMessageCount() + " EXISTS");
                                this.println("* 0 RECENT");
                                this.println("* OK [UIDVALIDITY " + folder.getUIDValidity() + "] UID validity status");
                                this.println(tag + " OK [" + (folder.getMode() == 1 ? "READ-ONLY" : "READ-WRITE") + "] complete");
                                break;
                            }
                            this.println(tag + " NO EXAMINE failed, no mailbox with that name");
                            break;
                        }
                        if ("CREATE".equals(command)) {
                            this.println(tag + " NO command not supported");
                            break;
                        }
                        if ("DELETE".equals(command)) {
                            this.println(tag + " NO command not supported");
                            break;
                        }
                        if ("RENAME".equals(command)) {
                            this.println(tag + " NO command not supported");
                            break;
                        }
                        if ("LIST".equals(command)) {
                            Pattern pattern = Pattern.compile(" \"([a-zA-Z0-9]*)\" \"([a-zA-Z0-9*%]*)\"");
                            Matcher matcher = pattern.matcher(params);
                            if (matcher.find()) {
                                String folderName = matcher.group(1);
                                String query = matcher.group(2);
                                if ("".equals(folderName)) {
                                    Map<String, String> availableFolders = this.getServer().getAvailableFolders(this.segmentName);
                                    for (String folder : availableFolders.keySet()) {
                                        if (!folder.equals(query) && query.length() != 0 && (!query.endsWith("*") && !query.endsWith("%") || !folder.startsWith(query.substring(0, query.length() - 1)))) continue;
                                        this.println("* LIST () \"/\" \"" + folder + "\"");
                                    }
                                }
                            }
                            this.println(tag + " OK LIST complete");
                            break;
                        }
                        if ("LSUB".equals(command)) {
                            for (Folder folder : this.getSubscribedFolders()) {
                                this.println("* LSUB () \"/\" \"" + folder.getFullName() + "\"");
                            }
                            this.println(tag + " OK LSUB complete");
                            break;
                        }
                        if ("SUBSCRIBE".equals(command)) {
                            params = params.replace("\"", "");
                            params = params.trim();
                            Map<String, String> availableFolders = this.getServer().getAvailableFolders(this.segmentName);
                            if (availableFolders.containsKey(params)) {
                                this.subscribeFolder(params, availableFolders);
                                this.println(tag + " OK SUBSCRIBE complete");
                                break;
                            }
                            this.println(tag + " NO SUBSCRIBE invalid folder name");
                            break;
                        }
                        if ("UNSUBSCRIBE".equals(command)) {
                            boolean bl;
                            params = params.replace("\"", "");
                            params = params.trim();
                            List<IMAPFolderImpl> subscribedFolders = this.getSubscribedFolders();
                            boolean bl2 = false;
                            for (IMAPFolderImpl folder : subscribedFolders) {
                                if (!folder.getFullName().equals(params)) continue;
                                this.unsubscribeFolder(params);
                                bl = true;
                                break;
                            }
                            if (bl) {
                                this.println(tag + " OK UNSUBSCRIBE complete");
                                break;
                            }
                            this.println(tag + " NO UNSUBSCRIBE invalid folder name");
                            break;
                        }
                        if ("APPEND".equals(command)) {
                            boolean hasDate = true;
                            Pattern pattern = Pattern.compile(" \"(.*)\"(?: \\((.*)\\))? \"(.*)\" \\{([0-9]+)\\}");
                            Matcher matcher = pattern.matcher(params);
                            boolean matches = matcher.find();
                            if (!matches) {
                                hasDate = false;
                                Pattern pattern2 = Pattern.compile(" \"(.*)\"(?: \\((.*)\\))? \\{([0-9]+)\\}");
                                matcher = pattern2.matcher(params);
                                matches = matcher.find();
                            }
                            if (matches) {
                                try {
                                    String date;
                                    int size = Integer.valueOf(matcher.group(hasDate ? 4 : 3));
                                    IMAPFolderImpl folder = this.getFolder(matcher.group(1));
                                    String string = date = hasDate ? matcher.group(3) : null;
                                    if (folder != null) {
                                        this.println("+ OK");
                                        if (this.getServer().isDebug()) {
                                            System.out.println("Reading " + size + " bytes");
                                        }
                                        byte[] msg = new byte[size];
                                        boolean success = true;
                                        int i = 0;
                                        for (i = 0; i < size; ++i) {
                                            int c;
                                            if (this.getServer().isDebug() && i > 0 && i % 1000 == 0) {
                                                System.out.println(i + " bytes");
                                            }
                                            if ((c = this.in.read()) < 0) {
                                                success = false;
                                                break;
                                            }
                                            msg[i] = (byte)c;
                                        }
                                        if (this.getServer().isDebug()) {
                                            System.out.println(new String(msg, "iso-8859-1"));
                                            System.out.println();
                                            System.out.println(new HexadecimalFormatter(msg, 0, size).toString());
                                            System.out.println();
                                            System.out.flush();
                                        }
                                        if (success) {
                                            MimeUtils.MimeMessageImpl message = new MimeUtils.MimeMessageImpl(new ByteArrayInputStream(msg));
                                            if (date != null) {
                                                message.setHeader("Date", date);
                                            }
                                            folder.appendMessages(new Message[]{message});
                                            this.println(tag + " OK APPEND complete");
                                            break;
                                        }
                                        this.println(tag + " NO invalid message");
                                        break;
                                    }
                                    this.println(tag + " NO folder not found");
                                }
                                catch (Exception e) {
                                    this.println(tag + " NO invalid message");
                                }
                                break;
                            }
                            this.println(tag + " NO invalid parameter");
                            break;
                        }
                        if ("CHECK".equals(command)) {
                            this.println(tag + " OK CHECK complete");
                            break;
                        }
                        if ("CLOSE".equals(command)) {
                            this.println(tag + " OK CLOSE complete");
                            this.state = SessionState.AUTHENTICATED;
                            break;
                        }
                        if ("EXPUNGE".equals(command)) {
                            this.println(tag + " NO EXPUNGE command not supported");
                            break;
                        }
                        if ("SEARCH".equals(command)) {
                            SearchTerm searchTerm = null;
                            try {
                                searchTerm = SearchTermParser.parseSearchTerm(params.substring(6));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Message[] messageArray = this.selectedFolder.search(searchTerm);
                            String ids = "";
                            for (Message message : messageArray) {
                                if (!(message instanceof MimeMessage)) continue;
                                ids = ids + " " + message.getMessageNumber();
                            }
                            this.println("* SEARCH" + ids);
                            this.println(tag + " OK SEARCH completed");
                            break;
                        }
                        if ("IDLE".equals(command)) {
                            long timeoutAtMillis = System.currentTimeMillis() + 1800000L;
                            boolean idling = false;
                            int oldCount = this.selectedFolder.getMessageCount();
                            this.println("+ idling");
                            block31: while (idling = System.currentTimeMillis() < timeoutAtMillis) {
                                int count;
                                try {
                                    for (int i = 0; i < 20; ++i) {
                                        String l = null;
                                        try {
                                            if (this.in.available() > 0) {
                                                l = this.readLine();
                                            }
                                        }
                                        catch (Exception message) {
                                            // empty catch block
                                        }
                                        if ("DONE".equalsIgnoreCase(l)) {
                                            this.println(tag + " OK IDLE terminated");
                                            break block31;
                                        }
                                        Thread.sleep(500L);
                                    }
                                }
                                catch (Exception i) {
                                    // empty catch block
                                }
                                if ((count = this.selectedFolder.getMessageCount()) == oldCount) continue;
                                if (count < oldCount) {
                                    this.println("* " + Integer.toString(oldCount - count) + " EXPUNGE");
                                }
                                this.println("* " + Integer.toString(count) + " EXISTS");
                                oldCount = count;
                            }
                            if (idling) break;
                            this.println("* BYE IMAP4rev1 Server logging out");
                            this.println(tag + " OK LOGOUT complete");
                            this.logout();
                            try {
                                return false;
                            }
                            catch (Exception e) {
                                new ServiceException(e).log();
                                break;
                            }
                        }
                        if ("FETCH".equals(command)) {
                            int posCommands = params.indexOf("(");
                            StringTokenizer stringTokenizer = new StringTokenizer(params.substring(0, posCommands), " ", false);
                            if (stringTokenizer.countTokens() != 1) break;
                            ArrayList<int[]> messageNumbers = new ArrayList<int[]>();
                            StringTokenizer g = new StringTokenizer(stringTokenizer.nextToken(), ",", false);
                            while (g.hasMoreTokens()) {
                                try {
                                    String number = g.nextToken();
                                    if (number == null) continue;
                                    int start = -1;
                                    int end = -1;
                                    if (number.indexOf(":") > 0) {
                                        Message[] startAsString = number.substring(0, number.indexOf(":"));
                                        start = "*".equals(startAsString) ? 0 : Integer.valueOf((String)startAsString);
                                        String endAsString = number.substring(number.indexOf(":") + 1);
                                        end = "*".equals(endAsString) ? 0 : Integer.valueOf(endAsString);
                                    } else {
                                        end = start = Integer.valueOf(number).intValue();
                                    }
                                    messageNumbers.add(new int[]{start, end});
                                }
                                catch (Exception number) {}
                            }
                            String fetchParams = params.substring(posCommands);
                            for (int[] messageNumber : messageNumbers) {
                                for (Message message : this.selectedFolder.getMessages(messageNumber[0], messageNumber[1])) {
                                    if (!(message instanceof MimeMessage)) continue;
                                    List<String> commands = this.getFetchCommands(fetchParams);
                                    this.print("* " + message.getMessageNumber() + " FETCH (");
                                    int n = 0;
                                    for (String cmd : commands) {
                                        boolean success = this.processFetchCommand(cmd, (MimeMessage)message, n);
                                        if (!success) continue;
                                        ++n;
                                    }
                                    this.println(")");
                                }
                            }
                            this.println(tag + " OK FETCH complete");
                            break;
                        }
                        if ("STORE".equals(command)) {
                            this.println(tag + " NO STORE command not supported");
                            break;
                        }
                        if ("COPY".equals(command)) {
                            this.println(tag + " NO COPY command not supported");
                            break;
                        }
                        if ("UID".equals(command)) {
                            String uidCommand = params.trim().toUpperCase();
                            if (uidCommand.startsWith("FETCH")) {
                                int n = params.indexOf("(");
                                StringTokenizer p = new StringTokenizer(params.substring(0, n), " ", false);
                                if (p.countTokens() != 2) break;
                                ArrayList<long[]> messageUids = new ArrayList<long[]>();
                                p.nextToken();
                                StringTokenizer g = new StringTokenizer(p.nextToken(), ",", false);
                                while (g.hasMoreTokens()) {
                                    try {
                                        String uid = g.nextToken();
                                        if (uid == null) continue;
                                        long start = -1L;
                                        long end = -1L;
                                        if (uid.indexOf(":") > 0) {
                                            String startAsString = uid.substring(0, uid.indexOf(":"));
                                            start = "*".equals(startAsString) ? 0L : Long.valueOf(startAsString);
                                            String endAsString = uid.substring(uid.indexOf(":") + 1);
                                            end = "*".equals(endAsString) ? 9999999999L : Long.valueOf(endAsString);
                                        } else {
                                            end = start = Long.valueOf(uid).longValue();
                                        }
                                        messageUids.add(new long[]{start, end});
                                    }
                                    catch (Exception uid) {}
                                }
                                String fetchParams = params.substring(n);
                                for (long[] messageUid : messageUids) {
                                    for (Message message : this.selectedFolder.getMessagesByUID(messageUid[0], messageUid[1])) {
                                        if (!(message instanceof MimeMessage)) continue;
                                        List<String> commands = this.getFetchCommands(fetchParams);
                                        if (!commands.contains("UID")) {
                                            commands.add(0, "UID");
                                        }
                                        this.print("* " + message.getMessageNumber() + " FETCH (");
                                        int n2 = 0;
                                        for (String cmd : commands) {
                                            boolean success = this.processFetchCommand(cmd, (MimeMessage)message, n2);
                                            if (!success) continue;
                                            ++n2;
                                        }
                                        this.println(")");
                                    }
                                }
                                this.println(tag + " OK UID complete");
                                break;
                            }
                            if (uidCommand.startsWith("SEARCH")) {
                                void var5_33;
                                Object var5_31 = null;
                                try {
                                    SearchTerm searchTerm = SearchTermParser.parseSearchTerm(uidCommand.substring(6));
                                }
                                catch (Exception p) {
                                    // empty catch block
                                }
                                Message[] messages = this.selectedFolder.search((SearchTerm)var5_33);
                                String ids = "";
                                for (Message message : messages) {
                                    if (!(message instanceof MimeMessage)) continue;
                                    ids = ids + " " + message.getMessageNumber();
                                }
                                this.println("* SEARCH" + ids);
                                this.println(tag + " OK SEARCH completed");
                                break;
                            }
                            if ("COPY".equals(uidCommand)) {
                                IMAPFolderImpl folder;
                                Pattern pattern = Pattern.compile(" (?:COPY|copy) ([0-9*\\:]+)(?:,([0-9*\\:]+))* \"(.*)\"");
                                Matcher matcher = pattern.matcher(params);
                                if (matcher.find() && (folder = this.getFolder(matcher.group(matcher.groupCount()))) != null) {
                                    ArrayList<long[]> messageUids = new ArrayList<long[]>();
                                    for (int i = 1; i < matcher.groupCount(); ++i) {
                                        try {
                                            String uid = matcher.group(i);
                                            if (uid == null) continue;
                                            long start = -1L;
                                            long end = -1L;
                                            if (uid.indexOf(":") > 0) {
                                                String startAsString = uid.substring(0, uid.indexOf(":"));
                                                start = "*".equals(startAsString) ? 0L : Long.valueOf(startAsString);
                                                String endAsString = uid.substring(uid.indexOf(":") + 1);
                                                end = "*".equals(endAsString) ? 9999999999L : Long.valueOf(endAsString);
                                            } else {
                                                end = start = Long.valueOf(uid).longValue();
                                            }
                                            messageUids.add(new long[]{start, end});
                                            continue;
                                        }
                                        catch (Exception uid) {
                                            // empty catch block
                                        }
                                    }
                                    for (long[] messageUid : messageUids) {
                                        ArrayList<MimeUtils.MimeMessageImpl> newMessages = new ArrayList<MimeUtils.MimeMessageImpl>();
                                        for (Message message : this.selectedFolder.getMessagesByUID(messageUid[0], messageUid[1])) {
                                            if (!(message instanceof MimeMessage)) continue;
                                            newMessages.add(new MimeUtils.MimeMessageImpl((MimeMessage)message));
                                        }
                                        folder.appendMessages((Message[])newMessages.toArray(new MimeMessage[newMessages.size()]));
                                    }
                                }
                                this.println(tag + " OK UID complete");
                                break;
                            }
                            this.println(tag + " NO UID" + params + " command not supported");
                            break;
                        }
                        this.unrecognizedCommand(tag, command);
                    }
                }
            }
        }
        return true;
    }

    public void unrecognizedCommand(String tag, String command) {
        SysLog.detail((String)"Could not", (Object)(tag + " " + command));
        this.println(tag + " BAD " + command);
    }

    public List<String> getFetchCommands(String fetchParams) {
        ArrayList<String> fetchCommands = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\.]+(\\[\\])?(\\[[a-zA-Z0-9\\.()\\- ]+\\])?");
        Matcher matcher = pattern.matcher(fetchParams);
        while (matcher.find()) {
            String newCommand = matcher.group(0);
            if (!newCommand.startsWith("BODY")) {
                fetchCommands.add(0, newCommand);
            } else {
                fetchCommands.add(newCommand);
            }
            fetchParams = fetchParams.substring(newCommand.length()).trim();
            matcher = pattern.matcher(fetchParams);
        }
        return fetchCommands;
    }

    protected void getBodyAsRFC822(MimePart part, boolean ignoreHeaders, QuotaByteArrayOutputStream out) {
        try {
            out.reset();
            if (ignoreHeaders) {
                OutputStream os = MimeUtility.encode((OutputStream)out, (String)part.getEncoding());
                part.getDataHandler().writeTo(os);
                os.flush();
            } else {
                part.writeTo((OutputStream)out);
                out.close();
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected int getBodyLength(MimePart part, boolean ignoreHeaders) {
        try {
            QuotaByteArrayOutputStream bos = byteOutputStreams.get();
            bos.reset();
            if (ignoreHeaders) {
                OutputStream os = MimeUtility.encode((OutputStream)bos, (String)part.getEncoding());
                part.getDataHandler().writeTo(os);
                os.flush();
            } else {
                part.writeTo((OutputStream)bos);
                bos.close();
            }
            return bos.size();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            return 0;
        }
    }

    protected String getMessageFlags(Message message) throws MessagingException {
        return "\\Seen";
    }

    public boolean processFetchCommand(String params, MimeMessage message, int count) throws MessagingException {
        block55: {
            String command = params;
            if (params.indexOf(" ") != -1) {
                command = params.substring(0, params.indexOf(" "));
                params = params.substring(params.indexOf(" ")).trim();
            }
            if ((command = command.toUpperCase()).equals("FLAGS")) {
                if (count > 0) {
                    this.print(" ");
                }
                this.print("FLAGS (" + this.getMessageFlags((Message)message) + ")");
                return true;
            }
            if (command.equals("RFC822")) {
                if (count > 0) {
                    this.print(" ");
                }
                QuotaByteArrayOutputStream messageRFC822 = byteOutputStreams.get();
                this.getBodyAsRFC822((MimePart)message, false, messageRFC822);
                this.println("RFC822 {" + (messageRFC822.size() + 2) + "}");
                this.printBytes(messageRFC822);
                this.println("");
                return true;
            }
            if (command.equals("RFC822.HEADER")) {
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, MimeUtils.STANDARD_HEADER_FIELDS);
                if (count > 0) {
                    this.print(" ");
                }
                this.println("RFC822 {" + (temp.length() + 2) + "}");
                this.print(temp);
                return true;
            }
            if (command.equals("RFC822.SIZE")) {
                if (count > 0) {
                    this.print(" ");
                }
                int length = this.getBodyLength((MimePart)message, false);
                this.print("RFC822.SIZE " + length);
                return true;
            }
            if (command.equals("UID")) {
                if (count > 0) {
                    this.print(" ");
                }
                this.print("UID " + this.selectedFolder.getUID((Message)message));
                return true;
            }
            if (command.equals("BODY[]") || command.equals("BODY.PEEK[]")) {
                if (count > 0) {
                    this.print(" ");
                }
                QuotaByteArrayOutputStream messageRFC822 = byteOutputStreams.get();
                this.getBodyAsRFC822((MimePart)message, false, messageRFC822);
                this.println("BODY[] {" + (messageRFC822.size() + 2) + "}");
                this.printBytes(messageRFC822);
                this.println("");
                return true;
            }
            if (command.equals("BODY[HEADER]")) {
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, MimeUtils.STANDARD_HEADER_FIELDS);
                if (count > 0) {
                    this.print(" ");
                }
                this.println("BODY[HEADER] {" + (temp.length() + 2) + "}");
                this.print(temp);
                return true;
            }
            if (command.matches("BODY\\.PEEK\\[([0-9]+)(?:\\.MIME)?\\]")) {
                try {
                    Pattern pattern;
                    Matcher matcher;
                    if (message.getContent() instanceof MimeMultipart && (matcher = (pattern = Pattern.compile("BODY\\.PEEK\\[([0-9]+)(?:\\.MIME)?\\]")).matcher(command)).find()) {
                        int partId = Integer.valueOf(matcher.group(1));
                        if (command.indexOf(".MIME") > 0) {
                            String temp = MimeUtils.getHeadersAsRFC822((Part)((MimeMultipart)message.getContent()).getBodyPart(partId - 1), new String[]{"Content-Type", "Content-Disposition", "Content-Transfer-Encoding"});
                            if (count > 0) {
                                this.print(" ");
                            }
                            this.println("BODY[" + partId + ".MIME] {" + (temp.length() + 2) + "}");
                            this.println(temp);
                            return true;
                        }
                        QuotaByteArrayOutputStream temp = byteOutputStreams.get();
                        this.getBodyAsRFC822((MimePart)((MimeMultipart)message.getContent()).getBodyPart(partId - 1), true, temp);
                        if (count > 0) {
                            this.print(" ");
                        }
                        this.println("BODY[" + partId + "] {" + (temp.size() + 2) + "}");
                        this.printBytes(temp);
                        this.println("");
                        return true;
                    }
                    break block55;
                }
                catch (IOException e) {
                    throw new MessagingException(e.getMessage());
                }
            }
            if (command.equals("BODY[TEXT]")) {
                if (count > 0) {
                    this.print(" ");
                }
                QuotaByteArrayOutputStream messageRFC822 = byteOutputStreams.get();
                this.getBodyAsRFC822((MimePart)message, false, messageRFC822);
                this.println("BODY[TEXT] {" + (messageRFC822.size() + 2) + "}");
                this.printBytes(messageRFC822);
                this.println("");
                return true;
            }
            if (command.equals("BODY[HEADER.FIELDS")) {
                params = params.replace("]", "");
                params = params.replace("(", "");
                params = params.replace(")", "");
                params = params.replace("\"", "");
                if (count > 0) {
                    this.print(" ");
                }
                this.print("BODY[HEADER.FIELDS (");
                String[] fields = params.split(" ");
                int n = 0;
                for (int i = 0; i < fields.length; ++i) {
                    if (n > 0) {
                        this.print(" ");
                    }
                    this.print("\"" + fields[i].toUpperCase() + "\"");
                    ++n;
                }
                this.print(")] ");
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, fields);
                this.println("{" + (temp.length() + 2) + "}");
                this.println(temp);
                return true;
            }
            if (command.equals("BODY[HEADER.FIELDS.NOT")) {
                params = params.replace("]", "");
                params = params.replace("(", "");
                params = params.replace(")", "");
                params = params.replace("\"", "");
                String[] fields = params.split(" ");
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, fields);
                if (count > 0) {
                    this.print(" ");
                }
                this.println("BODY[HEADER.FIELDS.NOT" + params + " {" + (temp.length() + 2) + "}");
                this.println(temp);
                return true;
            }
            if (command.equals("BODY.PEEK[TEXT]")) {
                if (count > 0) {
                    this.print(" ");
                }
                QuotaByteArrayOutputStream messageRFC822 = byteOutputStreams.get();
                this.getBodyAsRFC822((MimePart)message, false, messageRFC822);
                this.println("BODY[TEXT] {" + (messageRFC822.size() + 2) + "}");
                this.printBytes(messageRFC822);
                this.println("");
                return true;
            }
            if (command.equals("BODY.PEEK[HEADER]")) {
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, MimeUtils.STANDARD_HEADER_FIELDS);
                if (count > 0) {
                    this.print(" ");
                }
                this.println("BODY[HEADER] {" + (temp.length() + 2) + "}");
                this.println(temp);
                return true;
            }
            if (command.equals("BODY.PEEK[HEADER.FIELDS")) {
                params = params.replace("]", "");
                params = params.replace("(", "");
                params = params.replace(")", "");
                params = params.replace("\"", "");
                if (count > 0) {
                    this.print(" ");
                }
                this.print("BODY[HEADER.FIELDS (");
                String[] fields = params.split(" ");
                int n = 0;
                for (int i = 0; i < fields.length; ++i) {
                    if (n > 0) {
                        this.print(" ");
                    }
                    this.print("\"" + fields[i].toUpperCase() + "\"");
                    ++n;
                }
                this.print(")] ");
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, fields);
                this.println("{" + (temp.length() + 2) + "}");
                this.println(temp);
                return true;
            }
            if (command.equals("BODY.PEEK[HEADER.FIELDS.NOT")) {
                params = params.replace("]", "");
                params = params.replace("(", "");
                params = params.replace(")", "");
                params = params.replace("\"", "");
                String[] fields = params.split(" ");
                String temp = MimeUtils.getHeadersAsRFC822((Part)message, fields);
                if (count > 0) {
                    this.print(" ");
                }
                this.println("BODY[HEADER.FIELDS.NOT" + params + " {" + (temp.length() + 2) + "}");
                this.println(temp);
                return true;
            }
            if (command.equals("INTERNALDATE")) {
                if (count > 0) {
                    this.print(" ");
                }
                this.print("INTERNALDATE ");
                this.printList(message.getHeader("Date"), true);
                return true;
            }
            if (command.equals("ENVELOPE")) {
                if (count > 0) {
                    this.print(" ");
                }
                this.print("ENVELOPE (");
                this.printList(message.getHeader("Date"), true);
                this.print(" ");
                String[] subjects = message.getHeader("Subject");
                if (subjects != null && subjects.length > 0) {
                    String subject = subjects[0].replace("\r\n", " ");
                    subject = subject.replace("\r", " ");
                    subject = subject.replace("\n", " ");
                    this.printList(new String[]{subject}, true);
                }
                try {
                    this.printAddresses(message.getFrom(), 1);
                }
                catch (Exception e) {
                    this.printAddresses(null, 1);
                }
                try {
                    this.printAddresses(message.getFrom(), 1);
                }
                catch (Exception e) {
                    this.printAddresses(null, 1);
                }
                try {
                    this.printAddresses(message.getFrom(), 1);
                }
                catch (Exception e) {
                    this.printAddresses(null, 1);
                }
                try {
                    this.printAddresses(message.getAllRecipients(), 1);
                }
                catch (Exception e) {
                    this.printAddresses(null, 1);
                }
                this.print(" NIL NIL NIL ");
                this.printList(message.getHeader("Message-Id"), true);
                this.print(")");
                return true;
            }
            if (command.equals("BODYSTRUCTURE")) {
                if (count > 0) {
                    this.print(" ");
                }
                this.print("BODYSTRUCTURE ");
                this.printMessageStructure((Message)message);
                return true;
            }
        }
        return false;
    }

    private void amendSubscriptions(List<IMAPFolderImpl> folders) {
        try {
            PrintStream ps;
            File mailDir = IMAPFolderImpl.getMailDir(this.username);
            mailDir.mkdirs();
            File subscriptionsFile = new File(mailDir, ".SUBSCRIPTIONS-" + this.getServer().getProviderName());
            if (!subscriptionsFile.exists()) {
                ps = new PrintStream(subscriptionsFile);
                ps.println();
                ps.close();
            }
            ps = new PrintStream(subscriptionsFile);
            for (IMAPFolderImpl f : folders) {
                ps.println(f.getFullName());
            }
            ps.close();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    private void unsubscribeFolder(String name) throws MessagingException {
        List<IMAPFolderImpl> folders = this.getSubscribedFolders();
        Iterator<IMAPFolderImpl> i = folders.iterator();
        while (i.hasNext()) {
            IMAPFolderImpl folder = i.next();
            if (!folder.getFullName().equals(name)) continue;
            if (!"INBOX".equalsIgnoreCase(name)) {
                try {
                    File dest = new File(folder.folderDir.getParentFile(), folder.folderDir.getName() + "-" + UUIDConversion.toUID((UUID)UUIDs.newUUID()) + ".UNSUBSCRIBE");
                    folder.folderDir.renameTo(dest);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
            i.remove();
            break;
        }
        this.amendSubscriptions(folders);
    }

    private void subscribeFolder(String name, Map<String, String> availableFolders) throws MessagingException {
        List<IMAPFolderImpl> folders = this.getSubscribedFolders();
        for (IMAPFolderImpl folder : folders) {
            if (!name.equals(folder.getFullName())) continue;
            return;
        }
        IMAPFolderImpl folder = new IMAPFolderImpl(name, availableFolders.get(name), this.username, this.getServer().getPersistenceManagerFactory());
        folders.add(folder);
        this.amendSubscriptions(folders);
        folder.synchronizeMailDir();
    }

    private List<IMAPFolderImpl> getSubscribedFolders() throws MessagingException {
        ArrayList<IMAPFolderImpl> folders = new ArrayList<IMAPFolderImpl>();
        try {
            File mailDir = IMAPFolderImpl.getMailDir(this.username);
            mailDir.mkdirs();
            File subscriptionsFile = new File(mailDir, ".SUBSCRIPTIONS-" + this.getServer().getProviderName());
            if (!subscriptionsFile.exists()) {
                subscriptionsFile = new File(mailDir, ".SUBSCRIPTIONS");
            }
            folders.add(new IMAPFolderImpl("INBOX", "INBOX", this.username, this.getServer().getPersistenceManagerFactory()));
            if (subscriptionsFile.exists()) {
                Map<String, String> availableFolders = this.getServer().getAvailableFolders(this.segmentName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(subscriptionsFile)));
                while (reader.ready()) {
                    String name = reader.readLine();
                    if (!availableFolders.containsKey(name)) continue;
                    try {
                        IMAPFolderImpl folder = new IMAPFolderImpl(name, availableFolders.get(name), this.username, this.getServer().getPersistenceManagerFactory());
                        folders.add(folder);
                    }
                    catch (Exception exception) {}
                }
                reader.close();
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        return folders;
    }

    private IMAPFolderImpl getFolder(String name) throws MessagingException {
        if ("INBOX".equals(name)) {
            return new IMAPFolderImpl("INBOX", "INBOX", this.username, this.getServer().getPersistenceManagerFactory());
        }
        for (Map.Entry<String, String> entry : this.getServer().getAvailableFolders(this.segmentName).entrySet()) {
            String folderName = entry.getKey();
            String folderId = entry.getValue();
            if (!folderName.equalsIgnoreCase(name) && !folderName.replace("/", "").equalsIgnoreCase(name)) continue;
            return new IMAPFolderImpl(name, folderId, this.username, this.getServer().getPersistenceManagerFactory());
        }
        return null;
    }

    protected void println(String s) {
        try {
            if (this.getServer().isDebug()) {
                System.out.println(s);
                System.out.flush();
            }
            this.out.write(s.getBytes("US-ASCII"));
            this.out.write("\r\n".getBytes("US-ASCII"));
            this.out.flush();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void print(String s) {
        try {
            if (this.getServer().isDebug()) {
                System.out.print(s);
                System.out.flush();
            }
            this.out.write(s.getBytes("US-ASCII"));
            this.out.flush();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void printBytes(QuotaByteArrayOutputStream bytes) {
        try {
            if (this.getServer().isDebug()) {
                System.out.print(new String(bytes.getBuffer(), 0, bytes.size(), "UTF-8"));
                System.out.flush();
            }
            bytes.writeTo(this.out);
            this.out.flush();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void printList(String[] values, boolean nested) {
        if (values == null) {
            this.print("NIL");
            return;
        }
        if (nested && values.length > 1) {
            this.print("(");
        }
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                this.print(" ");
            }
            try {
                if (values[i].startsWith("\"")) {
                    this.print(MimeUtility.encodeText((String)values[i], (String)"UTF-8", null));
                    continue;
                }
                this.print("\"" + MimeUtility.encodeText((String)values[i].trim(), (String)"UTF-8", null) + "\"");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (nested && values.length > 1) {
            this.print(")");
        }
    }

    protected void printMessageStructure(Message message) throws MessagingException {
        try {
            this.print("(");
            if (message.getContent() instanceof Multipart) {
                Multipart mp = (Multipart)message.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    this.printBodyPartStructure(mp.getBodyPart(i));
                }
                if (message.getContentType() == null) {
                    this.print(" NIL");
                } else {
                    String[] contentType = new String[]{};
                    try {
                        message.getHeader("Content-Type")[0].split(";");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.print(" \"mixed\"");
                    if (contentType.length > 1) {
                        this.print(" ");
                        int pos = contentType[1].indexOf("=");
                        this.printList(new String[]{contentType[1].substring(0, pos), contentType[1].substring(pos + 1)}, true);
                    }
                }
                this.print(" NIL NIL");
            } else if (message.getContent() instanceof BodyPart) {
                this.printBodyPartStructure((BodyPart)message.getContent());
            }
            this.print(")");
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void printBodyPartStructure(BodyPart part) throws MessagingException {
        this.print("(");
        String[] contentType = part.getContentType().split(";");
        if (contentType.length > 0) {
            String[] mimeType = contentType[0].split("/");
            this.printList(mimeType, false);
        }
        if (contentType.length > 1) {
            this.print(" ");
            int pos = contentType[1].indexOf("=");
            this.printList(new String[]{contentType[1].substring(0, pos), contentType[1].substring(pos + 1)}, true);
        }
        this.print(" NIL NIL ");
        this.printList(part.getHeader("Content-Transfer-Encoding"), true);
        if (part.getSize() > 0) {
            this.print(" " + part.getSize());
        } else {
            this.print(" NIL");
        }
        this.print(" NIL");
        if (part.getDisposition() == null) {
            this.print(" NIL");
        } else {
            this.print(" (");
            String[] disposition = part.getHeader("Content-Disposition")[0].split(";");
            for (int i = 0; i < disposition.length; ++i) {
                int pos;
                if (i > 0) {
                    this.print(" ");
                }
                if ((pos = disposition[i].indexOf("=")) > 0) {
                    this.printList(new String[]{disposition[i].substring(0, pos), disposition[i].substring(pos + 1)}, true);
                    continue;
                }
                this.printList(new String[]{disposition[i]}, true);
            }
            this.print(")");
        }
        this.print(" NIL");
        this.print(")");
    }

    protected void printAddresses(Address[] addresses, int max) {
        if (addresses == null) {
            this.print(" ((NIL NIL NIL NIL))");
        } else {
            int n = 0;
            for (Address address : addresses) {
                if (address instanceof InternetAddress) {
                    InternetAddress inetAddress = (InternetAddress)address;
                    int pos = inetAddress.getAddress().indexOf("@");
                    String personalName = inetAddress.getPersonal();
                    if (personalName != null) {
                        if (personalName.startsWith("'")) {
                            personalName = personalName.substring(1);
                        }
                        if (personalName.endsWith("'")) {
                            personalName = personalName.substring(0, personalName.length() - 1);
                        }
                    }
                    if (pos > 0) {
                        this.print(" ((NIL NIL \"" + inetAddress.getAddress().substring(0, pos) + "\" \"" + inetAddress.getAddress().substring(pos + 1) + "\"))");
                    } else {
                        this.print(" ((NIL NIL \"" + inetAddress.getAddress() + "\" NIL))");
                    }
                }
                if (++n >= max) break;
            }
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    static class SearchTermParser {
        SearchTermParser() {
        }

        private static void skipWhitespaces(String searchString, Position pos) {
            while (pos.value < searchString.length() && Character.isWhitespace(searchString.charAt(pos.value))) {
                ++pos.value;
            }
        }

        private static String parseString(String searchString, Position pos) {
            SearchTermParser.skipWhitespaces(searchString, pos);
            String s = "";
            if (pos.value < searchString.length() && searchString.charAt(pos.value) == '\"') {
                ++pos.value;
                while (searchString.charAt(pos.value) != '\"') {
                    s = s + searchString.charAt(pos.value++);
                }
                ++pos.value;
            }
            return s;
        }

        private static String parseIdentifier(String searchString, Position pos) {
            SearchTermParser.skipWhitespaces(searchString, pos);
            String s = "";
            while (pos.value < searchString.length() && !Character.isWhitespace(searchString.charAt(pos.value))) {
                s = s + searchString.charAt(pos.value++);
            }
            return s;
        }

        private static SearchTerm parseSearchTerm(String query, Position pos) throws ParseException, AddressException {
            SearchTermParser.skipWhitespaces(query, pos);
            if (pos.value >= query.length()) {
                return null;
            }
            if (Character.isDigit(query.charAt(pos.value))) {
                SearchTermParser.parseIdentifier(query, pos);
                return null;
            }
            if (query.startsWith("ALL", pos.value)) {
                pos.value += 3;
                ArrayList<SearchTerm> terms = new ArrayList<SearchTerm>();
                while (pos.value < query.length()) {
                    SearchTerm term = SearchTermParser.parseSearchTerm(query, pos);
                    if (term == null) continue;
                    terms.add(term);
                }
                return new AndTerm(terms.toArray(new SearchTerm[terms.size()]));
            }
            if (query.startsWith("ANSWERED", pos.value)) {
                pos.value += 8;
                Flags flags = new Flags();
                flags.add(Flags.Flag.ANSWERED);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("BCC", pos.value)) {
                pos.value += 3;
                return new RecipientTerm(Message.RecipientType.BCC, (Address)new InternetAddress(SearchTermParser.parseString(query, pos)));
            }
            if (query.startsWith("BEFORE", pos.value)) {
                pos.value += 6;
                return new ReceivedDateTerm(1, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("BODY", pos.value)) {
                pos.value += 4;
                return new BodyTerm(SearchTermParser.parseIdentifier(query, pos));
            }
            if (query.startsWith("CC", pos.value)) {
                pos.value += 2;
                return new RecipientTerm(Message.RecipientType.CC, (Address)new InternetAddress(SearchTermParser.parseString(query, pos)));
            }
            if (query.startsWith("DELETED", pos.value)) {
                pos.value += 7;
                Flags flags = new Flags();
                flags.add(Flags.Flag.DELETED);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("DRAFT", pos.value)) {
                pos.value += 5;
                Flags flags = new Flags();
                flags.add(Flags.Flag.DRAFT);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("FLAGGED", pos.value)) {
                pos.value += 7;
                Flags flags = new Flags();
                flags.add(Flags.Flag.FLAGGED);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("FROM", pos.value)) {
                pos.value += 4;
                return new FromTerm((Address)new InternetAddress(SearchTermParser.parseString(query, pos)));
            }
            if (query.startsWith("HEADER", pos.value)) {
                pos.value += 6;
                String headerName = SearchTermParser.parseIdentifier(query, pos);
                String pattern = SearchTermParser.parseString(query, pos);
                return new HeaderTerm(headerName, pattern);
            }
            if (query.startsWith("KEYWORD", pos.value)) {
                pos.value += 7;
                SearchTermParser.parseIdentifier(query, pos);
                return null;
            }
            if (query.startsWith("LARGER", pos.value)) {
                pos.value += 6;
                String size = SearchTermParser.parseIdentifier(query, pos);
                return new SizeTerm(5, Integer.parseInt(size, 8));
            }
            if (query.startsWith("NEW", pos.value)) {
                pos.value += 3;
                return null;
            }
            if (query.startsWith("NOT", pos.value)) {
                pos.value += 3;
                return new NotTerm(SearchTermParser.parseSearchTerm(query, pos));
            }
            if (query.startsWith("OLD", pos.value)) {
                pos.value += 3;
                Flags flags = new Flags();
                flags.add(Flags.Flag.RECENT);
                return new FlagTerm(flags, false);
            }
            if (query.startsWith("ON", pos.value)) {
                pos.value += 2;
                return new ReceivedDateTerm(3, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("OR", pos.value)) {
                pos.value += 2;
                ArrayList<SearchTerm> terms = new ArrayList<SearchTerm>();
                for (int i = 0; i < 2; ++i) {
                    SearchTerm term = SearchTermParser.parseSearchTerm(query, pos);
                    if (term == null) continue;
                    terms.add(term);
                }
                return new OrTerm(terms.toArray(new SearchTerm[terms.size()]));
            }
            if (query.startsWith("RECENT", pos.value)) {
                pos.value += 6;
                Flags flags = new Flags();
                flags.add(Flags.Flag.RECENT);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("SEEN", pos.value)) {
                pos.value += 4;
                Flags flags = new Flags();
                flags.add(Flags.Flag.SEEN);
                return new FlagTerm(flags, true);
            }
            if (query.startsWith("SENTBEFORE", pos.value)) {
                pos.value += 10;
                return new SentDateTerm(2, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("SENTON", pos.value)) {
                pos.value += 6;
                return new SentDateTerm(3, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("SENTSINCE", pos.value)) {
                pos.value += 9;
                return new SentDateTerm(6, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("SINCE", pos.value)) {
                pos.value += 5;
                return new ReceivedDateTerm(6, DateTimeFormat.BASIC_UTC_FORMAT.parse(SearchTermParser.parseIdentifier(query, pos)));
            }
            if (query.startsWith("SMALLER", pos.value)) {
                pos.value += 7;
                String size = SearchTermParser.parseIdentifier(query, pos);
                return new SizeTerm(2, Integer.parseInt(size, 8));
            }
            if (query.startsWith("SUBJECT", pos.value)) {
                pos.value += 7;
                String s = SearchTermParser.parseString(query, pos);
                return new SubjectTerm(s);
            }
            if (query.startsWith("TEXT", pos.value)) {
                pos.value += 5;
                String s = SearchTermParser.parseString(query, pos);
                return new BodyTerm(s);
            }
            if (query.startsWith("TO", pos.value)) {
                pos.value += 2;
                return new RecipientTerm(Message.RecipientType.TO, (Address)new InternetAddress(SearchTermParser.parseString(query, pos)));
            }
            if (query.startsWith("UID", pos.value)) {
                pos.value += 2;
                String uid = SearchTermParser.parseIdentifier(query, pos);
                while (uid != null && uid.length() > 0 && Character.isDigit(uid.charAt(0))) {
                    uid = SearchTermParser.parseIdentifier(query, pos);
                }
                return null;
            }
            if (query.startsWith("UNANSWERED", pos.value)) {
                pos.value += 10;
                Flags flags = new Flags();
                flags.add(Flags.Flag.ANSWERED);
                return new FlagTerm(flags, false);
            }
            if (query.startsWith("UNDELETED", pos.value)) {
                pos.value += 9;
                Flags flags = new Flags();
                flags.add(Flags.Flag.DELETED);
                return new FlagTerm(flags, false);
            }
            if (query.startsWith("UNDRAFT", pos.value)) {
                pos.value += 7;
                Flags flags = new Flags();
                flags.add(Flags.Flag.DRAFT);
                return new FlagTerm(flags, false);
            }
            if (query.startsWith("UNFLAGGED", pos.value)) {
                pos.value += 9;
                Flags flags = new Flags();
                flags.add(Flags.Flag.FLAGGED);
                return new FlagTerm(flags, false);
            }
            if (query.startsWith("UNKEYWORD", pos.value)) {
                pos.value += 9;
                SearchTermParser.parseIdentifier(query, pos);
                return null;
            }
            if (query.startsWith("UNSEEN", pos.value)) {
                pos.value += 6;
                Flags flags = new Flags();
                flags.add(Flags.Flag.SEEN);
                return new FlagTerm(flags, false);
            }
            SearchTermParser.parseIdentifier(query, pos);
            return null;
        }

        public static SearchTerm parseSearchTerm(String query) throws MessagingException, ParseException {
            Position position = new Position();
            if (!(query = query.trim()).startsWith("ALL ")) {
                query = "ALL " + query;
            }
            return SearchTermParser.parseSearchTerm(query, position);
        }

        static class Position {
            public int value = 0;

            Position() {
            }
        }
    }

    public static enum SessionState {
        NOT_AUTHENTICATED,
        AUTHENTICATED;

    }
}

