/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.ldap;

import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.PersistenceManager;
import org.opencrx.application.adapter.AbstractServer;
import org.opencrx.application.adapter.AbstractSession;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.utils.AccountQueryHelper;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Codes;

public class LDAPSession
extends AbstractSession {
    public static final int SIZE_LIMIT = 1000;
    static final Pattern PERSONS_FILTER_PATTERN = Pattern.compile("ou=filter/(.+?),ou=Persons");
    static final Pattern PERSONS_GROUP_PATTERN = Pattern.compile("ou=group/(.+?),ou=Persons");
    static final List<String> PERSON_OBJECT_CLASSES = Arrays.asList("top", "person", "organizationalPerson", "inetOrgPerson", "user", "mozillaAbPerson", "mozillaAddressBookEntry");
    static final int LDAP_VERSION2 = 2;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_OTHER = 80;
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_GE = 165;
    static final int LDAP_FILTER_LE = 166;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_APPROX = 168;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SET = 49;
    static final int LBER_SEQUENCE = 48;
    static final int SCOPE_BASE_OBJECT = 0;
    static final int SCOPE_ONE_LEVEL = 1;
    static final int SCOPE_SUBTREE = 2;
    private static ThreadLocal<BerEncoder> berEncoders = new ThreadLocal<BerEncoder>(){

        @Override
        protected synchronized BerEncoder initialValue() {
            return new BerEncoder();
        }
    };
    int ldapVersion = 3;
    protected OutputStream out = null;
    protected InputStream in = null;

    public LDAPSession(Socket socket, AbstractServer server) {
        super(socket, server);
    }

    @Override
    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isLdapV3() {
        return this.ldapVersion == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.socket == null || !this.socket.isConnected()) {
            System.out.println("Unable to start conversation, invalid connection passed to client handler");
        } else {
            SysLog.info((String)"Session started for client", (Object)this.socket.getInetAddress().getHostAddress());
            try {
                int offset;
                int bytesread;
                this.out = new PrintStream(this.socket.getOutputStream());
                this.in = this.socket.getInputStream();
                byte[] inbuf = new byte[2048];
                while ((bytesread = this.in.read(inbuf, offset = 0, 1)) >= 0) {
                    int bytesleft;
                    int seqlen;
                    if (inbuf[offset++] != 48) continue;
                    bytesread = this.in.read(inbuf, offset, 1);
                    if (bytesread < 0) {
                        break;
                    }
                    if (((seqlen = inbuf[offset++]) & 0x80) == 128) {
                        int br;
                        int seqlenlen = seqlen & 0x7F;
                        boolean eos = false;
                        for (bytesread = 0; bytesread < seqlenlen; bytesread += br) {
                            br = this.in.read(inbuf, offset + bytesread, seqlenlen - bytesread);
                            if (br >= 0) continue;
                            eos = true;
                            break;
                        }
                        if (eos) {
                            break;
                        }
                        seqlen = 0;
                        for (int i = 0; i < seqlenlen; ++i) {
                            seqlen = (seqlen << 8) + (inbuf[offset + i] & 0xFF);
                        }
                        offset += bytesread;
                    }
                    if (offset + (bytesleft = seqlen) > inbuf.length) {
                        byte[] nbuf = new byte[offset + bytesleft];
                        System.arraycopy(inbuf, 0, nbuf, 0, offset);
                        inbuf = nbuf;
                    }
                    while (bytesleft > 0 && (bytesread = this.in.read(inbuf, offset, bytesleft)) >= 0) {
                        offset += bytesread;
                        bytesleft -= bytesread;
                    }
                    this.handleRequest(new BerDecoder(inbuf, 0, offset));
                }
            }
            catch (Exception e) {
                if (!(e instanceof SocketTimeoutException)) {
                    ServiceException e0 = new ServiceException(e);
                    SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                }
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getProviderName() {
        return this.server.getProviderName();
    }

    protected Codes getCodes(PersistenceManager pm) {
        return new Codes((RefObject_1_0)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1/provider/" + this.getProviderName() + "/segment/Root")));
    }

    protected void handleRequest(BerDecoder reqBer) throws IOException {
        int currentMessageId = 0;
        try {
            reqBer.parseSeq(null);
            currentMessageId = reqBer.parseInt();
            int requestOperation = reqBer.peekByte();
            if (requestOperation == 96) {
                reqBer.parseSeq(null);
                this.ldapVersion = reqBer.parseInt();
                String userName = reqBer.parseString(this.isLdapV3());
                String password = reqBer.parseStringWithTag(128, this.isLdapV3(), null);
                if (userName.length() > 0 && password.length() > 0 && this.login(userName, password)) {
                    this.sendClient(currentMessageId, 97, 0, "");
                } else {
                    this.sendClient(currentMessageId, 97, 49, "");
                }
            } else {
                if (requestOperation == 66) {
                    SysLog.detail((String)"LOG_LDAP_REQ_UNBIND", (Object)currentMessageId);
                    this.socket.close();
                    this.logout();
                    return;
                }
                if (requestOperation == 99) {
                    PersistenceManager pm = AbstractSession.newPersistenceManager(this.server.getPersistenceManagerFactory(), this.username);
                    reqBer.parseSeq(null);
                    String dn = reqBer.parseString(this.isLdapV3());
                    if (pm != null) {
                        int scope = reqBer.parseEnumeration();
                        reqBer.parseEnumeration();
                        int sizeLimit = reqBer.parseInt();
                        if (sizeLimit > 1000 || sizeLimit == 0) {
                            sizeLimit = 1000;
                        }
                        int timeLimit = reqBer.parseInt();
                        reqBer.parseBoolean();
                        LDAPQuery ldapQuery = this.parseQuery(dn, reqBer, pm);
                        if (ldapQuery != null) {
                            ldapQuery.process(dn, currentMessageId, scope, sizeLimit, timeLimit);
                            this.sendClient(currentMessageId, 101, 0, "");
                        } else {
                            this.sendClient(currentMessageId, 101, 80, "Invalid query");
                        }
                    } else {
                        this.sendClient(currentMessageId, 101, 80, "Anonymous access forbidden");
                    }
                    pm.close();
                } else if (requestOperation == 80) {
                    SysLog.detail((String)"LOG_LDAP_REQ_ABANDON_SEARCH", (Object)currentMessageId);
                } else {
                    SysLog.detail((String)"LOG_LDAP_UNSUPPORTED_OPERATION", (Object)requestOperation);
                    this.sendClient(currentMessageId, 101, 80, "Unsupported operation");
                }
            }
        }
        catch (IOException e) {
            try {
                this.sendErr(currentMessageId, 101, e);
            }
            catch (IOException e2) {
                SysLog.detail((String)"LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", (Throwable)e2);
            }
            throw e;
        }
    }

    protected LDAPQuery parseQuery(String dn, BerDecoder reqBer, PersistenceManager pm) throws IOException {
        AccountQueryHelper accountsQuery;
        Matcher personsMatcher = PERSONS_FILTER_PATTERN.matcher(dn);
        if (personsMatcher.matches()) {
            accountsQuery = new AccountQueryHelper(pm);
            try {
                accountsQuery.parseQueryId("/" + this.server.getProviderName() + "/" + this.segmentName + "/filter/" + personsMatcher.group(1));
                LDAPFilter filter = this.parseFilter(reqBer);
                return new LDAPAccountQuery(accountsQuery, filter);
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
        if ((personsMatcher = PERSONS_GROUP_PATTERN.matcher(dn)).matches()) {
            accountsQuery = new AccountQueryHelper(pm);
            try {
                accountsQuery.parseQueryId("/" + this.server.getProviderName() + "/" + this.segmentName + "/group/" + personsMatcher.group(1));
                LDAPFilter filter = this.parseFilter(reqBer);
                return new LDAPAccountQuery(accountsQuery, filter);
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
        return null;
    }

    protected LDAPFilter parseFilter(BerDecoder reqBer) throws ServiceException {
        try {
            LDAPFilter ldapFilter = null;
            if (reqBer.peekByte() == 135) {
                String attributeName = reqBer.parseStringWithTag(135, this.isLdapV3(), null).toLowerCase();
                ldapFilter = new LDAPSimpleFilter(attributeName);
            } else {
                int[] seqSize = new int[1];
                int ldapFilterType = reqBer.parseSeq(seqSize);
                int end = reqBer.getParsePosition() + seqSize[0];
                ldapFilter = this.parseNestedFilter(reqBer, ldapFilterType, end);
            }
            return ldapFilter;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    protected LDAPFilter parseNestedFilter(BerDecoder reqBer, int ldapFilterType, int end) throws ServiceException {
        try {
            LDAPFilter nestedFilter;
            if (ldapFilterType == 161 || ldapFilterType == 160) {
                nestedFilter = new LDAPCompoundFilter(ldapFilterType);
                while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                    if (reqBer.peekByte() == 135) {
                        String attributeName = reqBer.parseStringWithTag(135, this.isLdapV3(), null).toLowerCase();
                        ((LDAPCompoundFilter)nestedFilter).add(new LDAPSimpleFilter(attributeName));
                        continue;
                    }
                    int[] seqSize = new int[1];
                    int ldapFilterOperator = reqBer.parseSeq(seqSize);
                    int subEnd = reqBer.getParsePosition() + seqSize[0];
                    ((LDAPCompoundFilter)nestedFilter).add(this.parseNestedFilter(reqBer, ldapFilterOperator, subEnd));
                }
            } else {
                nestedFilter = this.parseSimpleFilter(reqBer, ldapFilterType);
            }
            return nestedFilter;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    protected LDAPFilter parseSimpleFilter(BerDecoder reqBer, int ldapFilterOperator) throws ServiceException {
        try {
            String attributeName = reqBer.parseString(this.isLdapV3()).toLowerCase();
            int ldapFilterMode = 0;
            StringBuilder value = new StringBuilder();
            if (ldapFilterOperator == 164) {
                int[] seqSize = new int[1];
                reqBer.parseSeq(seqSize);
                int end = reqBer.getParsePosition() + seqSize[0];
                while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                    ldapFilterMode = reqBer.peekByte();
                    if (value.length() > 0) {
                        value.append(' ');
                    }
                    value.append(reqBer.parseStringWithTag(ldapFilterMode, this.isLdapV3(), null));
                }
            } else if (ldapFilterOperator == 163) {
                value.append(reqBer.parseString(this.isLdapV3()));
            } else {
                SysLog.warning((String)"LOG_LDAP_UNSUPPORTED_FILTER_VALUE");
            }
            String sValue = value.toString();
            return new LDAPSimpleFilter(attributeName, sValue, ldapFilterOperator, ldapFilterMode);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    protected void sendEntry(int currentMessageId, String dn, Map<String, Object> attributes) throws ServiceException {
        try {
            BerEncoder berEncoder = berEncoders.get();
            berEncoder.reset();
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(currentMessageId);
            berEncoder.beginSeq(100);
            berEncoder.encodeString(dn, this.isLdapV3());
            berEncoder.beginSeq(48);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                berEncoder.beginSeq(48);
                berEncoder.encodeString(entry.getKey(), this.isLdapV3());
                berEncoder.beginSeq(49);
                Object values = entry.getValue();
                if (values instanceof String) {
                    berEncoder.encodeString((String)values, this.isLdapV3());
                } else if (values instanceof List) {
                    for (Object value : (List)values) {
                        berEncoder.encodeString((String)value, this.isLdapV3());
                    }
                } else {
                    throw new ServiceException("DefaultDomain", -2, "EXCEPTION_UNSUPPORTED_VALUE", new BasicException.Parameter[]{new BasicException.Parameter("values", values)});
                }
                berEncoder.endSeq();
                berEncoder.endSeq();
            }
            berEncoder.endSeq();
            berEncoder.endSeq();
            berEncoder.endSeq();
            this.sendResponse(berEncoder);
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
    }

    protected void sendErr(int currentMessageId, int responseOperation, Exception e) throws IOException {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        this.sendClient(currentMessageId, responseOperation, 80, message);
    }

    protected void sendClient(int currentMessageId, int responseOperation, int status, String message) throws IOException {
        BerEncoder berEncoder = berEncoders.get();
        berEncoder.reset();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(currentMessageId);
        berEncoder.beginSeq(responseOperation);
        berEncoder.encodeInt(status, 10);
        berEncoder.encodeString("", this.isLdapV3());
        berEncoder.encodeString(message, this.isLdapV3());
        berEncoder.endSeq();
        berEncoder.endSeq();
        this.sendResponse(berEncoder);
    }

    protected void sendResponse(BerEncoder berEncoder) throws IOException {
        this.out.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
        this.out.flush();
    }

    static class LDAPSimpleFilter
    implements LDAPFilter {
        static final String STAR = "*";
        final String attributeName;
        final String value;
        final int mode;
        final int operator;

        LDAPSimpleFilter(String attributeName) {
            this.attributeName = attributeName;
            this.value = STAR;
            this.operator = 164;
            this.mode = 0;
        }

        LDAPSimpleFilter(String attributeName, String value, int ldapFilterOperator, int ldapFilterMode) {
            this.attributeName = attributeName;
            this.value = value;
            this.operator = ldapFilterOperator;
            this.mode = ldapFilterMode;
        }

        @Override
        public boolean isFullSearch() {
            return "objectclass".equals(this.attributeName) && STAR.equals(this.value);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            buffer.append(this.attributeName);
            buffer.append('=');
            if (STAR.equals(this.value)) {
                buffer.append(STAR);
            } else if (this.operator == 164) {
                if (this.mode == 130 || this.mode == 129) {
                    buffer.append(STAR);
                }
                buffer.append(this.value);
                if (this.mode == 128 || this.mode == 129) {
                    buffer.append(STAR);
                }
            } else {
                buffer.append(this.value);
            }
            buffer.append(')');
            return buffer.toString();
        }

        @Override
        public String getSearchFilter() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('\"').append(this.getAttributeName()).append('\"');
            if (this.operator == 163) {
                buffer.append("='").append(this.value).append('\'');
            } else if (STAR.equals(this.value)) {
                buffer.append(" is not null");
            } else {
                buffer.append(" LIKE '");
                if (this.mode == 130 || this.mode == 129) {
                    buffer.append('%');
                }
                buffer.append(this.value.replaceAll("'", "''"));
                buffer.append('%');
                buffer.append('\'');
            }
            return buffer.toString();
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }

    static class LDAPCompoundFilter
    implements LDAPFilter {
        final Set<LDAPFilter> criteria = new HashSet<LDAPFilter>();
        final int type;

        LDAPCompoundFilter(int filterType) {
            this.type = filterType;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.type == 161) {
                buffer.append("(|");
            } else {
                buffer.append("(&");
            }
            for (LDAPFilter child : this.criteria) {
                buffer.append(child.toString());
            }
            buffer.append(')');
            return buffer.toString();
        }

        public void add(LDAPFilter filter) {
            this.criteria.add(filter);
        }

        @Override
        public boolean isFullSearch() {
            for (LDAPFilter child : this.criteria) {
                if (child.isFullSearch()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getSearchFilter() {
            StringBuilder buffer = new StringBuilder();
            String op = this.type == 161 ? " OR " : " AND ";
            buffer.append('(');
            for (LDAPFilter child : this.criteria) {
                String childFilter = child.getSearchFilter();
                if (childFilter == null) continue;
                if (buffer.length() > 1) {
                    buffer.append(op);
                }
                buffer.append(childFilter);
            }
            if (buffer.length() == 1) {
                return null;
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    static interface LDAPFilter {
        public String getSearchFilter();

        public boolean isFullSearch();
    }

    class LDAPAccountQuery
    implements LDAPQuery {
        private final AccountQueryHelper accountsFilterHelper;
        private final LDAPFilter ldapFilter;

        public LDAPAccountQuery(AccountQueryHelper accountsFilterHelper, LDAPFilter ldapFilter) {
            this.accountsFilterHelper = accountsFilterHelper;
            this.ldapFilter = ldapFilter;
        }

        private Object toStreet(PostalAddress postalAddress) {
            return postalAddress.getPostalStreet();
        }

        private String getCountryName(PostalAddress postalAddress) {
            Codes codes = LDAPSession.this.getCodes(this.accountsFilterHelper.getPersistenceManager());
            return codes == null ? Short.toString(postalAddress.getPostalCountry()) : (String)codes.getLongText("country", (short)0, true, true).get(postalAddress.getPostalCountry());
        }

        @Override
        public void process(String dn, int messageId, int scope, int sizeLimit, int timeLimit) {
            PersistenceManager pm = this.accountsFilterHelper.getPersistenceManager();
            pm = pm.getPersistenceManagerFactory().getPersistenceManager(UserObjects.getPrincipalChain((PersistenceManager)pm).toString(), null);
            AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
            if (this.ldapFilter != null && this.ldapFilter instanceof LDAPCompoundFilter) {
                LDAPCompoundFilter compoundFilter = (LDAPCompoundFilter)this.ldapFilter;
                for (LDAPFilter criteria : compoundFilter.criteria) {
                    if (criteria instanceof LDAPSimpleFilter) {
                        LDAPSimpleFilter simpleFilter = (LDAPSimpleFilter)criteria;
                        if (!"cn".equals(simpleFilter.getAttributeName())) continue;
                        accountQuery.thereExistsFullName().like((Object)("(?i).*" + simpleFilter.value + ".*"));
                        continue;
                    }
                    if (!(criteria instanceof LDAPCompoundFilter)) continue;
                    LDAPCompoundFilter nestedCompoundFilter = (LDAPCompoundFilter)criteria;
                    for (LDAPFilter nestedCriteria : nestedCompoundFilter.criteria) {
                        LDAPSimpleFilter simpleFilter;
                        if (!(nestedCriteria instanceof LDAPSimpleFilter) || !"cn".equals((simpleFilter = (LDAPSimpleFilter)nestedCriteria).getAttributeName())) continue;
                        accountQuery.thereExistsFullName().like((Object)("(?i).*" + simpleFilter.value + ".*"));
                    }
                }
            }
            int n = 0;
            for (Account account : this.accountsFilterHelper.getFilteredAccounts(accountQuery)) {
                try {
                    Object street;
                    PostalAddress postalAddress;
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    AccountAddress[] addresses = Accounts.getInstance().getMainAddresses(account);
                    attributes.put("uid", account.refGetPath().getLastSegment().toString());
                    attributes.put("objectclass", PERSON_OBJECT_CLASSES);
                    boolean hasEMailBusiness = false;
                    if (addresses[0] != null) {
                        attributes.put("mail", ((EMailAddress)addresses[0]).getEmailAddress());
                        hasEMailBusiness = true;
                    }
                    if (addresses[1] != null) {
                        if (!hasEMailBusiness) {
                            attributes.put("mail", ((EMailAddress)addresses[1]).getEmailAddress());
                        } else {
                            attributes.put("email2", ((EMailAddress)addresses[1]).getEmailAddress());
                        }
                    }
                    attributes.put("cn", account.getFullName());
                    attributes.put("displayName", account.getFullName());
                    boolean hasPhoneNumberBusiness = false;
                    if (addresses[2] != null) {
                        attributes.put("telephoneNumber", ((PhoneNumber)addresses[2]).getPhoneNumberFull());
                        hasPhoneNumberBusiness = true;
                    }
                    if (addresses[3] != null) {
                        if (!hasPhoneNumberBusiness) {
                            attributes.put("telephoneNumber", ((PhoneNumber)addresses[3]).getPhoneNumberFull());
                        }
                        attributes.put("homephone", ((PhoneNumber)addresses[3]).getPhoneNumberFull());
                    }
                    if (account instanceof Contact) {
                        Contact contact = (Contact)account;
                        if (contact.getOrganization() != null) {
                            attributes.put("company", contact.getOrganization());
                            attributes.put("o", contact.getOrganization());
                        }
                        if (contact.getJobTitle() != null) {
                            attributes.put("title", contact.getJobTitle());
                        }
                        if (contact.getJobRole() != null) {
                            attributes.put("organizationalRole", contact.getJobRole());
                        }
                        if (contact.getFirstName() != null) {
                            attributes.put("givenName", contact.getFirstName());
                        }
                        if (contact.getLastName() != null) {
                            attributes.put("sn", contact.getLastName());
                        }
                    }
                    boolean hasPostalBusiness = false;
                    if (addresses[6] != null) {
                        postalAddress = (PostalAddress)addresses[6];
                        street = this.toStreet(postalAddress);
                        attributes.put("street", street);
                        attributes.put("streetAddress", street);
                        if (postalAddress.getPostalState() != null) {
                            attributes.put("st", postalAddress.getPostalState());
                        }
                        if (postalAddress.getPostalCode() != null) {
                            attributes.put("postalCode", postalAddress.getPostalCode());
                        }
                        if (postalAddress.getPostalCode() != null) {
                            attributes.put("l", postalAddress.getPostalCity());
                        }
                        attributes.put("c", this.getCountryName(postalAddress));
                        attributes.put("countryname", this.getCountryName(postalAddress));
                        if (street instanceof List && ((List)street).size() > 0) {
                            attributes.put("mozillaWorkstreet", ((List)street).get(0));
                        }
                        if (street instanceof List && ((List)street).size() > 1) {
                            attributes.put("mozillaWorkStreet2", ((List)street).get(1));
                        }
                        hasPostalBusiness = true;
                    }
                    if (addresses[8] != null) {
                        postalAddress = (PostalAddress)addresses[8];
                        street = this.toStreet(postalAddress);
                        if (!hasPostalBusiness) {
                            attributes.put("street", street);
                            attributes.put("streetAddress", street);
                            if (postalAddress.getPostalState() != null) {
                                attributes.put("st", postalAddress.getPostalState());
                            }
                            if (postalAddress.getPostalCode() != null) {
                                attributes.put("postalCode", postalAddress.getPostalCode());
                            }
                            if (postalAddress.getPostalCode() != null) {
                                attributes.put("l", postalAddress.getPostalCity());
                            }
                            attributes.put("c", this.getCountryName(postalAddress));
                        }
                        if (street instanceof List && ((List)street).size() > 0) {
                            attributes.put("mozillaHomeStreet", ((List)street).get(0));
                        }
                        if (street instanceof List && ((List)street).size() > 1) {
                            attributes.put("mozillaHomeStreet2", ((List)street).get(1));
                        }
                        if (postalAddress.getPostalState() != null) {
                            attributes.put("mozillaHomeState", postalAddress.getPostalState());
                        }
                        if (postalAddress.getPostalCode() != null) {
                            attributes.put("mozillaHomePostalCode", postalAddress.getPostalCode());
                        }
                        if (postalAddress.getPostalCode() != null) {
                            attributes.put("mozillaHomeLocalityName", postalAddress.getPostalCity());
                        }
                        attributes.put("countryname", this.getCountryName(postalAddress));
                        attributes.put("mozillaHomeCountryName", this.getCountryName(postalAddress));
                    }
                    if (addresses[10] != null) {
                        attributes.put("mobile", ((PhoneNumber)addresses[10]).getPhoneNumberFull());
                    }
                    if (addresses[7] != null) {
                        attributes.put("mozillaWorkUrl", ((WebAddress)addresses[7]).getWebUrl());
                    }
                    if (addresses[9] != null) {
                        attributes.put("mozillaHomeUrl", ((WebAddress)addresses[9]).getWebUrl());
                    }
                    if (account.getDescription() != null) {
                        attributes.put("description", account.getDescription());
                    }
                    if (account.getAliasName() != null) {
                        attributes.put("mozillanickname", account.getAliasName());
                    }
                    LDAPSession.this.sendEntry(messageId, "cn=" + attributes.get("cn") + "," + dn, attributes);
                    if (++n <= sizeLimit) continue;
                    break;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
        }
    }

    static interface LDAPQuery {
        public void process(String var1, int var2, int var3, int var4, int var5);
    }
}

