/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.StreamReader;
import org.opencrx.application.uses.ezvcard.io.scribe.ScribeIndex;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.text.VCardReader;
import org.opencrx.application.uses.ezvcard.io.text.VCardWriter;
import org.opencrx.application.uses.ezvcard.io.xml.XCardDocument;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Ezvcard {
    public static ParserChainTextString parse(String str) {
        return new ParserChainTextString(str);
    }

    public static ParserChainTextReader parse(File file) {
        return new ParserChainTextReader(file);
    }

    public static ParserChainTextReader parse(InputStream in) {
        return Ezvcard.parse(new InputStreamReader(in));
    }

    public static ParserChainTextReader parse(Reader reader) {
        return new ParserChainTextReader(reader);
    }

    public static ParserChainXmlString parseXml(String xml) {
        return new ParserChainXmlString(xml);
    }

    public static ParserChainXmlReader parseXml(File file) {
        return new ParserChainXmlReader(file);
    }

    public static ParserChainXmlReader parseXml(InputStream in) {
        return new ParserChainXmlReader(in);
    }

    public static ParserChainXmlReader parseXml(Reader reader) {
        return new ParserChainXmlReader(reader);
    }

    public static ParserChainXmlDom parseXml(Document document) {
        return new ParserChainXmlDom(document);
    }

    public static WriterChainText write(VCard ... vcards) {
        return Ezvcard.write(Arrays.asList(vcards));
    }

    public static WriterChainText write(Collection<VCard> vcards) {
        return new WriterChainText(vcards);
    }

    public static WriterChainXml writeXml(VCard ... vcards) {
        return Ezvcard.writeXml(Arrays.asList(vcards));
    }

    public static WriterChainXml writeXml(Collection<VCard> vcards) {
        return new WriterChainXml(vcards);
    }

    private Ezvcard() {
    }

    public static class WriterChainXml
    extends WriterChain<WriterChainXml> {
        boolean prodId = true;
        boolean versionStrict = true;
        int indent = -1;
        final ScribeIndex index = new ScribeIndex();

        private WriterChainXml(Collection<VCard> vcards) {
            super(vcards);
        }

        public WriterChainXml prodId(boolean include) {
            this.prodId = include;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml indent(int indent) {
            this.indent = indent;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml versionStrict(boolean versionStrict) {
            this.versionStrict = versionStrict;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return (WriterChainXml)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(out, this.indent);
        }

        public void go(File file) throws IOException, TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(file, this.indent);
        }

        public void go(Writer writer) throws TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(writer, this.indent);
        }

        public Document dom() {
            XCardDocument doc = this.createXCardDocument();
            return doc.getDocument();
        }

        private XCardDocument createXCardDocument() {
            XCardDocument doc = new XCardDocument();
            XCardDocument.XCardDocumentStreamWriter writer = doc.writer();
            writer.setAddProdId(this.prodId);
            writer.setVersionStrict(this.versionStrict);
            writer.setScribeIndex(this.index);
            for (VCard vcard : this.vcards) {
                writer.write(vcard);
            }
            return doc;
        }
    }

    public static class WriterChainText
    extends WriterChain<WriterChainText> {
        VCardVersion version;
        boolean prodId = true;
        boolean versionStrict = true;
        boolean caretEncoding = false;
        final ScribeIndex index = new ScribeIndex();

        private WriterChainText(Collection<VCard> vcards) {
            super(vcards);
        }

        public WriterChainText version(VCardVersion version) {
            this.version = version;
            return (WriterChainText)this.this_;
        }

        public WriterChainText prodId(boolean include) {
            this.prodId = include;
            return (WriterChainText)this.this_;
        }

        public WriterChainText caretEncoding(boolean enable) {
            this.caretEncoding = enable;
            return (WriterChainText)this.this_;
        }

        public WriterChainText versionStrict(boolean versionStrict) {
            this.versionStrict = versionStrict;
            return (WriterChainText)this.this_;
        }

        public WriterChainText register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return (WriterChainText)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            VCardWriter vcardWriter = new VCardWriter(out, this.version);
            this.go(vcardWriter);
        }

        public void go(File file) throws IOException {
            this.go(file, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file, boolean append) throws IOException {
            VCardWriter vcardWriter = new VCardWriter(file, append, this.version);
            try {
                this.go(vcardWriter);
            }
            finally {
                IOUtils.closeQuietly(vcardWriter);
            }
        }

        public void go(Writer writer) throws IOException {
            VCardWriter vcardWriter = new VCardWriter(writer, this.version);
            this.go(vcardWriter);
        }

        private void go(VCardWriter vcardWriter) throws IOException {
            vcardWriter.setAddProdId(this.prodId);
            vcardWriter.setCaretEncodingEnabled(this.caretEncoding);
            vcardWriter.setVersionStrict(this.versionStrict);
            vcardWriter.setScribeIndex(this.index);
            for (VCard vcard : this.vcards) {
                if (this.version == null) {
                    VCardVersion vcardVersion = vcard.getVersion();
                    if (vcardVersion == null) {
                        vcardVersion = VCardVersion.V3_0;
                    }
                    vcardWriter.setTargetVersion(vcardVersion);
                }
                vcardWriter.write(vcard);
                vcardWriter.flush();
            }
        }
    }

    static abstract class WriterChain<T> {
        final Collection<VCard> vcards;
        final T this_ = this;

        WriterChain(Collection<VCard> vcards) {
            this.vcards = vcards;
        }
    }

    public static class ParserChainXmlDom
    extends ParserChainXml<ParserChainXmlDom> {
        private final Document document;

        private ParserChainXmlDom(Document document) {
            this.document = document;
        }

        @Override
        public ParserChainXmlDom register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlDom)super.register(scribe);
        }

        @Override
        public ParserChainXmlDom warnings(List<List<String>> warnings) {
            return (ParserChainXmlDom)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() {
            return new XCardDocument(this.document);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ParserChainXmlString
    extends ParserChainXml<ParserChainXmlString> {
        private final String xml;

        private ParserChainXmlString(String xml) {
            this.xml = xml;
        }

        @Override
        public ParserChainXmlString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlString)super.register(scribe);
        }

        @Override
        public ParserChainXmlString warnings(List<List<String>> warnings) {
            return (ParserChainXmlString)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() throws SAXException {
            return new XCardDocument(this.xml);
        }

        @Override
        public VCard first() throws SAXException {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() throws SAXException {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ParserChainXmlReader
    extends ParserChainXml<ParserChainXmlReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainXmlReader(InputStream in) {
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainXmlReader(File file) {
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainXmlReader(Reader reader) {
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainXmlReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlReader)super.register(scribe);
        }

        @Override
        public ParserChainXmlReader warnings(List<List<String>> warnings) {
            return (ParserChainXmlReader)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() throws IOException, SAXException {
            if (this.in != null) {
                return new XCardDocument(this.in);
            }
            if (this.file != null) {
                return new XCardDocument(this.file);
            }
            return new XCardDocument(this.reader);
        }
    }

    static abstract class ParserChainXml<T>
    extends ParserChain<T> {
        ParserChainXml() {
        }

        @Override
        public VCard first() throws IOException, SAXException {
            StreamReader reader = this.constructStreamReader();
            VCard vcard = reader.readNext();
            if (this.warnings != null) {
                this.warnings.add(reader.getWarnings());
            }
            return vcard;
        }

        @Override
        public List<VCard> all() throws IOException, SAXException {
            ArrayList<VCard> vcards = new ArrayList<VCard>();
            StreamReader reader = this.constructStreamReader();
            VCard vcard = null;
            while ((vcard = reader.readNext()) != null) {
                vcards.add(vcard);
                if (this.warnings == null) continue;
                this.warnings.add(reader.getWarnings());
            }
            return vcards;
        }

        private StreamReader constructStreamReader() throws SAXException, IOException {
            XCardDocument parser = this._constructDocument();
            StreamReader reader = parser.reader();
            reader.setScribeIndex(this.index);
            return reader;
        }

        abstract XCardDocument _constructDocument() throws IOException, SAXException;
    }

    public static class ParserChainTextString
    extends ParserChainText<ParserChainTextString> {
        private final String text;

        private ParserChainTextString(String text) {
            super(false);
            this.text = text;
        }

        @Override
        public ParserChainTextString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainTextString)super.register(scribe);
        }

        @Override
        public ParserChainTextString warnings(List<List<String>> warnings) {
            return (ParserChainTextString)super.warnings(warnings);
        }

        @Override
        public ParserChainTextString caretDecoding(boolean enable) {
            return (ParserChainTextString)super.caretDecoding(enable);
        }

        @Override
        VCardReader _constructReader() {
            return new VCardReader(this.text);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ParserChainTextReader
    extends ParserChainText<ParserChainTextReader> {
        private final Reader reader;
        private final File file;

        private ParserChainTextReader(Reader reader) {
            super(false);
            this.reader = reader;
            this.file = null;
        }

        private ParserChainTextReader(File file) {
            super(true);
            this.reader = null;
            this.file = file;
        }

        @Override
        public ParserChainTextReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainTextReader)super.register(scribe);
        }

        @Override
        public ParserChainTextReader warnings(List<List<String>> warnings) {
            return (ParserChainTextReader)super.warnings(warnings);
        }

        @Override
        public ParserChainTextReader caretDecoding(boolean enable) {
            return (ParserChainTextReader)super.caretDecoding(enable);
        }

        @Override
        VCardReader _constructReader() throws IOException {
            return this.reader != null ? new VCardReader(this.reader) : new VCardReader(this.file);
        }
    }

    static abstract class ParserChainText<T>
    extends ParserChain<T> {
        boolean caretDecoding = true;
        final boolean closeWhenDone;

        private ParserChainText(boolean closeWhenDone) {
            this.closeWhenDone = closeWhenDone;
        }

        public T caretDecoding(boolean enable) {
            this.caretDecoding = enable;
            return (T)this.this_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VCard first() throws IOException {
            VCardReader parser = this.constructReader();
            try {
                VCard vcard = parser.readNext();
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                VCard vCard = vcard;
                return vCard;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<VCard> all() throws IOException {
            VCardReader parser = this.constructReader();
            try {
                VCard vcard;
                ArrayList<VCard> vcards = new ArrayList<VCard>();
                while ((vcard = parser.readNext()) != null) {
                    if (this.warnings != null) {
                        this.warnings.add(parser.getWarnings());
                    }
                    vcards.add(vcard);
                }
                ArrayList<VCard> arrayList = vcards;
                return arrayList;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        private VCardReader constructReader() throws IOException {
            VCardReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            parser.setCaretDecodingEnabled(this.caretDecoding);
            return parser;
        }

        abstract VCardReader _constructReader() throws IOException;
    }

    static abstract class ParserChain<T> {
        final ScribeIndex index = new ScribeIndex();
        List<List<String>> warnings;
        final T this_ = this;

        ParserChain() {
        }

        public T register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return this.this_;
        }

        public T warnings(List<List<String>> warnings) {
            this.warnings = warnings;
            return this.this_;
        }

        public abstract VCard first() throws IOException, SAXException;

        public abstract List<VCard> all() throws IOException, SAXException;
    }
}

