/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard;

public enum VCardVersion {
    V2_1("2.1", null),
    V3_0("3.0", null),
    V4_0("4.0", "urn:ietf:params:xml:ns:vcard-4.0");

    private final String version;
    private final String xmlNamespace;

    private VCardVersion(String version, String xmlNamespace) {
        this.version = version;
        this.xmlNamespace = xmlNamespace;
    }

    public String getVersion() {
        return this.version;
    }

    public String getXmlNamespace() {
        return this.xmlNamespace;
    }

    public static VCardVersion valueOfByStr(String value) {
        for (VCardVersion version : VCardVersion.values()) {
            if (!version.getVersion().equals(value)) continue;
            return version;
        }
        return null;
    }

    public static VCardVersion valueOfByXmlNamespace(String ns) {
        for (VCardVersion version : VCardVersion.values()) {
            String versionNs = version.getXmlNamespace();
            if (versionNs == null || !versionNs.equals(ns)) continue;
            return version;
        }
        return null;
    }

    public String toString() {
        return this.version;
    }
}

