/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.ListMultimap;
import org.opencrx.application.uses.ezvcard.util.StringUtils;

public class ValidationWarnings
implements Iterable<Map.Entry<VCardProperty, List<Warning>>> {
    private final ListMultimap<VCardProperty, Warning> warnings = new ListMultimap();

    public void add(VCardProperty property, Warning warning) {
        this.warnings.put(property, warning);
    }

    public void add(VCardProperty property, List<Warning> warnings) {
        this.warnings.putAll(property, warnings);
    }

    public ListMultimap<VCardProperty, Warning> getWarnings() {
        return this.warnings;
    }

    public boolean isEmpty() {
        return this.warnings.isEmpty();
    }

    public List<Warning> getByProperty(Class<? extends VCardProperty> propertyClass) {
        ArrayList<Warning> propWarnings = new ArrayList<Warning>();
        for (Map.Entry<VCardProperty, List<Warning>> entry : this.warnings) {
            VCardProperty property = entry.getKey();
            if ((property != null || propertyClass != null) && (property == null || propertyClass != property.getClass())) continue;
            List<Warning> propViolations = entry.getValue();
            propWarnings.addAll(propViolations);
        }
        return propWarnings;
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<VCardProperty, List<Warning>> entry : this.warnings) {
            VCardProperty property = entry.getKey();
            List<Warning> propViolations = entry.getValue();
            for (Warning propViolation : propViolations) {
                Integer code;
                if (property != null) {
                    sb.append('[');
                    sb.append(property.getClass().getSimpleName());
                    sb.append("] | ");
                }
                if ((code = propViolation.getCode()) != null) {
                    sb.append('W');
                    sb.append(nf.format(code));
                    sb.append(": ");
                }
                sb.append(propViolation.getMessage());
                sb.append(StringUtils.NEWLINE);
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<VCardProperty, List<Warning>>> iterator() {
        return this.warnings.iterator();
    }
}

