/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Geo;
import org.opencrx.application.uses.ezvcard.util.GeoUri;
import org.opencrx.application.uses.ezvcard.util.VCardFloatFormatter;

public class GeoScribe
extends VCardPropertyScribe<Geo> {
    public GeoScribe() {
        super(Geo.class, "GEO");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.URI;
            }
        }
        return null;
    }

    @Override
    protected String _writeText(Geo property, VCardVersion version) {
        return this.write(property, version);
    }

    @Override
    protected Geo _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = GeoScribe.unescape(value);
        return this.parse(value, version, warnings);
    }

    @Override
    protected void _writeXml(Geo property, XCardElement parent) {
        parent.append(VCardDataType.URI, this.write(property, parent.version()));
    }

    @Override
    protected Geo _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            return this.parse(value, element.version(), warnings);
        }
        throw GeoScribe.missingXmlElements(VCardDataType.URI);
    }

    private Geo parse(String value, VCardVersion version, List<String> warnings) {
        if (value == null || value.length() == 0) {
            return new Geo(null);
        }
        switch (version) {
            case V2_1: 
            case V3_0: {
                Double longitude;
                Double latitude;
                VCardPropertyScribe.SemiStructuredIterator it = GeoScribe.semistructured(value);
                String latitudeStr = it.next();
                String longitudeStr = it.next();
                if (latitudeStr == null || longitudeStr == null) {
                    throw new CannotParseException(11, new Object[0]);
                }
                try {
                    latitude = Double.valueOf(latitudeStr);
                }
                catch (NumberFormatException e) {
                    throw new CannotParseException(8, latitudeStr);
                }
                try {
                    longitude = Double.valueOf(longitudeStr);
                }
                catch (NumberFormatException e) {
                    throw new CannotParseException(10, longitudeStr);
                }
                return new Geo(latitude, longitude);
            }
            case V4_0: {
                try {
                    return new Geo(GeoUri.parse(value));
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(12, new Object[0]);
                }
            }
        }
        return null;
    }

    private String write(Geo property, VCardVersion version) {
        if (property.getGeoUri() == null) {
            return "";
        }
        switch (version) {
            case V2_1: 
            case V3_0: {
                VCardFloatFormatter formatter = new VCardFloatFormatter(6);
                return GeoScribe.structured(formatter.format(property.getLatitude()), formatter.format(property.getLongitude()));
            }
            case V4_0: {
                return property.getGeoUri().toString(6);
            }
        }
        return null;
    }
}

