/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.Messages;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Telephone;
import org.opencrx.application.uses.ezvcard.util.TelUri;

public class TelephoneScribe
extends VCardPropertyScribe<Telephone> {
    public TelephoneScribe() {
        super(Telephone.class, "TEL");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected VCardDataType _dataType(Telephone property, VCardVersion version) {
        if (version == VCardVersion.V4_0) {
            if (property.getText() != null) {
                return VCardDataType.TEXT;
            }
            if (property.getUri() != null) {
                return VCardDataType.URI;
            }
        }
        return VCardDataType.TEXT;
    }

    @Override
    protected void _prepareParameters(Telephone property, VCardParameters copy, VCardVersion version, VCard vcard) {
        TelephoneScribe.handlePrefParam(property, copy, version, vcard);
    }

    @Override
    protected String _writeText(Telephone property, VCardVersion version) {
        String text = property.getText();
        if (text != null) {
            return TelephoneScribe.escape(text);
        }
        TelUri uri = property.getUri();
        if (uri != null) {
            if (version == VCardVersion.V4_0) {
                return uri.toString();
            }
            String ext = uri.getExtension();
            if (ext == null) {
                return TelephoneScribe.escape(uri.getNumber());
            }
            return TelephoneScribe.escape(uri.getNumber() + " x" + ext);
        }
        return "";
    }

    @Override
    protected Telephone _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = TelephoneScribe.unescape(value);
        return this.parse(value, dataType, warnings);
    }

    @Override
    protected void _writeXml(Telephone property, XCardElement parent) {
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        TelUri uri = property.getUri();
        if (uri != null) {
            parent.append(VCardDataType.URI, uri.toString());
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected Telephone _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            return new Telephone(text);
        }
        String uri = element.first(VCardDataType.URI);
        if (uri != null) {
            try {
                return new Telephone(TelUri.parse(uri));
            }
            catch (IllegalArgumentException e) {
                warnings.add(Messages.INSTANCE.getParseMessage(18, new Object[0]));
                return new Telephone(uri);
            }
        }
        throw TelephoneScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.URI);
    }

    private Telephone parse(String value, VCardDataType dataType, List<String> warnings) {
        try {
            return new Telephone(TelUri.parse(value));
        }
        catch (IllegalArgumentException e) {
            if (dataType == VCardDataType.URI) {
                warnings.add(Messages.INSTANCE.getParseMessage(18, new Object[0]));
            }
            return new Telephone(value);
        }
    }
}

