/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.parameter;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.Calscale;
import org.opencrx.application.uses.ezvcard.parameter.Encoding;
import org.opencrx.application.uses.ezvcard.util.GeoUri;
import org.opencrx.application.uses.ezvcard.util.ListMultimap;

public class VCardParameters
extends ListMultimap<String, String> {
    public static final String ALTID = "ALTID";
    public static final String CALSCALE = "CALSCALE";
    public static final String CHARSET = "CHARSET";
    public static final String ENCODING = "ENCODING";
    public static final String GEO = "GEO";
    public static final String INDEX = "INDEX";
    public static final String LABEL = "LABEL";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String LEVEL = "LEVEL";
    public static final String MEDIATYPE = "MEDIATYPE";
    public static final String PID = "PID";
    public static final String PREF = "PREF";
    public static final String SORT_AS = "SORT-AS";
    public static final String TYPE = "TYPE";
    public static final String TZ = "TZ";
    public static final String VALUE = "VALUE";
    private static final Map<String, Set<VCardVersion>> supportedVersions;

    public VCardParameters() {
    }

    public VCardParameters(VCardParameters orig) {
        super(orig);
    }

    public Encoding getEncoding() {
        String value = (String)this.first(ENCODING);
        return value == null ? null : Encoding.get(value);
    }

    public void setEncoding(Encoding encoding) {
        this.replace(ENCODING, encoding == null ? null : encoding.getValue());
    }

    public VCardDataType getValue() {
        String value = (String)this.first(VALUE);
        return value == null ? null : VCardDataType.get(value);
    }

    public void setValue(VCardDataType value) {
        this.replace(VALUE, value == null ? null : value.getName());
    }

    public void removeValue() {
        this.removeAll(VALUE);
    }

    public String getCharset() {
        return (String)this.first(CHARSET);
    }

    public void setCharset(String charset) {
        this.replace(CHARSET, charset);
    }

    public String getLanguage() {
        return (String)this.first(LANGUAGE);
    }

    public void setLanguage(String language) {
        this.replace(LANGUAGE, language);
    }

    public String getLabel() {
        return (String)this.first(LABEL);
    }

    public void setLabel(String label) {
        this.replace(LABEL, label);
    }

    public String getTimezone() {
        return (String)this.first(TZ);
    }

    public void setTimezone(String tz) {
        this.replace(TZ, tz);
    }

    public Set<String> getTypes() {
        return new HashSet<String>(this.get(TYPE));
    }

    public void addType(String type) {
        this.put(TYPE, type);
    }

    public String getType() {
        Set<String> types = this.getTypes();
        return types.isEmpty() ? null : types.iterator().next();
    }

    public void setType(String type) {
        this.replace(TYPE, type);
    }

    public void removeType(String type) {
        this.remove(TYPE, type);
    }

    public void removeTypes() {
        this.removeAll(TYPE);
    }

    public Integer getPref() {
        String pref = (String)this.first(PREF);
        if (pref == null) {
            return null;
        }
        try {
            return Integer.valueOf(pref);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("PREF parameter value is malformed and could not be parsed. Retrieve its raw text value instead.", e);
        }
    }

    public void setPref(Integer pref) {
        if (pref != null && (pref < 1 || pref > 100)) {
            throw new IllegalArgumentException("Preference value must be between 1 and 100 inclusive.");
        }
        String value = pref == null ? null : pref.toString();
        this.replace(PREF, value);
    }

    public String getAltId() {
        return (String)this.first(ALTID);
    }

    public void setAltId(String altId) {
        this.replace(ALTID, altId);
    }

    public double[] getGeo() {
        String value = (String)this.first(GEO);
        if (value == null) {
            return null;
        }
        try {
            GeoUri geoUri = GeoUri.parse(value);
            return new double[]{geoUri.getCoordA(), geoUri.getCoordB()};
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("GEO parameter value is malformed and could not be parsed. Retrieve its raw text value instead.", e);
        }
    }

    public void setGeo(double latitude, double longitude) {
        GeoUri geoUri = new GeoUri.Builder(latitude, longitude).build();
        this.replace(GEO, geoUri.toString());
    }

    public List<String> getSortAs() {
        return this.get(SORT_AS);
    }

    public void setSortAs(String ... names) {
        this.removeAll(SORT_AS);
        if (names != null && names.length > 0) {
            for (String name : names) {
                this.put(SORT_AS, name);
            }
        }
    }

    public Calscale getCalscale() {
        String value = (String)this.first(CALSCALE);
        return value == null ? null : Calscale.get(value);
    }

    public void setCalscale(Calscale value) {
        this.replace(CALSCALE, value == null ? null : value.getValue());
    }

    public List<Integer[]> getPids() {
        List values = this.get(PID);
        ArrayList<Integer[]> pids = new ArrayList<Integer[]>(values.size());
        for (String value : values) {
            String[] split = value.split("\\.");
            try {
                Integer localId = Integer.valueOf(split[0]);
                Integer clientPidMapRef = split.length > 1 ? Integer.valueOf(split[1]) : null;
                pids.add(new Integer[]{localId, clientPidMapRef});
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("PID parameter value is malformed and could not be parsed. Retrieve its raw text value instead.", e);
            }
        }
        return pids;
    }

    public void addPid(int localId) {
        this.put(PID, localId + "");
    }

    public void addPid(int localId, int clientPidMapRef) {
        this.put(PID, localId + "." + clientPidMapRef);
    }

    public void removePids() {
        this.removeAll(PID);
    }

    public String getMediaType() {
        return (String)this.first(MEDIATYPE);
    }

    public void setMediaType(String mediaType) {
        this.replace(MEDIATYPE, mediaType);
    }

    public String getLevel() {
        return (String)this.first(LEVEL);
    }

    public void setLevel(String level) {
        this.replace(LEVEL, level);
    }

    public Integer getIndex() {
        String index = (String)this.first(INDEX);
        if (index == null) {
            return null;
        }
        try {
            return Integer.valueOf(index);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("INDEX parameter value is malformed and could not be parsed. Retrieve its raw text value instead.", e);
        }
    }

    public void setIndex(Integer index) {
        if (index != null && index <= 0) {
            throw new IllegalArgumentException("Index value must be greater than 0.");
        }
        String value = index == null ? null : index.toString();
        this.replace(INDEX, value);
    }

    public List<Warning> validate(VCardVersion version) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(0);
        int nonStandardCode = 3;
        int valueNotSupportedCode = 4;
        String value = (String)this.first(CALSCALE);
        if (value != null && Calscale.find(value) == null) {
            warnings.add(new Warning(nonStandardCode, CALSCALE, value, Calscale.all()));
        }
        if ((value = (String)this.first(ENCODING)) != null) {
            Encoding encoding = Encoding.find(value);
            if (encoding == null) {
                warnings.add(new Warning(nonStandardCode, ENCODING, value, Encoding.all()));
            } else if (!encoding.isSupported(version)) {
                warnings.add(new Warning(valueNotSupportedCode, ENCODING, value));
            }
        }
        if ((value = (String)this.first(VALUE)) != null) {
            VCardDataType dataType = VCardDataType.find(value);
            if (dataType == null) {
                warnings.add(new Warning(nonStandardCode, VALUE, value, VCardDataType.all()));
            } else if (!dataType.isSupported(version)) {
                warnings.add(new Warning(valueNotSupportedCode, VALUE, value));
            }
        }
        int malformedCode = 5;
        try {
            this.getGeo();
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(malformedCode, GEO, this.first(GEO)));
        }
        try {
            this.getIndex();
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(malformedCode, INDEX, this.first(INDEX)));
        }
        try {
            this.getPids();
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(malformedCode, PID, this.first(PID)));
        }
        try {
            this.getPref();
        }
        catch (IllegalStateException e) {
            warnings.add(new Warning(malformedCode, PREF, this.first(PREF)));
        }
        int paramNotSupportedCode = 6;
        for (Map.Entry<String, Set<VCardVersion>> entry : supportedVersions.entrySet()) {
            Set<VCardVersion> versions;
            String name = entry.getKey();
            String value2 = (String)this.first(name);
            if (value2 == null || (versions = entry.getValue()).contains((Object)version)) continue;
            warnings.add(new Warning(paramNotSupportedCode, name));
        }
        int invalidCharsetCode = 22;
        String charsetStr = this.getCharset();
        if (charsetStr != null) {
            try {
                Charset.forName(charsetStr);
            }
            catch (IllegalCharsetNameException e) {
                warnings.add(new Warning(invalidCharsetCode, charsetStr));
            }
            catch (UnsupportedCharsetException e) {
                warnings.add(new Warning(invalidCharsetCode, charsetStr));
            }
        }
        return warnings;
    }

    @Override
    protected String sanitizeKey(String key) {
        return key == null ? null : key.toUpperCase();
    }

    static {
        HashMap<String, EnumSet<VCardVersion>> m = new HashMap<String, EnumSet<VCardVersion>>();
        m.put(ALTID, EnumSet.of(VCardVersion.V4_0));
        m.put(CALSCALE, EnumSet.of(VCardVersion.V4_0));
        m.put(CHARSET, EnumSet.of(VCardVersion.V2_1));
        m.put(GEO, EnumSet.of(VCardVersion.V4_0));
        m.put(INDEX, EnumSet.of(VCardVersion.V4_0));
        m.put(LEVEL, EnumSet.of(VCardVersion.V4_0));
        m.put(MEDIATYPE, EnumSet.of(VCardVersion.V4_0));
        m.put(PID, EnumSet.of(VCardVersion.V4_0));
        m.put(SORT_AS, EnumSet.of(VCardVersion.V4_0));
        m.put(TZ, EnumSet.of(VCardVersion.V4_0));
        supportedVersions = Collections.unmodifiableMap(m);
    }
}

