/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.parameter.ImppType;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public class Impp
extends VCardProperty
implements HasAltId {
    private static final String AIM = "aim";
    private static final String ICQ = "icq";
    private static final String IRC = "irc";
    private static final String MSN = "msnim";
    private static final String SIP = "sip";
    private static final String SKYPE = "skype";
    private static final String XMPP = "xmpp";
    private static final String YAHOO = "ymsgr";
    private URI uri;

    public Impp(String uri) {
        this.setUri(uri);
    }

    public Impp(URI uri) {
        this.setUri(uri);
    }

    public Impp(String protocol, String handle) {
        this.setUri(protocol, handle);
    }

    @Override
    public Set<VCardVersion> _supportedVersions() {
        return EnumSet.of(VCardVersion.V3_0, VCardVersion.V4_0);
    }

    public static Impp aim(String handle) {
        return new Impp(AIM, handle);
    }

    public boolean isAim() {
        return this.isProtocol(AIM);
    }

    public static Impp yahoo(String handle) {
        return new Impp(YAHOO, handle);
    }

    public boolean isYahoo() {
        return this.isProtocol(YAHOO);
    }

    public static Impp msn(String handle) {
        return new Impp(MSN, handle);
    }

    public boolean isMsn() {
        return this.isProtocol(MSN);
    }

    public static Impp icq(String handle) {
        return new Impp(ICQ, handle);
    }

    public boolean isIcq() {
        return this.isProtocol(ICQ);
    }

    public static Impp irc(String handle) {
        return new Impp(IRC, handle);
    }

    public boolean isIrc() {
        return this.isProtocol(IRC);
    }

    public static Impp sip(String handle) {
        return new Impp(SIP, handle);
    }

    public boolean isSip() {
        return this.isProtocol(SIP);
    }

    public static Impp skype(String handle) {
        return new Impp(SKYPE, handle);
    }

    public boolean isSkype() {
        return this.isProtocol(SKYPE);
    }

    public static Impp xmpp(String handle) {
        return new Impp(XMPP, handle);
    }

    public boolean isXmpp() {
        return this.isProtocol(XMPP);
    }

    private boolean isProtocol(String protocol) {
        return this.uri != null && protocol.equals(this.uri.getScheme());
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.setUri(uri == null ? null : URI.create(uri));
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String protocol, String handle) {
        try {
            this.uri = new URI(protocol, handle, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getProtocol() {
        if (this.uri == null) {
            return null;
        }
        return this.uri.getScheme();
    }

    public String getHandle() {
        if (this.uri == null) {
            return null;
        }
        return this.uri.getSchemeSpecificPart();
    }

    public Set<ImppType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<ImppType> types = new HashSet<ImppType>(values.size());
        for (String value : values) {
            types.add(ImppType.get(value));
        }
        return types;
    }

    public void addType(ImppType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(ImppType type) {
        this.parameters.removeType(type.getValue());
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
    }
}

