/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.property.HasAltId;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.util.UtcOffset;
import org.opencrx.application.uses.ezvcard.util.VCardDateFormat;

public class Timezone
extends VCardProperty
implements HasAltId {
    private UtcOffset offset;
    private String text;

    public Timezone(String text) {
        this(null, text);
    }

    public Timezone(Integer hourOffset, Integer minuteOffset) {
        this(new UtcOffset(hourOffset, minuteOffset));
    }

    public Timezone(UtcOffset offset) {
        this(offset, null);
    }

    public Timezone(Integer hourOffset, Integer minuteOffset, String text) {
        this(new UtcOffset(hourOffset, minuteOffset), text);
    }

    public Timezone(UtcOffset offset, String text) {
        this.setOffset(offset);
        this.setText(text);
    }

    public Timezone(TimeZone timezone) {
        this(UtcOffset.parse(timezone), timezone.getID());
    }

    public Integer getHourOffset() {
        return this.offset == null ? null : Integer.valueOf(this.offset.getHour());
    }

    public Integer getMinuteOffset() {
        return this.offset == null ? null : Integer.valueOf(this.offset.getMinute());
    }

    public UtcOffset getOffset() {
        return this.offset;
    }

    public void setOffset(int hourOffset, int minuteOffset) {
        this.setOffset(new UtcOffset(hourOffset, minuteOffset));
    }

    public void setOffset(UtcOffset offset) {
        this.offset = offset;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TimeZone toTimeZone() {
        TimeZone timezone;
        if (this.text != null && (timezone = VCardDateFormat.parseTimeZoneId(this.text)) != null) {
            return timezone;
        }
        if (this.offset != null) {
            int rawHourOffset = this.offset.getHour() * 60 * 60 * 1000;
            int rawMinuteOffset = this.offset.getMinute() * 60 * 1000;
            if (rawHourOffset < 0) {
                rawMinuteOffset *= -1;
            }
            int rawOffset = rawHourOffset + rawMinuteOffset;
            String id = this.text == null ? "" : this.text;
            return new SimpleTimeZone(rawOffset, id);
        }
        return null;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.offset == null && this.text == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
        if (this.offset == null && version == VCardVersion.V2_1) {
            warnings.add(new Warning(20, new Object[0]));
        }
        if (this.offset != null && (this.offset.getMinute() < 0 || this.offset.getMinute() > 59)) {
            warnings.add(new Warning(21, new Object[0]));
        }
    }
}

